/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.comment;

import fr.ifremer.tutti.persistence.entities.CommentAware;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.comment.CommentEditorUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.spi.UIHandler;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import org.nuiton.i18n.I18n;

public class CommentEditorUIHandler
implements UIHandler<CommentEditorUI> {
    private static final int DEFAULT_EDITOR_WIDTH = 400;
    private static final int DEFAULT_EDITOR_HEIGHT = 200;
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    public static final String SHOW_DIALOG_ACTION = "showDialog";
    protected TuttiUIContext context;
    private CommentEditorUI ui;
    protected Action closeAction;
    protected Action openAction;

    public void beforeInit(CommentEditorUI ui) {
        this.ui = ui;
        this.context = TuttiUIUtil.getApplicationContext(ui);
    }

    public void afterInit(CommentEditorUI ui) {
        ui.pack();
        ui.setResizable(true);
        ui.setSize(400, 200);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{ui});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{ui});
        JRootPane rootPane = ui.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        this.closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommentEditorUIHandler.this.ui.dispose();
                CommentEditorUIHandler.this.ui.setVisible(false);
            }
        };
        this.openAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommentEditorUIHandler.this.ui.setVisible(true);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        this.closeAction.putValue("SmallIcon", actionIcon);
        this.closeAction.putValue("SwingLargeIconKey", actionIcon);
        this.closeAction.putValue("ActionCommandKey", "close");
        this.closeAction.putValue("Name", "close");
        this.closeAction.putValue("ShortDescription", I18n.t((String)"tutti.commentEditor.action.close.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, this.closeAction);
        rootPane.getActionMap().put(SHOW_DIALOG_ACTION, this.openAction);
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(this.closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        ui.getCommentEditorTopPanel().setRightDecoration((JComponent)jToolBar);
    }

    public void closeEditor() {
        this.closeAction.actionPerformed(null);
    }

    public void openEditor(JComponent component) {
        if (component != null) {
            this.place(component);
        }
        this.openAction.actionPerformed(null);
    }

    public void init() {
        CommentAware bean = this.ui.getBean();
        String content = bean == null ? null : bean.getComment();
        this.ui.getTextContent().setText(content);
    }

    public void place(JComponent component) {
        int x = 0;
        int y = component.getHeight();
        for (Container comp = component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        if (x + this.ui.getWidth() > this.ui.getOwner().getX() + this.ui.getOwner().getWidth()) {
            x = x - this.ui.getWidth() + component.getWidth();
        }
        this.ui.setLocation(x, y);
    }

    public void setText(String value) {
        CommentAware bean = this.ui.getBean();
        bean.setComment(value);
    }
}

