/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortableRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.util.Numbers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;

public class SpeciesBatchUIModel
extends AbstractTuttiBatchUIModel<SpeciesBatchRowModel, SpeciesBatchUIModel>
implements TabContentModel,
SpeciesSortableRowModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPLIT_BATCH_ENABLED = "splitBatchEnabled";
    public static final String PROPERTY_CHANGE_SAMPLE_CATEGORY_ENABLED = "changeSampleCategoryEnabled";
    public static final String PROPERTY_ADD_SAMPLE_CATEGORY_ENABLED = "addSampleCategoryEnabled";
    public static final String PROPERTY_REMOVE_SUB_BATCH_ENABLED = "removeSubBatchEnabled";
    public static final String PROPERTY_RENAME_BATCH_ENABLED = "renameBatchEnabled";
    public static final String PROPERTY_REMOVE_BATCH_ENABLED = "removeBatchEnabled";
    public static final String PROPERTY_CREATE_MELAG_ENABLED = "createMelagEnabled";
    public static final String PROPERTY_EDIT_FREQUENCIES_ENABLED = "editFrequenciesEnabled";
    public static final String PROPERTY_TABLE_VIEW_MODE = "tableViewMode";
    public static final String PROPERTY_TABLE_VIEW_MODE_ALL = "tableViewModeAll";
    public static final String PROPERTY_TABLE_VIEW_MODE_LEAF = "tableViewModeLeaf";
    public static final String PROPERTY_TABLE_VIEW_MODE_ROOT = "tableViewModeRoot";
    public static final String PROPERTY_ROOT_NUMBER = "rootNumber";
    public static final String PROPERTY_LEAF_NUMBER = "leafNumber";
    protected boolean splitBatchEnabled;
    protected boolean changeSampleCategoryEnabled;
    protected boolean addSampleCategoryEnabled;
    protected boolean removeBatchEnabled;
    protected boolean removeSubBatchEnabled;
    protected boolean createMelagEnabled = true;
    protected boolean renameBatchEnabled;
    private boolean editFrequenciesEnabled;
    protected TableViewMode tableViewMode;
    protected int rootNumber;
    protected int leafNumber;
    protected SpeciesSortMode speciesSortMode;
    protected int speciesDecoratorContextIndex;

    public SpeciesBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel, "speciesTotalComputedWeight", "speciesTotalSortedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "batchUpdated");
    }

    public Float getSpeciesTotalComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalComputedWeight();
    }

    public void setSpeciesTotalComputedWeight(Float speciesTotalComputedWeight) {
        this.catchesUIModel.setSpeciesTotalComputedWeight(speciesTotalComputedWeight);
    }

    public ComputableData<Float> getSpeciesTotalSortedComputedOrNotWeight() {
        return this.catchesUIModel.getSpeciesTotalSortedComputedOrNotWeight();
    }

    public Float getSpeciesTotalSortedWeight() {
        return this.catchesUIModel.getSpeciesTotalSortedWeight();
    }

    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        this.catchesUIModel.setSpeciesTotalSortedWeight(speciesTotalSortedWeight);
    }

    public Float getSpeciesTotalSortedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalSortedComputedWeight();
    }

    public void setSpeciesTotalSortedComputedWeight(Float speciesTotalSortedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalSortedComputedWeight(speciesTotalSortedComputedWeight);
    }

    public Float getSpeciesTotalUnsortedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalUnsortedComputedWeight();
    }

    public void setSpeciesTotalUnsortedComputedWeight(Float speciesTotalUnsortedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalUnsortedComputedWeight(speciesTotalUnsortedComputedWeight);
    }

    public Float getSpeciesTotalSampleSortedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalSampleSortedComputedWeight();
    }

    public void setSpeciesTotalSampleSortedComputedWeight(Float speciesTotalSampleSortedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalSampleSortedComputedWeight(speciesTotalSampleSortedComputedWeight);
    }

    public ComputableData<Float> getSpeciesTotalInertComputedOrNotWeight() {
        return this.catchesUIModel.getSpeciesTotalInertComputedOrNotWeight();
    }

    public Float getSpeciesTotalInertWeight() {
        return this.catchesUIModel.getSpeciesTotalInertWeight();
    }

    public void setSpeciesTotalInertWeight(Float speciesTotalInertWeight) {
        this.catchesUIModel.setSpeciesTotalInertWeight(speciesTotalInertWeight);
    }

    public Float getSpeciesTotalInertComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalInertComputedWeight();
    }

    public void setSpeciesTotalInertComputedWeight(Float speciesTotalInertComputedWeight) {
        this.catchesUIModel.setSpeciesTotalInertComputedWeight(speciesTotalInertComputedWeight);
    }

    public ComputableData<Float> getSpeciesTotalLivingNotItemizedComputedOrNotWeight() {
        return this.catchesUIModel.getSpeciesTotalLivingNotItemizedComputedOrNotWeight();
    }

    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return this.catchesUIModel.getSpeciesTotalLivingNotItemizedWeight();
    }

    public void setSpeciesTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        this.catchesUIModel.setSpeciesTotalLivingNotItemizedWeight(speciesTotalLivingNotItemizedWeight);
    }

    public Float getSpeciesTotalLivingNotItemizedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalLivingNotItemizedComputedWeight();
    }

    public void setSpeciesTotalLivingNotItemizedComputedWeight(Float speciesTotalLivingNotItemizedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalLivingNotItemizedComputedWeight(speciesTotalLivingNotItemizedComputedWeight);
    }

    public Integer getSpeciesDistinctSortedSpeciesCount() {
        return this.catchesUIModel.getSpeciesDistinctSortedSpeciesCount();
    }

    public void setSpeciesDistinctSortedSpeciesCount(Integer speciesDistinctSortedSpeciesCount) {
        this.catchesUIModel.setSpeciesDistinctSortedSpeciesCount(speciesDistinctSortedSpeciesCount);
    }

    public void incSpeciesDistinctSortedSpeciesCount() {
        Integer speciesDistinctSortedSpeciesCount = this.getSpeciesDistinctSortedSpeciesCount();
        if (speciesDistinctSortedSpeciesCount == null) {
            speciesDistinctSortedSpeciesCount = 0;
        }
        this.setSpeciesDistinctSortedSpeciesCount(speciesDistinctSortedSpeciesCount + 1);
    }

    public void decSpeciesDistinctSortedSpeciesCount() {
        Integer speciesDistinctSortedSpeciesCount = this.getSpeciesDistinctSortedSpeciesCount();
        if (speciesDistinctSortedSpeciesCount != null) {
            this.setSpeciesDistinctSortedSpeciesCount(speciesDistinctSortedSpeciesCount - 1);
        }
    }

    public TableViewMode getTableViewMode() {
        return this.tableViewMode;
    }

    public void setTableViewMode(TableViewMode tableViewMode) {
        TableViewMode oldValue = this.getTableViewMode();
        this.tableViewMode = tableViewMode;
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE, (Object)oldValue, (Object)tableViewMode);
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ALL, null, this.isTableViewModeAll());
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE_LEAF, null, this.isTableViewModeLeaf());
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ROOT, null, this.isTableViewModeRoot());
    }

    public boolean isTableViewModeAll() {
        return TableViewMode.ALL.equals((Object)this.tableViewMode);
    }

    public boolean isTableViewModeLeaf() {
        return TableViewMode.LEAF.equals((Object)this.tableViewMode);
    }

    public boolean isTableViewModeRoot() {
        return TableViewMode.ROOT.equals((Object)this.tableViewMode);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return this.catchesUIModel.getSpeciesUsed();
    }

    public int getRootNumber() {
        return this.rootNumber;
    }

    public void setRootNumber(int rootNumber) {
        Integer oldValue = this.getRootNumber();
        this.rootNumber = rootNumber;
        this.firePropertyChange(PROPERTY_ROOT_NUMBER, oldValue, rootNumber);
    }

    public int getLeafNumber() {
        return this.leafNumber;
    }

    public void setLeafNumber(int leafNumber) {
        Integer oldValue = this.getLeafNumber();
        this.leafNumber = leafNumber;
        this.firePropertyChange(PROPERTY_LEAF_NUMBER, oldValue, leafNumber);
    }

    public boolean isSplitBatchEnabled() {
        return this.splitBatchEnabled;
    }

    public void setSplitBatchEnabled(boolean splitBatchEnabled) {
        this.splitBatchEnabled = splitBatchEnabled;
        this.firePropertyChange(PROPERTY_SPLIT_BATCH_ENABLED, null, splitBatchEnabled);
    }

    public boolean isChangeSampleCategoryEnabled() {
        return this.changeSampleCategoryEnabled;
    }

    public void setChangeSampleCategoryEnabled(boolean changeSampleCategoryEnabled) {
        this.changeSampleCategoryEnabled = changeSampleCategoryEnabled;
        this.firePropertyChange(PROPERTY_CHANGE_SAMPLE_CATEGORY_ENABLED, null, changeSampleCategoryEnabled);
    }

    public boolean isAddSampleCategoryEnabled() {
        return this.addSampleCategoryEnabled;
    }

    public void setAddSampleCategoryEnabled(boolean addSampleCategoryEnabled) {
        this.addSampleCategoryEnabled = addSampleCategoryEnabled;
        this.firePropertyChange(PROPERTY_ADD_SAMPLE_CATEGORY_ENABLED, null, addSampleCategoryEnabled);
    }

    public boolean isRemoveBatchEnabled() {
        return this.removeBatchEnabled;
    }

    public void setRemoveBatchEnabled(boolean removeBatchEnabled) {
        this.removeBatchEnabled = removeBatchEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_BATCH_ENABLED, null, removeBatchEnabled);
    }

    public boolean isRemoveSubBatchEnabled() {
        return this.removeSubBatchEnabled;
    }

    public void setRemoveSubBatchEnabled(boolean removeSubBatchEnabled) {
        this.removeSubBatchEnabled = removeSubBatchEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_SUB_BATCH_ENABLED, null, removeSubBatchEnabled);
    }

    public boolean isRenameBatchEnabled() {
        return this.renameBatchEnabled;
    }

    public void setRenameBatchEnabled(boolean renameBatchEnabled) {
        this.renameBatchEnabled = renameBatchEnabled;
        this.firePropertyChange(PROPERTY_RENAME_BATCH_ENABLED, null, renameBatchEnabled);
    }

    public boolean isCreateMelagEnabled() {
        return this.createMelagEnabled;
    }

    public void setCreateMelagEnabled(boolean createMelagEnabled) {
        this.createMelagEnabled = createMelagEnabled;
        this.firePropertyChange(PROPERTY_CREATE_MELAG_ENABLED, null, createMelagEnabled);
    }

    public boolean isEditFrequenciesEnabled() {
        return this.editFrequenciesEnabled;
    }

    public void setEditFrequenciesEnabled(boolean editFrequenciesEnabled) {
        this.editFrequenciesEnabled = editFrequenciesEnabled;
        this.firePropertyChange(PROPERTY_EDIT_FREQUENCIES_ENABLED, null, editFrequenciesEnabled);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.getRows()) && this.getSpeciesTotalSortedWeight() == null && this.getSpeciesTotalInertWeight() == null && this.getSpeciesTotalLivingNotItemizedWeight() == null;
    }

    public String getTitle() {
        return I18n.n((String)"tutti.label.tab.species", (Object[])new Object[0]);
    }

    public String getIcon() {
        return null;
    }

    public boolean isCloseable() {
        return false;
    }

    public List<SpeciesBatchRowModel> getLeafs(Species species) {
        ArrayList result = Lists.newArrayList();
        for (SpeciesBatchRowModel rowModel : this.getRows()) {
            if (!rowModel.isBatchRoot()) continue;
            this.getLeafs(species, rowModel, result);
        }
        return result;
    }

    public void getLeafs(Species species, SpeciesBatchRowModel rowModel, List<SpeciesBatchRowModel> used) {
        if (rowModel.isBatchLeaf()) {
            if (species.equals(rowModel.getSpecies())) {
                used.add(rowModel);
            }
        } else {
            for (SpeciesBatchRowModel child : rowModel.getChildBatch()) {
                this.getLeafs(species, child, used);
            }
        }
    }

    public Map<Species, Integer> getSpeciesCount() {
        HashMap result = Maps.newHashMap();
        for (SpeciesBatchRowModel row : this.getRows()) {
            if (!row.isBatchLeaf()) continue;
            Species species = row.getSpecies();
            Integer count = (Integer)Numbers.getValueOrComputedValue((Number)((Number)result.get(species)), (Number)0);
            List<SpeciesFrequencyRowModel> frequencies = row.getFrequency();
            if (CollectionUtils.isEmpty(frequencies)) {
                Integer number = row.getNumber();
                if (number != null) {
                    count = count + number;
                }
            } else {
                for (SpeciesFrequencyRowModel frequency : frequencies) {
                    Integer number = frequency.getNumber();
                    if (number == null) continue;
                    count = count + number;
                }
            }
            result.put(species, count);
        }
        return result;
    }

    @Override
    public SpeciesSortMode getSpeciesSortMode() {
        return this.speciesSortMode;
    }

    @Override
    public void setSpeciesSortMode(SpeciesSortMode speciesSortMode) {
        SpeciesSortMode oldValue = this.getSpeciesSortMode();
        this.speciesSortMode = speciesSortMode;
        this.firePropertyChange("speciesSortMode", (Object)oldValue, (Object)speciesSortMode);
        this.firePropertyChange("speciesSortModeNone", null, this.isSpeciesSortModeNone());
        this.firePropertyChange("speciesSortModeAsc", null, this.isSpeciesSortModeAsc());
        this.firePropertyChange("speciesSortModeDesc", null, this.isSpeciesSortModeDesc());
    }

    @Override
    public boolean isSpeciesSortModeNone() {
        return SpeciesSortMode.NONE.equals((Object)this.speciesSortMode);
    }

    @Override
    public boolean isSpeciesSortModeAsc() {
        return SpeciesSortMode.ASC.equals((Object)this.speciesSortMode);
    }

    @Override
    public boolean isSpeciesSortModeDesc() {
        return SpeciesSortMode.DESC.equals((Object)this.speciesSortMode);
    }

    @Override
    public int getSpeciesDecoratorContextIndex() {
        return this.speciesDecoratorContextIndex;
    }

    @Override
    public void setSpeciesDecoratorContextIndex(int speciesDecoratorContextIndex) {
        int oldValue = this.getSpeciesDecoratorContextIndex();
        this.speciesDecoratorContextIndex = speciesDecoratorContextIndex;
        this.firePropertyChange("speciesDecoratorContextIndex", oldValue, speciesDecoratorContextIndex);
    }
}

