/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.LabelAware;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.TuttiConfigurationOption;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionException;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdaterCallback;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;

public class TuttiApplicationUpdaterCallBack
implements ApplicationUpdaterCallback {
    private static final Log log = LogFactory.getLog(TuttiApplicationUpdaterCallBack.class);
    protected final TuttiUIContext context;
    protected List<UpdateType> types;
    protected ProgressionModel progressionModel;
    protected boolean applicationUpdated;
    protected final AbstractTuttiAction action;

    public TuttiApplicationUpdaterCallBack(AbstractTuttiAction action, ProgressionModel progressionModel) {
        this.action = action;
        this.context = action.getContext();
        this.progressionModel = progressionModel;
    }

    public void setTypes(UpdateType ... types) {
        this.types = Lists.newArrayList((Object[])types);
    }

    public boolean isApplicationUpdated() {
        return this.applicationUpdated;
    }

    public Map<String, ApplicationInfo> updateToDo(Map<String, ApplicationInfo> appToUpdate) {
        HashMap result = Maps.newHashMap();
        for (UpdateType type : this.types) {
            ApplicationInfo info = this.getInfo(type, appToUpdate);
            if (info == null) continue;
            result.put(info.name, info);
        }
        return result;
    }

    public void startUpdate(ApplicationInfo info) {
        if (UpdateType.JRE.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage(I18n.t((String)"tutti.applicationUpdater.startUpdate.jre", (Object[])new Object[]{info.newVersion}));
        }
        if (UpdateType.TUTTI.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage(I18n.t((String)"tutti.applicationUpdater.startUpdate.tutti", (Object[])new Object[]{info.newVersion}));
        }
        if (UpdateType.I18N.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage(I18n.t((String)"tutti.applicationUpdater.startUpdate.i18n", (Object[])new Object[]{info.newVersion}));
        }
        if (UpdateType.HELP.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage(I18n.t((String)"tutti.applicationUpdater.startUpdate.help", (Object[])new Object[]{info.newVersion}));
        }
    }

    public void updateDone(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart;
        boolean updateJRE = this.updateDoneJre(appToUpdate, appUpdateError);
        boolean updateTutti = this.updateDoneTutti(appToUpdate, appUpdateError);
        boolean updateI18n = this.updateDoneI18n(appToUpdate, appUpdateError);
        boolean updateHelp = this.updateDoneHelp(appToUpdate, appUpdateError);
        boolean bl = doRestart = updateJRE || updateTutti || updateI18n || updateHelp;
        if (doRestart) {
            this.applicationUpdated = true;
        }
    }

    public void aborted(String propertiesURL, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Could not update from " + propertiesURL), (Throwable)eee);
        }
        throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)eee);
    }

    protected boolean updateDoneJre(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.JRE, appUpdateError);
        if (error != null) {
            throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.jre.error", (Object[])new Object[0]), (Throwable)error));
        }
        ApplicationInfo info = this.getInfo(UpdateType.JRE, appToUpdate);
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("A jre update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
            }
            doRestart = true;
        }
        return doRestart;
    }

    protected boolean updateDoneTutti(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.TUTTI, appUpdateError);
        if (error != null) {
            throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.tutti.error", (Object[])new Object[0]), (Throwable)error));
        }
        ApplicationInfo info = this.getInfo(UpdateType.TUTTI, appToUpdate);
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("A tutti update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
            }
            doRestart = true;
            TuttiConfiguration config = this.context.getConfig();
            File cacheDirectory = config.getCacheDirectory();
            ApplicationIOUtil.forceDeleteOnExit((File)cacheDirectory, (String)I18n.t((String)"tutti.applicationUpdater.updateDone.deleteDirectory.caches.error", (Object[])new Object[]{cacheDirectory}));
            Version oldVersion = Versions.valueOf((String)info.oldVersion);
            if (oldVersion.before(Versions.valueOf((String)"3.7.1"))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Remove from configuration tutti.update.application.url: " + config.getUpdateApplicationUrl()));
                }
                config.getApplicationConfig().setOption(TuttiConfigurationOption.UPDATE_APPLICATION_URL.getKey(), "");
                config.save();
            }
        }
        return doRestart;
    }

    protected boolean updateDoneI18n(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.I18N, appUpdateError);
        if (error != null) {
            throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.i18n.error", (Object[])new Object[0]), (Throwable)error));
        }
        ApplicationInfo info = this.getInfo(UpdateType.I18N, appToUpdate);
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("A i18n update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
            }
            doRestart = true;
        }
        return doRestart;
    }

    protected boolean updateDoneHelp(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.HELP, appUpdateError);
        if (error != null) {
            throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.help.error", (Object[])new Object[0]), (Throwable)error));
        }
        ApplicationInfo info = this.getInfo(UpdateType.HELP, appToUpdate);
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("A help update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
            }
            doRestart = true;
        }
        return doRestart;
    }

    protected ApplicationInfo getInfo(UpdateType type, Map<String, ApplicationInfo> appToUpdate) {
        return appToUpdate.get(type.name().toLowerCase());
    }

    protected Exception getError(UpdateType type, Map<String, Exception> appUpdateError) {
        return appUpdateError.get(type.name().toLowerCase());
    }

    protected File getDbDirectory(ApplicationInfo info) {
        File[] sources = info.destDir.listFiles();
        Preconditions.checkState((sources != null && sources.length == 1 ? 1 : 0) != 0, (Object)("Downloaded db should contains one directory at " + info.destDir));
        File result = sources[0];
        return result;
    }

    public static enum UpdateType implements LabelAware
    {
        JRE(I18n.n((String)"tutti.update.jre", (Object[])new Object[0])),
        TUTTI(I18n.n((String)"tutti.update.tutti", (Object[])new Object[0])),
        I18N(I18n.n((String)"tutti.update.i18n", (Object[])new Object[0])),
        HELP(I18n.n((String)"tutti.update.help", (Object[])new Object[0]));

        private final String i18nKey;

        private UpdateType(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String getLabel() {
            return I18n.t((String)this.i18nKey, (Object[])new Object[0]);
        }
    }
}

