/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.jar.JarFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileProvider
extends ZipFileProvider {
    static final Collection<Capability> capabilities;

    @Override
    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = new LayeredFileName(scheme, file.getName(), "/", FileType.FOLDER);
        return new JarFileSystem(name, file, fileSystemOptions);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    static {
        ArrayList<Capability> combined = new ArrayList<Capability>();
        combined.addAll(ZipFileProvider.capabilities);
        combined.addAll(Arrays.asList(Capability.ATTRIBUTES, Capability.FS_ATTRIBUTES, Capability.SIGNING, Capability.MANIFEST_ATTRIBUTES, Capability.VIRTUAL));
        capabilities = Collections.unmodifiableCollection(combined);
    }
}

