/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoFactory;
import fr.ifremer.adagio.synchro.dao.DaoFactoryImpl;
import fr.ifremer.adagio.synchro.dao.DaoStats;
import fr.ifremer.adagio.synchro.dao.Daos;
import fr.ifremer.adagio.synchro.dao.NotCloseablePreparedStatement;
import fr.ifremer.adagio.synchro.dao.SynchroBaseDao;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;

public class SynchroBaseDaoImpl
implements SynchroBaseDao {
    private static final Log log = LogFactory.getLog(SynchroBaseDaoImpl.class);
    private Connection connection;
    private DaoStats stats;
    private final LoadingCache<String, PreparedStatement> statementCache;
    private final LoadingCache<String, Optional<Object>> valueCache;
    private DaoFactory daoFactory;
    private int batchSize;
    private final String deleteTempQueryParameterQuery;
    private final String deleteTempQueryParameterQueryWithLike;
    private final String insertIntoTempQueryParameterQuery;
    private boolean debug;

    public SynchroBaseDaoImpl(SynchroDatabaseMetadata dbMeta) throws SQLException {
        this(dbMeta.getConnection(), dbMeta.getConfiguration(), dbMeta, new DaoFactoryImpl(dbMeta), new DaoStats(), 50, 300, 1000, 60);
    }

    public SynchroBaseDaoImpl(Connection connection, SynchroDatabaseConfiguration configuration, SynchroDatabaseMetadata dbMeta, DaoFactory daoFactory, DaoStats stats, int statementCacheSize, int statementCacheDurationInSecond, int valueCacheSize, int valueCacheDurationInSecond) {
        this.connection = connection;
        this.daoFactory = daoFactory;
        this.stats = stats;
        this.debug = log.isTraceEnabled();
        this.batchSize = SynchroConfiguration.getInstance().getImportJdbcBatchSize();
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0);
        int validStatementCacheSize = statementCacheSize > 0 ? statementCacheSize : 50;
        int validValueCacheSize = valueCacheSize > 0 ? valueCacheSize : 1000;
        this.statementCache = this.initStatementCache(validStatementCacheSize, statementCacheDurationInSecond);
        this.valueCache = this.initValueCache(validValueCacheSize, valueCacheDurationInSecond);
        Preconditions.checkNotNull((Object)dbMeta.getTable("TEMP_QUERY_PARAMETER"), (Object)String.format("%s could not be started without '%s' table. Please add this technical table to schema", this.getClass().getSimpleName(), "TEMP_QUERY_PARAMETER"));
        this.insertIntoTempQueryParameterQuery = this.initInsertIntoTempQueryParameterQuery(configuration.getDialect());
        this.deleteTempQueryParameterQuery = this.initDeleteTempQueryParameterQuery(false);
        this.deleteTempQueryParameterQueryWithLike = this.initDeleteTempQueryParameterQuery(true);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public DaoFactory getDaoFactory() {
        return this.daoFactory;
    }

    @Override
    public void close() throws IOException {
        this.statementCache.invalidateAll();
        this.valueCache.invalidateAll();
        this.daoFactory = null;
        this.stats = null;
        this.connection = null;
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        Preconditions.checkNotNull((Object)sql);
        try {
            return new NotCloseablePreparedStatement((PreparedStatement)this.statementCache.get((Object)sql));
        }
        catch (ExecutionException e) {
            throw new SynchroTechnicalException(String.format("[%s] Error during statement loading (using cache): %s", sql, e.getMessage()), e);
        }
    }

    @Override
    public <T> T getUniqueTyped(String sql, Object[] bindingValues) throws SQLException {
        String cacheKey = sql + "#" + SynchroTableMetadata.toPkStr(bindingValues);
        this.stats.incrementValue();
        Optional optionalResult = (Optional)this.valueCache.getIfPresent((Object)cacheKey);
        if (optionalResult != null && optionalResult.isPresent()) {
            return (T)optionalResult.get();
        }
        Object result = this.newSqlExecuteUnique(cacheKey);
        if (result != null) {
            this.valueCache.put((Object)cacheKey, (Object)Optional.of((Object)result));
        }
        return (T)result;
    }

    @Override
    public String getInsertIntoTempQueryParameterQuery() {
        return this.insertIntoTempQueryParameterQuery;
    }

    @Override
    public void cleanTempQueryParameter() throws SQLException {
        if (this.debug) {
            log.debug((Object)String.format("Deleting all synchro rows from %s", "TEMP_QUERY_PARAMETER".toUpperCase()));
        }
        String sql = this.initCleanTempQueryParameterQuery();
        PreparedStatement statement = null;
        try {
            statement = this.getPreparedStatement(sql);
            int deletedRows = statement.executeUpdate();
            if (this.debug) {
                log.trace((Object)String.format("%s rows delete from TEMP_QUERY_PAREMETER", deletedRows));
            }
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(String.format("Could not delete all synchro rows from %s", "TEMP_QUERY_PARAMETER"), e);
        }
        finally {
            Daos.closeSilently(statement);
        }
    }

    @Override
    public void executeDeleteTempQueryParameter(String queryParameterName, boolean likeOperatorForParameterName, int queryPersonId) throws SQLException {
        if (this.debug) {
            log.debug((Object)String.format("Deleting rows from %s", "TEMP_QUERY_PARAMETER".toUpperCase()));
        }
        String sql = likeOperatorForParameterName ? this.deleteTempQueryParameterQueryWithLike : this.deleteTempQueryParameterQuery;
        PreparedStatement statement = null;
        try {
            statement = this.getPreparedStatement(sql);
            statement.setString(1, queryParameterName);
            statement.setInt(2, queryPersonId);
            int deletedRows = statement.executeUpdate();
            if (this.debug) {
                log.trace((Object)String.format("%s rows delete from TEMP_QUERY_PAREMETER", deletedRows));
            }
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(String.format("Could not delete from table %s", "TEMP_QUERY_PARAMETER"), e);
        }
        finally {
            Daos.closeSilently(statement);
        }
    }

    @Override
    public void executeInsertIntoTempQueryParameter(List<Object> parameterValues, String queryParameterName, int queryPersonId) throws SQLException {
        this.executeDeleteTempQueryParameter(queryParameterName, false, queryPersonId);
        if (this.debug) {
            log.debug((Object)String.format("Setting query parameters into %s", "TEMP_QUERY_PARAMETER".toUpperCase()));
        }
        PreparedStatement statement = null;
        try {
            try {
                statement = this.getPreparedStatement(this.insertIntoTempQueryParameterQuery);
            }
            catch (SQLException e) {
                throw new SynchroTechnicalException(String.format("Error while creating statement on table %s. Make sure this table exist.", "TEMP_QUERY_PARAMETER"), e);
            }
            int rowCount = 0;
            for (Object parameterValue : parameterValues) {
                ++rowCount;
                statement.setString(1, queryParameterName);
                statement.setNull(2, 4);
                statement.setObject(3, parameterValue);
                statement.setInt(4, queryPersonId);
                statement.addBatch();
                if (rowCount % this.batchSize != 0) continue;
                statement.executeBatch();
                statement.clearBatch();
            }
            if (rowCount % this.batchSize != 0) {
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new SynchroTechnicalException(String.format("Could not insert into table %s", "TEMP_QUERY_PARAMETER"), e);
            }
            catch (Throwable throwable) {
                Daos.closeSilently(statement);
                throw throwable;
            }
        }
        Daos.closeSilently(statement);
    }

    protected LoadingCache<String, PreparedStatement> initStatementCache(int maximumSize, int durationInSeconds) {
        return CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterAccess((long)durationInSeconds, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<String, PreparedStatement>(){

            public void onRemoval(RemovalNotification<String, PreparedStatement> notification) {
                Daos.closeSilently((Statement)notification.getValue());
            }
        }).build((CacheLoader)new CacheLoader<String, PreparedStatement>(){

            public PreparedStatement load(String sql) throws SQLException {
                return SynchroBaseDaoImpl.this.newPreparedStatement(sql);
            }
        });
    }

    protected PreparedStatement newPreparedStatement(String sql) throws SQLException {
        this.stats.incrementStatement();
        return this.connection.prepareStatement(sql);
    }

    protected LoadingCache<String, Optional<Object>> initValueCache(int maximumSize, int durationInSeconds) {
        return CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterWrite((long)durationInSeconds, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Optional<Object>>(){

            public Optional<Object> load(String sqlAndBindings) throws SQLException {
                return Optional.fromNullable((Object)SynchroBaseDaoImpl.this.newSqlExecuteUnique(sqlAndBindings));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object newSqlExecuteUnique(String sqlAndBindings) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        String sql;
        block5: {
            Iterator<Object> i$;
            this.stats.incrementExecuteValue();
            String[] sqlParts = sqlAndBindings.split("#");
            sql = sqlParts[0];
            List<Object> bindingValues = SynchroTableMetadata.fromPkStr(sqlParts[1]);
            statement = null;
            rs = null;
            try {
                statement = this.getPreparedStatement(sql);
                int i = 1;
                for (Object value : bindingValues) {
                    statement.setObject(i++, value);
                }
                rs = statement.executeQuery();
                if (rs.next()) break block5;
                i$ = null;
            }
            catch (Throwable throwable) {
                Daos.closeSilently(rs);
                Daos.closeSilently(statement);
                throw throwable;
            }
            Daos.closeSilently(rs);
            Daos.closeSilently(statement);
            return i$;
        }
        Object result = rs.getObject(1);
        if (rs.next()) {
            throw new SynchroTechnicalException("Executed query has more than one row: " + sql);
        }
        Object object = result;
        Daos.closeSilently(rs);
        Daos.closeSilently(statement);
        return object;
    }

    protected String initCleanTempQueryParameterQuery() {
        String sql = String.format("DELETE FROM %s WHERE parameter_name like '%s'", "TEMP_QUERY_PARAMETER", "SYNC#%");
        return sql;
    }

    protected String initInsertIntoTempQueryParameterQuery(Dialect dialect) {
        String sequenceNextValString = dialect.getSelectSequenceNextValString("TEMP_QUERY_PARAMETER_SEQ");
        String sql = String.format("INSERT INTO %s (ID, PARAMETER_NAME, NUMERICAL_VALUE, ALPHANUMERICAL_VALUE, %s) VALUES (%s, ?, ?, ?, ?)", "TEMP_QUERY_PARAMETER", SynchroConfiguration.getInstance().getTempQueryParemeterUserIdColumn(), sequenceNextValString);
        return sql;
    }

    protected String initDeleteTempQueryParameterQuery(boolean likeOperatorForParameterName) {
        String sql = String.format("DELETE FROM %s WHERE parameter_name %s ? AND %s=?", "TEMP_QUERY_PARAMETER", likeOperatorForParameterName ? "LIKE" : "=", SynchroConfiguration.getInstance().getTempQueryParemeterUserIdColumn());
        return sql;
    }
}

