/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ImportRequestResult;
import fr.ifremer.tutti.service.referential.PersonModel;
import fr.ifremer.tutti.service.referential.PersonRow;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporaryPersonService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporaryPersonService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportResult<Person> importTemporaryPerson(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import persons from file: " + file));
        }
        List<Person> allPersons = this.persistenceService.getAllPerson();
        ImportRequestResult<Person, Integer> requestResult = this.processImportFile(file, allPersons);
        ReferentialImportResult<Person> result = new ReferentialImportResult<Person>();
        if (requestResult.withEntitiesToDelete()) {
            Collection<Integer> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporaryPersons(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            Collection<Person> entitiesToAdd = requestResult.getEntitiesToAdd();
            Collection<Person> entitiesAdded = this.persistenceService.importTemporaryPerson(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            Collection<Person> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            Collection<Person> entitiesUpdated = this.persistenceService.importTemporaryPerson(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        return result;
    }

    public void exportExistingTemporaryPerson(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all persons from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllPerson());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " persons"));
        }
        List<Person> toExport = this.persistenceService.retainTemporaryPersonList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary persons"));
        }
        this.exportTemporaryPerson(file, toExport);
    }

    public void exportTemporaryPersonExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Person p = Persons.newPerson();
        p.setFirstName("First name 1");
        p.setLastName("Last name 1");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 2");
        p.setLastName("Last name 2");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 3");
        p.setLastName("Last name 3");
        toExport.add(p);
        this.exportTemporaryPerson(file, toExport);
    }

    protected ImportRequestResult<Person, Integer> processImportFile(File file, List<Person> existingEntities) {
        ImportRequestResult<Person, Integer> requestResult = new ImportRequestResult<Person, Integer>(existingEntities, TuttiEntities.newIdAstIntFunction(), Persons.GET_FULL_NAME);
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            PersonModel csvModel = new PersonModel(this.getCsvSeparator());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (PersonRow bean : importer) {
                    this.importPerson(bean, requestResult);
                }
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.persons.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        return requestResult;
    }

    private void importPerson(PersonRow bean, ImportRequestResult<Person, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = (String)Persons.GET_FULL_NAME.apply((Object)bean.toEntity());
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (id == null) {
            if (delete) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.cannotDeleteWithoutId.error", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.add.noName.error", (Object[])new Object[0]));
            }
            if (!requestResult.addExistingNaturalId(name)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.existingName.error", (Object[])new Object[]{name}));
            }
            requestResult.addEntityToAdd(bean.toEntity());
        } else {
            Person person = requestResult.getExistingEntityById(id);
            if (person == null) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.notExistingId.error", (Object[])new Object[]{id}));
            }
            if (delete) {
                if (this.persistenceService.isTemporaryPersonUsed(id)) {
                    String personRef = id + " : " + this.decoratorService.getDecoratorByType(Person.class).toString((Object)person);
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.used.error", (Object[])new Object[]{personRef}));
                }
                requestResult.addIdToDelete(id);
                requestResult.removeExistingNaturalId(name);
            } else {
                if (StringUtils.isBlank((CharSequence)name)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.noName.error", (Object[])new Object[]{id}));
                }
                if (!name.equals(person.getName()) && !requestResult.addExistingNaturalId(name)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.existingName.error", (Object[])new Object[]{name}));
                }
                requestResult.addEntityToUpdate(bean.toEntity());
            }
        }
    }

    protected void exportTemporaryPerson(File file, List<Person> toExport) throws IOException {
        PersonModel csvModel = new PersonModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Person, PersonRow>(){

            public PersonRow apply(Person person) {
                return new PersonRow(person);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.person.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

