/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri.csv;

import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.pupitri.BoxType;
import fr.ifremer.tutti.service.pupitri.Directions;
import fr.ifremer.tutti.service.pupitri.Signs;
import fr.ifremer.tutti.service.pupitri.csv.CarrouselRow;
import java.text.ParseException;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParser;

public class CarrouselRowModel
extends TuttiCsvUtil.ImportModelWithHeader<CarrouselRow> {
    public CarrouselRowModel(char separator) {
        super(separator);
        this.newMandatoryColumn("operationCode");
        this.newMandatoryColumn("date", (ValueParser)new Common.DateValue("dd/MM/yy"));
        this.newMandatoryColumn("speciesId");
        this.newMandatoryColumn("sign", (ValueParser)new ValueParser<Signs>(){

            public Signs parse(String value) throws ParseException {
                Signs result = Signs.getSign(value.toUpperCase());
                if (result == null) {
                    throw new ParseException("Could not parse Sign value: " + value, 0);
                }
                return result;
            }
        });
        this.newMandatoryColumn("boxType", (ValueParser)new ValueParser<BoxType>(){

            public BoxType parse(String value) throws ParseException {
                BoxType result = BoxType.getBoxType(value.toUpperCase());
                if (result == null) {
                    throw new ParseException("Could not parse BoxType value: " + value, 0);
                }
                return result;
            }
        });
        this.newMandatoryColumn("direction", (ValueParser)TuttiCsvUtil.newEnumByNameParserFormatter(Directions.class));
        this.newMandatoryColumn("weight", (ValueParser)TuttiCsvUtil.WEIGHT_PARSER_FORMATTER);
        this.newIgnoredColumn("fileOrigin");
        this.newIgnoredColumn("rigNumber");
        this.newIgnoredColumn("time");
        this.newIgnoredColumn("balanceId");
        this.newIgnoredColumn("toConfirm");
    }

    @Override
    public String[] getHeader() {
        return new String[]{"fileOrigin", "date", "time", "balanceId", "toConfirm", "operationCode", "rigNumber", "boxType", "speciesId", "sign", "direction", "weight"};
    }

    public CarrouselRow newEmptyInstance() {
        return new CarrouselRow();
    }
}

