/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogFactory;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.parser.core.xml.XMLChangeLogSAXHandler;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomStripperInputStream;
import liquibase.util.file.FilenameUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XMLChangeLogSAXParser
implements ChangeLogParser {
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public XMLChangeLogSAXParser() {
        if (System.getProperty("java.vm.version").startsWith("1.4")) {
            this.saxParserFactory.setValidating(false);
            this.saxParserFactory.setNamespaceAware(false);
        } else {
            this.saxParserFactory.setValidating(true);
            this.saxParserFactory.setNamespaceAware(true);
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public static String getSchemaVersion() {
        return "3.2";
    }

    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return changeLogFile.endsWith("xml");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        inputStream = null;
        try {
            parser = this.saxParserFactory.newSAXParser();
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXNotRecognizedException var6_11) {
            }
            catch (SAXNotSupportedException var6_12) {
                // empty catch block
            }
            xmlReader = parser.getXMLReader();
            resolver = new LiquibaseEntityResolver(this);
            resolver.useResoureAccessor(resourceAccessor, FilenameUtils.getFullPath(physicalChangeLogLocation));
            xmlReader.setEntityResolver(resolver);
            xmlReader.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().warning(exception.getMessage());
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().severe(exception.getMessage());
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().severe(exception.getMessage());
                    throw exception;
                }
            });
            inputStream = resourceAccessor.getResourceAsStream(physicalChangeLogLocation);
            if (inputStream == null) {
                throw new ChangeLogParseException(String.valueOf(physicalChangeLogLocation) + " does not exist");
            }
            contentHandler = new XMLChangeLogSAXHandler(physicalChangeLogLocation, resourceAccessor, changeLogParameters);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(new UtfBomStripperInputStream(inputStream)));
            var10_19 = contentHandler.getDatabaseChangeLog();
            return var10_19;
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ChangeLogParseException("Error Reading Migration File: " + e.getMessage(), e);
        }
        catch (SAXParseException e) {
            throw new ChangeLogParseException("Error parsing line " + e.getLineNumber() + " column " + e.getColumnNumber() + " of " + physicalChangeLogLocation + ": " + e.getMessage(), e);
        }
        catch (SAXException e) {
            parentCause /* !! */  = e.getException();
            ** while (parentCause /* !! */  != null)
        }
lbl-1000:
        // 1 sources

        {
            if (parentCause /* !! */  instanceof ChangeLogParseException) {
                throw (ChangeLogParseException)parentCause /* !! */ ;
            }
            parentCause /* !! */  = parentCause /* !! */ .getCause();
            continue;
        }
lbl37:
        // 1 sources

        reason = e.getMessage();
        causeReason = null;
        if (e.getCause() != null) {
            causeReason = e.getCause().getMessage();
        }
        if (reason == null) {
            reason = causeReason != null ? causeReason : "Unknown Reason";
        }
        throw new ChangeLogParseException("Invalid Migration File: " + reason, e);
        catch (Exception e) {
            throw new ChangeLogParseException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException var11_21) {}
            }
        }
    }
}

