/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.config;

import java.util.Arrays;
import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionConfiguration;

public class DB2ConfigStandard
extends ConnectionConfiguration {
    @Override
    public String getDatabaseShortName() {
        return "db2";
    }

    @Override
    public String getConfigurationName() {
        return "standard";
    }

    @Override
    public String getUrl() {
        return "jdbc:db2://" + this.getHostname() + ":50000/lqbase";
    }

    @Override
    public String getVagrantBoxName() {
        return "linux.centos.6_4";
    }

    @Override
    public Set<String> getRequiredPackages(String vagrantBoxName) {
        Set<String> requiredPackages = super.getRequiredPackages(vagrantBoxName);
        requiredPackages.addAll(Arrays.asList("compat-libstdc++-33", "pam.i686", "numactl"));
        return requiredPackages;
    }

    @Override
    public String getPuppetInit(String box) {
        return "Package <| |> -> Exec['unzip db2']\n\nexec {'unzip db2':\n    command     => '/bin/tar xfzv /install/db2/*expc.tar.gz',\n    cwd     => '/install/db2/',\n    creates  => '/install/db2/expc/',\n    path    => ['/usr/bin', '/usr/sbin', '/bin'],\n}\n\nexec {'/install/db2/expc/db2setup -r /install/db2/db2expc.rsp':\n     require     => [Exec['unzip db2'], User['liquibase'],\n     cwd     => '/install/db2/expc',\n     creates  => '/opt/ibm/db2/',\n     path    => ['/usr/bin', '/usr/sbin', '/bin'],\n}\n";
    }
}

