/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.IMeasureViewConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.MeasureViewTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.CompatibilityStatus;
import org.eclipse.birt.report.model.api.extension.IllegalContentInfo;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class MeasureViewHandle
extends AbstractCrosstabItemHandle
implements IMeasureViewConstants,
ICrosstabConstants {
    MeasureViewHandle(DesignElementHandle handle) {
        super(handle);
    }

    public MeasureHandle getCubeMeasure() {
        MeasureHandle cubeMeasure = (MeasureHandle)this.handle.getElementProperty("measure");
        if (cubeMeasure == null) {
            String measureName = this.getCubeMeasureName();
            CubeHandle cube = this.getCrosstab().getCube();
            if (measureName != null && cube != null) {
                cubeMeasure = cube.getMeasure(measureName);
            }
        }
        return cubeMeasure;
    }

    public String getCubeMeasureName() {
        return this.handle.getStringProperty("measure");
    }

    public String getDataType() {
        String dataType = null;
        CrosstabReportItemHandle crosstabItem = this.getCrosstab();
        if (CrosstabUtil.isBoundToLinkedDataSet(crosstabItem)) {
            String linkedColumnName = this.getCubeMeasureName();
            AggregationCellHandle cell = this.getCell();
            if (cell != null) {
                List contents = cell.getContents();
                for (Object obj : contents) {
                    if (obj == null || !(obj instanceof DataItemHandle)) continue;
                    String bindingName = ((DataItemHandle)obj).getResultSetColumn();
                    ComputedColumnHandle column = CrosstabUtil.getColumnHandle(crosstabItem, bindingName);
                    String string = dataType = column != null ? column.getDataType() : null;
                    if (CrosstabUtil.validateBinding(column, linkedColumnName)) break;
                }
            }
        }
        if (dataType == null) {
            MeasureHandle cubeMeasure = this.getCubeMeasure();
            dataType = cubeMeasure == null ? null : cubeMeasure.getDataType();
        }
        return dataType;
    }

    PropertyHandle getAggregationsProperty() {
        return this.handle.getPropertyHandle("aggregations");
    }

    PropertyHandle getDetailProperty() {
        return this.handle.getPropertyHandle("detail");
    }

    public PropertyHandle getHeaderProperty() {
        return this.handle.getPropertyHandle("header");
    }

    public AggregationCellHandle getCell() {
        PropertyHandle propHandle = this.getDetailProperty();
        return propHandle.getContentCount() == 0 ? null : (AggregationCellHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "AggregationCell");
    }

    public AggregationCellHandle addAggregation(String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        AggregationCellHandle aggregation = this.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (aggregation != null) {
            logger.log(Level.INFO, Messages.getString("MeasureViewHandle.info.aggregation.already.exist"));
            return aggregation;
        }
        ExtendedItemHandle aggregationCell = CrosstabExtendedItemFactory.createAggregationCell(this.moduleHandle);
        if (aggregationCell != null) {
            CommandStack stack = this.getCommandStack();
            stack.startTrans(Messages.getString("MeasureViewHandle.msg.add.aggregation"));
            try {
                aggregationCell.setProperty("aggregationOnRow", rowLevel);
                aggregationCell.setProperty("aggregationOnColumn", colLevel);
                this.getAggregationsProperty().add(aggregationCell);
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
            stack.commit();
        }
        return (AggregationCellHandle)CrosstabUtil.getReportItem(aggregationCell);
    }

    public void removeAggregation(String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        AggregationCellHandle cell = this.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        if (cell != null) {
            cell.handle.drop();
        }
    }

    public AggregationCellHandle getAggregationCell(String rowDimension, String rowLevel, String colDimension, String colLevel) {
        int count = this.getAggregationCount();
        if (count == 0) {
            return null;
        }
        DesignElementHandle found = null;
        int i = 0;
        while (i < count) {
            DesignElementHandle element = this.getAggregationsProperty().getContent(i);
            String row = element.getStringProperty("aggregationOnRow");
            String column = element.getStringProperty("aggregationOnColumn");
            if ((rowLevel != null && rowLevel.equals(row) || rowLevel == null && row == null) && (colLevel != null && colLevel.equals(column) || colLevel == null && column == null)) {
                found = element;
                break;
            }
            ++i;
        }
        return (AggregationCellHandle)CrosstabUtil.getReportItem(found, "AggregationCell");
    }

    public int getAggregationCount() {
        return this.getAggregationsProperty().getContentCount();
    }

    public AggregationCellHandle getAggregationCell(int index) {
        DesignElementHandle element = this.getAggregationsProperty().getContent(index);
        return (AggregationCellHandle)CrosstabUtil.getReportItem(element, "AggregationCell");
    }

    public void removeAggregation(int index) throws SemanticException {
        this.getAggregationsProperty().drop(index);
    }

    public int getIndex() {
        return this.handle.getIndex();
    }

    public CrosstabCellHandle getHeader() {
        return this.getHeader(0);
    }

    public CrosstabCellHandle getHeader(LevelViewHandle levelView) {
        int targetAxis;
        CrosstabReportItemHandle crosstab = this.getCrosstab();
        int n = targetAxis = "vertical".equals(crosstab.getMeasureDirection()) ? 0 : 1;
        if (levelView == null) {
            if (CrosstabModelUtil.isAggregationOn(this, null, targetAxis)) {
                return this.getHeader(this.getHeaderCount() - 1);
            }
        } else if (levelView.getAxisType() == targetAxis) {
            LevelViewHandle innerMost = CrosstabModelUtil.getInnerMostLevel(crosstab, targetAxis);
            if (levelView == innerMost) {
                return this.getHeader();
            }
            List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstab, targetAxis);
            Collections.reverse(levels);
            int realIndex = 0;
            int i = 0;
            while (i < levels.size()) {
                LevelViewHandle lv = levels.get(i);
                if (lv == innerMost || CrosstabModelUtil.isAggregationOn(this, lv.getCubeLevelName(), targetAxis)) {
                    if (levelView == lv) {
                        return this.getHeader(realIndex);
                    }
                    ++realIndex;
                }
                ++i;
            }
        }
        return null;
    }

    public CrosstabCellHandle getHeader(int index) {
        DesignElementHandle headerCell = this.getHeaderCell(index);
        return (CrosstabCellHandle)(headerCell == null ? null : CrosstabUtil.getReportItem(headerCell, "CrosstabCell"));
    }

    public int getHeaderCount() {
        return this.getHeaderProperty().getContentCount();
    }

    private DesignElementHandle getHeaderCell(int index) {
        PropertyHandle propHandle = this.getHeaderProperty();
        if (index < 0 || propHandle.getContentCount() <= index) {
            return null;
        }
        return propHandle.getContent(index);
    }

    public void removeHeader() throws SemanticException {
        new MeasureViewTask(this).removeHeader();
    }

    public void addHeader() throws SemanticException {
        new MeasureViewTask(this).addHeader();
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.handle.getPropertyHandle("filter");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.getListValue().iterator();
    }

    private LevelHandle getInnerestLevel(CrosstabReportItemHandle crosstab, int axisType) {
        int dimCount = crosstab.getDimensionCount(axisType);
        if (dimCount > 0) {
            DimensionViewHandle dv = crosstab.getDimension(axisType, dimCount - 1);
            LevelViewHandle lv = dv.getLevel(dv.getLevelCount() - 1);
            return lv.getCubeLevel();
        }
        return null;
    }

    public CompatibilityStatus checkCompatibility() {
        CrosstabReportItemHandle crosstab = this.getCrosstab();
        if (crosstab.compStatus < 0) {
            IllegalContentInfo detailInfo;
            ExtendedItemHandle oldDetail;
            List<IllegalContentInfo> detailInfoList;
            CompatibilityStatus status = null;
            ArrayList<SemanticException> errorList = null;
            ExtendedItemHandle exhandle = (ExtendedItemHandle)this.getModelHandle();
            Map<String, List<IllegalContentInfo>> illegalContents = exhandle.getIllegalContents();
            if (illegalContents.containsKey("detail") && (detailInfoList = illegalContents.get("detail")).size() > 0 && (oldDetail = (ExtendedItemHandle)(detailInfo = detailInfoList.get(0)).getContent()) != null) {
                status = new CompatibilityStatus();
                status.setStatusType(2);
                try {
                    ExtendedItemHandle newDetail = CrosstabExtendedItemFactory.createAggregationCell(this.getModuleHandle());
                    this.handle.getPropertyHandle("detail").setValue(newDetail);
                    Iterator itr = oldDetail.getPropertyIterator();
                    while (itr.hasNext()) {
                        PropertyHandle propHandle = (PropertyHandle)itr.next();
                        String propName = propHandle.getPropertyDefn().getName();
                        if (!propHandle.isLocal() || "name".equals(propName) || "extends".equals(propName) || "extensionName".equals(propName) || "extensionVersion".equals(propName) || "content".equals(propName)) continue;
                        try {
                            oldDetail.copyPropertyTo(propName, newDetail);
                        }
                        catch (Exception exception) {
                            logger.log(Level.WARNING, "The old property [" + propName + "] is not converted properly to the new Crosstab model.");
                        }
                    }
                    LevelHandle rowLevel = this.getInnerestLevel(crosstab, 0);
                    LevelHandle columnLevel = this.getInnerestLevel(crosstab, 1);
                    if (rowLevel != null) {
                        newDetail.setProperty("aggregationOnRow", rowLevel);
                    }
                    if (columnLevel != null) {
                        newDetail.setProperty("aggregationOnColumn", columnLevel);
                    }
                    List contents = oldDetail.getContents("content");
                    int i = 0;
                    while (i < contents.size()) {
                        ((DesignElementHandle)contents.get(i)).moveTo((DesignElementHandle)newDetail, "content");
                        ++i;
                    }
                }
                catch (SemanticException e) {
                    if (errorList == null) {
                        errorList = new ArrayList(1);
                    }
                    errorList.add(e);
                }
            }
            int expectHeaders = CrosstabModelUtil.computeAllMeasureHeaderCount(crosstab, this);
            int availableHeaders = this.getHeaderCount();
            if (availableHeaders < expectHeaders) {
                PropertyHandle propHandle = this.getHeaderProperty();
                DesignElementHandle oldHeader = this.getHeaderCell(0);
                try {
                    int i = 0;
                    while (i < expectHeaders - availableHeaders) {
                        DesignElementHandle newHeader = oldHeader == null ? CrosstabExtendedItemFactory.createCrosstabCell(this.getModuleHandle()) : oldHeader.copy().getHandle(this.getModuleHandle().getModule());
                        propHandle.add(newHeader);
                        ++i;
                    }
                }
                catch (SemanticException e) {
                    if (errorList == null) {
                        errorList = new ArrayList<SemanticException>(1);
                    }
                    errorList.add(e);
                }
            }
            if (status != null) {
                if (errorList != null) {
                    status.setErrors(errorList);
                }
                return status;
            }
        }
        return COMP_OK_STATUS;
    }
}

