/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.docx.writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.emitter.wpml.writer.AbstractWordXmlWriter;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;
import org.eclipse.birt.report.engine.ooxml.MimeType;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public abstract class BasicComponent
extends AbstractWordXmlWriter {
    private static Logger logger = Logger.getLogger(BasicComponent.class.getName());
    protected ImageManager imageManager;
    protected IPart part;
    private final String validHtml = "^\\s*(.*)<html(.*?)>(.*?)</html>\\s*$";
    private final int DISPLAY_BLOCK = 1;
    private final int DISPLAY_FLAG_ALL = 65535;
    private final int DISPLAY_INLINE = 2;
    private final int DISPLAY_INLINE_BLOCK = 4;
    private final int DISPLAY_NONE = 8;
    private OOXmlWriter ooxmlWriter;
    private OOXmlWriter mhtPartWriter;
    private final String BOUNDARY = "___Actuate_Content_Boundary___";
    private List<String> imageSrc = new ArrayList<String>();
    private ReportDesignHandle handle;

    protected BasicComponent(IPart part) throws IOException {
        this.part = part;
        this.imageManager = (ImageManager)part.getPackage().getExtensionData();
        this.ooxmlWriter = part.getCacheWriter();
        this.writer = this.ooxmlWriter;
    }

    protected void writeXmlns() {
        this.ooxmlWriter.nameSpace("ve", "http://schemas.openxmlformats.org/markup-compatibility/2006");
        this.ooxmlWriter.nameSpace("o", "urn:schemas-microsoft-com:office:office");
        this.ooxmlWriter.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        this.ooxmlWriter.nameSpace("m", "http://schemas.openxmlformats.org/officeDocument/2006/math");
        this.ooxmlWriter.nameSpace("v", "urn:schemas-microsoft-com:vml");
        this.ooxmlWriter.nameSpace("wp", "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing");
        this.ooxmlWriter.nameSpace("w10", "urn:schemas-microsoft-com:office:word");
        this.ooxmlWriter.nameSpace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
        this.ooxmlWriter.nameSpace("wne", "http://schemas.microsoft.com/office/word/2006/wordml");
    }

    protected void drawImage(byte[] data, double height, double width, HyperlinkInfo hyper, IStyle style, AbstractEmitterImpl.InlineFlag inlineFlag, String altText, String uri) {
        int imageId = this.getImageID();
        IPart imagePart = null;
        if (data != null) {
            try {
                ImageManager.ImagePart imgPart = this.imageManager.getImagePart(this.part, uri, data);
                imagePart = imgPart.getPart();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (inlineFlag == AbstractEmitterImpl.InlineFlag.FIRST_INLINE || inlineFlag == AbstractEmitterImpl.InlineFlag.BLOCK) {
            this.writer.openTag("w:p");
        }
        this.openHyperlink(hyper);
        this.writer.openTag("w:r");
        this.writer.openTag("w:pict");
        this.drawImageShapeType(imageId);
        this.drawImageShape(height, width, style, altText, imageId, imagePart);
        this.writer.closeTag("w:pict");
        this.writer.closeTag("w:r");
        this.closeHyperlink(hyper);
        if (inlineFlag == AbstractEmitterImpl.InlineFlag.BLOCK) {
            this.writer.closeTag("w:p");
        }
    }

    private void drawImageShape(double height, double width, IStyle style, String altText, int imageId, IPart imagePart) {
        this.writer.openTag("v:shape");
        this.writer.attribute("id", "_x0000_i10" + imageId);
        this.writer.attribute("type", "#_x0000_t" + imageId);
        this.writer.attribute("alt", altText);
        this.writer.attribute("style", "width:" + width + "pt;height:" + height + "pt");
        this.drawImageBordersColor(style);
        this.writer.openTag("v:imagedata");
        if (imagePart != null) {
            this.writer.attribute("r:id", imagePart.getRelationshipId());
            this.writer.attribute("r:href", this.part.getExternalImageId("ooxWord:/" + imagePart.getAbsoluteUri()));
        } else {
            this.writer.attribute("r:id", this.part.getExternalImageId("wordml://" + imageId + ".png"));
        }
        this.writer.closeTag("v:imagedata");
        this.drawImageBordersStyle(style);
        this.writer.closeTag("v:shape");
    }

    @Override
    protected void openHyperlink(HyperlinkInfo info) {
        if (info == null) {
            return;
        }
        this.writer.openTag("w:hyperlink");
        if (info.getType() == 0) {
            this.writer.attribute("w:anchor", info.getUrl());
        } else if (1 == info.getType()) {
            if (info.getUrl() != null) {
                String url = info.getUrl().replaceAll(" ", "");
                this.writer.attribute("r:id", this.part.getHyperlinkId(url));
            }
            if (info.getBookmark() != null) {
                this.writer.attribute("w:anchor", info.getBookmark());
            }
        }
        if (info.getTooltip() != null) {
            this.writer.attribute("w:tooltip", info.getTooltip());
        }
    }

    @Override
    protected void closeHyperlink(HyperlinkInfo info) {
        if (info == null || info.getType() == 2) {
            return;
        }
        this.writer.closeTag("w:hyperlink");
    }

    @Override
    protected void writeTableLayout() {
        this.writer.openTag("w:tblLayout");
        this.writer.attribute("w:type", "fixed");
        this.writer.closeTag("w:tblLayout");
    }

    @Override
    protected void writeFontSize(IStyle style) {
        CSSValue fontSize = style.getProperty(39);
        int size = WordUtil.parseFontSize(PropertyUtil.getDimensionValue(fontSize));
        this.writeAttrTag("w:sz", size);
        this.writeAttrTag("w:szCs", size);
    }

    @Override
    protected void writeFont(String fontFamily) {
        this.writer.openTag("w:rFonts");
        this.writer.attribute("w:ascii", fontFamily);
        this.writer.attribute("w:eastAsia", fontFamily);
        this.writer.attribute("w:hAnsi", fontFamily);
        this.writer.attribute("w:cs", fontFamily);
        this.writer.closeTag("w:rFonts");
    }

    @Override
    protected void writeFontStyle(IStyle style) {
        String val = WordUtil.removeQuote(style.getFontStyle());
        if (!"normal".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:i", "on");
            this.writeAttrTag("w:iCs", "on");
        }
    }

    @Override
    protected void writeFontWeight(IStyle style) {
        String val = WordUtil.removeQuote(style.getFontWeight());
        if (!"normal".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:b", "on");
            this.writeAttrTag("w:bCs", "on");
        }
    }

    protected void writeTOC(String tocText, int level) {
        this.writeTOC(tocText, null, level, false);
    }

    protected void writeTOC(String tocText, String color, int level, boolean middleInline) {
        if (!middleInline) {
            this.writer.openTag("w:p");
        }
        if (color != null && color.length() != 0) {
            this.writer.openTag("w:pPr");
            this.writer.openTag("w:shd");
            this.writer.attribute("w:val", "clear");
            this.writer.attribute("w:color", "auto");
            this.writer.attribute("w:fill", color);
            this.writer.closeTag("w:shd");
            this.writer.openTag("w:rPr");
            this.writer.openTag("w:vanish");
            this.writer.closeTag("w:vanish");
            this.writer.closeTag("w:rPr");
            this.writer.closeTag("w:pPr");
        } else {
            this.writer.openTag("w:rPr");
            this.writer.openTag("w:vanish");
            this.writer.closeTag("w:vanish");
            this.writer.closeTag("w:rPr");
        }
        this.writer.openTag("w:bookmarkStart");
        this.writer.attribute("w:id", this.bookmarkId);
        this.writer.attribute("w:name", "_Toc" + tocText);
        this.writer.closeTag("w:bookmarkStart");
        this.writer.openTag("w:bookmarkEnd");
        this.writer.attribute("w:id", this.bookmarkId);
        this.writer.closeTag("w:bookmarkEnd");
        this.writeField(true);
        this.writeTocText(tocText, level);
        this.writeField(false);
        if (!middleInline) {
            this.writer.closeTag("w:p");
        }
    }

    @Override
    protected void writeVmerge(SpanInfo spanInfo) {
        if (spanInfo.isStart()) {
            this.writeAttrTag("w:vMerge", "restart");
        } else {
            this.writer.openTag("w:vMerge");
            this.writer.closeTag("w:vMerge");
        }
    }

    protected void writeBookmark(String bm) {
        String bookmark = WordUtil.validBookmarkName(bm);
        this.writer.openTag("w:bookmarkStart");
        this.writer.attribute("w:id", this.bookmarkId);
        this.writer.attribute("w:name", bookmark);
        this.writer.closeTag("w:bookmarkStart");
        this.writer.openTag("w:bookmarkEnd");
        this.writer.attribute("w:id", this.bookmarkId);
        this.writer.closeTag("w:bookmarkEnd");
        ++this.bookmarkId;
    }

    protected void writeForeign(IForeignContent foreignContent) {
        if (foreignContent.getRawValue() != null) {
            String uri = "mhtText" + this.getMhtTextId() + ".mht";
            MimeType type = MimeType.MHT;
            String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk";
            IPart mhtPart = this.part.getPart(uri, type, relationshipType);
            this.handle = foreignContent.getReportContent().getDesign().getReportDesign();
            this.writeMhtPart(mhtPart, foreignContent);
            this.writer.openTag("w:altChunk");
            this.writer.attribute("r:id", mhtPart.getRelationshipId());
            this.writer.closeTag("w:altChunk");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeMhtPart(IPart mhtPart, IForeignContent foreignContent) {
        try {
            try {
                this.mhtPartWriter = mhtPart.getWriter();
                this.mhtPartWriter.println("From:");
                this.mhtPartWriter.println("Subject:");
                this.mhtPartWriter.println("Date:");
                this.mhtPartWriter.println("MIME-Version: 1.0");
                this.mhtPartWriter.println("Content-Type: multipart/related; type=\"text/html\"; boundary=\"___Actuate_Content_Boundary___\"");
                this.writeHtmlText(foreignContent);
                this.writeImages();
                return;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                if (this.mhtPartWriter == null) return;
                this.mhtPartWriter.close();
                this.mhtPartWriter = null;
                return;
            }
            catch (EncoderException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                if (this.mhtPartWriter == null) return;
                this.mhtPartWriter.close();
                this.mhtPartWriter = null;
                return;
            }
        }
        finally {
            if (this.mhtPartWriter != null) {
                this.mhtPartWriter.close();
                this.mhtPartWriter = null;
            }
        }
    }

    private void buildHtmlBody(IForeignContent foreignContent, String foreignText, IStyle style, StringBuffer htmlBuffer) throws EncoderException, UnsupportedEncodingException {
        htmlBuffer.append("<body>");
        DimensionType x = foreignContent.getX();
        DimensionType y = foreignContent.getY();
        DimensionType width = foreignContent.getWidth();
        DimensionType height = foreignContent.getHeight();
        int display = this.getElementType(x, y, width, height, style);
        String tagName = this.getTagByType(display, 65535);
        if (tagName != null) {
            htmlBuffer.append("<div");
            if (tagName.equalsIgnoreCase("span")) {
                htmlBuffer.append(" style=\"display: inline\" ");
            }
        }
        if (style != null && !style.isEmpty()) {
            htmlBuffer.append(" class=\"styleForeign\"");
        }
        StringBuffer foreignStyles = new StringBuffer();
        this.buildForeignStyles(foreignContent, foreignStyles, display);
        if (foreignStyles.length() > 0) {
            htmlBuffer.append(" style =\"");
            htmlBuffer.append(foreignStyles + "\"");
        }
        htmlBuffer.append(">");
        Map appContext = foreignContent.getReportContent().getReportContext() == null ? null : foreignContent.getReportContent().getReportContext().getAppContext();
        htmlBuffer.append(this.normalize(foreignText, appContext));
        htmlBuffer.append("</" + tagName + ">");
        htmlBuffer.append("</body>");
        String quotedPritableHtml = this.encodcAsQuotedPrintable(htmlBuffer.toString());
        this.mhtPartWriter.println(quotedPritableHtml);
    }

    private String encodcAsQuotedPrintable(String normalizedHtml) throws EncoderException {
        return new QuotedPrintableCodec().encode(normalizedHtml);
    }

    private String normalize(String foreignText, Map appContext) throws UnsupportedEncodingException {
        NodeList bodys;
        Document doc = new TextParser().parse(foreignText, TextParser.TEXT_TYPE_HTML);
        HTMLProcessor htmlProcessor = new HTMLProcessor(this.handle, appContext);
        HashMap styleMap = new HashMap();
        Element body = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        HTMLWriter htmlWriter = new HTMLWriter();
        htmlWriter.open(byteOut);
        if (doc != null && (bodys = doc.getElementsByTagName("body")).getLength() > 0) {
            body = (Element)bodys.item(0);
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap);
            this.processNodes(body, styleMap, htmlWriter, appContext);
        }
        htmlWriter.close();
        return new String(byteOut.toByteArray(), "UTF-8");
    }

    private void buildStyleClass(IStyle style, StringBuffer htmlBuffer) {
        StringBuffer styleBuffer = new StringBuffer();
        this.buildStyle(styleBuffer, style);
        if (styleBuffer.length() > 0) {
            htmlBuffer.append("<head>");
            htmlBuffer.append("<style type=\"text/css\">");
            htmlBuffer.append(".styleForeign");
            htmlBuffer.append('{');
            htmlBuffer.append(styleBuffer.toString());
            htmlBuffer.append('}');
            htmlBuffer.append("</style>");
            htmlBuffer.append("</head>");
        }
    }

    private void buildStyle(StringBuffer styleBuffer, IStyle style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        this.buildFont(styleBuffer, style);
        this.buildBox(styleBuffer, style);
        this.buildText(styleBuffer, style);
        this.buildVisual(styleBuffer, style);
        this.buildTextDecoration(styleBuffer, style);
        this.buildDirection(styleBuffer, style);
    }

    private void buildDirection(StringBuffer styleBuffer, IStyle style) {
        String direction = style.getDirection();
        if ("rtl".equals(style.getDirection())) {
            styleBuffer.append(" direction:");
            styleBuffer.append(direction);
            styleBuffer.append(";");
            styleBuffer.append("unicode-bidi:didi-override;");
        }
    }

    private int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    private String getTagByType(int display, int mask) {
        int flag = display & mask;
        String tag = null;
        if ((flag & 1) > 0) {
            tag = "div";
        }
        if ((flag & 2) > 0) {
            tag = "span";
        }
        return tag;
    }

    private void buildForeignStyles(IForeignContent foreignContent, StringBuffer foreignStyles, int display) {
        IStyle style = foreignContent.getComputedStyle();
        foreignStyles.setLength(0);
        this.buildTextAlign(foreignStyles, style);
        style = this.getElementStyle(foreignContent);
        if (style == null) {
            return;
        }
        this.buildFont(foreignStyles, style);
        this.buildBox(foreignStyles, style);
        this.buildText(foreignStyles, style);
        this.buildVisual(foreignStyles, style);
        this.buildTextDecoration(foreignStyles, style);
    }

    private IStyle getElementStyle(IContent content) {
        IStyle style = content.getInlineStyle();
        if (style == null || style.isEmpty()) {
            return null;
        }
        return style;
    }

    private void buildTextAlign(StringBuffer foreignStyles, IStyle style) {
        String textAlign = style.getTextAlign();
        if (textAlign != null) {
            foreignStyles.append(" text-align:");
            foreignStyles.append(textAlign);
            foreignStyles.append(";");
        }
    }

    private void buildFont(StringBuffer styleBuffer, IStyle style) {
        this.buildProperty(styleBuffer, "font-family", style.getFontFamily());
        this.buildProperty(styleBuffer, "font-style", style.getFontStyle());
        this.buildProperty(styleBuffer, "font-variant", style.getFontVariant());
        this.buildProperty(styleBuffer, "font-weight", style.getFontWeight());
        this.buildProperty(styleBuffer, "font-size", style.getFontSize());
        this.buildProperty(styleBuffer, "color", style.getColor());
    }

    private void buildProperty(StringBuffer styleBuffer, String name, String value) {
        if (value != null) {
            this.addPropName(styleBuffer, name);
            this.addPropValue(styleBuffer, value);
            styleBuffer.append(';');
        }
    }

    private void addPropName(StringBuffer styleBuffer, String name) {
        styleBuffer.append(' ');
        styleBuffer.append(name);
        styleBuffer.append(':');
    }

    private void addPropValue(StringBuffer styleBuffer, String value) {
        if (value != null) {
            styleBuffer.append(' ');
            styleBuffer.append(value);
        }
    }

    private void buildBox(StringBuffer styleBuffer, IStyle style) {
        this.buildMargins(styleBuffer, style);
        this.buildPaddings(styleBuffer, style);
    }

    private void buildMargins(StringBuffer styleBuffer, IStyle style) {
        String topMargin = style.getMarginTop();
        String rightMargin = style.getMarginRight();
        String bottomMargin = style.getMarginBottom();
        String leftMargin = style.getMarginLeft();
        if (topMargin != null && rightMargin != null && bottomMargin != null && leftMargin != null) {
            if (rightMargin.equals(leftMargin)) {
                if (topMargin.equals(bottomMargin)) {
                    if (topMargin.equals(rightMargin)) {
                        this.buildProperty(styleBuffer, "margin", topMargin);
                    } else {
                        this.addPropName(styleBuffer, "margin");
                        this.addPropValue(styleBuffer, topMargin);
                        this.addPropValue(styleBuffer, rightMargin);
                        styleBuffer.append(';');
                    }
                } else {
                    this.addPropName(styleBuffer, "margin");
                    this.addPropValue(styleBuffer, topMargin);
                    this.addPropValue(styleBuffer, rightMargin);
                    this.addPropValue(styleBuffer, bottomMargin);
                    styleBuffer.append(';');
                }
            } else {
                this.addPropName(styleBuffer, "margin");
                this.addPropValue(styleBuffer, topMargin);
                this.addPropValue(styleBuffer, rightMargin);
                this.addPropValue(styleBuffer, bottomMargin);
                this.addPropValue(styleBuffer, leftMargin);
                styleBuffer.append(';');
            }
        } else {
            this.buildProperty(styleBuffer, "margin-top", topMargin);
            this.buildProperty(styleBuffer, "margin-right", rightMargin);
            this.buildProperty(styleBuffer, "margin-bottom", bottomMargin);
            this.buildProperty(styleBuffer, "margin-left", leftMargin);
        }
    }

    public void buildPaddings(StringBuffer styleBuffer, IStyle style) {
        String topPadding = style.getPaddingTop();
        String rightPadding = style.getPaddingRight();
        String bottomPadding = style.getPaddingBottom();
        String leftPadding = style.getPaddingLeft();
        if (topPadding != null && rightPadding != null && bottomPadding != null && leftPadding != null) {
            if (rightPadding.equals(leftPadding)) {
                if (topPadding.equals(bottomPadding)) {
                    if (topPadding.equals(rightPadding)) {
                        this.buildProperty(styleBuffer, "padding", topPadding);
                    } else {
                        this.addPropName(styleBuffer, "padding");
                        this.addPropValue(styleBuffer, topPadding);
                        this.addPropValue(styleBuffer, rightPadding);
                        styleBuffer.append(';');
                    }
                } else {
                    this.addPropName(styleBuffer, "padding");
                    this.addPropValue(styleBuffer, topPadding);
                    this.addPropValue(styleBuffer, rightPadding);
                    this.addPropValue(styleBuffer, bottomPadding);
                    styleBuffer.append(';');
                }
            } else {
                this.addPropName(styleBuffer, "padding");
                this.addPropValue(styleBuffer, topPadding);
                this.addPropValue(styleBuffer, rightPadding);
                this.addPropValue(styleBuffer, bottomPadding);
                this.addPropValue(styleBuffer, leftPadding);
                styleBuffer.append(';');
            }
        } else {
            this.buildProperty(styleBuffer, "padding-top", topPadding);
            this.buildProperty(styleBuffer, "padding-right", rightPadding);
            this.buildProperty(styleBuffer, "padding-bottom", bottomPadding);
            this.buildProperty(styleBuffer, "padding-left", leftPadding);
        }
    }

    private void buildText(StringBuffer styleBuffer, IStyle style) {
        this.buildProperty(styleBuffer, "text-indent", style.getTextIndent());
        this.buildProperty(styleBuffer, "letter-spacing", style.getLetterSpacing());
        this.buildProperty(styleBuffer, "word-spacing", style.getWordSpacing());
        this.buildProperty(styleBuffer, "text-transform", style.getTextTransform());
        this.buildProperty(styleBuffer, "white-space", style.getWhiteSpace());
    }

    private void buildVisual(StringBuffer styleBuffer, IStyle style) {
        this.buildProperty(styleBuffer, "line-height", style.getLineHeight());
    }

    private void buildTextDecoration(StringBuffer styleBuffer, IStyle style) {
        CSSValue linethrough = style.getProperty(27);
        CSSValue underline = style.getProperty(58);
        CSSValue overline = style.getProperty(34);
        if (linethrough == IStyle.LINE_THROUGH_VALUE || underline == IStyle.UNDERLINE_VALUE || overline == IStyle.OVERLINE_VALUE) {
            styleBuffer.append(" text-decoration:");
            if (IStyle.LINE_THROUGH_VALUE == linethrough) {
                this.addPropValue(styleBuffer, "line-through");
            }
            if (IStyle.UNDERLINE_VALUE == underline) {
                this.addPropValue(styleBuffer, "underline");
            }
            if (IStyle.OVERLINE_VALUE == overline) {
                this.addPropValue(styleBuffer, "overline");
            }
            styleBuffer.append(';');
        }
    }

    private void writeImages() {
        for (String uri : this.imageSrc) {
            String imageType = uri.substring(uri.indexOf(46) + 1);
            this.mhtPartWriter.println();
            this.mhtPartWriter.println("--___Actuate_Content_Boundary___");
            this.mhtPartWriter.println("Content-Type: image/" + imageType);
            this.mhtPartWriter.println("Content-Transfer-Encoding: base64");
            this.mhtPartWriter.println("Content-Location:" + uri);
            this.mhtPartWriter.println();
            try {
                byte[] data = EmitterUtil.getImageData(uri);
                if (data == null || data.length == 0) continue;
                Base64 base = new Base64();
                String pic2Text = new String(base.encode(data));
                this.mhtPartWriter.println(pic2Text);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        this.mhtPartWriter.println();
        this.mhtPartWriter.println("--___Actuate_Content_Boundary___--");
    }

    private void writeHtmlText(IForeignContent foreignContent) throws EncoderException, UnsupportedEncodingException {
        this.mhtPartWriter.println();
        this.mhtPartWriter.println("--___Actuate_Content_Boundary___");
        this.mhtPartWriter.println("Content-Type: text/html; charset=\"gb2312\"");
        this.mhtPartWriter.println("Content-Transfer-Encoding: quoted-printable");
        this.mhtPartWriter.println();
        StringBuffer htmlBuffer = new StringBuffer();
        String foreignText = foreignContent.getRawValue().toString();
        String headInformation = null;
        String htmlAttribute = null;
        Pattern pattern = Pattern.compile("^\\s*(.*)<html(.*?)>(.*?)</html>\\s*$", 42);
        Matcher matcher = pattern.matcher(foreignText);
        if (matcher.find() && matcher.group(0).length() == foreignText.length()) {
            headInformation = matcher.group(1);
            htmlAttribute = matcher.group(2);
            foreignText = matcher.group(3);
        }
        this.mhtPartWriter.print("=EF=BB=BF");
        if (headInformation != null) {
            htmlBuffer.append(String.valueOf(headInformation) + " ");
        }
        htmlBuffer.append("<html");
        if (htmlAttribute != null) {
            htmlBuffer.append(" " + htmlAttribute);
        }
        htmlBuffer.append(">");
        IStyle style = foreignContent.getComputedStyle();
        this.buildStyleClass(style, htmlBuffer);
        this.buildHtmlBody(foreignContent, foreignText, style, htmlBuffer);
        this.mhtPartWriter.print("</html>");
    }

    private void processNodes(Element ele, HashMap cssStyles, HTMLWriter writer, Map appContext) {
        Node node = ele.getFirstChild();
        while (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 3) {
                if (this.isScriptText(node)) {
                    writer.cdata(node.getNodeValue());
                } else {
                    writer.text(node.getNodeValue());
                }
            } else if (nodeType == 8) {
                writer.comment(node.getNodeValue());
            } else if (nodeType == 1) {
                Element cfr_ignored_0 = (Element)node;
                if ("br".equalsIgnoreCase(node.getNodeName())) {
                    boolean bImplicitCloseTag = writer.isImplicitCloseTag();
                    writer.setImplicitCloseTag(true);
                    this.startNode(node, cssStyles, writer, appContext);
                    this.processNodes((Element)node, cssStyles, writer, appContext);
                    this.endNode(node, writer);
                    writer.setImplicitCloseTag(bImplicitCloseTag);
                } else {
                    this.startNode(node, cssStyles, writer, appContext);
                    this.processNodes((Element)node, cssStyles, writer, appContext);
                    this.endNode(node, writer);
                }
            }
            node = node.getNextSibling();
        }
    }

    public void startNode(Node node, HashMap cssStyles, HTMLWriter writer, Map appContext) {
        String nodeName = node.getNodeName();
        HashMap cssStyle = (HashMap)cssStyles.get(node);
        writer.openTag(nodeName);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String attrName = attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                if (attrValue != null) {
                    String attrValueTrue;
                    if ("img".equalsIgnoreCase(nodeName) && "src".equalsIgnoreCase(attrName) && (attrValueTrue = this.handleStyleImage(attrValue, appContext)) != null) {
                        attrValue = attrValueTrue;
                    }
                    writer.attribute(attrName, attrValue);
                }
                ++i;
            }
        }
        if (cssStyle != null) {
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry entry : cssStyle.entrySet()) {
                Object keyObj = entry.getKey();
                Object valueObj = entry.getValue();
                if (keyObj == null || valueObj == null) continue;
                String key = keyObj.toString();
                String value = valueObj.toString();
                buffer.append(key);
                buffer.append(":");
                if ("background-image".equalsIgnoreCase(key)) {
                    String valueTrue = this.handleStyleImage(value, appContext);
                    if (valueTrue != null) {
                        value = valueTrue;
                    }
                    buffer.append("url(");
                    buffer.append(value);
                    buffer.append(")");
                } else {
                    buffer.append(value);
                }
                buffer.append(";");
            }
            if (buffer.length() != 0) {
                writer.attribute("style", buffer.toString());
            }
        }
    }

    public String handleStyleImage(String uri, Map appContext) {
        if (uri != null) {
            URL url;
            if (FileUtil.isLocalResource(uri) && (url = this.handle.findResource(uri, 1, appContext)) != null) {
                uri = url.toString();
            }
            this.imageSrc.add(uri);
        }
        return uri;
    }

    public void endNode(Node node, HTMLWriter writer) {
        writer.closeTag(node.getNodeName());
    }

    private boolean isScriptText(Node node) {
        String tag;
        Node parent = node.getParentNode();
        return parent != null && parent.getNodeType() == 1 && "script".equalsIgnoreCase(tag = parent.getNodeName());
    }

    public String validHtmlText(String foreignText) {
        Pattern pattern = Pattern.compile("^\\s*(.*)<html(.*?)>(.*?)</html>\\s*$", 42);
        Matcher matcher = pattern.matcher(foreignText);
        if (matcher.matches()) {
            return foreignText;
        }
        return "<html>" + foreignText + "</html>";
    }

    protected String getRelationshipId() {
        return this.part.getRelationshipId();
    }

    @Override
    public void startTableRow(double height, boolean isHeader, boolean repeatHeader, boolean fixedLayout) {
        this.writer.openTag("w:tr");
        this.writer.openTag("w:trPr");
        if (height != -1.0) {
            this.writer.openTag("w:trHeight");
            if (fixedLayout) {
                this.writer.attribute("w:hRule", "exact");
            }
            this.writer.attribute("w:val", height);
            this.writer.closeTag("w:trHeight");
        }
        if (isHeader) {
            String headerOnOff = repeatHeader ? "on" : "off";
            this.writeAttrTag("w:tblHeader", headerOnOff);
        }
        this.writer.closeTag("w:trPr");
    }

    @Override
    protected void writeIndent(int textIndent) {
        this.writer.openTag("w:ind");
        this.writer.attribute("w:firstLine", textIndent);
        this.writer.closeTag("w:ind");
    }

    @Override
    protected void writeIndent(int leftMargin, int rightMargin, int textIndent) {
        if (leftMargin == 0 && rightMargin == 0 && textIndent == 0) {
            return;
        }
        this.writer.openTag("w:ind");
        if (leftMargin != 0) {
            this.writer.attribute("w:left", leftMargin);
        }
        if (rightMargin != 0) {
            this.writer.attribute("w:right", rightMargin);
        }
        if (textIndent != 0) {
            this.writer.attribute("w:firstLine", textIndent);
        }
        this.writer.closeTag("w:ind");
    }

    abstract void start();

    abstract void end();

    protected abstract int getMhtTextId();
}

