/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.IGroupedDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.datafeed.ChartVariableHelper;
import org.eclipse.birt.chart.internal.datafeed.GroupKey;
import org.eclipse.birt.chart.internal.datafeed.GroupingLookupHelper;
import org.eclipse.birt.chart.internal.datafeed.GroupingUtil;
import org.eclipse.birt.chart.internal.datafeed.ResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.ResultSetWrapper;
import org.eclipse.birt.chart.internal.datafeed.UserDataSetProcessor;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.emf.common.util.EList;

public class DataProcessor {
    private final RunTimeContext rtc;
    private final IActionEvaluator iae;

    public DataProcessor(RunTimeContext rtc, IActionEvaluator iae) {
        this.rtc = rtc;
        this.iae = iae;
    }

    public static String[] getSeriesTriggerExpressions(Series se, IActionEvaluator iae, SeriesDefinition baseSD, SeriesDefinition orthoSD) {
        ArrayList<String> rt = new ArrayList<String>();
        if (se != null && iae != null) {
            for (Trigger tg : se.getTriggers()) {
                String[] expra = iae.getActionExpressions(tg.getAction(), StructureSource.createSeries(se));
                if (expra == null || expra.length <= 0) continue;
                int i = 0;
                while (i < expra.length) {
                    String expr = expra[i];
                    if (baseSD != null && orthoSD != null) {
                        expr = ChartVariableHelper.parseChartVariables(expr, se, baseSD, orthoSD);
                    }
                    if (expr != null && expr.trim().length() > 0 && !rt.contains(expr)) {
                        rt.add(expr);
                    }
                    ++i;
                }
            }
        }
        if (rt.size() > 0) {
            return rt.toArray(new String[rt.size()]);
        }
        return null;
    }

    public static String[] getDesignTimeStringsSeriesTriggerExpressions(Series se, IActionEvaluator iae) {
        return DataProcessor.getSeriesTriggerExpressions(se, iae, null, null);
    }

    private GroupKey[] findGroupKeys(Chart cm, GroupingLookupHelper lhmLookup) {
        if (cm instanceof ChartWithAxes) {
            return this.findGroupKeys((ChartWithAxes)cm, lhmLookup);
        }
        if (cm instanceof ChartWithoutAxes) {
            return this.findGroupKeys((ChartWithoutAxes)cm, lhmLookup);
        }
        return null;
    }

    private GroupKey[] findGroupKeys(ChartWithoutAxes cwoa, GroupingLookupHelper lhmLookup) {
        ArrayList<GroupKey> alKeys = new ArrayList<GroupKey>(4);
        EList<SeriesDefinition> elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        elSD = sd.getSeriesDefinitions();
        int i = 0;
        while (i < elSD.size()) {
            GroupKey sortKey;
            String sExpression;
            sd = (SeriesDefinition)elSD.get(i);
            Query qOrthogonalSeriesDefinition = sd.getQuery();
            if (qOrthogonalSeriesDefinition != null && (sExpression = qOrthogonalSeriesDefinition.getDefinition()) != null && sExpression.trim().length() > 0 && !alKeys.contains(sortKey = new GroupKey(sExpression, sd.isSetSorting() ? sd.getSorting() : null))) {
                sortKey.setKeyIndex(lhmLookup.findIndex(sExpression, lhmLookup.getOrthogonalAggregationExpression(sd)));
                alKeys.add(sortKey);
            }
            ++i;
        }
        return alKeys.toArray(new GroupKey[alKeys.size()]);
    }

    private GroupKey[] findGroupKeys(ChartWithAxes cwa, GroupingLookupHelper lhmLookup) {
        ArrayList<GroupKey> alKeys = new ArrayList<GroupKey>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int i = 0;
        while (i < axaOrthogonal.length) {
            EList<SeriesDefinition> elSD = axaOrthogonal[i].getSeriesDefinitions();
            int j = 0;
            while (j < elSD.size()) {
                GroupKey sortKey;
                String sExpression;
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                Query qOrthogonalSeriesDefinition = sd.getQuery();
                if (qOrthogonalSeriesDefinition != null && (sExpression = qOrthogonalSeriesDefinition.getDefinition()) != null && sExpression.trim().length() > 0 && !alKeys.contains(sortKey = new GroupKey(sExpression, sd.isSetSorting() ? sd.getSorting() : null))) {
                    sortKey.setKeyIndex(lhmLookup.findIndex(sExpression, lhmLookup.getOrthogonalAggregationExpression(sd)));
                    alKeys.add(sortKey);
                }
                ++j;
            }
            ++i;
        }
        return alKeys.toArray(new GroupKey[alKeys.size()]);
    }

    protected ResultSetWrapper mapToChartResultSet(IDataRowExpressionEvaluator idre, Chart cm) throws ChartException {
        ResultSetWrapper rsw = null;
        GroupingLookupHelper lhmLookup = new GroupingLookupHelper(cm, this.iae, this.rtc, idre);
        List<Object[]> liResultSet = null;
        List<String> co = null;
        co = lhmLookup.getExpressions();
        try {
            liResultSet = this.evaluateRowSet(idre, co.toArray());
        }
        catch (RuntimeException e) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)e);
        }
        GroupKey[] orthogonalGroupKeys = this.findGroupKeys(cm, lhmLookup);
        if (idre instanceof IGroupedDataRowExpressionEvaluator && ((IGroupedDataRowExpressionEvaluator)idre).getGroupBreaks(0) != null) {
            int[] groupBreaks = new int[]{};
            if (orthogonalGroupKeys != null && orthogonalGroupKeys.length > 0) {
                int groupLevel = 0;
                boolean[] groupStatus = ((IGroupedDataRowExpressionEvaluator)idre).getGroupStatus();
                if (groupStatus != null) {
                    while (groupLevel < groupStatus.length) {
                        if (groupStatus[groupLevel]) break;
                        ++groupLevel;
                    }
                    if (groupLevel >= groupStatus.length) {
                        groupLevel = 0;
                    }
                }
                groupBreaks = ((IGroupedDataRowExpressionEvaluator)idre).getGroupBreaks(groupLevel);
            }
            this.formatBaseSeriesData(cm, lhmLookup, liResultSet);
            rsw = new ResultSetWrapper(lhmLookup, liResultSet, orthogonalGroupKeys, groupBreaks);
        } else {
            rsw = new ResultSetWrapper(lhmLookup, liResultSet, orthogonalGroupKeys);
            SeriesDefinition sdBase = null;
            SeriesDefinition sdValue = null;
            boolean bBaseGrouping = false;
            AggregationExpressionHelper aggHelper = new AggregationExpressionHelper();
            if (cm instanceof ChartWithAxes) {
                ChartWithAxes cwa = (ChartWithAxes)cm;
                Axis[] axaBase = cwa.getBaseAxes();
                Axis[] axaOrthogonal = null;
                int j = 0;
                while (j < axaBase.length) {
                    sdBase = (SeriesDefinition)axaBase[j].getSeriesDefinitions().get(0);
                    axaOrthogonal = cwa.getOrthogonalAxes(axaBase[j], true);
                    bBaseGrouping = rsw.getRowCount() > 0 && sdBase.getGrouping() != null && sdBase.getGrouping().isEnabled();
                    int i = 0;
                    while (i < axaOrthogonal.length) {
                        aggHelper.addSeriesDefinitions(axaOrthogonal[i].getSeriesDefinitions(), lhmLookup);
                        ++i;
                    }
                    ++j;
                }
                sdValue = (SeriesDefinition)cwa.getOrthogonalAxes(axaBase[0], true)[0].getSeriesDefinitions().get(0);
            } else if (cm instanceof ChartWithoutAxes) {
                ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
                sdBase = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
                bBaseGrouping = rsw.getRowCount() > 0 && sdBase.getGrouping() != null && sdBase.getGrouping().isEnabled();
                aggHelper.addSeriesDefinitions(sdBase.getSeriesDefinitions(), lhmLookup);
                sdValue = (SeriesDefinition)sdBase.getSeriesDefinitions().get(0);
            }
            if (bBaseGrouping && aggHelper.getDataDefinitionsForBaseGrouping().size() > 0) {
                aggHelper.addAggregation(sdBase.getGrouping().getAggregateExpression(), aggHelper.getDataDefinitionsForBaseGrouping());
            }
            String[] aggregationExp = aggHelper.getAggregations();
            String[] saExpressionKeys = aggHelper.getDataDefinitions();
            if (idre instanceof IGroupedDataRowExpressionEvaluator) {
                if (((IGroupedDataRowExpressionEvaluator)idre).needOptionalGrouping()) {
                    rsw.applyValueSeriesGroupingNSorting(sdValue, aggregationExp, saExpressionKeys);
                }
                if (((IGroupedDataRowExpressionEvaluator)idre).needCategoryGrouping()) {
                    rsw.applyBaseSeriesSortingAndGrouping(sdBase, aggregationExp, saExpressionKeys);
                }
            } else {
                rsw.applyValueSeriesGroupingNSorting(sdValue, aggregationExp, saExpressionKeys);
                rsw.applyBaseSeriesSortingAndGrouping(sdBase, aggregationExp, saExpressionKeys);
            }
            aggHelper.dispose();
        }
        return rsw;
    }

    public void generateRuntimeSeries(IDataRowExpressionEvaluator idre, Chart cm) throws ChartException {
        ResultSetWrapper rsw = this.mapToChartResultSet(idre, cm);
        this.generateRuntimeSeries(cm, rsw);
    }

    private void generateRuntimeSeries(ChartWithoutAxes cwoa, ResultSetWrapper rsw) throws ChartException {
        String sExpression;
        Query qy;
        List<String> columns;
        int iGroupCount = rsw.getGroupCount();
        EList<SeriesDefinition> elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sdBase = (SeriesDefinition)elSD.get(0);
        SortOption baseSorting = sdBase.isSetSorting() ? sdBase.getSorting() : null;
        Series seBaseDesignSeries = sdBase.getDesignTimeSeries();
        Series seBaseRuntimeSeries = seBaseDesignSeries.copyInstance();
        int iOrthogonalSeriesDefinitionCount = 0;
        int iBaseColumnIndex = 0;
        EList<Query> dda = sdBase.getDesignTimeSeries().getDataDefinition();
        if (dda.size() > 0 && (iBaseColumnIndex = (columns = rsw.getLookupHelper().getExpressions()).indexOf(((Query)dda.get(0)).getDefinition())) == -1) {
            iBaseColumnIndex = 0;
        }
        elSD = sdBase.getSeriesDefinitions();
        int j = 0;
        while (j < elSD.size()) {
            SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
            qy = sd.getQuery();
            if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                ++iOrthogonalSeriesDefinitionCount;
            }
            ++j;
        }
        if (iOrthogonalSeriesDefinitionCount < 1) {
            this.fillSeriesDataSet(cwoa, seBaseRuntimeSeries, rsw.getSubset(iBaseColumnIndex));
            sdBase.getSeries().add((Object)seBaseRuntimeSeries);
            elSD = sdBase.getSeriesDefinitions();
            int j2 = 0;
            while (j2 < elSD.size()) {
                SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(j2);
                Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                Series seOrthogonalRuntimeSeries = seOrthogonalDesignSeries.copyInstance();
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae, sdBase, sdOrthogonal);
                String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                this.fillSeriesDataSet(cwoa, seOrthogonalRuntimeSeries, rsw.getSubset(rsw.getLookupHelper().getValueSeriesExprBuilder().buildExpr((List<Query>)seOrthogonalDesignSeries.getDataDefinition(), sdOrthogonal, sdBase), aggExp, true), DataProcessor.getDesignTimeStringsSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae), rsw.getSubset(triggerExprs, aggExp, false));
                seOrthogonalRuntimeSeries.setSeriesIdentifier(seOrthogonalDesignSeries.getSeriesIdentifier());
                sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                ++j2;
            }
        } else {
            Series seOrthogonalRuntimeSeries;
            SeriesDefinition sdOrthogonal;
            Object[] oa = rsw.getMergedGroupingBaseValues(iBaseColumnIndex, baseSorting, true);
            List baseValues = (List)oa[0];
            List idxList = (List)oa[1];
            int maxCount = baseValues.size();
            Object[] baseData = this.populateSeriesDataSet(seBaseRuntimeSeries, new ResultSetDataSet(baseValues, rsw.getColumnDataType(iBaseColumnIndex)));
            ArrayList<Object[]> orthogonalDataList = new ArrayList<Object[]>();
            elSD = sdBase.getSeriesDefinitions();
            int j3 = 0;
            while (j3 < elSD.size()) {
                sdOrthogonal = (SeriesDefinition)elSD.get(j3);
                Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae, sdBase, sdOrthogonal);
                String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                int k = 0;
                while (k < iGroupCount) {
                    seOrthogonalRuntimeSeries = seOrthogonalDesignSeries.copyInstance();
                    Object[] odata = this.populateSeriesDataSet(seOrthogonalRuntimeSeries, rsw.getSubset(k, rsw.getLookupHelper().getValueSeriesExprBuilder().buildExpr((List<Query>)seOrthogonalDesignSeries.getDataDefinition(), sdOrthogonal, sdBase), aggExp, true), rsw.getSubset(k, triggerExprs, aggExp, false));
                    odata[3] = rsw.getGroupRowCount(k);
                    odata[4] = k;
                    odata[5] = DataProcessor.getDesignTimeStringsSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                    orthogonalDataList.add(odata);
                    ++k;
                }
                ++j3;
            }
            Object[] orthogonalData = orthogonalDataList.toArray();
            int i = 0;
            while (i < orthogonalData.length) {
                DataSet ds = (DataSet)((Object[])orthogonalData[i])[0];
                DataSet[] userDs = (DataSet[])((Object[])orthogonalData[i])[6];
                int groupIndex = (Integer)((Object[])orthogonalData[i])[4];
                ds = this.adjustDataSet(ds, maxCount, (List)idxList.get(groupIndex), userDs);
                ((Object[])orthogonalData[i])[3] = ds;
                ++i;
            }
            this.fillSeriesDataSet((IDataSetProcessor)baseData[1], seBaseRuntimeSeries, (DataSet)baseData[0]);
            sdBase.getSeries().add((Object)seBaseRuntimeSeries);
            int odx = 0;
            elSD = sdBase.getSeriesDefinitions();
            int j4 = 0;
            while (j4 < elSD.size()) {
                sdOrthogonal = (SeriesDefinition)elSD.get(j4);
                String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                int k = 0;
                while (k < iGroupCount) {
                    Object[] odata = (Object[])orthogonalData[odx];
                    seOrthogonalRuntimeSeries = (Series)odata[2];
                    this.fillSeriesDataSet((IDataSetProcessor)odata[1], seOrthogonalRuntimeSeries, (DataSet)odata[0], (String[])odata[5], (DataSet[])odata[6]);
                    qy = sdOrthogonal.getQuery();
                    String string = sExpression = qy == null ? "" : qy.getDefinition();
                    if (sExpression == null) {
                        sExpression = "";
                    }
                    seOrthogonalRuntimeSeries.setSeriesIdentifier(rsw.getGroupKey(k, sExpression, aggExp));
                    sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                    ++odx;
                    ++k;
                }
                ++j4;
            }
        }
    }

    private void generateRuntimeSeries(ChartWithAxes cwa, ResultSetWrapper rsw) throws ChartException {
        String sExpression;
        Query qy;
        List<String> columns;
        int iGroupCount = rsw.getGroupCount();
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList<SeriesDefinition> elSD = axPrimaryBase.getSeriesDefinitions();
        SeriesDefinition sdBase = (SeriesDefinition)elSD.get(0);
        SortOption baseSorting = sdBase.isSetSorting() ? sdBase.getSorting() : null;
        Series seBaseDesignSeries = sdBase.getDesignTimeSeries();
        Series seBaseRuntimeSeries = seBaseDesignSeries.copyInstance();
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int iOrthogonalSeriesDefinitionCount = 0;
        int iBaseColumnIndex = 0;
        EList<Query> dda = sdBase.getDesignTimeSeries().getDataDefinition();
        if (dda.size() > 0 && (iBaseColumnIndex = (columns = rsw.getLookupHelper().getExpressions()).indexOf(((Query)dda.get(0)).getDefinition())) == -1) {
            iBaseColumnIndex = 0;
        }
        int i = 0;
        while (i < axaOrthogonal.length) {
            elSD = axaOrthogonal[i].getSeriesDefinitions();
            int j = 0;
            while (j < elSD.size()) {
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                qy = sd.getQuery();
                if (qy != null && (sExpression = qy.getDefinition()) != null && sExpression.length() != 0) {
                    ++iOrthogonalSeriesDefinitionCount;
                }
                ++j;
            }
            ++i;
        }
        if (iOrthogonalSeriesDefinitionCount < 1) {
            this.fillSeriesDataSet(cwa, seBaseRuntimeSeries, rsw.getSubset(iBaseColumnIndex));
            sdBase.getSeries().add((Object)seBaseRuntimeSeries);
            int i2 = 0;
            while (i2 < axaOrthogonal.length) {
                elSD = axaOrthogonal[i2].getSeriesDefinitions();
                int j = 0;
                while (j < elSD.size()) {
                    SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                    Series seOrthogonalRuntimeSeries = seOrthogonalDesignSeries.copyInstance();
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae, sdBase, sdOrthogonal);
                    String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                    this.fillSeriesDataSet(cwa, seOrthogonalRuntimeSeries, rsw.getSubset(rsw.getLookupHelper().getValueSeriesExprBuilder().buildExpr((List<Query>)seOrthogonalDesignSeries.getDataDefinition(), sdOrthogonal, sdBase), aggExp, true), DataProcessor.getDesignTimeStringsSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae), rsw.getSubset(triggerExprs, aggExp, false));
                    seOrthogonalRuntimeSeries.setSeriesIdentifier(seOrthogonalDesignSeries.getSeriesIdentifier());
                    sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                    ++j;
                }
                ++i2;
            }
        } else {
            Series seOrthogonalRuntimeSeries;
            SeriesDefinition sdOrthogonal;
            Object[] oa = rsw.getMergedGroupingBaseValues(iBaseColumnIndex, baseSorting, ((Axis)cwa.getAxes().get(0)).isCategoryAxis() || !((Axis)cwa.getAxes().get(0)).isSetCategoryAxis() || ((Axis)cwa.getAxes().get(0)).getType() == AxisType.TEXT_LITERAL);
            List baseValues = (List)oa[0];
            List idxList = (List)oa[1];
            int maxCount = baseValues.size();
            Object[] baseData = this.populateSeriesDataSet(seBaseRuntimeSeries, new ResultSetDataSet(baseValues, rsw.getColumnDataType(iBaseColumnIndex)));
            ArrayList<Object[]> orthogonalDataList = new ArrayList<Object[]>();
            int i3 = 0;
            while (i3 < axaOrthogonal.length) {
                elSD = axaOrthogonal[i3].getSeriesDefinitions();
                int j = 0;
                while (j < elSD.size()) {
                    sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae, sdBase, sdOrthogonal);
                    String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                    int k = 0;
                    while (k < iGroupCount) {
                        seOrthogonalRuntimeSeries = seOrthogonalDesignSeries.copyInstance();
                        Object[] odata = this.populateSeriesDataSet(seOrthogonalRuntimeSeries, rsw.getSubset(k, rsw.getLookupHelper().getValueSeriesExprBuilder().buildExpr((List<Query>)seOrthogonalDesignSeries.getDataDefinition(), sdOrthogonal, sdBase), aggExp, true), rsw.getSubset(k, triggerExprs, aggExp, false));
                        odata[3] = rsw.getGroupRowCount(k);
                        odata[4] = k;
                        odata[5] = DataProcessor.getDesignTimeStringsSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                        orthogonalDataList.add(odata);
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
            Object[] orthogonalData = orthogonalDataList.toArray();
            int i4 = 0;
            while (i4 < orthogonalData.length) {
                DataSet ds = (DataSet)((Object[])orthogonalData[i4])[0];
                DataSet[] userDs = (DataSet[])((Object[])orthogonalData[i4])[6];
                int groupIndex = (Integer)((Object[])orthogonalData[i4])[4];
                ds = this.adjustDataSet(ds, maxCount, (List)idxList.get(groupIndex), userDs);
                ((Object[])orthogonalData[i4])[3] = ds;
                ++i4;
            }
            this.fillSeriesDataSet((IDataSetProcessor)baseData[1], seBaseRuntimeSeries, (DataSet)baseData[0]);
            sdBase.getSeries().add((Object)seBaseRuntimeSeries);
            int odx = 0;
            int i5 = 0;
            while (i5 < axaOrthogonal.length) {
                elSD = axaOrthogonal[i5].getSeriesDefinitions();
                int j = 0;
                while (j < elSD.size()) {
                    sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    String aggExp = rsw.getLookupHelper().getOrthogonalAggregationExpression(sdOrthogonal);
                    int k = 0;
                    while (k < iGroupCount) {
                        Object[] odata = (Object[])orthogonalData[odx];
                        seOrthogonalRuntimeSeries = (Series)odata[2];
                        this.fillSeriesDataSet((IDataSetProcessor)odata[1], seOrthogonalRuntimeSeries, (DataSet)odata[0], (String[])odata[5], (DataSet[])odata[6]);
                        qy = sdOrthogonal.getQuery();
                        String string = sExpression = qy == null ? "" : qy.getDefinition();
                        if (sExpression == null) {
                            sExpression = "";
                        }
                        seOrthogonalRuntimeSeries.setSeriesIdentifier(rsw.getGroupKey(k, sExpression, aggExp));
                        sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                        ++odx;
                        ++k;
                    }
                    ++j;
                }
                ++i5;
            }
        }
    }

    private DataSet adjustDataSet(DataSet ds, int maxcount, List<Integer> indexMap, DataSet[] userDs) {
        DataSet dataSet = this.adjustEachDataSet(ds, indexMap);
        if (userDs != null && userDs.length > 0) {
            int i = 0;
            while (i < userDs.length) {
                DataSet usds;
                userDs[i] = usds = this.adjustEachDataSet(userDs[i], indexMap);
                ++i;
            }
        }
        return dataSet;
    }

    private DataSet adjustEachDataSet(DataSet ds, List<Integer> indexMap) {
        int[] indexArray = new int[indexMap.size()];
        int i = 0;
        while (i < indexArray.length) {
            indexArray[i] = indexMap.get(i);
            ++i;
        }
        Object oContent = ds.getValues();
        if (ds instanceof NumberDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i2 = 0;
                for (Object o : co) {
                    int idx;
                    if ((idx = indexArray[i2++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                i2 = 0;
                while (i2 < objBuffer.length) {
                    co.add(objBuffer[i2]);
                    ++i2;
                }
            } else if (oContent instanceof double[]) {
                double[] da = (double[])oContent;
                double[] doubleBuffer = new double[indexArray.length];
                Arrays.fill(doubleBuffer, Double.NaN);
                int i3 = 0;
                while (i3 < da.length) {
                    int idx = indexArray[i3];
                    if (idx != -1) {
                        doubleBuffer[idx] = da[i3];
                    }
                    ++i3;
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof Double[]) {
                Double[] dda = (Double[])oContent;
                Double[] doubleBuffer = new Double[indexArray.length];
                int i4 = 0;
                while (i4 < dda.length) {
                    int idx = indexArray[i4];
                    if (idx != -1) {
                        doubleBuffer[idx] = dda[i4];
                    }
                    ++i4;
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof Number) {
                double[] da = new double[]{((Number)oContent).doubleValue()};
                double[] doubleBuffer = new double[indexArray.length];
                Arrays.fill(doubleBuffer, Double.NaN);
                int idx = indexArray[0];
                if (idx != -1) {
                    doubleBuffer[idx] = da[0];
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof BigNumber[]) {
                BigNumber[] bna = (BigNumber[])oContent;
                BigNumber[] bigNumberBuffer = new BigNumber[indexArray.length];
                int i5 = 0;
                while (i5 < bna.length) {
                    int idx = indexArray[i5];
                    if (idx != -1) {
                        bigNumberBuffer[idx] = bna[i5];
                    }
                    ++i5;
                }
                ds.setValues(bigNumberBuffer);
            } else if (oContent instanceof Number[]) {
                Number[] na = (Number[])oContent;
                Number[] numberBuffer = new Number[indexArray.length];
                int i6 = 0;
                while (i6 < na.length) {
                    int idx = indexArray[i6];
                    if (idx != -1) {
                        numberBuffer[idx] = na[i6];
                    }
                    ++i6;
                }
                ds.setValues(numberBuffer);
            }
        } else if (ds instanceof DateTimeDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i7 = 0;
                for (Object o : co) {
                    int idx;
                    if ((idx = indexArray[i7++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                i7 = 0;
                while (i7 < objBuffer.length) {
                    co.add(objBuffer[i7]);
                    ++i7;
                }
            } else if (oContent instanceof long[]) {
                long[] la = (long[])oContent;
                double[] longBuffer = new double[indexArray.length];
                Arrays.fill(longBuffer, Double.NaN);
                int i8 = 0;
                while (i8 < la.length) {
                    int idx = indexArray[i8];
                    if (idx != -1) {
                        longBuffer[idx] = la[i8];
                    }
                    ++i8;
                }
                ds.setValues(longBuffer);
            } else if (oContent instanceof Calendar[]) {
                Calendar[] ca = (Calendar[])oContent;
                Calendar[] calendarBuffer = new Calendar[indexArray.length];
                int i9 = 0;
                while (i9 < ca.length) {
                    int idx = indexArray[i9];
                    if (idx != -1) {
                        calendarBuffer[idx] = ca[i9];
                    }
                    ++i9;
                }
                ds.setValues(calendarBuffer);
            }
        } else if (ds instanceof TextDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i10 = 0;
                for (Object o : co) {
                    int idx;
                    if ((idx = indexArray[i10++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                i10 = 0;
                while (i10 < objBuffer.length) {
                    co.add(objBuffer[i10]);
                    ++i10;
                }
            } else if (oContent instanceof String[]) {
                String[] sa = (String[])oContent;
                String[] stringBuffer = new String[indexArray.length];
                int i11 = 0;
                while (i11 < sa.length) {
                    int idx = indexArray[i11];
                    if (idx != -1) {
                        stringBuffer[idx] = sa[i11];
                    }
                    ++i11;
                }
                ds.setValues(stringBuffer);
            }
        } else if (oContent instanceof Collection) {
            Collection co = (Collection)oContent;
            Object[] objBuffer = new Object[indexArray.length];
            int i12 = 0;
            for (Object o : co) {
                int idx;
                if ((idx = indexArray[i12++]) == -1) continue;
                objBuffer[idx] = o;
            }
            co.clear();
            i12 = 0;
            while (i12 < objBuffer.length) {
                co.add(objBuffer[i12]);
                ++i12;
            }
        } else if (oContent instanceof Object[]) {
            Object[] oa = (Object[])oContent;
            Object[] objectBuffer = new Object[indexArray.length];
            int i13 = 0;
            while (i13 < oa.length) {
                int idx = indexArray[i13];
                if (idx != -1) {
                    objectBuffer[idx] = oa[i13];
                }
                ++i13;
            }
            ds.setValues(objectBuffer);
        }
        return ds;
    }

    private Object[] populateSeriesDataSet(Series seRuntime, IResultSetDataSet rsds) throws ChartException {
        return this.populateSeriesDataSet(seRuntime, rsds, null);
    }

    private Object[] populateSeriesDataSet(Series seRuntime, IResultSetDataSet rsds, IResultSetDataSet userRsds) throws ChartException {
        IDataSetProcessor idsp = null;
        try {
            idsp = PluginSettings.instance().getDataSetProcessor(seRuntime.getClass());
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)pex);
        }
        DataSet ds = null;
        ds = idsp.populate(rsds, null);
        DataSet[] usds = null;
        if (userRsds != null) {
            UserDataSetProcessor tdsp = new UserDataSetProcessor();
            usds = tdsp.populate(userRsds);
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = ds;
        objectArray[1] = idsp;
        objectArray[2] = seRuntime;
        objectArray[6] = usds;
        return objectArray;
    }

    private void fillSeriesDataSet(IDataSetProcessor idsp, Series seRuntime, DataSet ds) throws ChartException {
        this.fillSeriesDataSet(idsp, seRuntime, ds, null, null);
    }

    private void fillSeriesDataSet(IDataSetProcessor idsp, Series seRuntime, DataSet ds, String[] userKeys, DataSet[] userDs) throws ChartException {
        AbstractScriptHandler sh = this.rtc.getScriptHandler();
        ScriptHandler.callFunction(sh, "beforeDataSetFilled", seRuntime, idsp, this.rtc.getScriptContext());
        seRuntime.setDataSet(ds);
        if (userDs != null && userKeys != null) {
            int i = 0;
            while (i < Math.min(userDs.length, userKeys.length)) {
                seRuntime.setDataSet(userKeys[i], userDs[i]);
                ++i;
            }
        }
        ScriptHandler.callFunction(sh, "afterDataSetFilled", seRuntime, ds, this.rtc.getScriptContext());
    }

    private void fillSeriesDataSet(Chart cm, Series seRuntime, IResultSetDataSet rsds) throws ChartException {
        this.fillSeriesDataSet(cm, seRuntime, rsds, null, null);
    }

    private void fillSeriesDataSet(Chart cm, Series seRuntime, IResultSetDataSet rsds, String[] userKeys, IResultSetDataSet userRsds) throws ChartException {
        AbstractScriptHandler sh = this.rtc.getScriptHandler();
        IDataSetProcessor idsp = null;
        try {
            idsp = PluginSettings.instance().getDataSetProcessor(seRuntime.getClass());
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)pex);
        }
        ScriptHandler.callFunction(sh, "beforeDataSetFilled", seRuntime, idsp, this.rtc.getScriptContext());
        DataSet ds = null;
        ds = idsp.populate(rsds, null);
        seRuntime.setDataSet(ds);
        if (userRsds != null && userKeys != null) {
            UserDataSetProcessor tdsp = new UserDataSetProcessor();
            DataSet[] usds = tdsp.populate(userRsds);
            int i = 0;
            while (i < Math.min(usds.length, userKeys.length)) {
                seRuntime.setDataSet(userKeys[i], usds[i]);
                ++i;
            }
        }
        ScriptHandler.callFunction(sh, "afterDataSetFilled", seRuntime, ds, this.rtc.getScriptContext());
    }

    public List<Object[]> evaluateRowSet(IDataRowExpressionEvaluator idre, Object[] columns) throws ChartException {
        ArrayList<Object[]> liResultSet = new ArrayList<Object[]>();
        int iColumnCount = columns.length;
        int MAX_ROW_COUNT = ChartUtil.getSupportedMaxRowCount(this.rtc);
        if (idre.first()) {
            int count = 0;
            while (MAX_ROW_COUNT <= 0 || count++ < MAX_ROW_COUNT) {
                Object[] oaTuple = new Object[iColumnCount];
                int i = 0;
                while (i < columns.length) {
                    Object value = idre.evaluate((String)columns[i]);
                    if (value instanceof Date) {
                        CDateTime newValue = new CDateTime((Date)value);
                        if (newValue.isFullDateTime() && this.rtc.getTimeZone() != null) {
                            newValue.setTimeZone(this.rtc.getTimeZone());
                        }
                        value = newValue;
                    } else if (value instanceof Calendar) {
                        value = new CDateTime((Calendar)value);
                    } else if (value instanceof BirtException) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)((BirtException)value));
                    }
                    oaTuple[i] = value;
                    ++i;
                }
                liResultSet.add(oaTuple);
                if (idre.next()) continue;
            }
        }
        return liResultSet;
    }

    private void generateRuntimeSeries(Chart cm, ResultSetWrapper rsw) throws ChartException {
        cm.clearSections(3);
        if (cm instanceof ChartWithAxes) {
            this.generateRuntimeSeries((ChartWithAxes)cm, rsw);
        } else if (cm instanceof ChartWithoutAxes) {
            this.generateRuntimeSeries((ChartWithoutAxes)cm, rsw);
        }
        ChartUtil.adjustBigNumberWithinDataSets(cm);
    }

    public void formatBaseSeriesData(Chart cm, GroupingLookupHelper lhmLookup, List<Object[]> rowSet) throws ChartException {
        boolean bIsSumAggr;
        SeriesDefinition sdBase = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions(cm).get(0);
        SeriesGrouping sg = sdBase.getGrouping();
        if (sg == null || !sg.isEnabled()) {
            return;
        }
        Series seBaseDesignTime = sdBase.getDesignTimeSeries();
        Query q = (Query)seBaseDesignTime.getDataDefinition().get(0);
        int iBaseColumnIndex = lhmLookup.findIndexOfBaseSeries(q.getDefinition());
        DataType dtGrouping = sg.getGroupType();
        String aggr = sdBase.getGrouping().getAggregateExpression();
        IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggr);
        boolean bl = bIsSumAggr = aFunc != null && aFunc.getType() == 0;
        if (dtGrouping == DataType.DATE_TIME_LITERAL && bIsSumAggr) {
            int cunit = GroupingUtil.groupingUnit2CDateUnit(sg.getGroupingUnit());
            CDateTime baseReference = null;
            for (Object[] oaTuple : rowSet) {
                Object obj = oaTuple[iBaseColumnIndex];
                if (!(obj instanceof CDateTime)) continue;
                baseReference = (CDateTime)((Object)obj);
                baseReference.clearBelow(cunit, true);
                oaTuple[iBaseColumnIndex] = baseReference;
            }
        }
    }

    private static class AggregationExpressionHelper {
        private List<String> aggregationExpsList = new ArrayList<String>(3);
        private List<String> querysList = new ArrayList<String>(3);
        private List<String> baseQueryList = new ArrayList<String>(3);

        private AggregationExpressionHelper() {
        }

        public void addAggregation(String aggExp, List<String> querys) {
            int i = 0;
            while (i < querys.size()) {
                this.aggregationExpsList.add(aggExp);
                this.querysList.add(querys.get(i));
                ++i;
            }
        }

        public String[] getAggregations() {
            return this.aggregationExpsList.toArray(new String[this.aggregationExpsList.size()]);
        }

        public String[] getDataDefinitions() {
            return this.querysList.toArray(new String[this.querysList.size()]);
        }

        public List<String> getDataDefinitionsForBaseGrouping() {
            return this.baseQueryList;
        }

        public void dispose() {
            this.aggregationExpsList.clear();
            this.querysList.clear();
            this.baseQueryList.clear();
        }

        public boolean isEmpty() {
            return this.aggregationExpsList.isEmpty() || this.querysList.isEmpty();
        }

        public void addSeriesDefinitions(EList<SeriesDefinition> elSD, GroupingLookupHelper lhmLookup) throws ChartException {
            for (SeriesDefinition sdOrthogonal : elSD) {
                Series series = sdOrthogonal.getDesignTimeSeries();
                List<Query> qlist = ChartEngine.instance().getDataSetProcessor(series.getClass()).getDataDefinitionsForGrouping(series);
                String strOrtAgg = lhmLookup.getOrthogonalAggregationExpression(sdOrthogonal);
                for (Query query : qlist) {
                    if (strOrtAgg == null) {
                        this.baseQueryList.add(query.getDefinition());
                        continue;
                    }
                    if (query.getGrouping() == null || !query.getGrouping().isEnabled()) {
                        this.aggregationExpsList.add(strOrtAgg);
                    } else {
                        this.aggregationExpsList.add(query.getGrouping().getAggregateExpression());
                    }
                    this.querysList.add(query.getDefinition());
                }
            }
        }
    }
}

