/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.launcher;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class LauncherProperties {
    public static final String LAUNCHER_PROPERTIES = "launcher.properties";
    public static final String LAUNCHER_PROPERTIES_JAR = "JAR";
    public static final String LAUNCHER_PROPERTIES_LOGFILE = "LOGFILE";
    public static final String LAUNCHER_PROPERTIES_JAVA_OPTS = "JAVA_OPTS";
    private final Path basedir;
    Properties launcherProperties;

    public LauncherProperties(Path basedir) {
        this.basedir = basedir;
    }

    public void load() throws IOException {
        Path applicationFile = this.basedir.resolve("tutti").resolve(LAUNCHER_PROPERTIES);
        Path localFile = this.basedir.resolve(LAUNCHER_PROPERTIES);
        if (!Files.exists(localFile, new LinkOption[0]) && !Files.exists(applicationFile, new LinkOption[0])) {
            throw new IOException("Could not find launcher.properties");
        }
        Properties p1 = new Properties();
        if (Files.isReadable(applicationFile)) {
            p1.load(new FileReader(applicationFile.toFile()));
        }
        this.launcherProperties = new Properties(p1);
        if (Files.isReadable(localFile)) {
            this.launcherProperties.load(new FileReader(localFile.toFile()));
        }
    }

    public Path getJarFile() {
        String jarFileName = this.launcherProperties.getProperty(LAUNCHER_PROPERTIES_JAR);
        Path jarFile = this.basedir.resolve(jarFileName);
        return jarFile;
    }

    public Path getLogFile() {
        String logFileName = this.launcherProperties.getProperty(LAUNCHER_PROPERTIES_LOGFILE);
        Path logFile = this.basedir.resolve(logFileName);
        return logFile;
    }

    public List<String> getJavaOptions() {
        ArrayList<String> javaOptions = new ArrayList<String>();
        String javaOpts = this.launcherProperties.getProperty(LAUNCHER_PROPERTIES_JAVA_OPTS);
        if (javaOpts != null && !javaOpts.trim().isEmpty()) {
            String[] javaOptsArray;
            for (String opt : javaOptsArray = javaOpts.replaceAll("\"", "").split(" ")) {
                if (opt == null || opt.trim().isEmpty()) continue;
                javaOptions.add(opt);
            }
        }
        return javaOptions;
    }
}

