package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class EditCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCruiseUIModel, EditCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENTS_BUTTON_ENABLED = "attachmentsButton.enabled";
    public static final String BINDING_BEGIN_DATE_FIELD_DATE = "beginDateField.date";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DEPARTURE_LOCATION_COMBO_BOX_SELECTED_ITEM = "departureLocationComboBox.selectedItem";
    public static final String BINDING_EDIT_GEAR_CARACTERISTICS_ITEM_ENABLED = "editGearCaracteristicsItem.enabled";
    public static final String BINDING_END_DATE_FIELD_DATE = "endDateField.date";
    public static final String BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED = "filterVesselAllButton.selected";
    public static final String BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED = "filterVesselFishingButton.selected";
    public static final String BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED = "filterVesselScientificButton.selected";
    public static final String BINDING_GENERATE_NAME_BUTTON_ENABLED = "generateNameButton.enabled";
    public static final String BINDING_MULTIRIG_NUMBER_FIELD_NUMBER_PATTERN = "multirigNumberField.numberPattern";
    public static final String BINDING_MULTIRIG_NUMBER_FIELD_NUMBER_VALUE = "multirigNumberField.numberValue";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_RETURN_LOCATION_COMBO_BOX_SELECTED_ITEM = "returnLocationComboBox.selectedItem";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";
    public static final String BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM = "vesselComboBox.selectedItem";
    public static final String BINDING_VIEW_GEAR_CARACTERISTICS_ITEM_ENABLED = "viewGearCaracteristicsItem.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment attachmentsButton;
    @ValidatorField( validatorId = "validator",  propertyName = "beginDate",  editorName = "beginDateField")
    protected JXDatePicker beginDateField;
    protected JLabel beginDateLabel;
    protected SimpleTimeEditor beginTimeField;
    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JScrollPane cruiseScrollPane;
    @ValidatorField( validatorId = "validator",  propertyName = "departureLocation",  editorName = "departureLocationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> departureLocationComboBox;
    protected JLabel departureLocationLabel;
    protected EditCruiseUI editCruiseTopPanel = this;
    protected JMenuItem editGearCaracteristicsItem;
    @ValidatorField( validatorId = "validator",  propertyName = "endDate",  editorName = "endDateField")
    protected JXDatePicker endDateField;
    protected JLabel endDateLabel;
    protected SimpleTimeEditor endTimeField;
    protected JRadioButton filterVesselAllButton;
    protected JRadioButton filterVesselFishingButton;
    protected JLabel filterVesselLabel;
    protected JRadioButton filterVesselScientificButton;
    protected JAXXButtonGroup filterVesselType;
    protected GearCaracteristicsEditorUI gearCaracteristicsEditor;
    protected JXTitledPanel gearCaracteristicsEditorTitledPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearList")
    protected BeanDoubleList<Gear> gearList;
    protected JPopupMenu gearMenuPopup;
    protected JButton generateNameButton;
    protected final EditCruiseUIHandler handler = new EditCruiseUIHandler();
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionList")
    protected BeanDoubleList<Person> headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomList")
    protected BeanDoubleList<Person> headOfSortRoomList;
    protected CardLayout2Ext mainPanelLayout;
    protected EditCruiseUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigNumber",  editorName = "multirigNumberField")
    protected NumberEditor multirigNumberField;
    protected JLabel multirigNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    protected JButton resetButton;
    @ValidatorField( validatorId = "validator",  propertyName = "returnLocation",  editorName = "returnLocationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> returnLocationComboBox;
    protected JLabel returnLocationLabel;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    protected JButton surveyPartResetButton;
    protected JToolBar topToolBar;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselComboBox")
    protected BeanFilterableComboBox<Vessel> vesselComboBox;
    protected JPanel vesselFilterPane;
    protected JLabel vesselLabel;
    protected JMenuItem viewGearCaracteristicsItem;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JSeparator $JSeparator0;
    private JToolBar $JToolBar0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCruiseUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI() {
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "beginDate");
    }

    public void doActionPerformed__on__endDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "endDate");
    }

    public void doActionPerformed__on__filterVesselAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.ALL);
    }

    public void doActionPerformed__on__filterVesselFishingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.FISHING);
    }

    public void doActionPerformed__on__filterVesselScientificButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
    }

    public void doActionPerformed__on__generateNameButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateCampaignName();
    }

    public void doActionPerformed__on__surveyPartResetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSurveyPart(null);
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAttachmentsButton() {
        return attachmentsButton;
    }

    public JXDatePicker getBeginDateField() {
        return beginDateField;
    }

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public SimpleTimeEditor getBeginTimeField() {
        return beginTimeField;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JScrollPane getCruiseScrollPane() {
        return cruiseScrollPane;
    }

    public BeanFilterableComboBox<TuttiLocation> getDepartureLocationComboBox() {
        return departureLocationComboBox;
    }

    public JLabel getDepartureLocationLabel() {
        return departureLocationLabel;
    }

    public JMenuItem getEditGearCaracteristicsItem() {
        return editGearCaracteristicsItem;
    }

    public JXDatePicker getEndDateField() {
        return endDateField;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public SimpleTimeEditor getEndTimeField() {
        return endTimeField;
    }

    public JRadioButton getFilterVesselAllButton() {
        return filterVesselAllButton;
    }

    public JRadioButton getFilterVesselFishingButton() {
        return filterVesselFishingButton;
    }

    public JLabel getFilterVesselLabel() {
        return filterVesselLabel;
    }

    public JRadioButton getFilterVesselScientificButton() {
        return filterVesselScientificButton;
    }

    public JAXXButtonGroup getFilterVesselType() {
        return filterVesselType;
    }

    public GearCaracteristicsEditorUI getGearCaracteristicsEditor() {
        return gearCaracteristicsEditor;
    }

    public JXTitledPanel getGearCaracteristicsEditorTitledPanel() {
        return gearCaracteristicsEditorTitledPanel;
    }

    public BeanDoubleList<Gear> getGearList() {
        return gearList;
    }

    public JPopupMenu getGearMenuPopup() {
        return gearMenuPopup;
    }

    public JButton getGenerateNameButton() {
        return generateNameButton;
    }

    public EditCruiseUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Person> getHeadOfMissionList() {
        return headOfMissionList;
    }

    public BeanDoubleList<Person> getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public CardLayout2Ext getMainPanelLayout() {
        return mainPanelLayout;
    }

    public EditCruiseUIModel getModel() {
        return model;
    }

    public NumberEditor getMultirigNumberField() {
        return multirigNumberField;
    }

    public JLabel getMultirigNumberLabel() {
        return multirigNumberLabel;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public BeanFilterableComboBox<TuttiLocation> getReturnLocationComboBox() {
        return returnLocationComboBox;
    }

    public JLabel getReturnLocationLabel() {
        return returnLocationLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public JButton getSurveyPartResetButton() {
        return surveyPartResetButton;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public SwingValidator<EditCruiseUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<Vessel> getVesselComboBox() {
        return vesselComboBox;
    }

    public JPanel getVesselFilterPane() {
        return vesselFilterPane;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    public JMenuItem getViewGearCaracteristicsItem() {
        return viewGearCaracteristicsItem;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCruiseScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        cruiseScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToEditCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add($JPanel0, EditCruiseUIHandler.CRUISE_CARD);
        add(gearCaracteristicsEditorTitledPanel, EditCruiseUIHandler.GEAR_CARACTERISTICS_CARD);
    }

    protected void addChildrenToFilterVesselAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselAllButton); }
    }

    protected void addChildrenToFilterVesselFishingButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselFishingButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselFishingButton); }
    }

    protected void addChildrenToFilterVesselScientificButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselScientificButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselScientificButton); }
    }

    protected void addChildrenToGearCaracteristicsEditorTitledPanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsEditorTitledPanel.add(gearCaracteristicsEditor);
    }

    protected void addChildrenToGearMenuPopup() {
        if (!allComponentsCreated) {
            return;
        }
        gearMenuPopup.add(editGearCaracteristicsItem);
        gearMenuPopup.add(viewGearCaracteristicsItem);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(attachmentsButton);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselFilterPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselFilterPane.add(filterVesselLabel);
        vesselFilterPane.add(filterVesselAllButton);
        vesselFilterPane.add(filterVesselScientificButton);
        vesselFilterPane.add(filterVesselFishingButton);
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createBeginDateField() {
        $objectMap.put("beginDateField", beginDateField = new JXDatePicker());
        
        beginDateField.setName("beginDateField");
        beginDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDateField"));
        beginDateField.putClientProperty("help", "tutti.editCruise.field.beginDate.help");
        beginDateField.putClientProperty("validatorLabel", t("tutti.editCruise.field.beginDate"));
        beginDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(t("tutti.editCruise.field.beginDate"));
        beginDateLabel.setToolTipText(t("tutti.editCruise.field.beginDate.tip"));
        beginDateLabel.putClientProperty("help", "tutti.editCruise.field.beginDate.help");
    }

    protected void createBeginTimeField() {
        $objectMap.put("beginTimeField", beginTimeField = new SimpleTimeEditor(this));
        
        beginTimeField.setName("beginTimeField");
        beginTimeField.setProperty("beginTime");
        beginTimeField.putClientProperty("help", "tutti.editCruise.field.beginTime.help");
        beginTimeField.putClientProperty("selectOnFocus", true);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCruise.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.editCruise.action.closeEditCruise"));
        closeButton.setToolTipText(t("tutti.editCruise.action.closeEditCruise.tip"));
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SelectCruiseAction.class);
        closeButton.putClientProperty("help", "tutti.editCruise.action.close.help");
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", t("tutti.editCruise.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(t("tutti.editCruise.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editCruise.field.comment.help");
    }

    protected void createCruiseScrollPane() {
        $objectMap.put("cruiseScrollPane", cruiseScrollPane = new JScrollPane());
        
        cruiseScrollPane.setName("cruiseScrollPane");
        cruiseScrollPane.putClientProperty("onlyVerticalScrollable", true);
    }

    protected void createDepartureLocationComboBox() {
        $objectMap.put("departureLocationComboBox", departureLocationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        departureLocationComboBox.setName("departureLocationComboBox");
        departureLocationComboBox.setProperty("departureLocation");
        departureLocationComboBox.setShowReset(true);
        departureLocationComboBox.putClientProperty("help", "tutti.editCruise.field.departureLocation.help");
        departureLocationComboBox.putClientProperty("validatorLabel", t("tutti.editCruise.field.departureLocation"));
    }

    protected void createDepartureLocationLabel() {
        $objectMap.put("departureLocationLabel", departureLocationLabel = new JLabel());
        
        departureLocationLabel.setName("departureLocationLabel");
        departureLocationLabel.setText(t("tutti.editCruise.field.departureLocation"));
        departureLocationLabel.setToolTipText(t("tutti.editCruise.field.departureLocation.tip"));
        departureLocationLabel.putClientProperty("help", "tutti.editCruise.field.departureLocation.help");
    }

    protected void createEditGearCaracteristicsItem() {
        $objectMap.put("editGearCaracteristicsItem", editGearCaracteristicsItem = new JMenuItem());
        
        editGearCaracteristicsItem.setName("editGearCaracteristicsItem");
        editGearCaracteristicsItem.setText(t("tutti.editCruise.action.editGearCaracteristics"));
        editGearCaracteristicsItem.setToolTipText(t("tutti.editCruise.action.editGearCaracteristics.tip"));
        editGearCaracteristicsItem.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditGearCaracteristicsAction.class);
        editGearCaracteristicsItem.putClientProperty("help", "tutti.editCruise.action.editGearCaracteristics.help");
    }

    protected void createEndDateField() {
        $objectMap.put("endDateField", endDateField = new JXDatePicker());
        
        endDateField.setName("endDateField");
        endDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDateField"));
        endDateField.putClientProperty("help", "tutti.editCruise.field.endDate.help");
        endDateField.putClientProperty("validatorLabel", t("tutti.editCruise.field.endDate"));
        endDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(t("tutti.editCruise.field.endDate"));
        endDateLabel.setToolTipText(t("tutti.editCruise.field.endDate.tip"));
        endDateLabel.putClientProperty("help", "tutti.editCruise.field.endDate.help");
    }

    protected void createEndTimeField() {
        $objectMap.put("endTimeField", endTimeField = new SimpleTimeEditor(this));
        
        endTimeField.setName("endTimeField");
        endTimeField.setProperty("endTime");
        endTimeField.putClientProperty("help", "tutti.editCruise.field.endTime.help");
        endTimeField.putClientProperty("selectOnFocus", true);
    }

    protected void createFilterVesselAllButton() {
        $objectMap.put("filterVesselAllButton", filterVesselAllButton = new JRadioButton());
        
        filterVesselAllButton.setName("filterVesselAllButton");
        filterVesselAllButton.setText(t("tutti.editCruise.filterVesselType.all"));
        { filterVesselAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterVesselAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselAllButton.setToolTipText(t("tutti.editCruise.filterVesselType.all.tip"));
        filterVesselAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselAllButton"));
    }

    protected void createFilterVesselFishingButton() {
        $objectMap.put("filterVesselFishingButton", filterVesselFishingButton = new JRadioButton());
        
        filterVesselFishingButton.setName("filterVesselFishingButton");
        filterVesselFishingButton.setText(t("tutti.editCruise.filterVesselType.fishing"));
        { filterVesselFishingButton.putClientProperty("$value", "fishing");  Object $buttonGroup = filterVesselFishingButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselFishingButton.setToolTipText(t("tutti.editCruise.filterVesselType.fishing.tip"));
        filterVesselFishingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselFishingButton"));
    }

    protected void createFilterVesselLabel() {
        $objectMap.put("filterVesselLabel", filterVesselLabel = new JLabel());
        
        filterVesselLabel.setName("filterVesselLabel");
        filterVesselLabel.setText(t("tutti.editCruise.filterVesselType"));
        filterVesselLabel.setToolTipText(t("tutti.editCruise.filterVessel.tip"));
        filterVesselLabel.putClientProperty("help", "tutti.editCruise.filterVessel.help");
        filterVesselLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterVesselScientificButton() {
        $objectMap.put("filterVesselScientificButton", filterVesselScientificButton = new JRadioButton());
        
        filterVesselScientificButton.setName("filterVesselScientificButton");
        filterVesselScientificButton.setText(t("tutti.editCruise.filterVesselType.scientific"));
        { filterVesselScientificButton.putClientProperty("$value", "scientific");  Object $buttonGroup = filterVesselScientificButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselScientificButton.setToolTipText(t("tutti.editCruise.filterVesselType.scientific.tip"));
        filterVesselScientificButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselScientificButton"));
    }

    protected void createFilterVesselType() {
        $objectMap.put("filterVesselType", filterVesselType = new JAXXButtonGroup());
    }

    protected void createGearCaracteristicsEditor() {
        $objectMap.put("gearCaracteristicsEditor", gearCaracteristicsEditor = new GearCaracteristicsEditorUI(this));
        
        gearCaracteristicsEditor.setName("gearCaracteristicsEditor");
    }

    protected void createGearCaracteristicsEditorTitledPanel() {
        $objectMap.put("gearCaracteristicsEditorTitledPanel", gearCaracteristicsEditorTitledPanel = new JXTitledPanel());
        
        gearCaracteristicsEditorTitledPanel.setName("gearCaracteristicsEditorTitledPanel");
        gearCaracteristicsEditorTitledPanel.setTitle(t("tutti.editCruise.gearCaracteristics.title"));
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Gear>());
        
        gearList.setName("gearList");
        gearList.setShowSelectPopupEnabled(true);
        gearList.setUseMultiSelect(true);
        gearList.setProperty("gear");
        gearList.setShowReset(true);
        gearList.setToolTipText(t("tutti.editCruise.field.gear.tip"));
        gearList.putClientProperty("help", "tutti.editCruise.field.gear.help");
        gearList.putClientProperty("validatorLabel", t("tutti.editCruise.field.gear"));
    }

    protected void createGearMenuPopup() {
        $objectMap.put("gearMenuPopup", gearMenuPopup = new JPopupMenu());
        
        gearMenuPopup.setName("gearMenuPopup");
    }

    protected void createGenerateNameButton() {
        $objectMap.put("generateNameButton", generateNameButton = new JButton());
        
        generateNameButton.setName("generateNameButton");
        generateNameButton.setText(t("tutti.editCruise.action.generateCampaignName"));
        generateNameButton.setToolTipText(t("tutti.editCruise.action.generateName.tip"));
        generateNameButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateNameButton"));
        generateNameButton.putClientProperty("help", "tutti.editCruise.action.generateName.help");
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new BeanDoubleList<Person>());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.setShowSelectPopupEnabled(true);
        headOfMissionList.setProperty("headOfMission");
        headOfMissionList.setShowReset(true);
        headOfMissionList.setToolTipText(t("tutti.editCruise.field.headOfMission.tip"));
        headOfMissionList.putClientProperty("help", "tutti.editCruise.field.headOfMission.help");
        headOfMissionList.putClientProperty("validatorLabel", t("tutti.editCruise.field.headOfMission"));
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new BeanDoubleList<Person>());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.setShowSelectPopupEnabled(true);
        headOfSortRoomList.setProperty("headOfSortRoom");
        headOfSortRoomList.setShowReset(true);
        headOfSortRoomList.setToolTipText(t("tutti.editCruise.field.headOfSortRoom.tip"));
        headOfSortRoomList.putClientProperty("help", "tutti.editCruise.field.headOfSortRoom.help");
        headOfSortRoomList.putClientProperty("validatorLabel", t("tutti.editCruise.field.headOfSortRoom"));
    }

    protected void createMainPanelLayout() {
        $objectMap.put("mainPanelLayout", mainPanelLayout = new CardLayout2Ext(this, "editCruiseTopPanel"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCruiseUIModel.class));
    }

    protected void createMultirigNumberField() {
        $objectMap.put("multirigNumberField", multirigNumberField = new NumberEditor(this));
        
        multirigNumberField.setName("multirigNumberField");
        multirigNumberField.setProperty("multirigNumber");
        multirigNumberField.setShowReset(true);
        multirigNumberField.putClientProperty("help", "tutti.editCruise.field.multirigNumber.help");
        multirigNumberField.putClientProperty("validatorLabel", t("tutti.editCruise.field.multirigNumber"));
        multirigNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createMultirigNumberLabel() {
        $objectMap.put("multirigNumberLabel", multirigNumberLabel = new JLabel());
        
        multirigNumberLabel.setName("multirigNumberLabel");
        multirigNumberLabel.setText(t("tutti.editCruise.field.multirigNumber"));
        multirigNumberLabel.setToolTipText(t("tutti.editCruise.field.multirigNumber.tip"));
        multirigNumberLabel.putClientProperty("help", "tutti.editCruise.field.multirigNumber.help");
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("help", "tutti.editCruise.field.name.help");
        nameField.putClientProperty("validatorLabel", t("tutti.editCruise.field.name"));
        nameField.putClientProperty("selectOnFocus", true);
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("tutti.editCruise.field.name"));
        nameLabel.setToolTipText(t("tutti.editCruise.field.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editCruise.field.name.help");
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("help", "tutti.editCruise.field.program.help");
        programComboBox.putClientProperty("validatorLabel", t("tutti.editCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.editCruise.field.program"));
        programLabel.setToolTipText(t("tutti.editCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.editCruise.field.program.help");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setText(t("tutti.editCruise.action.resetCruise"));
        resetButton.setToolTipText(t("tutti.editCruise.action.resetCruise.tip"));
        resetButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ResetCruiseAction.class);
        resetButton.putClientProperty("help", "tutti.editCruise.action.reset.help");
    }

    protected void createReturnLocationComboBox() {
        $objectMap.put("returnLocationComboBox", returnLocationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        returnLocationComboBox.setName("returnLocationComboBox");
        returnLocationComboBox.setProperty("returnLocation");
        returnLocationComboBox.setShowReset(true);
        returnLocationComboBox.putClientProperty("help", "tutti.editCruise.field.returnLocation.help");
        returnLocationComboBox.putClientProperty("validatorLabel", t("tutti.editCruise.field.returnLocation"));
    }

    protected void createReturnLocationLabel() {
        $objectMap.put("returnLocationLabel", returnLocationLabel = new JLabel());
        
        returnLocationLabel.setName("returnLocationLabel");
        returnLocationLabel.setText(t("tutti.editCruise.field.returnLocation"));
        returnLocationLabel.setToolTipText(t("tutti.editCruise.field.returnLocation.tip"));
        returnLocationLabel.putClientProperty("help", "tutti.editCruise.field.returnLocation.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editCruise.action.saveCruise"));
        saveButton.setToolTipText(t("tutti.editCruise.action.saveCruise.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SaveCruiseAction.class);
        saveButton.putClientProperty("help", "tutti.editCruise.action.save.help");
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
        surveyPartField.putClientProperty("help", "tutti.editCruise.field.surveyPart.help");
        surveyPartField.putClientProperty("validatorLabel", t("tutti.editCruise.field.surveyPart"));
        surveyPartField.putClientProperty("selectOnFocus", true);
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(t("tutti.editCruise.field.surveyPart"));
        surveyPartLabel.setToolTipText(t("tutti.editCruise.field.surveyPart.tip"));
        surveyPartLabel.putClientProperty("help", "tutti.editCruise.field.surveyPart.help");
    }

    protected void createSurveyPartResetButton() {
        $objectMap.put("surveyPartResetButton", surveyPartResetButton = new JButton());
        
        surveyPartResetButton.setName("surveyPartResetButton");
        surveyPartResetButton.setToolTipText(t("tutti.editCruise.action.resetSurveyPart.tip"));
        surveyPartResetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__surveyPartResetButton"));
        surveyPartResetButton.putClientProperty("help", "tutti.editCruise.action.resetSurveyPart.help");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCruiseUIModel.class, "validate"));
    }

    protected void createVesselComboBox() {
        $objectMap.put("vesselComboBox", vesselComboBox = new BeanFilterableComboBox<Vessel>(this));
        
        vesselComboBox.setName("vesselComboBox");
        vesselComboBox.setProperty("vessel");
        vesselComboBox.setShowReset(true);
        vesselComboBox.setToolTipText(t("tutti.editCruise.field.vessel.tip"));
        vesselComboBox.putClientProperty("help", "tutti.editCruise.field.vessel.help");
        vesselComboBox.putClientProperty("validatorLabel", t("tutti.editCruise.field.vessel"));
    }

    protected void createVesselFilterPane() {
        $objectMap.put("vesselFilterPane", vesselFilterPane = new JPanel());
        
        vesselFilterPane.setName("vesselFilterPane");
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(t("tutti.editCruise.field.vessel"));
        vesselLabel.setToolTipText(t("tutti.editCruise.field.vessel.tip"));
        vesselLabel.putClientProperty("help", "tutti.editCruise.field.vessel.help");
    }

    protected void createViewGearCaracteristicsItem() {
        $objectMap.put("viewGearCaracteristicsItem", viewGearCaracteristicsItem = new JMenuItem());
        
        viewGearCaracteristicsItem.setName("viewGearCaracteristicsItem");
        viewGearCaracteristicsItem.setText(t("tutti.editCruise.action.viewGearCaracteristics"));
        viewGearCaracteristicsItem.setToolTipText(t("tutti.editCruise.action.viewGearCaracteristics.tip"));
        viewGearCaracteristicsItem.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ViewGearCaracteristicsAction.class);
        viewGearCaracteristicsItem.putClientProperty("help", "tutti.editCruise.action.viewGearCaracteristics.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCruiseTopPanel();
        addChildrenToValidator();
        addChildrenToTopToolBar();
        addChildrenToGearMenuPopup();
        // inline complete setup of $JPanel0
        $JPanel0.add(cruiseScrollPane, BorderLayout.CENTER);
        $JPanel0.add($JPanel5, BorderLayout.SOUTH);
        addChildrenToCruiseScrollPane();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(departureLocationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(departureLocationComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(returnLocationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(returnLocationComboBox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(generateNameButton, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multirigNumberLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(multirigNumberField), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselFilterPane, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(vesselComboBox), new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(gearList), new GridBagConstraints(0, 8, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 10, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add($JToolBar0, BorderLayout.WEST);
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), BorderLayout.CENTER);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(surveyPartResetButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(beginDateField), BorderLayout.CENTER);
        $JPanel2.add(beginTimeField, BorderLayout.EAST);
        // inline complete setup of $JPanel3
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(endDateField), BorderLayout.CENTER);
        $JPanel3.add(endTimeField, BorderLayout.EAST);
        addChildrenToVesselFilterPane();
        addChildrenToFilterVesselAllButton();
        addChildrenToFilterVesselScientificButton();
        addChildrenToFilterVesselFishingButton();
        // inline complete setup of $JPanel4
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(headOfMissionList));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomList));
        addChildrenToCommentPane();
        // inline complete setup of $JPanel5
        $JPanel5.add(closeButton);
        $JPanel5.add(resetButton);
        $JPanel5.add(saveButton);
        addChildrenToGearCaracteristicsEditorTitledPanel();
        
        // apply 20 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 53 property setters
        programComboBox.setBeanType(Program.class);
        departureLocationComboBox.setBeanType(TuttiLocation.class);
        returnLocationComboBox.setBeanType(TuttiLocation.class);
        vesselComboBox.setBeanType(Vessel.class);
        gearList.setBeanType(Gear.class);
        headOfMissionList.setBeanType(Person.class);
        headOfSortRoomList.setBeanType(Person.class);
        editGearCaracteristicsItem.setIcon(SwingUtil.createActionIcon("edit"));
        viewGearCaracteristicsItem.setIcon(SwingUtil.createActionIcon("show-frequency"));
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        surveyPartLabel.setLabelFor(surveyPartField);
        surveyPartResetButton.setIcon(SwingUtil.createActionIcon("reset"));
        surveyPartResetButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCruise.action.resetSurveyPart.mnemonic"),'Z'));
        departureLocationLabel.setLabelFor(departureLocationComboBox);
        departureLocationComboBox.setBean(model);
        beginDateLabel.setLabelFor(beginDateField);
        beginTimeField.setBean(model);
        returnLocationLabel.setLabelFor(returnLocationComboBox);
        returnLocationComboBox.setBean(model);
        endDateLabel.setLabelFor(endDateField);
        endTimeField.setBean(model);
        nameLabel.setLabelFor(nameField);
        generateNameButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateNameButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCruise.action.generateCampaignName.mnemonic"),'Z'));
        multirigNumberLabel.setLabelFor(multirigNumberField);
        multirigNumberField.setBean(model);
        multirigNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        multirigNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        multirigNumberField.setNumberType(Integer.class);
        filterVesselLabel.setIcon(SwingUtil.createActionIcon("filter"));
        vesselLabel.setLabelFor(vesselComboBox);
        vesselComboBox.setBean(model);
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(t("tutti.editCruise.field.gear")));
        headOfMissionList.setBean(model);
        headOfMissionList.setBorder(BorderFactory.createTitledBorder(t("tutti.editCruise.field.headOfMission")));
        headOfSortRoomList.setBean(model);
        headOfSortRoomList.setBorder(BorderFactory.createTitledBorder(t("tutti.editCruise.field.headOfSortRoom")));
        commentPane.setBorder(BorderFactory.createTitledBorder(t("tutti.editCruise.field.comment")));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCruise.action.closeEditCruise.mnemonic"),'Z'));
        resetButton.setIcon(SwingUtil.createActionIcon("reset"));
        resetButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCruise.action.resetCruise.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCruise.action.saveCruise.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCruiseTopPanel, "tutti.editCruise.help");
        registerHelpId(_broker, editGearCaracteristicsItem, "tutti.editCruise.action.editGearCaracteristics.help");
        registerHelpId(_broker, viewGearCaracteristicsItem, "tutti.editCruise.action.viewGearCaracteristics.help");
        registerHelpId(_broker, programLabel, "tutti.editCruise.field.program.help");
        registerHelpId(_broker, programComboBox, "tutti.editCruise.field.program.help");
        registerHelpId(_broker, surveyPartLabel, "tutti.editCruise.field.surveyPart.help");
        registerHelpId(_broker, surveyPartResetButton, "tutti.editCruise.action.resetSurveyPart.help");
        registerHelpId(_broker, surveyPartField, "tutti.editCruise.field.surveyPart.help");
        registerHelpId(_broker, departureLocationLabel, "tutti.editCruise.field.departureLocation.help");
        registerHelpId(_broker, departureLocationComboBox, "tutti.editCruise.field.departureLocation.help");
        registerHelpId(_broker, beginDateLabel, "tutti.editCruise.field.beginDate.help");
        registerHelpId(_broker, beginDateField, "tutti.editCruise.field.beginDate.help");
        registerHelpId(_broker, beginTimeField, "tutti.editCruise.field.beginTime.help");
        registerHelpId(_broker, returnLocationLabel, "tutti.editCruise.field.returnLocation.help");
        registerHelpId(_broker, returnLocationComboBox, "tutti.editCruise.field.returnLocation.help");
        registerHelpId(_broker, endDateLabel, "tutti.editCruise.field.endDate.help");
        registerHelpId(_broker, endDateField, "tutti.editCruise.field.endDate.help");
        registerHelpId(_broker, endTimeField, "tutti.editCruise.field.endTime.help");
        registerHelpId(_broker, nameLabel, "tutti.editCruise.field.name.help");
        registerHelpId(_broker, nameField, "tutti.editCruise.field.name.help");
        registerHelpId(_broker, generateNameButton, "tutti.editCruise.action.generateName.help");
        registerHelpId(_broker, multirigNumberLabel, "tutti.editCruise.field.multirigNumber.help");
        registerHelpId(_broker, multirigNumberField, "tutti.editCruise.field.multirigNumber.help");
        registerHelpId(_broker, filterVesselLabel, "tutti.editCruise.filterVessel.help");
        registerHelpId(_broker, vesselLabel, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, vesselComboBox, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, gearList, "tutti.editCruise.field.gear.help");
        registerHelpId(_broker, headOfMissionList, "tutti.editCruise.field.headOfMission.help");
        registerHelpId(_broker, headOfSortRoomList, "tutti.editCruise.field.headOfSortRoom.help");
        registerHelpId(_broker, commentPane, "tutti.editCruise.field.comment.help");
        registerHelpId(_broker, closeButton, "tutti.editCruise.action.close.help");
        registerHelpId(_broker, resetButton, "tutti.editCruise.action.reset.help");
        registerHelpId(_broker, saveButton, "tutti.editCruise.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editCruiseTopPanel", editCruiseTopPanel);
        createModel();
        createValidator();
        createMainPanelLayout();
        createBroker();
        createTopToolBar();
        createAttachmentsButton();
        createGearMenuPopup();
        createEditGearCaracteristicsItem();
        createViewGearCaracteristicsItem();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCruiseScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramComboBox();
        createSurveyPartLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        $JToolBar0.setOpaque(false);
        $JToolBar0.setBorderPainted(false);
        createSurveyPartResetButton();
        createSurveyPartField();
        createDepartureLocationLabel();
        createDepartureLocationComboBox();
        createBeginDateLabel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createBeginDateField();
        createBeginTimeField();
        createReturnLocationLabel();
        createReturnLocationComboBox();
        createEndDateLabel();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new BorderLayout());
        createEndDateField();
        createEndTimeField();
        createNameLabel();
        createNameField();
        createGenerateNameButton();
        createMultirigNumberLabel();
        createMultirigNumberField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.HORIZONTAL));
        
        $JSeparator0.setName("$JSeparator0");
        createVesselFilterPane();
        createFilterVesselLabel();
        createFilterVesselAllButton();
        createFilterVesselScientificButton();
        createFilterVesselFishingButton();
        createVesselLabel();
        createVesselComboBox();
        createGearList();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1, 0));
        createHeadOfMissionList();
        createHeadOfSortRoomList();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createResetButton();
        createSaveButton();
        createGearCaracteristicsEditorTitledPanel();
        createGearCaracteristicsEditor();
        createFilterVesselType();
        // inline creation of editCruiseTopPanel
        setName("editCruiseTopPanel");
        setLayout(mainPanelLayout);
        editCruiseTopPanel.putClientProperty("help", "tutti.editCruise.help");
        
        // registers 20 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 20 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_GEAR_CARACTERISTICS_ITEM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canEditGearCatacteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editGearCaracteristicsItem.setEnabled(model.isCanEditGearCatacteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canEditGearCatacteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VIEW_GEAR_CARACTERISTICS_ITEM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canShowGearCatacteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    viewGearCaracteristicsItem.setEnabled(model.isCanShowGearCatacteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canShowGearCatacteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEPARTURE_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("departureLocation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    departureLocationComboBox.setSelectedItem(model.getDepartureLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("departureLocation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEGIN_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beginDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beginDateField.setDate(model.getBeginDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beginDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RETURN_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("returnLocation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    returnLocationComboBox.setSelectedItem(model.getReturnLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("returnLocation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("endDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    endDateField.setDate(model.getEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("endDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_NAME_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerateName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateNameButton.setEnabled(model.isCanGenerateName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerateName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_NUMBER_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    multirigNumberField.setNumberValue(model.getMultirigNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MULTIRIG_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_1_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                multirigNumberField.setNumberPattern(INT_1_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselAllButton.setSelected(model.isVesselTypeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeScientific", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselScientificButton.setSelected(model.isVesselTypeScientific());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeScientific", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselFishingButton.setSelected(model.isVesselTypeFishing());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeFishing", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselComboBox.setSelectedItem(model.getVessel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("create", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resetButton.setEnabled(model.isModify() && !model.isCreate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("create", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}