// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.fishingArea;

import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.referential.DepthGradient;
import fr.ifremer.adagio.core.dao.referential.DistanceToCoastGradient;
import fr.ifremer.adagio.core.dao.referential.NearbySpecificArea;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * Zone de peche ou d'activité effective d'un navire.
 * Contient une entrée pour chaque zone de peche d'un navire.
 * Dans le cas des campagne scientifique, cela correspon à la "station" d'une opération.
 * ATTENTION : ne pas réutiliser une zone de peche effective dèjà existante, à cause des liens de
 * composition (et des contraintes "delete cascade") depuis les autres tables.
 * Votre enregistrement pourrait etre supprimée par quelqu'un d'autre !
 */
// HibernateEntity.vsl annotations merge-point
public abstract class FishingArea
    implements Serializable, Comparable<FishingArea>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -1175291070403446393L;

    // Generate 2 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 10 associations
    private Sale sale;

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @return this.sale Sale
     */
    public Sale getSale()
    {
        return this.sale;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param saleIn Sale
     */
    public void setSale(Sale saleIn)
    {
        this.sale = saleIn;
    }

    private Collection<FishingArea2RegulationLocation> regulationLocations = new HashSet<FishingArea2RegulationLocation>();

    /**
     * Zones réglementaires particulières (ex : ZEE, zone d'effort, etc.)
     * @return this.regulationLocations Collection<FishingArea2RegulationLocation>
     */
    public Collection<FishingArea2RegulationLocation> getRegulationLocations()
    {
        return this.regulationLocations;
    }

    /**
     * Zones réglementaires particulières (ex : ZEE, zone d'effort, etc.)
     * @param regulationLocationsIn Collection<FishingArea2RegulationLocation>
     */
    public void setRegulationLocations(Collection<FishingArea2RegulationLocation> regulationLocationsIn)
    {
        this.regulationLocations = regulationLocationsIn;
    }

    /**
     * Zones réglementaires particulières (ex : ZEE, zone d'effort, etc.)
     * @param elementToAdd FishingArea2RegulationLocation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addRegulationLocations(FishingArea2RegulationLocation elementToAdd)
    {
        return this.regulationLocations.add(elementToAdd);
    }

    /**
     * Zones réglementaires particulières (ex : ZEE, zone d'effort, etc.)
     * @param elementToRemove FishingArea2RegulationLocation
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeRegulationLocations(FishingArea2RegulationLocation elementToRemove)
    {
        return this.regulationLocations.remove(elementToRemove);
    }

    private Sample sample;

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @return this.sample Sample
     */
    public Sample getSample()
    {
        return this.sample;
    }

    /**
     * Un prélèvement représente un (et un seul) support, prélevé au cours d'une opération de peche,
     * d'un
     * échantillonnage au débarquement ou d'une vente. Il s'agit de la partie qui est recueillie
     * pour
     * analyse ou dénombrement.
     * Un prélèvement est rattaché à une opération de peche ou un groupe d'opérations, un
     * débarquement ou à
     * une vente. Il peut être en plus rattaché à un des lots échantillonnés (le lot de provenance).
     * Dans le cas des marées observées en mer, un prlèvement correspond à un individu, dont le
     * support
     * est, par exemple :
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme (oursin...)
     * - etc.
     * Le nombre d'individu, généralement égal à 1, permet de constituer des prélèvement de
     * plusieurs
     * individu (dès lors qu'il sont ne meme anture). Chaque résultat de mesure (SampleMeasurement)
     * pourra
     * identifié l'individu concerné par la mesure, par une numéro din'dividu.
     * Un mnémonique, représentant généralement l'étiquette collée sur le sachet contenant le
     * prélèvement,
     * permet d"identifier le prélèvement de manière simple, notamment en laboratoire pour la saisie
     * des
     * lectures d'age, etc..
     * Par exemple de prélèvement :
     * - un poisson, d'une espèce donnée, sur lequel est prélevé un otholithe, et/ou des écailes
     * afin de
     * réaliser une lecture d'age.
     * - un cétacé, issu d'un lot, sur lesquels doit être effectué des analyses d'age, de taille,
     * - etc.
     * @param sampleIn Sample
     */
    public void setSample(Sample sampleIn)
    {
        this.sample = sampleIn;
    }

    private DepthGradient depthGradient;

    /**
     * Type de gradient de profondeur de la zone de pêche.
     * @return this.depthGradient DepthGradient
     */
    public DepthGradient getDepthGradient()
    {
        return this.depthGradient;
    }

    /**
     * Type de gradient de profondeur de la zone de pêche.
     * @param depthGradientIn DepthGradient
     */
    public void setDepthGradient(DepthGradient depthGradientIn)
    {
        this.depthGradient = depthGradientIn;
    }

    private Location location;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private DistanceToCoastGradient distanceToCoastGradient;

    /**
     * Gradient de distance à la cote.
     * passage en optionel nécessaire pour SACROIS.
     * @return this.distanceToCoastGradient DistanceToCoastGradient
     */
    public DistanceToCoastGradient getDistanceToCoastGradient()
    {
        return this.distanceToCoastGradient;
    }

    /**
     * Gradient de distance à la cote.
     * passage en optionel nécessaire pour SACROIS.
     * @param distanceToCoastGradientIn DistanceToCoastGradient
     */
    public void setDistanceToCoastGradient(DistanceToCoastGradient distanceToCoastGradientIn)
    {
        this.distanceToCoastGradient = distanceToCoastGradientIn;
    }

    private NearbySpecificArea nearbySpecificArea;

    /**
     * Type de zone de proximité particulière.
     * Par exemple :
     * - DCP (Dispositif de Concentration de Poison)
     * - Filière aquacole
     * - ...
     * (liste non exhaustive)
     * Nombre de lignes : 10
     * @return this.nearbySpecificArea NearbySpecificArea
     */
    public NearbySpecificArea getNearbySpecificArea()
    {
        return this.nearbySpecificArea;
    }

    /**
     * Type de zone de proximité particulière.
     * Par exemple :
     * - DCP (Dispositif de Concentration de Poison)
     * - Filière aquacole
     * - ...
     * (liste non exhaustive)
     * Nombre de lignes : 10
     * @param nearbySpecificAreaIn NearbySpecificArea
     */
    public void setNearbySpecificArea(NearbySpecificArea nearbySpecificAreaIn)
    {
        this.nearbySpecificArea = nearbySpecificAreaIn;
    }

    private Produce produce;

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @return this.produce Produce
     */
    public Produce getProduce()
    {
        return this.produce;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param produceIn Produce
     */
    public void setProduce(Produce produceIn)
    {
        this.produce = produceIn;
    }

    private VesselUseFeatures vesselUseFeatures;

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @return this.vesselUseFeatures VesselUseFeatures
     */
    public VesselUseFeatures getVesselUseFeatures()
    {
        return this.vesselUseFeatures;
    }

    /**
     * Paramètres de mise en oeuvre du navire. Il peut s'agir de données d'observation comme de
     * données de
     * déclaration, mais liée à comment est utilisé le navire et dans quelles conditions.
     * Par exemple, pour les donénes d'observation :
     * • profondeur de mer au début de l'opération, en mètre,
     * • profondeur de mer à la fin de l'opération, en mètre,
     * • déroulement de l'opération (normal, anormal, etc.)
     * • état de la mer lors durant l'opération : échelle de 0 à 9 (4=agitée, etc)
     * • trait rectiligne (oui/non)
     * • cout en gazoil,
     * • nombre d'engin perdu,
     * • cout des pertes,
     * • etc.
     * Par exemple, pour les données de déclaration :
     * • temps de pêche,
     * • temps de route (qui peut aussi etre calculé à l'exploitation),
     * • nombre d'opérations,
     * • etc.
     * @param vesselUseFeaturesIn VesselUseFeatures
     */
    public void setVesselUseFeatures(VesselUseFeatures vesselUseFeaturesIn)
    {
        this.vesselUseFeatures = vesselUseFeaturesIn;
    }

    private GearUseFeatures gearUseFeatures;

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @return this.gearUseFeatures GearUseFeatures
     */
    public GearUseFeatures getGearUseFeatures()
    {
        return this.gearUseFeatures;
    }

    /**
     * Paramètre de mise en oeuvre de l'engin durant une opération.
     * Exemple de paramètre de mise en oeuvre:
     * • nombre de boués,
     * • type de panneau,
     * • présence d'un racasseur,
     * • nombre de casier.
     * mais aussi :
     * • profondeur moyenne de l'engin,
     * • vitesse de traine moyenne
     * • ouverture du chalut
     * @param gearUseFeaturesIn GearUseFeatures
     */
    public void setGearUseFeatures(GearUseFeatures gearUseFeaturesIn)
    {
        this.gearUseFeatures = gearUseFeaturesIn;
    }

    /**
     * Returns <code>true</code> if the argument is an FishingArea instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof FishingArea))
        {
            return false;
        }
        final FishingArea that = (FishingArea)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link FishingArea}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link FishingArea}.
         * @return new FishingAreaImpl()
         */
        public static FishingArea newInstance()
        {
            return new FishingAreaImpl();
        }


        /**
         * Constructs a new instance of {@link FishingArea}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param remoteId Integer
         * @param sale Sale
         * @param regulationLocations Collection<FishingArea2RegulationLocation>
         * @param sample Sample
         * @param depthGradient DepthGradient
         * @param location Location
         * @param distanceToCoastGradient DistanceToCoastGradient
         * @param nearbySpecificArea NearbySpecificArea
         * @param produce Produce
         * @param vesselUseFeatures VesselUseFeatures
         * @param gearUseFeatures GearUseFeatures
         * @return newInstance FishingArea
         */
        public static FishingArea newInstance(Integer remoteId, Sale sale, Collection<FishingArea2RegulationLocation> regulationLocations, Sample sample, DepthGradient depthGradient, Location location, DistanceToCoastGradient distanceToCoastGradient, NearbySpecificArea nearbySpecificArea, Produce produce, VesselUseFeatures vesselUseFeatures, GearUseFeatures gearUseFeatures)
        {
            final FishingArea entity = new FishingAreaImpl();
            entity.setRemoteId(remoteId);
            entity.setSale(sale);
            entity.setRegulationLocations(regulationLocations);
            entity.setSample(sample);
            entity.setDepthGradient(depthGradient);
            entity.setLocation(location);
            entity.setDistanceToCoastGradient(distanceToCoastGradient);
            entity.setNearbySpecificArea(nearbySpecificArea);
            entity.setProduce(produce);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setGearUseFeatures(gearUseFeatures);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(FishingArea o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// FishingArea.java merge-point
}