/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectComparator;

public class DatabaseObjectCollection
implements LiquibaseSerializable {
    private Map<Class<? extends DatabaseObject>, Map<String, Set<DatabaseObject>>> cache = new HashMap<Class<? extends DatabaseObject>, Map<String, Set<DatabaseObject>>>();
    private Database database;

    public DatabaseObjectCollection(Database database) {
        this.database = database;
    }

    @Override
    public String getSerializedObjectName() {
        return "objects";
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/snapshot";
    }

    @Override
    public Set<String> getSerializableFields() {
        TreeSet<String> types = new TreeSet<String>();
        for (Class<? extends DatabaseObject> type : this.cache.keySet()) {
            types.add(type.getName());
        }
        return types;
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        Map<String, Set<DatabaseObject>> map;
        TreeSet<DatabaseObject> objects;
        block4: {
            objects = new TreeSet<DatabaseObject>(new DatabaseObjectComparator());
            map = this.cache.get(Class.forName(field));
            if (map != null) break block4;
            return null;
        }
        try {
            for (Set<DatabaseObject> set : map.values()) {
                objects.addAll(set);
            }
            return objects;
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    public void add(DatabaseObject databaseObject) {
        String[] hashes;
        if (databaseObject == null) {
            return;
        }
        Map<String, Set<DatabaseObject>> collectionMap = this.cache.get(databaseObject.getClass());
        if (collectionMap == null) {
            collectionMap = new HashMap<String, Set<DatabaseObject>>();
            this.cache.put(databaseObject.getClass(), collectionMap);
        }
        String[] stringArray = hashes = DatabaseObjectComparatorFactory.getInstance().hash(databaseObject, this.database);
        int n = hashes.length;
        int n2 = 0;
        while (n2 < n) {
            String hash = stringArray[n2];
            Set<DatabaseObject> collection = collectionMap.get(hash);
            if (collection == null) {
                collection = new HashSet<DatabaseObject>();
                collectionMap.put(hash, collection);
            }
            collection.add(databaseObject);
            ++n2;
        }
    }

    public <DatabaseObjectType extends DatabaseObject> DatabaseObjectType get(DatabaseObjectType example) {
        Map<String, Set<DatabaseObject>> databaseObjectsByHash = this.cache.get(example.getClass());
        if (databaseObjectsByHash == null) {
            return null;
        }
        String[] hashes = DatabaseObjectComparatorFactory.getInstance().hash(example, this.database);
        TreeSet<Set<DatabaseObject>> objectSets = new TreeSet<Set<DatabaseObject>>(new Comparator<Set<DatabaseObject>>(){

            @Override
            public int compare(Set<DatabaseObject> o1, Set<DatabaseObject> o2) {
                int sizeComparison = Integer.valueOf(o1.size()).compareTo(o2.size());
                if (sizeComparison == 0) {
                    return o1.toString().compareTo(o2.toString());
                }
                return sizeComparison;
            }
        });
        String[] stringArray = hashes;
        int n = hashes.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Set<DatabaseObject> databaseObjects = databaseObjectsByHash.get(string);
            if (databaseObjects != null) {
                objectSets.add(databaseObjects);
            }
            ++n2;
        }
        for (Set set : objectSets) {
            for (DatabaseObject obj : set) {
                if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(obj, example, this.database)) continue;
                return (DatabaseObjectType)obj;
            }
        }
        return null;
    }

    public <DatabaseObjectType extends DatabaseObject> Set<DatabaseObjectType> get(Class<DatabaseObjectType> type) {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Map<String, Set<DatabaseObject>> allFound = this.cache.get(type);
        if (allFound != null) {
            for (Set<DatabaseObject> objects : allFound.values()) {
                returnSet.addAll(objects);
            }
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public boolean contains(DatabaseObject wantedObject) {
        return this.get(wantedObject) != null;
    }
}

