/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.Liquibase;
import liquibase.change.CheckSum;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogFactory;
import liquibase.logging.LogLevel;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class Main {
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String outputDefaultSchema = "true";
    protected String outputDefaultCatalog = "true";
    protected String defaultCatalogName;
    protected String changeLogFile;
    protected String classpath;
    protected String contexts;
    protected String driverPropertiesFile;
    protected Boolean promptForNonLocalDatabase = null;
    protected Boolean includeSystemClasspath;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataOutputDirectory;
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new LinkedHashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();

    public static void main(String[] args) throws CommandLineParsingException, IOException {
        try {
            List<String> setupMessages;
            String shouldRunProperty = System.getProperty("liquibase.should.run");
            if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
                System.err.println("Liquibase did not run because 'liquibase.should.run' system property was set to false");
                return;
            }
            Main main = new Main();
            if (args.length == 1 && "--help".equals(args[0])) {
                main.printHelp(System.err);
                return;
            }
            if (args.length == 1 && "--version".equals(args[0])) {
                System.err.println("Liquibase Version: " + LiquibaseUtil.getBuildVersion() + StreamUtil.getLineSeparator());
                return;
            }
            try {
                main.parseOptions(args);
            }
            catch (CommandLineParsingException e) {
                main.printHelp(Arrays.asList(e.getMessage()), System.err);
                System.exit(-2);
            }
            File propertiesFile = new File(main.defaultsFile);
            File localPropertiesFile = new File(main.defaultsFile.replaceFirst("(\\.[^\\.]+)$", ".local$1"));
            if (localPropertiesFile.exists()) {
                main.parsePropertiesFile(new FileInputStream(localPropertiesFile));
            }
            if (propertiesFile.exists()) {
                main.parsePropertiesFile(new FileInputStream(propertiesFile));
            }
            if ((setupMessages = main.checkSetup()).size() > 0) {
                main.printHelp(setupMessages, System.err);
                return;
            }
            try {
                main.applyDefaults();
                main.configureClassLoader();
                main.doMigration();
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "Unknown Reason";
                }
                if (e.getCause() instanceof ValidationFailedException) {
                    ((ValidationFailedException)e.getCause()).printDescriptiveError(System.err);
                } else {
                    System.err.println("Liquibase " + main.command + " Failed: " + message);
                    LogFactory.getLogger().severe(message, e);
                    System.err.println(Main.generateLogLevelWarningMessage());
                }
                System.exit(-1);
            }
            if ("update".equals(main.command)) {
                System.err.println("Liquibase Update Successful");
            } else if (main.command.startsWith("rollback") && !main.command.endsWith("SQL")) {
                System.err.println("Liquibase Rollback Successful");
            } else if (!main.command.endsWith("SQL")) {
                System.err.println("Liquibase '" + main.command + "' Successful");
            }
        }
        catch (Throwable e) {
            String message = "Unexpected error running Liquibase: " + e.getMessage();
            System.err.println(message);
            try {
                LogFactory.getLogger().severe(message, e);
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
            System.exit(-3);
        }
        System.exit(0);
    }

    private static String generateLogLevelWarningMessage() {
        Logger logger = LogFactory.getLogger();
        if (logger != null && logger.getLogLevel() != null && logger.getLogLevel().equals((Object)LogLevel.OFF)) {
            return "";
        }
        return "\n\nFor more information, use the --logLevel flag";
    }

    protected String[] fixupArgs(String[] args) {
        ArrayList<String> fixedArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if ((arg.startsWith("--") || arg.startsWith("-D")) && !arg.contains("=")) {
                String nextArg = null;
                if (i + 1 < args.length) {
                    nextArg = args[i + 1];
                }
                if (nextArg != null && !nextArg.startsWith("--") && !this.isCommand(nextArg)) {
                    arg = String.valueOf(arg) + "=" + nextArg;
                    ++i;
                }
            }
            fixedArgs.add(arg);
            ++i;
        }
        return fixedArgs.toArray(new String[fixedArgs.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.command == null) {
            messages.add("Command not passed");
        } else if (!this.isCommand(this.command)) {
            messages.add("Unknown command: " + this.command);
        } else {
            if (this.url == null) {
                messages.add("--url is required");
            }
            if (this.isChangeLogRequired(this.command) && this.changeLogFile == null) {
                messages.add("--changeLogFile is required");
            }
            if (this.isNoArgCommand(this.command) && !this.commandParams.isEmpty()) {
                messages.add("unexpected command parameters: " + this.commandParams);
            } else {
                this.validateCommandParameters(messages);
            }
        }
        return messages;
    }

    private void checkForUnexpectedCommandParameter(List<String> messages) {
        if ("updateCount".equalsIgnoreCase(this.command) || "updateCountSQL".equalsIgnoreCase(this.command) || "rollback".equalsIgnoreCase(this.command) || "rollbackToDate".equalsIgnoreCase(this.command) || "rollbackCount".equalsIgnoreCase(this.command) || "rollbackSQL".equalsIgnoreCase(this.command) || "rollbackToDateSQL".equalsIgnoreCase(this.command) || "rollbackCountSQL".equalsIgnoreCase(this.command) || "calculateCheckSum".equalsIgnoreCase(this.command) || "dbDoc".equalsIgnoreCase(this.command) || "tag".equalsIgnoreCase(this.command)) {
            if (this.commandParams.size() > 0 && this.commandParams.iterator().next().startsWith("-")) {
                messages.add("unexpected command parameters: " + this.commandParams);
            }
        } else if ("status".equalsIgnoreCase(this.command) || "unexpectedChangeSets".equalsIgnoreCase(this.command)) {
            if (this.commandParams.size() > 0 && !this.commandParams.iterator().next().equalsIgnoreCase("--verbose")) {
                messages.add("unexpected command parameters: " + this.commandParams);
            }
        } else if (("diff".equalsIgnoreCase(this.command) || "diffChangeLog".equalsIgnoreCase(this.command)) && this.commandParams.size() > 0) {
            for (String cmdParm : this.commandParams) {
                if (cmdParm.startsWith("--referenceUsername") || cmdParm.startsWith("--referencePassword") || cmdParm.startsWith("--referenceDriver") || cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--referenceUrl")) continue;
                messages.add("unexpected command parameters: " + this.commandParams);
            }
        }
    }

    private void validateCommandParameters(List<String> messages) {
        this.checkForUnexpectedCommandParameter(messages);
        this.checkForMissingCommandParameters(messages);
        this.checkForMalformedCommandParameters(messages);
    }

    private void checkForMissingCommandParameters(List<String> messages) {
        if ((this.commandParams.isEmpty() || this.commandParams.iterator().next().startsWith("-")) && "calculateCheckSum".equalsIgnoreCase(this.command)) {
            messages.add("missing changeSet identifier");
        }
    }

    private void checkForMalformedCommandParameters(List<String> messages) {
        if (!this.commandParams.isEmpty() && "calculateCheckSum".equalsIgnoreCase(this.command)) {
            for (String param : this.commandParams) {
                String[] parts;
                assert (param != null);
                if (param == null || param.startsWith("-") || (parts = param.split("::")) != null && parts.length >= 3) continue;
                messages.add("changeSet identifier must be of the form filepath::id::author");
                break;
            }
        }
    }

    private boolean isChangeLogRequired(String command) {
        return command.toLowerCase().startsWith("update") || command.toLowerCase().startsWith("rollback") || "calculateCheckSum".equalsIgnoreCase(command) || "status".equalsIgnoreCase(command) || "validate".equalsIgnoreCase(command) || "changeLogSync".equalsIgnoreCase(command) || "changeLogSyncSql".equalsIgnoreCase(command);
    }

    private boolean isCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateCount".equalsIgnoreCase(arg) || "updateCountSQL".equalsIgnoreCase(arg) || "rollback".equalsIgnoreCase(arg) || "rollbackToDate".equalsIgnoreCase(arg) || "rollbackCount".equalsIgnoreCase(arg) || "rollbackSQL".equalsIgnoreCase(arg) || "rollbackToDateSQL".equalsIgnoreCase(arg) || "rollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "futureRollbackCountSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "tag".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "status".equalsIgnoreCase(arg) || "unexpectedChangeSets".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "diff".equalsIgnoreCase(arg) || "diffChangeLog".equalsIgnoreCase(arg) || "generateChangeLog".equalsIgnoreCase(arg) || "calculateCheckSum".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "dbDoc".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    private boolean isNoArgCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws IOException, CommandLineParsingException {
        Properties props = new Properties();
        props.load(propertiesInputStream);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            try {
                if (entry.getKey().equals("promptOnNonLocalDatabase")) continue;
                if (((String)entry.getKey()).startsWith("parameter.")) {
                    this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
                    continue;
                }
                Field field = this.getClass().getDeclaredField((String)entry.getKey());
                Object currentValue = field.get(this);
                if (currentValue != null) continue;
                String value = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                    continue;
                }
                field.set(this, value);
            }
            catch (Exception e) {
                throw new CommandLineParsingException("Unknown parameter: '" + entry.getKey() + "'");
            }
        }
    }

    protected void printHelp(List<String> errorMessages, PrintStream stream) {
        stream.println("Errors:");
        for (String message : errorMessages) {
            stream.println("  " + message);
        }
        stream.println();
        this.printHelp(stream);
    }

    protected void printWarning(List<String> warningMessages, PrintStream stream) {
        stream.println("Warnings:");
        for (String message : warningMessages) {
            stream.println("  " + message);
        }
        stream.println();
    }

    protected void printHelp(PrintStream stream) {
        stream.println("Usage: java -jar liquibase.jar [options] [command]");
        stream.println("");
        stream.println("Standard Commands:");
        stream.println(" update                         Updates database to current version");
        stream.println(" updateSQL                      Writes SQL to update database to current");
        stream.println("                                version to STDOUT");
        stream.println(" updateCount <num>              Applies next NUM changes to the database");
        stream.println(" updateCountSQL <num>           Writes SQL to apply next NUM changes");
        stream.println("                                to the database");
        stream.println(" rollback <tag>                 Rolls back the database to the the state is was");
        stream.println("                                when the tag was applied");
        stream.println(" rollbackSQL <tag>              Writes SQL to roll back the database to that");
        stream.println("                                state it was in when the tag was applied");
        stream.println("                                to STDOUT");
        stream.println(" rollbackToDate <date/time>     Rolls back the database to the the state is was");
        stream.println("                                at the given date/time.");
        stream.println("                                Date Format: yyyy-MM-dd'T'HH:mm:ss");
        stream.println(" rollbackToDateSQL <date/time>  Writes SQL to roll back the database to that");
        stream.println("                                state it was in at the given date/time version");
        stream.println("                                to STDOUT");
        stream.println(" rollbackCount <value>          Rolls back the last <value> change sets");
        stream.println("                                applied to the database");
        stream.println(" rollbackCountSQL <value>       Writes SQL to roll back the last");
        stream.println("                                <value> change sets to STDOUT");
        stream.println("                                applied to the database");
        stream.println(" futureRollbackSQL              Writes SQL to roll back the database to the ");
        stream.println("                                current state after the changes in the ");
        stream.println("                                changeslog have been applied");
        stream.println(" futureRollbackSQL <value>      Writes SQL to roll back the database to the ");
        stream.println("                                current state after <value> changes in the ");
        stream.println("                                changeslog have been applied");
        stream.println(" updateTestingRollback          Updates database, then rolls back changes before");
        stream.println("                                updating again. Useful for testing");
        stream.println("                                rollback support");
        stream.println(" generateChangeLog              Writes Change Log XML to copy the current state");
        stream.println("                                of the database to standard out");
        stream.println("");
        stream.println("Diff Commands");
        stream.println(" diff [diff parameters]          Writes description of differences");
        stream.println("                                 to standard out");
        stream.println(" diffChangeLog [diff parameters] Writes Change Log XML to update");
        stream.println("                                 the database");
        stream.println("                                 to the reference database to standard out");
        stream.println("");
        stream.println("Documentation Commands");
        stream.println(" dbDoc <outputDirectory>         Generates Javadoc-like documentation");
        stream.println("                                 based on current database and change log");
        stream.println("");
        stream.println("Maintenance Commands");
        stream.println(" tag <tag string>          'Tags' the current database state for future rollback");
        stream.println(" status [--verbose]        Outputs count (list if --verbose) of unrun changesets");
        stream.println(" unexpectedChangeSets [--verbose]");
        stream.println("                           Outputs count (list if --verbose) of changesets run");
        stream.println("                           in the database that do not exist in the changelog.");
        stream.println(" validate                  Checks changelog for errors");
        stream.println(" calculateCheckSum <id>    Calculates and prints a checksum for the changeset");
        stream.println("                           with the given id in the format filepath::id::author.");
        stream.println(" clearCheckSums            Removes all saved checksums from database log.");
        stream.println("                           Useful for 'MD5Sum Check Failed' errors");
        stream.println(" changelogSync             Mark all changes as executed in the database");
        stream.println(" changelogSyncSQL          Writes SQL to mark all changes as executed ");
        stream.println("                           in the database to STDOUT");
        stream.println(" markNextChangeSetRan      Mark the next change changes as executed ");
        stream.println("                           in the database");
        stream.println(" markNextChangeSetRanSQL   Writes SQL to mark the next change ");
        stream.println("                           as executed in the database to STDOUT");
        stream.println(" listLocks                 Lists who currently has locks on the");
        stream.println("                           database changelog");
        stream.println(" releaseLocks              Releases all locks on the database changelog");
        stream.println(" dropAll                   Drop all database objects owned by user");
        stream.println("");
        stream.println("Required Parameters:");
        stream.println(" --changeLogFile=<path and filename>        Migration file");
        stream.println(" --username=<value>                         Database username");
        stream.println(" --password=<value>                         Database password. If values");
        stream.println("                                            is PROMPT, Liquibase will");
        stream.println("                                            prompt for a password");
        stream.println(" --url=<value>                              Database URL");
        stream.println("");
        stream.println("Optional Parameters:");
        stream.println(" --classpath=<value>                        Classpath containing");
        stream.println("                                            migration files and JDBC Driver");
        stream.println(" --driver=<jdbc.driver.ClassName>           Database driver class name");
        stream.println(" --databaseClass=<database.ClassName>       custom liquibase.database.Database");
        stream.println("                                            implementation to use");
        stream.println(" --defaultSchemaName=<name>                 Default database schema to use");
        stream.println(" --contexts=<value>                         ChangeSet contexts to execute");
        stream.println(" --defaultsFile=</path/to/file.properties>  File with default option values");
        stream.println("                                            (default: ./liquibase.properties)");
        stream.println(" --driverPropertiesFile=</path/to/file.properties>  File with custom properties");
        stream.println("                                            to be set on the JDBC connection");
        stream.println("                                            to be created");
        stream.println(" --includeSystemClasspath=<true|false>      Include the system classpath");
        stream.println("                                            in the Liquibase classpath");
        stream.println("                                            (default: true)");
        stream.println(" --promptForNonLocalDatabase=<true|false>   Prompt if non-localhost");
        stream.println("                                            databases (default: false)");
        stream.println(" --logLevel=<level>                         Execution log level");
        stream.println("                                            (debug, info, warning, severe, off");
        stream.println(" --logFile=<file>                           Log file");
        stream.println(" --currentDateTimeFunction=<value>          Overrides current date time function");
        stream.println("                                            used in SQL.");
        stream.println("                                            Useful for unsupported databases");
        stream.println(" --outputDefaultSchema=<true|false>         If true, SQL object references");
        stream.println("                                            include the schema name, even if");
        stream.println("                                            it is the default schema. ");
        stream.println("                                            Defaults to true");
        stream.println(" --outputDefaultCatalog=<true|false>        If true, SQL object references");
        stream.println("                                            include the catalog name, even if");
        stream.println("                                            it is the default catalog.");
        stream.println("                                            Defaults to true");
        stream.println(" --help                                     Prints this message");
        stream.println(" --version                                  Prints this version information");
        stream.println("");
        stream.println("Required Diff Parameters:");
        stream.println(" --referenceUsername=<value>                Reference Database username");
        stream.println(" --referencePassword=<value>                Reference Database password. If");
        stream.println("                                            value is PROMPT, Liquibase will");
        stream.println("                                            prompt for a password");
        stream.println(" --referenceUrl=<value>                     Reference Database URL");
        stream.println("");
        stream.println("Optional Diff Parameters:");
        stream.println(" --referenceDriver=<jdbc.driver.ClassName>  Reference Database driver class name");
        stream.println(" --dataOutputDirectory=DIR                  Output data as CSV in the given ");
        stream.println("                                            directory");
        stream.println(" --diffTypes                                List of diff types to include in");
        stream.println("                                            Change Log expressed as a comma");
        stream.println("                                            separated list from: tables, views,");
        stream.println("                                            columns, indexes, foreignkeys,");
        stream.println("                                            primarykeys, uniqueconstraints");
        stream.println("                                            data.");
        stream.println("                                            If this is null then the default");
        stream.println("                                            types will be: tables, views,");
        stream.println("                                            columns, indexes, foreignkeys,");
        stream.println("                                             primarykeys, uniqueconstraints.");
        stream.println("");
        stream.println("Change Log Properties:");
        stream.println(" -D<property.name>=<property.value>         Pass a name/value pair for");
        stream.println("                                            substitution in the change log(s)");
        stream.println("");
        stream.println("Default value for parameters can be stored in a file called");
        stream.println("'liquibase.properties' that is read from the current working directory.");
        stream.println("");
        stream.println("Full documentation is available at");
        stream.println("http://www.liquibase.org/documentation/command_line.html");
        stream.println("");
    }

    protected void parseOptions(String[] args) throws CommandLineParsingException {
        args = this.fixupArgs(args);
        boolean seenCommand = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String attributeName;
            String[] splitArg;
            String arg = stringArray[n2];
            if (this.isCommand(arg)) {
                this.command = arg;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                seenCommand = true;
            } else if (seenCommand) {
                if (arg.startsWith("-D")) {
                    splitArg = this.splitArg(arg);
                    attributeName = splitArg[0].replaceFirst("^-D", "");
                    value = splitArg[1];
                    this.changeLogParameters.put(attributeName, value);
                } else {
                    this.commandParams.add(arg);
                }
            } else if (arg.startsWith("--")) {
                splitArg = this.splitArg(arg);
                attributeName = splitArg[0];
                value = splitArg[1];
                if (StringUtils.trimToEmpty(value).equalsIgnoreCase("PROMPT")) {
                    Console c = System.console();
                    if (c == null) {
                        throw new CommandLineParsingException("Console unavailable");
                    }
                    value = attributeName.toLowerCase().contains("password") ? new String(c.readPassword(String.valueOf(attributeName) + ": ", new Object[0])) : new String(c.readLine(String.valueOf(attributeName) + ": ", new Object[0]));
                }
                try {
                    Field field = this.getClass().getDeclaredField(attributeName);
                    if (field.getType().equals(Boolean.class)) {
                        field.set(this, Boolean.valueOf(value));
                    }
                    field.set(this, value);
                }
                catch (Exception e) {
                    throw new CommandLineParsingException("Unknown parameter: '" + attributeName + "'");
                }
            } else {
                throw new CommandLineParsingException("Unexpected value " + arg + ": parameters must start with a '--'");
            }
            ++n2;
        }
    }

    private String[] splitArg(String arg) throws CommandLineParsingException {
        String[] splitArg = arg.split("=", 2);
        if (splitArg.length < 2) {
            throw new CommandLineParsingException("Could not parse '" + arg + "'");
        }
        splitArg[0] = splitArg[0].replaceFirst("--", "");
        return splitArg;
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "off";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
    }

    protected void configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] classpath = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            String[] stringArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                String classpathEntry = stringArray[n2];
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new CommandLineParsingException(String.valueOf(classPathFile.getAbsolutePath()) + " does not exist");
                }
                try {
                    if (classpathEntry.endsWith(".war")) {
                        this.addWarFileClasspathEntries(classPathFile, urls);
                    } else if (classpathEntry.endsWith(".ear")) {
                        JarFile earZip = new JarFile(classPathFile);
                        Enumeration<JarEntry> entries = earZip.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().toLowerCase().endsWith(".jar")) {
                                File jar = this.extract(earZip, entry);
                                urls.add(new URL("jar:" + jar.toURL() + "!/"));
                                jar.deleteOnExit();
                                continue;
                            }
                            if (!entry.getName().toLowerCase().endsWith("war")) continue;
                            File warFile = this.extract(earZip, entry);
                            this.addWarFileClasspathEntries(warFile, urls);
                        }
                    } else {
                        urls.add(new File(classpathEntry).toURL());
                    }
                }
                catch (Exception e) {
                    throw new CommandLineParsingException(e);
                }
                ++n2;
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
        });
        ServiceLocator.getInstance().setResourceAccessor(new ClassLoaderResourceAccessor(this.classLoader));
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    private void addWarFileClasspathEntries(File classPathFile, List<URL> urls) throws IOException {
        URL url = new URL("jar:" + classPathFile.toURL() + "!/WEB-INF/classes/");
        urls.add(url);
        JarFile warZip = new JarFile(classPathFile);
        Enumeration<JarEntry> entries = warZip.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith("WEB-INF/lib") || !entry.getName().toLowerCase().endsWith(".jar")) continue;
            File jar = this.extract(warZip, entry);
            urls.add(new URL("jar:" + jar.toURL() + "!/"));
            jar.deleteOnExit();
        }
    }

    private File extract(JarFile jar, JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("liquibase.tmp", null);
        BufferedInputStream inStream = null;
        FilterOutputStream outStream = null;
        try {
            int status;
            inStream = new BufferedInputStream(jar.getInputStream(entry));
            outStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            while ((status = inStream.read()) != -1) {
                ((BufferedOutputStream)outStream).write(status);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tempFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doMigration() throws Exception {
        if ("help".equalsIgnoreCase(this.command)) {
            this.printHelp(System.err);
            return;
        }
        try {
            if (this.logFile != null) {
                LogFactory.getLogger().setLogLevel(this.logLevel, this.logFile);
            } else {
                LogFactory.getLogger().setLogLevel(this.logLevel);
            }
        }
        catch (IllegalArgumentException e) {
            throw new CommandLineParsingException(e.getMessage(), e);
        }
        FileSystemResourceAccessor fsOpener = new FileSystemResourceAccessor();
        CommandLineResourceAccessor clOpener = new CommandLineResourceAccessor(this.classLoader);
        Database database = CommandLineUtils.createDatabaseObject(this.classLoader, this.url, this.username, this.password, this.driver, this.defaultCatalogName, this.defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), this.databaseClass, this.driverPropertiesFile, null, null);
        try {
            CompositeResourceAccessor fileOpener = new CompositeResourceAccessor(fsOpener, clOpener);
            boolean includeCatalog = Boolean.parseBoolean(this.getCommandParam("includeCatalog", "false"));
            boolean includeSchema = Boolean.parseBoolean(this.getCommandParam("includeSchema", "false"));
            boolean includeTablespace = Boolean.parseBoolean(this.getCommandParam("includeTablespace", "false"));
            DiffOutputControl diffOutputControl = new DiffOutputControl(includeCatalog, includeSchema, includeTablespace);
            if ("diff".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doDiff(this.createReferenceDatabaseFromCommandParams(this.commandParams), database, StringUtils.trimToNull(this.diffTypes));
                return;
            }
            if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doDiffToChangeLog(this.changeLogFile, this.createReferenceDatabaseFromCommandParams(this.commandParams), database, diffOutputControl, StringUtils.trimToNull(this.diffTypes));
                return;
            }
            if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                CommandLineUtils.doGenerateChangeLog(this.changeLogFile, database, this.defaultCatalogName, this.defaultSchemaName, StringUtils.trimToNull(this.diffTypes), StringUtils.trimToNull(this.changeSetAuthor), StringUtils.trimToNull(this.changeSetContext), StringUtils.trimToNull(this.dataOutputDirectory), diffOutputControl);
                return;
            }
            Liquibase liquibase = new Liquibase(this.changeLogFile, (ResourceAccessor)fileOpener, database);
            liquibase.setCurrentDateTimeFunction(this.currentDateTimeFunction);
            for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            if ("listLocks".equalsIgnoreCase(this.command)) {
                liquibase.reportLocks(System.err);
                return;
            }
            if ("releaseLocks".equalsIgnoreCase(this.command)) {
                LockService lockService = LockServiceFactory.getInstance().getLockService(database);
                lockService.forceReleaseLock();
                System.err.println("Successfully released all database change log locks for " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                return;
            }
            if ("tag".equalsIgnoreCase(this.command)) {
                liquibase.tag(this.commandParams.iterator().next());
                System.err.println("Successfully tagged " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                return;
            }
            if ("dropAll".equals(this.command)) {
                liquibase.dropAll();
                System.err.println("All objects dropped from " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                return;
            }
            if ("status".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportStatus(runVerbose, this.contexts, this.getOutputWriter());
                return;
            }
            if ("unexpectedChangeSets".equalsIgnoreCase(this.command)) {
                boolean runVerbose = false;
                if (this.commandParams.contains("--verbose")) {
                    runVerbose = true;
                }
                liquibase.reportUnexpectedChangeSets(runVerbose, this.contexts, this.getOutputWriter());
                return;
            }
            if ("validate".equalsIgnoreCase(this.command)) {
                try {
                    liquibase.validate();
                }
                catch (ValidationFailedException e) {
                    e.printDescriptiveError(System.err);
                    try {
                        database.rollback();
                        database.close();
                        return;
                    }
                    catch (DatabaseException e2) {
                        LogFactory.getLogger().warning("problem closing connection", e2);
                    }
                    return;
                }
                System.err.println("No validation errors found");
                return;
            }
            if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                liquibase.clearCheckSums();
                return;
            }
            if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
                CheckSum checkSum = null;
                checkSum = liquibase.calculateCheckSum(this.commandParams.iterator().next());
                System.out.println(checkSum);
                return;
            }
            if ("dbdoc".equalsIgnoreCase(this.command)) {
                if (this.commandParams.size() == 0) {
                    throw new CommandLineParsingException("dbdoc requires an output directory");
                }
                if (this.changeLogFile == null) {
                    throw new CommandLineParsingException("dbdoc requires a changeLog parameter");
                }
                liquibase.generateDocumentation(this.commandParams.iterator().next(), this.contexts);
                return;
            }
            try {
                if ("update".equalsIgnoreCase(this.command)) {
                    liquibase.update(this.contexts);
                    return;
                } else if ("changelogSync".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(this.contexts);
                    return;
                } else if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                    liquibase.changeLogSync(this.contexts, this.getOutputWriter());
                    return;
                } else if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(this.contexts);
                    return;
                } else if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                    liquibase.markNextChangeSetRan(this.contexts, this.getOutputWriter());
                    return;
                } else if ("updateCount".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), this.contexts);
                    return;
                } else if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                    return;
                } else if ("updateSQL".equalsIgnoreCase(this.command)) {
                    liquibase.update(this.contexts, this.getOutputWriter());
                    return;
                } else if ("rollback".equalsIgnoreCase(this.command)) {
                    if (this.commandParams == null || this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("rollback requires a rollback tag");
                    }
                    liquibase.rollback(this.commandParams.iterator().next(), this.contexts);
                    return;
                } else if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                    if (this.commandParams == null || this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("rollback requires a rollback date");
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.commandParams.iterator().next()), this.contexts);
                    return;
                } else if ("rollbackCount".equalsIgnoreCase(this.command)) {
                    liquibase.rollback(Integer.parseInt(this.commandParams.iterator().next()), this.contexts);
                    return;
                } else if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams == null || this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("rollbackSQL requires a rollback tag");
                    }
                    liquibase.rollback(this.commandParams.iterator().next(), this.contexts, this.getOutputWriter());
                    return;
                } else if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams == null || this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("rollbackToDateSQL requires a rollback date");
                    }
                    liquibase.rollback(new ISODateFormat().parse(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                    return;
                } else if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams == null || this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("rollbackCountSQL requires a rollback tag");
                    }
                    liquibase.rollback(Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                    return;
                } else if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                    liquibase.futureRollbackSQL(this.contexts, this.getOutputWriter());
                    return;
                } else if ("futureRollbackCountSQL".equalsIgnoreCase(this.command)) {
                    if (this.commandParams == null || this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("futureRollbackCountSQL requires a rollback count");
                    }
                    liquibase.futureRollbackSQL((Integer)Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                    return;
                } else {
                    if (!"updateTestingRollback".equalsIgnoreCase(this.command)) throw new CommandLineParsingException("Unknown command: " + this.command);
                    liquibase.updateTestingRollback(this.contexts);
                }
                return;
            }
            catch (ParseException e) {
                throw new CommandLineParsingException("Unexpected date/time format.  Use 'yyyy-MM-dd'T'HH:mm:ss'");
            }
        }
        finally {
            try {
                database.rollback();
                database.close();
            }
            catch (DatabaseException e) {
                LogFactory.getLogger().warning("problem closing connection", e);
            }
        }
    }

    private String getCommandParam(String paramName, String defaultValue) throws CommandLineParsingException {
        for (String param : this.commandParams) {
            if (!param.contains("=")) {
                return null;
            }
            String[] splitArg = this.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if (!attributeName.equalsIgnoreCase(paramName)) continue;
            return value;
        }
        return defaultValue;
    }

    private Database createReferenceDatabaseFromCommandParams(Set<String> commandParams) throws CommandLineParsingException, DatabaseException {
        String driver = this.referenceDriver;
        String url = this.referenceUrl;
        String username = this.referenceUsername;
        String password = this.referencePassword;
        String defaultSchemaName = this.defaultSchemaName;
        String defaultCatalogName = this.defaultCatalogName;
        for (String param : commandParams) {
            String[] splitArg = this.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("referenceDriver".equalsIgnoreCase(attributeName)) {
                driver = value;
                continue;
            }
            if ("referenceUrl".equalsIgnoreCase(attributeName)) {
                url = value;
                continue;
            }
            if ("referenceUsername".equalsIgnoreCase(attributeName)) {
                username = value;
                continue;
            }
            if ("referencePassword".equalsIgnoreCase(attributeName)) {
                password = value;
                continue;
            }
            if ("referenceDefaultCatalogName".equalsIgnoreCase(attributeName)) {
                defaultCatalogName = value;
                continue;
            }
            if ("referenceDefaultSchemaName".equalsIgnoreCase(attributeName)) {
                defaultSchemaName = value;
                continue;
            }
            if (!"dataOutputDirectory".equalsIgnoreCase(attributeName)) continue;
            this.dataOutputDirectory = value;
        }
        if (url == null) {
            throw new CommandLineParsingException("referenceUrl parameter missing");
        }
        return CommandLineUtils.createDatabaseObject(this.classLoader, url, username, password, driver, defaultCatalogName, defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), null, null, null, null);
    }

    private Writer getOutputWriter() throws UnsupportedEncodingException {
        String charsetName = StringUtils.trimToNull(System.getProperty("liquibase.file.encoding"));
        if (charsetName == null) {
            charsetName = StringUtils.trimToNull(System.getProperty("file.encoding"));
        }
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        return new OutputStreamWriter((OutputStream)System.out, charsetName);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }
}

