/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.DbmsTargetedChange;
import liquibase.database.Database;
import liquibase.statement.InsertExecutablePreparedStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;

@DatabaseChange(name="insert", description="Inserts data into an existing table", priority=1, appliesTo={"table"})
public class InsertDataChange
extends AbstractChange
implements ChangeWithColumns<ColumnConfig>,
DbmsTargetedChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private String dbms;

    @DatabaseChangeProperty(mustEqualExisting="table.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table", description="Name of the table to insert data into")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    @DatabaseChangeProperty(mustEqualExisting="table.column", description="Data to insert into columns", requiredForDatabase={"all"})
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        boolean needsPreparedStatement = false;
        for (ColumnConfig column : this.columns) {
            if (column.getValueBlobFile() != null) {
                needsPreparedStatement = true;
            }
            if (column.getValueClobFile() == null) continue;
            needsPreparedStatement = true;
        }
        if (needsPreparedStatement) {
            return new SqlStatement[]{new InsertExecutablePreparedStatement(database, this.catalogName, this.schemaName, this.tableName, this.columns, this.getChangeSet(), this.getResourceAccessor())};
        }
        InsertStatement statement = new InsertStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.columns) {
            if (database.supportsAutoIncrement() && column.isAutoIncrement() != null && column.isAutoIncrement().booleanValue()) continue;
            statement.addColumnValue(column.getName(), column.getValueObject());
        }
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "New row inserted into " + this.getTableName();
    }

    @Override
    @DatabaseChangeProperty(since="3.0", exampleValue="h2, oracle")
    public String getDbms() {
        return this.dbms;
    }

    @Override
    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

