/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.export.generic.AccidentalCatchExportModel;
import fr.ifremer.tutti.service.export.generic.AccidentalCatchExportRow;
import fr.ifremer.tutti.service.export.generic.CatchExportModel;
import fr.ifremer.tutti.service.export.generic.CatchExportRow;
import fr.ifremer.tutti.service.export.generic.GearCaracteristicExportModel;
import fr.ifremer.tutti.service.export.generic.GearCaracteristicExportRow;
import fr.ifremer.tutti.service.export.generic.IndividualObservationExportModel;
import fr.ifremer.tutti.service.export.generic.IndividualObservationExportRow;
import fr.ifremer.tutti.service.export.generic.MarineLitterExportModel;
import fr.ifremer.tutti.service.export.generic.MarineLitterExportRow;
import fr.ifremer.tutti.service.export.generic.OperationExportModel;
import fr.ifremer.tutti.service.export.generic.OperationExportRow;
import fr.ifremer.tutti.service.export.generic.ParameterExportModel;
import fr.ifremer.tutti.service.export.generic.ParameterExportRow;
import fr.ifremer.tutti.service.export.generic.SpeciesExportModel;
import fr.ifremer.tutti.service.export.generic.SpeciesExportRow;
import fr.ifremer.tutti.service.export.generic.SurveyExportModel;
import fr.ifremer.tutti.service.export.generic.SurveyExportRow;
import fr.ifremer.tutti.util.Numbers;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class TuttiExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiExportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected WeightComputingService weightComputingService;
    protected Caracteristic verticalOpeningCaracteristic;
    protected Caracteristic horizontalOpeningWingCaracteristic;
    protected Caracteristic horizontalOpeningDoorCaracteristic;
    protected Caracteristic deadOrAliveCaracteristic;
    protected Caracteristic genderCaracteristic;
    protected Caracteristic weightMeasuredCaracteristic;
    protected Caracteristic pmfmIdCaracteristic;
    protected Map<String, OperationContext> operationContexts = Maps.newTreeMap();

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.verticalOpeningCaracteristic = this.persistenceService.getVerticalOpeningCaracteristic();
        this.horizontalOpeningWingCaracteristic = this.persistenceService.getHorizontalOpeningWingsCaracteristic();
        this.horizontalOpeningDoorCaracteristic = this.persistenceService.getHorizontalOpeningDoorCaracteristic();
        this.weightMeasuredCaracteristic = this.persistenceService.getWeightMeasuredCaracteristic();
        this.pmfmIdCaracteristic = this.persistenceService.getPmfmIdCaracteristic();
        this.deadOrAliveCaracteristic = this.persistenceService.getDeadOrAliveCaracteristic();
        this.genderCaracteristic = this.persistenceService.getSexCaracteristic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProgram(String programId, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)programId);
        Preconditions.checkNotNull((Object)exportFile);
        Program program = this.persistenceService.getProgram(programId);
        Preconditions.checkNotNull((Object)program);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export program: " + programId));
        }
        this.operationContexts.clear();
        List<Cruise> allCruise = this.persistenceService.getAllCruise(programId);
        File basedir = new File(this.context.getConfig().newTempFile("exportProgram"), "exportProgram-" + programId);
        ApplicationIOUtil.forceMkdir((File)basedir, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{basedir}));
        ExportContext exportContext = this.createExportContext(basedir);
        try {
            for (Cruise cruise : allCruise) {
                cruise = this.persistenceService.getCruise(cruise.getId());
                this.exportCruise(cruise, exportContext, progressionModel);
            }
            ApplicationIOUtil.close((Closeable)exportContext, (String)I18n.t((String)"tutti.service.export.closeContext.error", (Object[])new Object[0]));
            this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.buildZip", (Object[])new Object[]{exportFile}));
            ApplicationIOUtil.zip((File)basedir, (File)exportFile, (String)I18n.t((String)"tutti.service.export.zip.error", (Object[])new Object[]{exportFile}));
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
    }

    public void exportCruise(String cruiseId, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)exportFile);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        this.operationContexts.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export cruise: " + cruiseId));
        }
        ApplicationBusinessException checkError = null;
        try {
            this.checkCruise(progressionModel, cruise, null);
        }
        catch (ApplicationBusinessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Got a check cruise error", (Throwable)e);
            }
            checkError = e;
        }
        File basedir = new File(this.context.getConfig().newTempFile("exportCruise"), "exportCruise-" + cruiseId);
        ApplicationIOUtil.forceMkdir((File)basedir, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{basedir}));
        ExportContext exportContext = this.createExportContext(basedir);
        try {
            this.exportCruise(cruise, exportContext, progressionModel);
            ApplicationIOUtil.close((Closeable)exportContext, (String)I18n.t((String)"tutti.service.export.closeContext.error", (Object[])new Object[0]));
            progressionModel.increments(I18n.t((String)"tutti.service.exportCruise.buildZip", (Object[])new Object[]{exportFile}));
            ApplicationIOUtil.zip((File)basedir, (File)exportFile, (String)I18n.t((String)"tutti.service.export.zip.error", (Object[])new Object[]{exportFile}));
        }
        catch (ApplicationBusinessException e) {
            if (checkError != null) {
                throw checkError;
            }
            throw e;
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
        if (checkError != null) {
            throw checkError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportFishingOperation(String cruiseId, String fishingOperationId) {
        Preconditions.checkNotNull((Object)cruiseId);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        this.operationContexts.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will export cruise: " + cruiseId));
        }
        ApplicationBusinessException checkError = null;
        try {
            this.checkCruise(null, cruise, fishingOperationId);
        }
        catch (ApplicationBusinessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Got a check cruise error", (Throwable)e);
            }
            checkError = e;
        }
        File basedir = new File(this.context.getConfig().newTempFile("exportCruise"), "exportCruise-" + cruiseId);
        ApplicationIOUtil.forceMkdir((File)basedir, (String)I18n.t((String)"tutti.io.mkDir.error", (Object[])new Object[]{basedir}));
        ExportContext exportContext = this.createExportContext(basedir);
        FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
        try {
            this.exportCruise(cruise, Lists.newArrayList((Object[])new FishingOperation[]{fishingOperation}), exportContext, null);
            ApplicationIOUtil.close((Closeable)exportContext, (String)I18n.t((String)"tutti.service.export.closeContext.error", (Object[])new Object[0]));
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
        if (checkError != null) {
            throw checkError;
        }
        return basedir;
    }

    protected ExportContext createExportContext(File basedir) {
        List<Species> allReferentSpecies = this.persistenceService.getAllReferentSpecies();
        Map speciesById = TuttiEntities.splitById(allReferentSpecies);
        char csvSeparator = this.context.getConfig().getCsvSeparator();
        return new ExportContext(basedir, csvSeparator, this.decoratorService, this.weightMeasuredCaracteristic, this.deadOrAliveCaracteristic, this.genderCaracteristic, this.pmfmIdCaracteristic, this.context.getSampleCategoryModel(), speciesById);
    }

    protected void checkCruise(ProgressionModel progressionModel, Cruise cruise, String fishingOperationId) {
        Preconditions.checkNotNull((Object)cruise);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.checkCruise", (Object[])new Object[]{cruise.getName()}));
        Map<String, String> errors = this.weightComputingService.checkCruise(cruise.getId(), fishingOperationId);
        if (MapUtils.isNotEmpty(errors)) {
            Decorator<Cruise> cruiseDecorator = this.decoratorService.getDecoratorByType(Cruise.class);
            Decorator<FishingOperation> fishingOperationDecorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : errors.entrySet()) {
                String operationId = entry.getKey();
                FishingOperation fishingOperation = this.persistenceService.getFishingOperation(operationId);
                String fishingOperationStr = fishingOperationDecorator.toString((Object)fishingOperation);
                sb.append(I18n.t((String)"tutti.service.export.invalid.fishingOperation", (Object[])new Object[]{fishingOperationStr, entry.getValue()}));
            }
            String cruiseStr = cruiseDecorator.toString((Object)cruise);
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.export.invalid.cruise", (Object[])new Object[]{cruiseStr, sb.toString()}));
        }
    }

    protected void increments(ProgressionModel progressionModel, String message) {
        if (progressionModel != null) {
            progressionModel.increments(message);
        }
    }

    protected void exportCruise(Cruise cruise, ExportContext exportContext, ProgressionModel progressionModel) {
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(cruise.getId());
        this.exportCruise(cruise, operations, exportContext, progressionModel);
    }

    protected void exportCruise(Cruise cruise, List<FishingOperation> operations, ExportContext exportContext, ProgressionModel progressionModel) {
        ArrayList loadedOperations = Lists.newArrayListWithCapacity((int)operations.size());
        for (FishingOperation operation : operations) {
            FishingOperation loadedOeration = this.persistenceService.getFishingOperation(operation.getId());
            loadedOperations.add(loadedOeration);
        }
        String cruiseName = cruise.getName();
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportSurvey", (Object[])new Object[]{cruiseName}));
        this.exportSurvey(exportContext, cruise);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportGearCaracteristics", (Object[])new Object[]{cruiseName}));
        this.exportGearCaracteristics(exportContext, cruise);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportOperations", (Object[])new Object[]{cruiseName}));
        this.exportOperations(exportContext, cruise, loadedOperations);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportParameters", (Object[])new Object[]{cruiseName}));
        this.exportParameters(exportContext, cruise, loadedOperations);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportMarineLitters", (Object[])new Object[]{cruiseName}));
        this.exportMarineLitters(exportContext, cruise, loadedOperations);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportIndividualObservations", (Object[])new Object[]{cruiseName}));
        this.exportIndividualObservations(exportContext, cruise, loadedOperations);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportAccidentalCatches", (Object[])new Object[]{cruiseName}));
        this.exportAccidentalCatch(exportContext, cruise, loadedOperations);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportCatches", (Object[])new Object[]{cruiseName}));
        this.exportCatches(exportContext, cruise, loadedOperations);
        this.increments(progressionModel, I18n.t((String)"tutti.service.exportCruise.exportSpecies", (Object[])new Object[]{cruiseName}));
        this.exportSpecies(exportContext, exportContext.getSpeciesToExport());
    }

    protected void exportSurvey(ExportContext exportContext, Cruise cruise) {
        List<TuttiLocation> allCountry = this.persistenceService.getAllCountry();
        String countryId = this.context.getConfig().getExportCountryId();
        TuttiLocation country = (TuttiLocation)TuttiEntities.splitById(allCountry).get(countryId);
        try {
            ArrayList rows = Lists.newArrayList();
            exportContext.surveyModel.prepareRows(rows, cruise, country);
            exportContext.surveyExport.write(rows, exportContext.surveyWriter);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.survey.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportGearCaracteristics(ExportContext exportContext, Cruise cruise) {
        try {
            ArrayList rows = Lists.newArrayList();
            for (Gear gear : cruise.getGear()) {
                CaracteristicMap caracteristics = this.persistenceService.getGearCaracteristics(cruise.getId(), gear.getId(), gear.getRankOrder());
                Gear gearWithCaracteristics = Gears.newGear((Gear)gear);
                gearWithCaracteristics.setCaracteristics(caracteristics);
                exportContext.gearCaracteristicsModel.prepareRows(rows, cruise, gearWithCaracteristics);
            }
            exportContext.gearCaracteristicsExport.write(rows, exportContext.gearCaracteristicsWriter);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.survey.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportOperations(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            ArrayList rows = Lists.newArrayList();
            for (FishingOperation operation : operations) {
                OperationContext operationContext = this.getOperationContext(operation);
                CatchBatch catchBatch = operationContext.getCatchBatch();
                exportContext.operationModel.prepareRows(rows, cruise, operation, catchBatch);
            }
            exportContext.operationExport.write(rows, exportContext.operationWriter);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.operations.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportParameters(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                ArrayList rows = Lists.newArrayList();
                exportContext.parameterModel.prepareRows(rows, cruise, operation);
                exportContext.parameterExport.write(rows, exportContext.parameterWriter);
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.parameters.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportMarineLitters(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                OperationContext operationContext = this.getOperationContext(operation);
                boolean withCatchBatch = operationContext.isWithCatchBatch();
                if (!withCatchBatch) continue;
                ArrayList rows = Lists.newArrayList();
                exportContext.marineLitterModel.prepareRows(this.persistenceService, rows, cruise, operation);
                exportContext.marineLitterExport.write(rows, exportContext.marineLitterWriter);
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.marineLitters.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportIndividualObservations(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                OperationContext operationContext = this.getOperationContext(operation);
                boolean withCatchBatch = operationContext.isWithCatchBatch();
                if (!withCatchBatch) continue;
                ArrayList rows = Lists.newArrayList();
                exportContext.individualObservationModel.prepareRows(this.persistenceService, rows, cruise, operation);
                exportContext.speciesModel.prepareIndividualRows(exportContext, rows);
                exportContext.individualObservationExport.write(rows, exportContext.individualObservationWriter);
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.individualObservations.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportAccidentalCatch(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                ArrayList rows = Lists.newArrayList();
                exportContext.accidentalCatchModel.prepareRows(this.persistenceService, rows, cruise, operation);
                exportContext.speciesModel.prepareAccidentalRows(exportContext, rows);
                exportContext.accidentalCatchExport.write(rows, exportContext.accidentalCatchWriter);
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.accidentalCatch.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportCatches(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                OperationContext operationContext = this.getOperationContext(operation);
                boolean withCatchBatch = operationContext.isWithCatchBatch();
                if (!withCatchBatch) continue;
                CatchBatch catchBatch = operationContext.getCatchBatch();
                BatchContainer<SpeciesBatch> rootSpeciesBatch = operationContext.getRootSpeciesBatch();
                BatchContainer<BenthosBatch> rootBenthosBatch = operationContext.getRootBenthosBatch();
                exportContext.speciesModel.prepareBatchRows(exportContext, rootSpeciesBatch, rootBenthosBatch);
                Float totalWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getCatchTotalWeight(), (Number)catchBatch.getCatchTotalComputedWeight());
                Float totalUnsortedWeight = catchBatch.getCatchTotalUnsortedComputedWeight();
                Float totalSortedSpeciesWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getSpeciesTotalSortedWeight(), (Number)catchBatch.getSpeciesTotalSortedComputedWeight());
                Float totalSampleSortedSpeciesWeight = catchBatch.getSpeciesTotalSampleSortedComputedWeight();
                Float totalSortedBenthosWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getBenthosTotalSortedWeight(), (Number)catchBatch.getBenthosTotalSortedComputedWeight());
                Float totalSampleSortedBenthosWeight = catchBatch.getBenthosTotalSampleSortedComputedWeight();
                Float totalSortedWeight = catchBatch.getCatchTotalSortedComputedWeight();
                Float catchRaisingFactor = Float.valueOf(totalWeight == null || totalUnsortedWeight == null || totalSortedWeight == null ? 1.0f : (totalWeight.floatValue() - totalUnsortedWeight.floatValue()) / totalSortedWeight.floatValue());
                Float speciesCatchRaisingFactor = Float.valueOf(totalSampleSortedSpeciesWeight == null || totalSortedSpeciesWeight == null || totalSampleSortedSpeciesWeight == null ? 1.0f : (totalSampleSortedSpeciesWeight.floatValue() == 0.0f ? 0.0f : totalSortedSpeciesWeight.floatValue() / totalSampleSortedSpeciesWeight.floatValue() * catchRaisingFactor.floatValue()));
                Float benthosCatchRaisingFactor = Float.valueOf(totalSampleSortedBenthosWeight == null || totalSortedBenthosWeight == null || totalSampleSortedBenthosWeight == null ? 1.0f : (totalSampleSortedBenthosWeight.floatValue() == 0.0f ? 0.0f : totalSortedBenthosWeight.floatValue() / totalSampleSortedBenthosWeight.floatValue() * catchRaisingFactor.floatValue()));
                if (log.isDebugEnabled()) {
                    String message = "\ncatchTotalWeight               : " + totalWeight + "\ncatchTotalUnsortedWeight       : " + totalUnsortedWeight + "\ntotalSampleSortedSpeciesWeight : " + totalSampleSortedSpeciesWeight + "\ntotalSampleSortedBenthosWeight : " + totalSampleSortedBenthosWeight + "\ntotalSortedWeight              : " + totalSortedWeight + "\ncatchRaisingFactor             : " + catchRaisingFactor + "\nspeciesCatchRaisingFactor      : " + speciesCatchRaisingFactor + "\nbenthosCatchRaisingFactor      : " + benthosCatchRaisingFactor;
                    log.debug((Object)message);
                }
                ArrayList rows = Lists.newArrayList();
                exportContext.catchModel.prepareRows(this.persistenceService, rows, cruise, operation, rootSpeciesBatch, rootBenthosBatch, speciesCatchRaisingFactor, benthosCatchRaisingFactor);
                exportContext.catchExport.write(rows, exportContext.catchWriter);
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.catches.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void exportSpecies(ExportContext exportContext, List<SpeciesExportRow> rows) {
        try {
            exportContext.speciesExport.write(rows, exportContext.speciesWriter);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.species.error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected OperationContext getOperationContext(FishingOperation operation) {
        String operationId = operation.getId();
        OperationContext result = this.operationContexts.get(operationId);
        if (result == null) {
            result = new OperationContext(operation, this.persistenceService, this.weightComputingService);
            this.operationContexts.put(operationId, result);
        }
        return result;
    }

    protected static class OperationContext {
        protected final FishingOperation operation;
        private final CatchBatch catchBatch;
        private BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
        private BatchContainer<SpeciesBatch> rootSpeciesBatch;
        private BatchContainer<BenthosBatch> rootBenthosBatch;
        protected boolean withCatchBatch;

        public OperationContext(FishingOperation operation, PersistenceService persistenceService, WeightComputingService weightComputingService) {
            this.operation = operation;
            String operationId = operation.getId();
            this.withCatchBatch = persistenceService.isFishingOperationWithCatchBatch(operationId);
            if (this.withCatchBatch) {
                this.catchBatch = persistenceService.getCatchBatchFromFishingOperation(operationId);
                boolean withError = false;
                try {
                    this.rootSpeciesBatch = weightComputingService.getComputedSpeciesBatches(operationId);
                }
                catch (Exception e) {
                    withError = true;
                    this.rootSpeciesBatch = persistenceService.getRootSpeciesBatch(operationId, false);
                }
                try {
                    this.rootBenthosBatch = weightComputingService.getComputedBenthosBatches(operationId);
                }
                catch (Exception e) {
                    withError = true;
                    this.rootBenthosBatch = persistenceService.getRootBenthosBatch(operationId, false);
                }
                try {
                    this.rootMarineLitterBatch = weightComputingService.getComputedMarineLitterBatches(operationId, this.catchBatch.getMarineLitterTotalWeight());
                }
                catch (Exception e) {
                    withError = true;
                    this.rootMarineLitterBatch = persistenceService.getRootMarineLitterBatch(operationId);
                }
                if (!withError) {
                    weightComputingService.computeCatchBatchWeights(this.catchBatch, this.rootSpeciesBatch, this.rootBenthosBatch, this.rootMarineLitterBatch);
                }
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Skip fishing operation " + operationId + " since no catchBatch associated."));
                }
                this.catchBatch = null;
                this.rootSpeciesBatch = null;
                this.rootBenthosBatch = null;
                this.rootMarineLitterBatch = null;
            }
        }

        public CatchBatch getCatchBatch() {
            return this.catchBatch;
        }

        public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch() {
            return this.rootMarineLitterBatch;
        }

        public BatchContainer<SpeciesBatch> getRootSpeciesBatch() {
            return this.rootSpeciesBatch;
        }

        public BatchContainer<BenthosBatch> getRootBenthosBatch() {
            return this.rootBenthosBatch;
        }

        public boolean isWithCatchBatch() {
            return this.withCatchBatch;
        }
    }

    protected static class ExportContext
    implements Closeable {
        File surveyFile;
        File gearCaracteristicsFile;
        File operationFile;
        File parameterFile;
        File marineLitterFile;
        File individualObservationFile;
        File catchFile;
        File accidentalCatchFile;
        File speciesFile;
        BufferedWriter surveyWriter;
        BufferedWriter gearCaracteristicsWriter;
        BufferedWriter operationWriter;
        BufferedWriter parameterWriter;
        BufferedWriter marineLitterWriter;
        BufferedWriter catchWriter;
        BufferedWriter accidentalCatchWriter;
        BufferedWriter individualObservationWriter;
        BufferedWriter speciesWriter;
        SurveyExportModel surveyModel;
        GearCaracteristicExportModel gearCaracteristicsModel;
        OperationExportModel operationModel;
        MarineLitterExportModel marineLitterModel;
        ParameterExportModel parameterModel;
        CatchExportModel catchModel;
        AccidentalCatchExportModel accidentalCatchModel;
        IndividualObservationExportModel individualObservationModel;
        SpeciesExportModel speciesModel;
        final Map<String, SpeciesExportRow> speciesToExport = Maps.newTreeMap();
        TuttiCsvUtil.TuttiRepeatableExport<SurveyExportRow> surveyExport;
        TuttiCsvUtil.TuttiRepeatableExport<GearCaracteristicExportRow> gearCaracteristicsExport;
        TuttiCsvUtil.TuttiRepeatableExport<OperationExportRow> operationExport;
        TuttiCsvUtil.TuttiRepeatableExport<MarineLitterExportRow> marineLitterExport;
        TuttiCsvUtil.TuttiRepeatableExport<ParameterExportRow> parameterExport;
        TuttiCsvUtil.TuttiRepeatableExport<CatchExportRow> catchExport;
        TuttiCsvUtil.TuttiRepeatableExport<AccidentalCatchExportRow> accidentalCatchExport;
        TuttiCsvUtil.TuttiRepeatableExport<IndividualObservationExportRow> individualObservationExport;
        TuttiCsvUtil.TuttiRepeatableExport<SpeciesExportRow> speciesExport;
        Map<String, Species> speciesById;
        String checkError;

        ExportContext(File basedir, char csvSeparator, DecoratorService decoratorService, Caracteristic weightMeasuredCaracteristic, Caracteristic deadOrAliveCaracteristic, Caracteristic genderCaracteristic, Caracteristic pmfmIdCaracteristic, SampleCategoryModel sampleCategoryModel, Map<String, Species> speciesById) {
            this.speciesById = speciesById;
            try {
                this.surveyFile = new File(basedir, "survey.csv");
                this.surveyWriter = Files.newWriter((File)this.surveyFile, (Charset)Charsets.UTF_8);
                this.gearCaracteristicsFile = new File(basedir, "gearCaracteristics.csv");
                this.gearCaracteristicsWriter = Files.newWriter((File)this.gearCaracteristicsFile, (Charset)Charsets.UTF_8);
                this.operationFile = new File(basedir, "operation.csv");
                this.operationWriter = Files.newWriter((File)this.operationFile, (Charset)Charsets.UTF_8);
                this.marineLitterFile = new File(basedir, "marineLitter.csv");
                this.marineLitterWriter = Files.newWriter((File)this.marineLitterFile, (Charset)Charsets.UTF_8);
                this.parameterFile = new File(basedir, "parameter.csv");
                this.parameterWriter = Files.newWriter((File)this.parameterFile, (Charset)Charsets.UTF_8);
                this.catchFile = new File(basedir, "catch.csv");
                this.catchWriter = Files.newWriter((File)this.catchFile, (Charset)Charsets.UTF_8);
                this.accidentalCatchFile = new File(basedir, "accidentalCatch.csv");
                this.accidentalCatchWriter = Files.newWriter((File)this.accidentalCatchFile, (Charset)Charsets.UTF_8);
                this.individualObservationFile = new File(basedir, "individualObservation.csv");
                this.individualObservationWriter = Files.newWriter((File)this.individualObservationFile, (Charset)Charsets.UTF_8);
                this.speciesFile = new File(basedir, "species.csv");
                this.speciesWriter = Files.newWriter((File)this.speciesFile, (Charset)Charsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.export.context.error", (Object[])new Object[0]), (Throwable)e);
            }
            this.surveyModel = new SurveyExportModel(csvSeparator);
            this.gearCaracteristicsModel = new GearCaracteristicExportModel(csvSeparator, decoratorService);
            this.operationModel = new OperationExportModel(csvSeparator, decoratorService.getDecoratorByType(Vessel.class));
            this.parameterModel = new ParameterExportModel(csvSeparator, decoratorService);
            this.marineLitterModel = new MarineLitterExportModel(csvSeparator);
            this.catchModel = new CatchExportModel(csvSeparator, sampleCategoryModel, decoratorService);
            this.accidentalCatchModel = new AccidentalCatchExportModel(csvSeparator, deadOrAliveCaracteristic, genderCaracteristic, weightMeasuredCaracteristic, pmfmIdCaracteristic);
            this.individualObservationModel = new IndividualObservationExportModel(csvSeparator, weightMeasuredCaracteristic, pmfmIdCaracteristic);
            this.speciesModel = new SpeciesExportModel(csvSeparator);
            this.surveyExport = TuttiCsvUtil.newRepeatableExport(this.surveyModel);
            this.gearCaracteristicsExport = TuttiCsvUtil.newRepeatableExport(this.gearCaracteristicsModel);
            this.operationExport = TuttiCsvUtil.newRepeatableExport(this.operationModel);
            this.parameterExport = TuttiCsvUtil.newRepeatableExport(this.parameterModel);
            this.marineLitterExport = TuttiCsvUtil.newRepeatableExport(this.marineLitterModel);
            this.catchExport = TuttiCsvUtil.newRepeatableExport(this.catchModel);
            this.accidentalCatchExport = TuttiCsvUtil.newRepeatableExport(this.accidentalCatchModel);
            this.individualObservationExport = TuttiCsvUtil.newRepeatableExport(this.individualObservationModel);
            this.speciesExport = TuttiCsvUtil.newRepeatableExport(this.speciesModel);
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly((Writer)this.surveyWriter);
            IOUtils.closeQuietly((Writer)this.gearCaracteristicsWriter);
            IOUtils.closeQuietly((Writer)this.operationWriter);
            IOUtils.closeQuietly((Writer)this.parameterWriter);
            IOUtils.closeQuietly((Writer)this.catchWriter);
            IOUtils.closeQuietly((Writer)this.accidentalCatchWriter);
            IOUtils.closeQuietly((Writer)this.marineLitterWriter);
            IOUtils.closeQuietly((Writer)this.individualObservationWriter);
            IOUtils.closeQuietly((Writer)this.speciesWriter);
        }

        public String getCheckError() {
            return this.checkError;
        }

        public void setCheckError(String checkError) {
            this.checkError = checkError;
        }

        public void addSpecies(Species species) {
            String speciesId = species.getId();
            if (!this.speciesToExport.containsKey(speciesId)) {
                Species fullSpecies = this.speciesById.get(speciesId);
                SpeciesExportRow row = new SpeciesExportRow();
                row.setSpecies(fullSpecies);
                this.speciesToExport.put(speciesId, row);
                species.setSurveyCode(fullSpecies.getSurveyCode());
            }
        }

        public List<SpeciesExportRow> getSpeciesToExport() {
            ArrayList result = Lists.newArrayList(this.speciesToExport.values());
            Collections.sort(result, new Comparator<SpeciesExportRow>(){

                @Override
                public int compare(SpeciesExportRow o1, SpeciesExportRow o2) {
                    return o1.getSpecies().getReferenceTaxonId().compareTo(o2.getSpecies().getReferenceTaxonId());
                }
            });
            return result;
        }
    }
}

