/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import com.ibm.icu.util.ULocale;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.BindingIOUtil;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.CubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.DimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.HierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMirroredDefinition;
import org.eclipse.birt.data.engine.olap.api.query.LevelDefiniton;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.ComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.DerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.EdgeDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.EdgeDrillingFilterDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MirroredDefinition;

public class CubeQueryDefinitionIOUtil {
    private static String STREAM_FLAG = "_CUBE_QUERY_DEFINITION";
    private static int FILTER_DEFN_FLAG_COMMON = 0;
    private static int FILTER_DEFN_FLAG_CUBE = 1;
    private static int SORT_DEFN_FLAG_COMMON = 0;
    private static int SORT_DEFN_FLAG_CUBE = 1;
    private static int CUBE_OPERATION_FLAG_ADDING_NEST_AGGRS = 0;

    private CubeQueryDefinitionIOUtil() {
    }

    public static boolean existStream(IDocArchiveReader reader, String queryResultID) {
        if (queryResultID == null) {
            return false;
        }
        return reader.exists(String.valueOf(queryResultID) + STREAM_FLAG);
    }

    public static void save(String queryResultID, DataEngineContext context, ICubeQueryDefinition qd) throws DataException, IOException {
        FilterOutputStream dos = null;
        try {
            StreamManager manager = new StreamManager(context, new QueryResultInfo(queryResultID, null, 0));
            int version = manager.getVersion();
            IDocArchiveWriter writer = context.getDocWriter();
            RAOutputStream outputStream = writer.createRandomAccessStream(String.valueOf(queryResultID) + STREAM_FLAG);
            dos = new DataOutputStream(outputStream);
            IOUtil.writeString((DataOutputStream)dos, qd.getName());
            IOUtil.writeBool(dos, qd.cacheQueryResults());
            IOUtil.writeInt(dos, qd.getFilterOption());
            CubeQueryDefinitionIOUtil.saveBindings((DataOutputStream)dos, qd.getBindings(), version);
            CubeQueryDefinitionIOUtil.saveFilters((DataOutputStream)dos, qd.getFilters(), version);
            CubeQueryDefinitionIOUtil.saveSortDefns((DataOutputStream)dos, qd.getSorts());
            CubeQueryDefinitionIOUtil.saveMeasures((DataOutputStream)dos, qd.getMeasures());
            CubeQueryDefinitionIOUtil.saveComputedMeasures((DataOutputStream)dos, qd.getComputedMeasures());
            CubeQueryDefinitionIOUtil.saveCalculatedMeasures((DataOutputStream)dos, qd.getDerivedMeasures(), version);
            CubeQueryDefinitionIOUtil.saveEdges((DataOutputStream)dos, qd, version);
            CubeQueryDefinitionIOUtil.saveCubeOperations((DataOutputStream)dos, qd.getCubeOperations(), version);
            ((DataOutputStream)dos).flush();
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }

    private static void saveCalculatedMeasures(DataOutputStream dos, List<IDerivedMeasureDefinition> derivedMeasures, int version) throws IOException, DataException {
        if (version < 180) {
            return;
        }
        if (CubeQueryDefinitionIOUtil.writeSize(dos, derivedMeasures) > 0) {
            for (IDerivedMeasureDefinition m : derivedMeasures) {
                CubeQueryDefinitionIOUtil.saveCalculatedMeasure(dos, m);
            }
        }
    }

    private static void loadCalculatedMeasures(DataInputStream dis, ICubeQueryDefinition qd, int version) throws DataException, IOException {
        if (version < 180) {
            return;
        }
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            IDerivedMeasureDefinition md = CubeQueryDefinitionIOUtil.loadCaculatedMeasure(dis);
            IDerivedMeasureDefinition md1 = qd.createDerivedMeasure(md.getName(), md.getDataType(), md.getExpression());
            md1.setAggrFunction(md.getAggrFunction());
            ++i;
        }
    }

    private static void saveCalculatedMeasure(DataOutputStream dos, IDerivedMeasureDefinition m) throws IOException, DataException {
        if (m == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        CubeQueryDefinitionIOUtil.saveMeasure(dos, m);
        IOUtil.writeInt(dos, m.getDataType());
        ExprUtil.saveBaseExpr(dos, m.getExpression());
    }

    private static IDerivedMeasureDefinition loadCaculatedMeasure(DataInputStream dis) throws DataException, IOException {
        IMeasureDefinition md = CubeQueryDefinitionIOUtil.loadMeasure(dis);
        if (md == null) {
            return null;
        }
        String name = md.getName();
        int type = IOUtil.readInt(dis);
        IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
        DerivedMeasureDefinition dmd = new DerivedMeasureDefinition(name, type, expr);
        dmd.setAggrFunction(md.getAggrFunction());
        return dmd;
    }

    public static ICubeQueryDefinition load(String queryResultID, DataEngineContext context) throws DataException, IOException {
        FilterInputStream dis = null;
        IDocArchiveReader reader = context.getDocReader();
        VersionManager vm = new VersionManager(context);
        int version = vm.getVersion(queryResultID);
        try {
            RAInputStream inputStream = reader.getStream(String.valueOf(queryResultID) + STREAM_FLAG);
            dis = new DataInputStream(inputStream);
            String name = IOUtil.readString((DataInputStream)dis);
            CubeQueryDefinition cqd = new CubeQueryDefinition(name);
            cqd.setCacheQueryResults(IOUtil.readBool(dis));
            cqd.setFilterOption(IOUtil.readInt(dis));
            CubeQueryDefinitionIOUtil.loadBindings((DataInputStream)dis, cqd, version);
            CubeQueryDefinitionIOUtil.loadFilters((DataInputStream)dis, cqd, version);
            CubeQueryDefinitionIOUtil.loadSortDefns((DataInputStream)dis, cqd);
            CubeQueryDefinitionIOUtil.loadMeasures((DataInputStream)dis, cqd);
            CubeQueryDefinitionIOUtil.loadComputedMeasures((DataInputStream)dis, cqd);
            CubeQueryDefinitionIOUtil.loadCalculatedMeasures((DataInputStream)dis, cqd, version);
            CubeQueryDefinitionIOUtil.loadEdges((DataInputStream)dis, cqd, version);
            CubeQueryDefinitionIOUtil.loadCubeOperations((DataInputStream)dis, cqd, version);
            CubeQueryDefinition cubeQueryDefinition = cqd;
            return cubeQueryDefinition;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    private static void saveFilters(DataOutputStream dos, List<IFilterDefinition> filters, int version) throws DataException, IOException {
        if (CubeQueryDefinitionIOUtil.writeSize(dos, filters) > 0) {
            for (IFilterDefinition fd : filters) {
                CubeQueryDefinitionIOUtil.saveFilterDefn(dos, fd, version);
            }
        }
    }

    private static void loadFilters(DataInputStream dis, ICubeQueryDefinition qd, int version) throws DataException, IOException {
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            IFilterDefinition fd = CubeQueryDefinitionIOUtil.loadFilterDefn(dis, version);
            qd.addFilter(fd);
            ++i;
        }
    }

    private static void loadFilters(DataInputStream dis, IEdgeDrillFilter edf, int version) throws DataException, IOException {
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            IFilterDefinition fd = CubeQueryDefinitionIOUtil.loadFilterDefn(dis, version);
            edf.addLevelFilter(fd);
            ++i;
        }
    }

    private static void saveCubeOperations(DataOutputStream dos, ICubeOperation[] cos, int version) throws DataException, IOException {
        if (CubeQueryDefinitionIOUtil.writeSize(dos, cos) > 0) {
            ICubeOperation[] iCubeOperationArray = cos;
            int n = cos.length;
            int n2 = 0;
            while (n2 < n) {
                ICubeOperation co = iCubeOperationArray[n2];
                CubeQueryDefinitionIOUtil.saveCubeOperation(dos, co, version);
                ++n2;
            }
        }
    }

    private static void loadCubeOperations(DataInputStream dis, ICubeQueryDefinition qd, int version) throws DataException, IOException {
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            ICubeOperation co = CubeQueryDefinitionIOUtil.loadCubeOperation(dis, version);
            qd.addCubeOperation(co);
            ++i;
        }
    }

    private static void saveCubeOperation(DataOutputStream dos, ICubeOperation co, int version) throws DataException, IOException {
        if (co == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        if (co instanceof AddingNestAggregations) {
            IOUtil.writeInt(dos, CUBE_OPERATION_FLAG_ADDING_NEST_AGGRS);
            CubeQueryDefinitionIOUtil.saveBindings(dos, Arrays.asList(co.getNewBindings()), version);
        }
    }

    private static ICubeOperation loadCubeOperation(DataInputStream dis, int version) throws DataException, IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        int type = IOUtil.readInt(dis);
        if (type == CUBE_OPERATION_FLAG_ADDING_NEST_AGGRS) {
            int count = IOUtil.readInt(dis);
            IBinding[] bs = new IBinding[count];
            int i = 0;
            while (i < count) {
                bs[i] = BindingIOUtil.loadBinding(dis, version);
                ++i;
            }
            return new AddingNestAggregations(bs);
        }
        assert (false);
        return null;
    }

    private static void saveEdges(DataOutputStream dos, ICubeQueryDefinition qd, int version) throws DataException, IOException {
        CubeQueryDefinitionIOUtil.saveEdge(dos, qd.getEdge(1), version);
        CubeQueryDefinitionIOUtil.saveEdge(dos, qd.getEdge(2), version);
        CubeQueryDefinitionIOUtil.saveEdge(dos, qd.getEdge(3), version);
    }

    private static void loadEdges(DataInputStream dis, ICubeQueryDefinition qd, int version) throws DataException, IOException {
        IEdgeDefinition ed1;
        IEdgeDefinition ed = CubeQueryDefinitionIOUtil.loadEdge(dis, version);
        if (ed != null) {
            ed1 = qd.createEdge(1);
            CubeQueryDefinitionIOUtil.copy(ed, ed1);
        }
        if ((ed = CubeQueryDefinitionIOUtil.loadEdge(dis, version)) != null) {
            ed1 = qd.createEdge(2);
            CubeQueryDefinitionIOUtil.copy(ed, ed1);
        }
        if ((ed = CubeQueryDefinitionIOUtil.loadEdge(dis, version)) != null) {
            ed1 = qd.createEdge(3);
            CubeQueryDefinitionIOUtil.copy(ed, ed1);
        }
    }

    private static void saveEdge(DataOutputStream dos, IEdgeDefinition ed, int version) throws DataException, IOException {
        if (ed == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, ed.getName());
        if (CubeQueryDefinitionIOUtil.writeSize(dos, ed.getDimensions()) > 0) {
            for (IDimensionDefinition dd : ed.getDimensions()) {
                CubeQueryDefinitionIOUtil.saveDimensionDefinition(dos, dd);
            }
        }
        if (CubeQueryDefinitionIOUtil.writeSize(dos, ed.getDrillFilter()) > 0) {
            for (IEdgeDrillFilter edf : ed.getDrillFilter()) {
                CubeQueryDefinitionIOUtil.saveEdgeDrillFilter(dos, edf, version);
            }
        }
        CubeQueryDefinitionIOUtil.saveMirroredDefn(dos, ed.getMirroredDefinition());
    }

    private static IEdgeDefinition loadEdge(DataInputStream dis, int version) throws DataException, IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        String name = IOUtil.readString(dis);
        EdgeDefinition ed = new EdgeDefinition(name);
        int count = IOUtil.readInt(dis);
        int i = 0;
        while (i < count) {
            IDimensionDefinition dd = CubeQueryDefinitionIOUtil.loadDimensionDefinition(dis);
            IDimensionDefinition dd1 = ed.createDimension(dd.getName());
            CubeQueryDefinitionIOUtil.copy(dd, dd1);
            ++i;
        }
        count = IOUtil.readInt(dis);
        i = 0;
        while (i < count) {
            IEdgeDrillFilter edf = CubeQueryDefinitionIOUtil.loadEdgeDrillFilter(dis, version);
            IEdgeDrillFilter edf1 = ed.createDrillFilter(edf.getName());
            CubeQueryDefinitionIOUtil.copy(edf, edf1);
            ++i;
        }
        IMirroredDefinition md = CubeQueryDefinitionIOUtil.loadMirroredDefn(dis);
        if (md != null) {
            ed.creatMirrorDefinition(md.getMirrorStartingLevel(), md.isBreakHierarchy());
        }
        return ed;
    }

    private static void saveMirroredDefn(DataOutputStream dos, IMirroredDefinition md) throws DataException, IOException {
        if (md == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        CubeQueryDefinitionIOUtil.saveLevelDefinition(dos, md.getMirrorStartingLevel());
        IOUtil.writeBool(dos, md.isBreakHierarchy());
    }

    private static IMirroredDefinition loadMirroredDefn(DataInputStream dis) throws DataException, IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        ILevelDefinition ld = CubeQueryDefinitionIOUtil.loadLevelDefinition(dis);
        boolean b = IOUtil.readBool(dis);
        MirroredDefinition md = new MirroredDefinition(ld, b);
        return md;
    }

    private static void saveEdgeDrillFilter(DataOutputStream dos, IEdgeDrillFilter edf, int version) throws DataException, IOException {
        if (edf == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, edf.getName());
        CubeQueryDefinitionIOUtil.saveHierarchyDefinition(dos, edf.getTargetHierarchy());
        IOUtil.writeString(dos, edf.getTargetLevelName());
        CubeQueryDefinitionIOUtil.saveFilters(dos, edf.getLevelFilter(), version);
        CubeQueryDefinitionIOUtil.saveSortDefns(dos, edf.getLevelSort());
        if (CubeQueryDefinitionIOUtil.writeSize(dos, edf.getTuple()) > 0) {
            for (Object[] tuple : edf.getTuple()) {
                if (CubeQueryDefinitionIOUtil.writeSize(dos, tuple) <= 0) continue;
                Object[] objectArray = tuple;
                int n = tuple.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    IOUtil.writeObject(dos, o);
                    ++n2;
                }
            }
        }
    }

    private static IEdgeDrillFilter loadEdgeDrillFilter(DataInputStream dis, int version) throws DataException, IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        String name = IOUtil.readString(dis);
        EdgeDrillingFilterDefinition edf = new EdgeDrillingFilterDefinition(name);
        edf.setTargetHierarchy(CubeQueryDefinitionIOUtil.loadHierarchyDefinition(dis));
        edf.setTargetLevelName(IOUtil.readString(dis));
        CubeQueryDefinitionIOUtil.loadFilters(dis, edf, version);
        CubeQueryDefinitionIOUtil.loadSortDefns(dis, edf);
        int count = IOUtil.readInt(dis);
        ArrayList<Object[]> tuples = new ArrayList<Object[]>();
        int i = 0;
        while (i < count) {
            int size = IOUtil.readInt(dis);
            Object[] tuple = new Object[size];
            int j = 0;
            while (j < size) {
                tuple[j] = IOUtil.readObject(dis, DataEngineSession.getCurrentClassLoader());
                ++j;
            }
            tuples.add(tuple);
            ++i;
        }
        edf.setTuple(tuples);
        return edf;
    }

    private static void saveBindings(DataOutputStream dos, List<IBinding> bindings, int version) throws DataException, IOException {
        if (CubeQueryDefinitionIOUtil.writeSize(dos, bindings) > 0) {
            for (IBinding b : bindings) {
                BindingIOUtil.saveBinding(dos, b, version);
            }
        }
    }

    private static void loadBindings(DataInputStream dis, ICubeQueryDefinition qd, int version) throws DataException, IOException {
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            IBinding b = BindingIOUtil.loadBinding(dis, version);
            qd.addBinding(b);
            ++i;
        }
    }

    private static void saveMeasures(DataOutputStream dos, List<IMeasureDefinition> measures) throws DataException, IOException {
        if (CubeQueryDefinitionIOUtil.writeSize(dos, measures) > 0) {
            for (IMeasureDefinition m : measures) {
                CubeQueryDefinitionIOUtil.saveMeasure(dos, m);
            }
        }
    }

    private static void loadMeasures(DataInputStream dis, ICubeQueryDefinition qd) throws DataException, IOException {
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            IMeasureDefinition md = CubeQueryDefinitionIOUtil.loadMeasure(dis);
            IMeasureDefinition md1 = qd.createMeasure(md.getName());
            md1.setAggrFunction(md.getAggrFunction());
            ++i;
        }
    }

    private static void saveMeasure(DataOutputStream dos, IMeasureDefinition m) throws DataException, IOException {
        if (m == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, m.getName());
        IOUtil.writeString(dos, m.getAggrFunction());
    }

    private static IMeasureDefinition loadMeasure(DataInputStream dis) throws DataException, IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        String name = IOUtil.readString(dis);
        MeasureDefinition md = new MeasureDefinition(name);
        String aggrFunc = IOUtil.readString(dis);
        md.setAggrFunction(aggrFunc);
        return md;
    }

    private static void saveComputedMeasures(DataOutputStream dos, List<IComputedMeasureDefinition> measures) throws DataException, IOException {
        if (CubeQueryDefinitionIOUtil.writeSize(dos, measures) > 0) {
            for (IComputedMeasureDefinition m : measures) {
                CubeQueryDefinitionIOUtil.saveComputedMeasure(dos, m);
            }
        }
    }

    private static void loadComputedMeasures(DataInputStream dis, ICubeQueryDefinition qd) throws DataException, IOException {
        int size = IOUtil.readInt(dis);
        int i = 0;
        while (i < size) {
            IComputedMeasureDefinition md = CubeQueryDefinitionIOUtil.loadComputedMeasure(dis);
            IComputedMeasureDefinition md1 = qd.createComputedMeasure(md.getName(), md.getDataType(), md.getExpression());
            md1.setAggrFunction(md.getAggrFunction());
            ++i;
        }
    }

    private static void saveComputedMeasure(DataOutputStream dos, IComputedMeasureDefinition m) throws DataException, IOException {
        if (m == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        CubeQueryDefinitionIOUtil.saveMeasure(dos, m);
        IOUtil.writeInt(dos, m.getDataType());
        ExprUtil.saveBaseExpr(dos, m.getExpression());
    }

    private static IComputedMeasureDefinition loadComputedMeasure(DataInputStream dis) throws DataException, IOException {
        IMeasureDefinition md = CubeQueryDefinitionIOUtil.loadMeasure(dis);
        if (md == null) {
            return null;
        }
        String name = md.getName();
        int type = IOUtil.readInt(dis);
        IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
        ComputedMeasureDefinition cmd = new ComputedMeasureDefinition(name, type, expr);
        cmd.setAggrFunction(md.getAggrFunction());
        return cmd;
    }

    private static void saveSortDefns(DataOutputStream dos, List<ISortDefinition> sorts) throws DataException, IOException {
        if (CubeQueryDefinitionIOUtil.writeSize(dos, sorts) > 0) {
            for (ISortDefinition sort : sorts) {
                CubeQueryDefinitionIOUtil.saveSortDefn(dos, sort);
            }
        }
    }

    private static void loadSortDefns(DataInputStream dis, ICubeQueryDefinition cqd) throws DataException, IOException {
        int count = IOUtil.readInt(dis);
        int i = 0;
        while (i < count) {
            ISortDefinition csd = CubeQueryDefinitionIOUtil.loadSortDefn(dis);
            cqd.addSort(csd);
            ++i;
        }
    }

    private static void loadSortDefns(DataInputStream dis, IEdgeDrillFilter edf) throws DataException, IOException {
        int count = IOUtil.readInt(dis);
        int i = 0;
        while (i < count) {
            ISortDefinition sd = CubeQueryDefinitionIOUtil.loadSortDefn(dis);
            edf.addLevelSort(sd);
            ++i;
        }
    }

    private static void saveHierarchyDefinition(DataOutputStream dos, IHierarchyDefinition hd) throws IOException {
        if (hd == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, hd.getName());
        CubeQueryDefinitionIOUtil.saveDimensionDefinition(dos, hd.getDimension());
        if (CubeQueryDefinitionIOUtil.writeSize(dos, hd.getLevels()) > 0) {
            for (ILevelDefinition ld : hd.getLevels()) {
                IOUtil.writeString(dos, ld.getName());
            }
        }
    }

    private static IHierarchyDefinition loadHierarchyDefinition(DataInputStream dis) throws IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        String name = IOUtil.readString(dis);
        IDimensionDefinition dd = CubeQueryDefinitionIOUtil.loadDimensionDefinition(dis);
        HierarchyDefinition hd = new HierarchyDefinition(dd, name);
        int levelCount = IOUtil.readInt(dis);
        int i = 0;
        while (i < levelCount) {
            hd.createLevel(IOUtil.readString(dis));
            ++i;
        }
        return hd;
    }

    private static void saveLevelDefinition(DataOutputStream dos, ILevelDefinition ld) throws IOException {
        if (ld == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, ld.getName());
        CubeQueryDefinitionIOUtil.saveHierarchyDefinition(dos, ld.getHierarchy());
    }

    private static ILevelDefinition loadLevelDefinition(DataInputStream dis) throws IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        String name = IOUtil.readString(dis);
        IHierarchyDefinition hd = CubeQueryDefinitionIOUtil.loadHierarchyDefinition(dis);
        return new LevelDefiniton(hd, name);
    }

    private static void saveDimensionDefinition(DataOutputStream dos, IDimensionDefinition dd) throws IOException {
        if (dd == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, dd.getName());
        if (CubeQueryDefinitionIOUtil.writeSize(dos, dd.getHierarchy()) > 0) {
            for (IHierarchyDefinition hd : dd.getHierarchy()) {
                IOUtil.writeString(dos, hd.getName());
                if (CubeQueryDefinitionIOUtil.writeSize(dos, hd.getLevels()) <= 0) continue;
                for (ILevelDefinition ld : hd.getLevels()) {
                    IOUtil.writeString(dos, ld.getName());
                }
            }
        }
    }

    private static IDimensionDefinition loadDimensionDefinition(DataInputStream dis) throws IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        String name = IOUtil.readString(dis);
        DimensionDefinition dd = new DimensionDefinition(name);
        int hierarchyCount = IOUtil.readInt(dis);
        int i = 0;
        while (i < hierarchyCount) {
            String hierarchyName = IOUtil.readString(dis);
            IHierarchyDefinition hd = dd.createHierarchy(hierarchyName);
            int levelCount = IOUtil.readInt(dis);
            int j = 0;
            while (j < levelCount) {
                String levelName = IOUtil.readString(dis);
                hd.createLevel(levelName);
                ++j;
            }
            ++i;
        }
        return dd;
    }

    private static <T> int writeSize(DataOutputStream dos, Collection<T> c) throws IOException {
        int size = 0;
        if (c != null) {
            size = c.size();
        }
        IOUtil.writeInt(dos, size);
        return size;
    }

    private static <T> int writeSize(DataOutputStream dos, Object[] os) throws IOException {
        int size = 0;
        if (os != null) {
            size = os.length;
        }
        IOUtil.writeInt(dos, size);
        return size;
    }

    private static void copy(IDimensionDefinition from, IDimensionDefinition to) {
        if (from.getHierarchy() != null) {
            for (IHierarchyDefinition hd : from.getHierarchy()) {
                IHierarchyDefinition hd1 = to.createHierarchy(hd.getName());
                if (hd.getLevels() == null) continue;
                for (ILevelDefinition ld : hd.getLevels()) {
                    hd1.createLevel(ld.getName());
                }
            }
        }
    }

    private static void copy(IEdgeDefinition from, IEdgeDefinition to) {
        if (from.getDimensions() != null) {
            for (IDimensionDefinition dd : from.getDimensions()) {
                IDimensionDefinition dd1 = to.createDimension(dd.getName());
                CubeQueryDefinitionIOUtil.copy(dd, dd1);
            }
        }
        if (from.getMirroredDefinition() != null) {
            to.creatMirrorDefinition(from.getMirroredDefinition().getMirrorStartingLevel(), from.getMirroredDefinition().isBreakHierarchy());
        }
        if (from.getDrillFilter() != null) {
            for (IEdgeDrillFilter edf : from.getDrillFilter()) {
                IEdgeDrillFilter edf1 = to.createDrillFilter(edf.getName());
                CubeQueryDefinitionIOUtil.copy(edf, edf1);
            }
        }
    }

    private static void copy(IEdgeDrillFilter from, IEdgeDrillFilter to) {
        if (from.getLevelSort() != null) {
            for (ISortDefinition sd : from.getLevelSort()) {
                to.addLevelSort(sd);
            }
        }
        if (from.getLevelFilter() != null) {
            for (IFilterDefinition fd : from.getLevelFilter()) {
                to.addLevelFilter(fd);
            }
        }
        to.setTargetHierarchy(from.getTargetHierarchy());
        to.setTargetLevelName(from.getTargetLevelName());
        to.setTuple(from.getTuple());
    }

    private static void saveFilterDefn(DataOutputStream dos, IFilterDefinition fd, int version) throws IOException {
        if (fd == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        ExprUtil.saveBaseExpr(dos, fd.getExpression());
        if (!(fd instanceof ICubeFilterDefinition)) {
            IOUtil.writeInt(dos, FILTER_DEFN_FLAG_COMMON);
        } else {
            int n;
            int n2;
            Object[] objectArray;
            IOUtil.writeInt(dos, FILTER_DEFN_FLAG_CUBE);
            ICubeFilterDefinition cfd = (ICubeFilterDefinition)fd;
            CubeQueryDefinitionIOUtil.saveLevelDefinition(dos, cfd.getTargetLevel());
            if (CubeQueryDefinitionIOUtil.writeSize(dos, cfd.getAxisQualifierLevels()) > 0) {
                objectArray = cfd.getAxisQualifierLevels();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object ld = objectArray[n];
                    CubeQueryDefinitionIOUtil.saveLevelDefinition(dos, (ILevelDefinition)ld);
                    ++n;
                }
            }
            if (CubeQueryDefinitionIOUtil.writeSize(dos, cfd.getAxisQualifierValues()) > 0) {
                objectArray = cfd.getAxisQualifierValues();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object o = objectArray[n];
                    IOUtil.writeObject(dos, o);
                    ++n;
                }
            }
        }
        if (version >= 190) {
            IOUtil.writeBool(dos, fd.updateAggregation());
        }
        if (version >= 220) {
            IOUtil.writeString(dos, fd.getFilterTarget() == null ? null : fd.getFilterTarget().toString());
        }
    }

    private static IFilterDefinition loadFilterDefn(DataInputStream dis, int version) throws IOException {
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
        int type = IOUtil.readInt(dis);
        if (type != FILTER_DEFN_FLAG_CUBE) {
            FilterDefinition fd = new FilterDefinition(expr);
            if (version >= 190) {
                fd.setUpdateAggregation(IOUtil.readBool(dis));
            }
            if (version >= 220) {
                String filterTarget = IOUtil.readString(dis);
                if (IFilterDefinition.FilterTarget.DATASET.equals(filterTarget)) {
                    fd.setFilterTarget(IFilterDefinition.FilterTarget.DATASET);
                } else if (IFilterDefinition.FilterTarget.RESULTSET.equals(filterTarget)) {
                    fd.setFilterTarget(IFilterDefinition.FilterTarget.RESULTSET);
                }
            }
            return fd;
        }
        assert (type == FILTER_DEFN_FLAG_CUBE);
        CubeFilterDefinition cfd = new CubeFilterDefinition(expr);
        ILevelDefinition targetLevel = CubeQueryDefinitionIOUtil.loadLevelDefinition(dis);
        cfd.setTargetLevel(targetLevel);
        int count = IOUtil.readInt(dis);
        ILevelDefinition[] lds = new ILevelDefinition[count];
        int i = 0;
        while (i < count) {
            lds[i] = CubeQueryDefinitionIOUtil.loadLevelDefinition(dis);
            ++i;
        }
        cfd.setAxisQualifierLevels(lds);
        count = IOUtil.readInt(dis);
        Object[] os = new Object[count];
        int i2 = 0;
        while (i2 < count) {
            os[i2] = IOUtil.readObject(dis, DataEngineSession.getCurrentClassLoader());
            ++i2;
        }
        cfd.setAxisQualifierValues(os);
        if (version >= 190) {
            cfd.setUpdateAggregation(IOUtil.readBool(dis));
        }
        if (version >= 220) {
            String filterTarget = IOUtil.readString(dis);
            if (IFilterDefinition.FilterTarget.DATASET.equals(filterTarget)) {
                cfd.setFilterTarget(IFilterDefinition.FilterTarget.DATASET);
            } else if (IFilterDefinition.FilterTarget.RESULTSET.equals(filterTarget)) {
                cfd.setFilterTarget(IFilterDefinition.FilterTarget.RESULTSET);
            }
        }
        return cfd;
    }

    private static void saveSortDefn(DataOutputStream dos, ISortDefinition sort) throws IOException {
        if (sort == null) {
            IOUtil.writeBool(dos, false);
            return;
        }
        IOUtil.writeBool(dos, true);
        IOUtil.writeString(dos, sort.getColumn());
        ExprUtil.saveBaseExpr(dos, sort.getExpression());
        IOUtil.writeInt(dos, sort.getSortDirection());
        IOUtil.writeInt(dos, sort.getSortStrength());
        IOUtil.writeString(dos, sort.getSortLocale() == null ? null : sort.getSortLocale().getBaseName());
        if (!(sort instanceof ICubeSortDefinition)) {
            IOUtil.writeInt(dos, SORT_DEFN_FLAG_COMMON);
        } else {
            int n;
            int n2;
            Object[] objectArray;
            IOUtil.writeInt(dos, SORT_DEFN_FLAG_CUBE);
            ICubeSortDefinition sort1 = (ICubeSortDefinition)sort;
            CubeQueryDefinitionIOUtil.saveLevelDefinition(dos, sort1.getTargetLevel());
            if (CubeQueryDefinitionIOUtil.writeSize(dos, sort1.getAxisQualifierLevels()) > 0) {
                objectArray = sort1.getAxisQualifierLevels();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object ld = objectArray[n];
                    CubeQueryDefinitionIOUtil.saveLevelDefinition(dos, (ILevelDefinition)ld);
                    ++n;
                }
            }
            if (CubeQueryDefinitionIOUtil.writeSize(dos, sort1.getAxisQualifierValues()) > 0) {
                objectArray = sort1.getAxisQualifierValues();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object o = objectArray[n];
                    IOUtil.writeObject(dos, o);
                    ++n;
                }
            }
        }
    }

    private static ISortDefinition loadSortDefn(DataInputStream dis) throws IOException {
        int type;
        if (!IOUtil.readBool(dis)) {
            return null;
        }
        SortDefinition sd = new SortDefinition();
        sd.setColumn(IOUtil.readString(dis));
        sd.setExpression((IScriptExpression)ExprUtil.loadBaseExpr(dis));
        sd.setSortDirection(IOUtil.readInt(dis));
        sd.setSortStrength(IOUtil.readInt(dis));
        String localeName = IOUtil.readString(dis);
        if (localeName != null) {
            sd.setSortLocale(new ULocale(localeName));
        }
        if ((type = IOUtil.readInt(dis)) != SORT_DEFN_FLAG_CUBE) {
            return sd;
        }
        assert (type == FILTER_DEFN_FLAG_CUBE);
        CubeSortDefinition csd = new CubeSortDefinition();
        csd.setColumn(sd.getColumn());
        csd.setExpression(sd.getExpression());
        csd.setSortDirection(sd.getSortDirection());
        csd.setSortLocale(sd.getSortLocale());
        csd.setTargetLevel(CubeQueryDefinitionIOUtil.loadLevelDefinition(dis));
        int count = IOUtil.readInt(dis);
        ILevelDefinition[] levels = new ILevelDefinition[count];
        int i = 0;
        while (i < count) {
            levels[i] = CubeQueryDefinitionIOUtil.loadLevelDefinition(dis);
            ++i;
        }
        csd.setAxisQualifierLevels(levels);
        count = IOUtil.readInt(dis);
        Object[] values = new Object[count];
        int i2 = 0;
        while (i2 < count) {
            values[i2] = IOUtil.readObject(dis, DataEngineSession.getCurrentClassLoader());
            ++i2;
        }
        csd.setAxisQualifierValues(values);
        return csd;
    }
}

