/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;
import org.nuiton.util.version.Version;

public class DbManagerUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, DbManagerUI> {
    private static final Log log = LogFactory.getLog(DbManagerUIHandler.class);

    public void updateMessage() {
        String message;
        boolean dbExist = this.getContext().isDbExist();
        boolean dbLoaded = this.getContext().isDbLoaded();
        if (log.isInfoEnabled()) {
            log.info((Object)("Rebuild information text... (dbExist?" + dbExist + "/ dbLoaded?" + dbLoaded + ")"));
        }
        if (dbExist) {
            String title;
            TuttiConfiguration config = this.getConfig();
            String jdbcUrl = config.getJdbcUrl();
            LinkedHashMap caracteristics = Maps.newLinkedHashMap();
            caracteristics.put(I18n.t((String)"tutti.dbManager.caracteristic.url", (Object[])new Object[0]), jdbcUrl);
            if (dbLoaded) {
                Version dbVersion = this.getContext().getPersistenceService().getSchemaVersion();
                title = I18n.n((String)"tutti.dbManager.info.db.loaded", (Object[])new Object[0]);
                caracteristics.put(I18n.t((String)"tutti.dbManager.caracteristic.schemaVersion", (Object[])new Object[0]), dbVersion.toString());
            } else {
                title = I18n.n((String)"tutti.dbManager.info.no.db.loaded", (Object[])new Object[0]);
            }
            if (this.getContext().checkUpdateDataReachable(false)) {
                String urlDb = config.getUpdateDataUrl();
                ApplicationUpdater up = new ApplicationUpdater();
                Map dbVersions = up.getVersions(urlDb, config.getDataDirectory());
                ApplicationInfo updateDbVersion = (ApplicationInfo)dbVersions.get("db");
                String currentReferentialVersion = updateDbVersion.oldVersion;
                String newReferentialVersion = updateDbVersion.newVersion;
                caracteristics.put(I18n.t((String)"tutti.dbManager.caracteristic.referentialVersion", (Object[])new Object[0]), currentReferentialVersion);
                if (newReferentialVersion != null) {
                    caracteristics.put(I18n.t((String)"tutti.dbManager.caracteristic.lastReferentialVersion", (Object[])new Object[0]), newReferentialVersion);
                }
            }
            StringBuilder caracteristicsToString = new StringBuilder("<ul>");
            for (Map.Entry entry : caracteristics.entrySet()) {
                caracteristicsToString.append("<li>");
                caracteristicsToString.append((String)entry.getKey());
                caracteristicsToString.append(" : <strong>");
                caracteristicsToString.append((String)entry.getValue());
                caracteristicsToString.append("</strong></li>");
            }
            caracteristicsToString.append("</ul>");
            message = I18n.t((String)title, (Object[])new Object[]{caracteristicsToString});
        } else {
            message = I18n.t((String)"tutti.dbManager.info.no.db.exist", (Object[])new Object[0]);
        }
        String result = "<html><body>" + message + "</body></html>";
        ((DbManagerUI)this.getUI()).getInformationArea().setText(result);
    }

    public void beforeInit(DbManagerUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ui.setContextValue(this.getContext());
    }

    public void afterInit(DbManagerUI ui) {
        this.initUI(ui);
        ((TuttiUIContext)this.getModel()).addPropertyChangeListener("dbExist", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean dbExist = (Boolean)evt.getNewValue();
                String mnemonic = dbExist != false ? I18n.t((String)"tutti.dbManager.action.reinstallDb.mnemonic", (Object[])new Object[0]) : I18n.t((String)"tutti.dbManager.action.installDb.mnemonic", (Object[])new Object[0]);
                if (StringUtils.isNotBlank((CharSequence)mnemonic)) {
                    ((DbManagerUI)DbManagerUIHandler.this.ui).getInstallOrReinstallDbButton().setMnemonic(mnemonic.charAt(0));
                }
            }
        });
        this.updateMessage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbManagerUIHandler.this.getContext().getMainUI().getBody().repaint();
            }
        });
    }

    protected JComponent getComponentToFocus() {
        return ((DbManagerUI)this.getUI()).getUpgradeDbButton();
    }

    public void onCloseUI() {
    }

    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public String getInstallButtonText(boolean dbExist) {
        String result = dbExist ? I18n.t((String)"tutti.dbManager.action.reinstallDb", (Object[])new Object[0]) : I18n.t((String)"tutti.dbManager.action.installDb", (Object[])new Object[0]);
        return result;
    }

    public String getInstallButtonTip(boolean dbExist) {
        String result = dbExist ? I18n.t((String)"tutti.dbManager.action.reinstallDb.tip", (Object[])new Object[0]) : I18n.t((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]);
        return result;
    }
}

