/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.query.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryName;
import fr.ifremer.adagio.synchro.query.SynchroQueryOperator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class SynchroAbstractQuery
extends SynchroQueryBuilder {
    protected final SynchroQueryName queryName;
    protected String tableName;
    protected String tableAlias;
    protected List<String> columnNames;
    protected LinkedHashMap<String, SynchroQueryOperator> whereClauses = null;
    protected boolean allowWhereClause;

    protected SynchroAbstractQuery(SynchroQueryName queryName, String tableName, List<String> columnNames, boolean allowWhereClause) {
        this.queryName = queryName;
        this.tableName = tableName;
        this.whereClauses = null;
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames));
        this.columnNames = Lists.newArrayListWithExpectedSize((int)columnNames.size());
        for (String columnName : columnNames) {
            this.columnNames.add(columnName.toLowerCase());
        }
        this.allowWhereClause = allowWhereClause;
    }

    protected SynchroAbstractQuery(SynchroQueryName queryName, String tableName, boolean allowWhereClause) {
        this.queryName = queryName;
        this.tableName = tableName;
        this.columnNames = Lists.newArrayList();
        this.whereClauses = null;
        this.allowWhereClause = allowWhereClause;
    }

    protected SynchroAbstractQuery(boolean allowWhereClause) {
        this.queryName = null;
        this.tableName = null;
        this.columnNames = null;
        this.whereClauses = null;
        this.allowWhereClause = allowWhereClause;
    }

    public SynchroQueryBuilder setAllowWhereClause(boolean allowWhereClause) {
        this.allowWhereClause = allowWhereClause;
        return this;
    }

    public SynchroQueryBuilder setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
        return this;
    }

    protected String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return String.format("%s(%s)", this.queryName == null ? "" : this.queryName.name(), this.toSql());
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }

    @Override
    public SynchroQueryBuilder replaceColumn(String oldColumn, String newColumn) {
        Preconditions.checkArgument((this.columnNames.contains(oldColumn = oldColumn.toLowerCase()) || StringUtils.isNotBlank((CharSequence)this.tableAlias) && this.columnNames.contains("~~alias~~" + oldColumn) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.columnNames.contains(newColumn) ? 1 : 0) != 0);
        int index = this.columnNames.indexOf(oldColumn);
        if (index == -1) {
            index = this.columnNames.indexOf("~~alias~~" + oldColumn);
        }
        this.columnNames.set(index, newColumn);
        return this;
    }

    @Override
    public SynchroQueryBuilder addColumn(String columnName, String value) {
        Preconditions.checkArgument((!this.columnNames.contains(columnName = columnName.toLowerCase()) ? 1 : 0) != 0);
        this.columnNames.add(columnName);
        return this;
    }

    @Override
    public List<String> getColumnNames() {
        if (StringUtils.isBlank((CharSequence)this.tableAlias)) {
            return this.columnNames != null ? ImmutableList.copyOf(this.columnNames) : null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)this.columnNames.size());
        for (String columnName : this.columnNames) {
            result.add(columnName.replace("~~alias~~", ""));
        }
        return result;
    }

    @Override
    public List<String> getColumnNamesWithAlias() {
        return this.columnNames != null ? ImmutableList.copyOf(this.columnNames) : null;
    }

    @Override
    public SynchroQueryBuilder deleteColumn(String columnName) {
        boolean isRemoved = this.columnNames.remove(columnName = columnName.toLowerCase()) || StringUtils.isNotBlank((CharSequence)this.tableAlias) && this.columnNames.remove("~~alias~~" + columnName);
        Preconditions.checkArgument((boolean)isRemoved, (Object)(isRemoved ? "" : String.format("Could not remove column [%s] from query on table [%s]: column not found", columnName, this.tableName)));
        return this;
    }

    @Override
    public SynchroQueryBuilder deleteColumnIfExists(String columnName) {
        boolean isRemoved = this.columnNames.remove(columnName = columnName.toLowerCase()) || StringUtils.isNotBlank((CharSequence)this.tableAlias) && this.columnNames.remove("~~alias~~" + columnName);
        return this;
    }

    @Override
    public SynchroQueryBuilder setColumnValue(String columnName, String value) {
        throw new UnsupportedOperationException("not implement for query " + this.getClass().getSimpleName());
    }

    @Override
    public boolean constainsColumn(String columnName) {
        return this.columnNames.contains(columnName);
    }

    @Override
    public SynchroQueryBuilder setWhereClause(String whereClause) {
        if (!this.allowWhereClause) {
            throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
        }
        if (StringUtils.isBlank((CharSequence)whereClause)) {
            this.whereClauses = null;
        } else {
            this.whereClauses = Maps.newLinkedHashMap();
            this.whereClauses.put(whereClause, SynchroQueryOperator.AND);
        }
        return this;
    }

    @Override
    public SynchroQueryBuilder addWhere(SynchroQueryOperator operator, String whereClause) {
        if (!this.allowWhereClause) {
            throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)whereClause));
        whereClause = whereClause.trim();
        String[] parts = whereClause.split("[ \t=><]+");
        if (parts.length == 2) {
            String columnName = parts[0];
            String columnValue = parts[1];
            String columnOperator = whereClause.substring(columnName.length());
            columnOperator = columnOperator.substring(0, columnOperator.length() - columnValue.length()).trim();
            return this.addWhere(operator, columnName, columnOperator, columnValue);
        }
        if (this.whereClauses == null) {
            this.whereClauses = Maps.newLinkedHashMap();
        }
        this.whereClauses.put(whereClause, operator);
        return this;
    }

    @Override
    public SynchroQueryBuilder addWhere(SynchroQueryOperator operator, String columnName, String columnValue) {
        this.addWhere(operator, columnName, "=", columnValue);
        return this;
    }

    @Override
    public SynchroQueryBuilder addWhere(SynchroQueryOperator operator, String columnName, String columnOperator, String columnValue) {
        if (!this.allowWhereClause) {
            throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
        }
        if (this.whereClauses == null) {
            this.whereClauses = Maps.newLinkedHashMap();
        }
        StringBuilder whereParams = new StringBuilder();
        if ((columnName = columnName.toLowerCase()).split("[.]").length == 0) {
            whereParams.append("~~alias~~").append(columnName);
        } else {
            whereParams.append(columnName);
        }
        whereParams.append(' ').append(columnOperator).append(' ').append(columnValue);
        this.whereClauses.put(whereParams.toString(), operator);
        return this;
    }

    @Override
    public String getColumnValue(String columnName) {
        throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
    }

    @Override
    public SynchroQueryBuilder setColumnDistinct(boolean columnDistinct) {
        throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
    }

    @Override
    public SynchroQueryBuilder addJoin(String joinClause) {
        throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
    }

    protected String getSqlWhereClause() {
        if (!this.allowWhereClause) {
            throw new UnsupportedOperationException("not allowed for query " + this.getClass().getSimpleName());
        }
        if (MapUtils.isEmpty(this.whereClauses)) {
            return "";
        }
        StringBuilder whereParams = new StringBuilder();
        for (Map.Entry<String, SynchroQueryOperator> entry : this.whereClauses.entrySet()) {
            if (whereParams.length() == 0) {
                whereParams.append(entry.getKey());
                continue;
            }
            SynchroQueryOperator operator = entry.getValue();
            whereParams.append(" ").append(operator.name()).append(" ").append(entry.getKey());
            if (operator != SynchroQueryOperator.OR) continue;
            whereParams.insert(0, "(").append(")");
        }
        whereParams.insert(0, " WHERE ");
        String tableAliasSubstitute = "";
        if (StringUtils.isNotBlank((CharSequence)this.tableAlias)) {
            tableAliasSubstitute = this.tableAlias + ".";
        }
        String sql = whereParams.toString().replaceAll("~~alias~~", tableAliasSubstitute);
        return sql;
    }
}

