package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class CreateBenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateBenthosBatchUIModel, CreateBenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE = "batchCountField.numberValue";
    public static final String BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE = "batchWeightField.numberValue";
    public static final String BINDING_CATEGORY_COMBO_BOX_DATA = "categoryComboBox.data";
    public static final String BINDING_CATEGORY_COMBO_BOX_ENABLED = "categoryComboBox.enabled";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_CATEGORY_PANEL_VISIBLE = "categoryPanel.visible";
    public static final String BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sampleCategoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateBenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchCount",  editorName = "batchCountField")
    protected NumberEditor batchCountField;
    protected JLabel batchCountLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected BeanFilterableComboBox<SampleCategoryModelEntry> categoryComboBox;
    protected Table categoryConfigurationPanel;
    protected JLabel categoryLabel;
    protected JPanel categoryPanel;
    protected Table configurationPanel;
    protected CreateBenthosBatchUI createBenthosBatchTopPanel = this;
    protected final CreateBenthosBatchUIHandler handler = createHandler();
    protected CreateBenthosBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleCategory",  editorName = "sampleCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sampleCategoryComboBox;
    protected JLabel sampleCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateBenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateBenthosBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateBenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI() {
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchCountField() {
        return batchCountField;
    }

    public JLabel getBatchCountLabel() {
        return batchCountLabel;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public BeanFilterableComboBox<SampleCategoryModelEntry> getCategoryComboBox() {
        return categoryComboBox;
    }

    public Table getCategoryConfigurationPanel() {
        return categoryConfigurationPanel;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryPanel() {
        return categoryPanel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateBenthosBatchUIHandler getHandler() {
        return handler;
    }

    public CreateBenthosBatchUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSampleCategoryComboBox() {
        return sampleCategoryComboBox;
    }

    public JLabel getSampleCategoryLabel() {
        return sampleCategoryLabel;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<CreateBenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryConfigurationPanel.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(categoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCategoryPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryPanel.add(categoryConfigurationPanel, BorderLayout.NORTH);
        categoryPanel.add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchCountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchCountField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleCategoryLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleCategoryComboBox), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(categoryPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(t("tutti.createBenthosBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(t("tutti.createBenthosBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SelectSpeciesForBenthosBatchAction.class);
        addSpeciesButton.putClientProperty("help", "tutti.createBenthosBatch.action.addSpecies.help");
    }

    protected void createBatchCountField() {
        $objectMap.put("batchCountField", batchCountField = new NumberEditor(this));
        
        batchCountField.setName("batchCountField");
        batchCountField.setProperty("batchCount");
        batchCountField.setShowReset(true);
        batchCountField.putClientProperty("help", "tutti.createBenthosBatch.field.batchCount.help");
    }

    protected void createBatchCountLabel() {
        $objectMap.put("batchCountLabel", batchCountLabel = new JLabel());
        
        batchCountLabel.setName("batchCountLabel");
        batchCountLabel.setText(t("tutti.createBenthosBatch.field.batchCount"));
        batchCountLabel.setToolTipText(t("tutti.createBenthosBatch.field.batchCount.tip"));
        batchCountLabel.putClientProperty("help", "tutti.createBenthosBatch.field.batchCount.help");
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setShowReset(true);
        batchWeightField.putClientProperty("help", "tutti.createBenthosBatch.field.batchWeight.help");
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(t("tutti.createBenthosBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(t("tutti.createBenthosBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createBenthosBatch.field.batchWeight.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createBenthosBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createBenthosBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createBenthosBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createBenthosBatch.action.cancel.help");
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new BeanFilterableComboBox<SampleCategoryModelEntry>(this));
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.setShowDecorator(false);
        categoryComboBox.setSortable(false);
        categoryComboBox.setProperty("selectedCategory");
        categoryComboBox.setShowReset(false);
        categoryComboBox.putClientProperty("help", "tutti.createBenthosBatch.field.categoryField.help");
    }

    protected void createCategoryConfigurationPanel() {
        $objectMap.put("categoryConfigurationPanel", categoryConfigurationPanel = new Table());
        
        categoryConfigurationPanel.setName("categoryConfigurationPanel");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(t("tutti.createBenthosBatch.field.category"));
        categoryLabel.setToolTipText(t("tutti.createBenthosBatch.field.category.tip"));
        categoryLabel.putClientProperty("help", "tutti.createBenthosBatch.field.categoryField.help");
    }

    protected void createCategoryPanel() {
        $objectMap.put("categoryPanel", categoryPanel = new JPanel());
        
        categoryPanel.setName("categoryPanel");
        categoryPanel.setLayout(new BorderLayout());
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateBenthosBatchUIHandler createHandler() {
        return new CreateBenthosBatchUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateBenthosBatchUIModel.class));
    }

    protected void createSampleCategoryComboBox() {
        $objectMap.put("sampleCategoryComboBox", sampleCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sampleCategoryComboBox.setName("sampleCategoryComboBox");
        sampleCategoryComboBox.setProperty("sampleCategory");
        sampleCategoryComboBox.setShowReset(true);
        sampleCategoryComboBox.putClientProperty("help", "tutti.createBenthosBatch.field.sampleCategory.help");
    }

    protected void createSampleCategoryLabel() {
        $objectMap.put("sampleCategoryLabel", sampleCategoryLabel = new JLabel());
        
        sampleCategoryLabel.setName("sampleCategoryLabel");
        sampleCategoryLabel.setText(t("tutti.createBenthosBatch.field.sampleCategory"));
        sampleCategoryLabel.setToolTipText(t("tutti.createBenthosBatch.field.sampleCategory.tip"));
        sampleCategoryLabel.putClientProperty("help", "tutti.createBenthosBatch.field.sampleCategory.help");
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.putClientProperty("help", "tutti.createBenthosBatch.field.sampleWeightField.help");
        sampleWeightField.putClientProperty("computed", true);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(t("tutti.createBenthosBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(t("tutti.createBenthosBatch.field.sampleWeight.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.createBenthosBatch.field.sampleWeightField.help");
        sampleWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createBenthosBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createBenthosBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createBenthosBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createBenthosBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createBenthosBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createBenthosBatch.action.saveAndContinue.help");
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
        speciesComboBox.putClientProperty("help", "tutti.createBenthosBatch.field.species.help");
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(t("tutti.createBenthosBatch.field.species"));
        speciesLabel.setToolTipText(t("tutti.createBenthosBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createBenthosBatch.field.species.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateBenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToCategoryPanel();
        addChildrenToCategoryConfigurationPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 34 property setters
        speciesComboBox.setBeanType(Species.class);
        sampleCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        categoryComboBox.setBeanType(SampleCategoryModelEntry.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createBenthosBatch.action.addSpecies.mnemonic"),'Z'));
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchWeightField.setNumberType(Float.class);
        batchCountLabel.setLabelFor(batchCountField);
        batchCountField.setBean(model);
        batchCountField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchCountField.setNumberPattern(INT_6_DIGITS_PATTERN);
        batchCountField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchCountField.setNumberType(Integer.class);
        sampleCategoryLabel.setLabelFor(sampleCategoryComboBox);
        sampleCategoryComboBox.setBean(model);
        categoryLabel.setLabelFor(categoryComboBox);
        categoryComboBox.setBean(model);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createBenthosBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createBenthosBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createBenthosBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createBenthosBatchTopPanel, "tutti.createBenthosBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createBenthosBatch.field.species.help");
        registerHelpId(_broker, speciesComboBox, "tutti.createBenthosBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createBenthosBatch.action.addSpecies.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createBenthosBatch.field.batchWeight.help");
        registerHelpId(_broker, batchWeightField, "tutti.createBenthosBatch.field.batchWeight.help");
        registerHelpId(_broker, batchCountLabel, "tutti.createBenthosBatch.field.batchCount.help");
        registerHelpId(_broker, batchCountField, "tutti.createBenthosBatch.field.batchCount.help");
        registerHelpId(_broker, sampleCategoryLabel, "tutti.createBenthosBatch.field.sampleCategory.help");
        registerHelpId(_broker, sampleCategoryComboBox, "tutti.createBenthosBatch.field.sampleCategory.help");
        registerHelpId(_broker, categoryLabel, "tutti.createBenthosBatch.field.categoryField.help");
        registerHelpId(_broker, categoryComboBox, "tutti.createBenthosBatch.field.categoryField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.createBenthosBatch.field.sampleWeightField.help");
        registerHelpId(_broker, sampleWeightField, "tutti.createBenthosBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.createBenthosBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createBenthosBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createBenthosBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createBenthosBatchTopPanel", createBenthosBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        createBatchWeightLabel();
        createBatchWeightField();
        createBatchCountLabel();
        createBatchCountField();
        createSampleCategoryLabel();
        createSampleCategoryComboBox();
        createCategoryPanel();
        createCategoryConfigurationPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createCategoryLabel();
        createCategoryComboBox();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createBenthosBatchTopPanel
        setName("createBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        createBenthosBatchTopPanel.putClientProperty("help", "tutti.createBenthosBatch.help");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setNumberValue(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchCountField.setNumberValue(model.getBatchCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleCategoryComboBox.setSelectedItem(model.getSampleCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_PANEL_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryPanel.setVisible(model.getSpecies() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setEnabled(model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("category", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setData(model.getCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("category", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}