/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.collect.Lists;
import fr.ifremer.shared.application.swing.ApplicationUI;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SelectCruiseUIHandler
extends AbstractTuttiUIHandler<SelectCruiseUIModel, SelectCruiseUI> {
    private static final Log log = LogFactory.getLog(SelectCruiseUIHandler.class);
    public static final MouseListener GRAB_FOCUS_ON_ENTER_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent source = (JComponent)e.getSource();
            source.grabFocus();
        }
    };
    protected boolean resetEditProtocolAction;
    protected boolean resetNewProtocolAction;
    protected boolean resetEditProgramAction;
    protected boolean resetEditCruiseAction;

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return ((SelectCruiseUI)this.ui).getValidator();
    }

    public void beforeInit(SelectCruiseUI ui) {
        super.beforeInit((ApplicationUI)ui);
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        SelectCruiseUIModel model = new SelectCruiseUIModel();
        List programs = persistenceService.getAllProgram();
        model.setPrograms(programs);
        if (programs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No program found.");
            }
        } else {
            Program selectedProgram = null;
            List cruises = null;
            if (this.getContext().isProgramFilled()) {
                selectedProgram = this.getDataContext().getProgram();
                cruises = persistenceService.getAllCruise(selectedProgram.getId());
            }
            model.setProgram(selectedProgram);
            model.setCruises(cruises);
            if (!CollectionUtils.isEmpty(cruises)) {
                Cruise selectedCruise = null;
                if (this.getContext().isCruiseFilled()) {
                    selectedCruise = this.getDataContext().getCruise();
                }
                model.setCruise(selectedCruise);
            }
        }
        ArrayList protocols = Lists.newArrayList((Iterable)persistenceService.getAllProtocol());
        model.setProtocols(protocols);
        if (protocols.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No protocol found.");
            }
        } else {
            model.setProtocol(this.getDataContext().getProtocol());
        }
        ui.setContextValue(model);
    }

    public void afterInit(SelectCruiseUI ui) {
        this.initUI(ui);
        SelectCruiseUIModel model = (SelectCruiseUIModel)((Object)this.getModel());
        ArrayList programs = Lists.newArrayList();
        if (model.getPrograms() != null) {
            programs.addAll(model.getPrograms());
        }
        this.initBeanFilterableComboBox(ui.getProgramCombobox(), programs, model.getProgram());
        ArrayList cruises = Lists.newArrayList();
        if (model.getCruises() != null) {
            cruises.addAll(model.getCruises());
        }
        this.initBeanFilterableComboBox(ui.getCruiseCombobox(), cruises, model.getCruise());
        ArrayList protocols = Lists.newArrayList();
        if (model.getProtocols() != null) {
            protocols.addAll(model.getProtocols());
        }
        this.initBeanFilterableComboBox(ui.getProtocolCombobox(), Lists.newArrayList(model.getProtocols()), model.getProtocol());
        this.initActionComboBox(ui.getEditProgramComboBox());
        this.initActionComboBox(ui.getEditCruiseComboBox());
        this.initActionComboBox(ui.getEditProtocolComboBox());
        this.initActionComboBox(ui.getNewProtocolComboBox());
        model.addPropertyChangeListener("protocols", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanFilterableComboBox<TuttiProtocol> combobox = ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).getProtocolCombobox();
                List protocols = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(protocols);
                ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).applyDataBinding("protocolCombobox.enabled");
            }
        });
        model.addPropertyChangeListener("program", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Program newValue = (Program)evt.getNewValue();
                boolean noProgram = newValue == null;
                SelectCruiseUIHandler.this.getContext().setProgramId(noProgram ? null : newValue.getId());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Selected program: " + newValue));
                }
                List cruises = noProgram ? Lists.newArrayList() : SelectCruiseUIHandler.this.getPersistenceService().getAllCruise(newValue.getId());
                SelectCruiseUIModel source = (SelectCruiseUIModel)((Object)evt.getSource());
                source.setCruises(cruises);
                source.setCruise(null);
            }
        });
        model.addPropertyChangeListener("cruises", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanFilterableComboBox<Cruise> combobox = ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).getCruiseCombobox();
                List campaigns = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("cruise", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cruise newValue = (Cruise)evt.getNewValue();
                SelectCruiseUIHandler.this.getContext().setCruiseId(newValue == null ? null : newValue.getId());
            }
        });
        model.addPropertyChangeListener("protocol", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiProtocol newValue = (TuttiProtocol)evt.getNewValue();
                SelectCruiseUIHandler.this.getContext().setProtocolId(newValue == null ? null : newValue.getId());
            }
        });
        this.registerValidators(this.getValidator());
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.getValidator().setBean((Object)model);
        ui.applyDataBinding("newCruiseButton.enabled");
        ui.applyDataBinding("editCatchesButton.enabled");
        ui.applyDataBinding("validateCatchesButton.enabled");
    }

    protected JComponent getComponentToFocus() {
        return ((SelectCruiseUI)this.getUI()).getEditCatchesButton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNewProtolAction() {
        this.resetNewProtocolAction = true;
        try {
            ((SelectCruiseUI)this.ui).getNewProtocolComboBox().setSelectedIndex(0);
        }
        finally {
            this.resetNewProtocolAction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditProtolAction() {
        this.resetEditProtocolAction = true;
        try {
            ((SelectCruiseUI)this.ui).getEditProtocolComboBox().setSelectedIndex(0);
        }
        finally {
            this.resetEditProtocolAction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditCruiseAction() {
        this.resetEditCruiseAction = true;
        try {
            ((SelectCruiseUI)this.ui).getEditCruiseComboBox().setSelectedIndex(0);
        }
        finally {
            this.resetEditCruiseAction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditProgramAction() {
        this.resetEditProgramAction = true;
        try {
            ((SelectCruiseUI)this.ui).getEditProgramComboBox().setSelectedIndex(0);
        }
        finally {
            this.resetEditProgramAction = false;
        }
    }

    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        for (PropertyChangeListener listener : listeners = ((SelectCruiseUIModel)((Object)this.getModel())).getPropertyChangeListeners()) {
            ((SelectCruiseUIModel)((Object)this.getModel())).removePropertyChangeListener(listener);
        }
        this.clearValidators();
    }

    public void startEditProgramAction(MouseEvent event) {
        this.startComboFirstAction(event);
    }

    public void startEditProgramAction(ActionEvent event) {
        this.startEditAction(!this.resetEditProgramAction, event);
    }

    public void startEditCruiseAction(MouseEvent event) {
        this.startComboFirstAction(event);
    }

    public void startEditCruiseAction(ActionEvent event) {
        this.startEditAction(!this.resetEditCruiseAction, event);
    }

    public void startExistingProtocolAction(MouseEvent event) {
        this.startComboFirstAction(event);
    }

    public void startExistingProtocolAction(ActionEvent event) {
        this.startEditAction(!this.resetEditProtocolAction, event);
    }

    public void startNewProtocolAction(MouseEvent event) {
        this.startComboFirstAction(event);
    }

    public void startNewProtocolAction(ActionEvent event) {
        this.startEditAction(!this.resetNewProtocolAction, event);
    }

    protected void startComboFirstAction(MouseEvent event) {
        JComboBox combo = (JComboBox)event.getSource();
        this.getContext().getActionEngine().runAction((AbstractButton)combo.getItemAt(0));
    }

    protected void startEditAction(boolean canEdit, ActionEvent event) {
        if (canEdit) {
            JComboBox existingCombo = (JComboBox)event.getSource();
            JButton selectedAction = (JButton)existingCombo.getSelectedItem();
            existingCombo.setSelectedIndex(0);
            existingCombo.hidePopup();
            this.getContext().getActionEngine().runAction((AbstractButton)selectedAction);
        }
    }

    protected void initActionComboBox(JComboBox combo) {
        combo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        combo.addMouseListener(GRAB_FOCUS_ON_ENTER_LISTENER);
    }
}

