/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolBenthosAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolBenthosAction.class);
    private File file;

    public ImportProtocolBenthosAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n._((String)"tutti.editProtocol.title.choose.benthosImportFile", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.action.chooseProtocolBenthosFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        String message;
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol benthos file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.importProtocolBenthos(this.file, protocol, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        List<EditProtocolSpeciesRowModel> rows = ((EditProtocolUIHandler)this.handler).toRows(protocol.getBenthos());
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().getHandler().reset();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().getHandler().reset();
        model.setBenthosRow(rows);
        ((EditProtocolUIHandler)this.getHandler()).getBenthosTableModel().setRows(rows);
        int nbSynonym = 0;
        for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
            if (speciesProtocol.isMadeFromAReferentTaxon()) continue;
            ++nbSynonym;
        }
        switch (nbSynonym) {
            case 0: {
                message = I18n._((String)"tutti.flash.info.benthos.imported.in.protocol", (Object[])new Object[]{this.file});
                break;
            }
            case 1: {
                message = I18n._((String)"tutti.flash.info.benthos.imported.in.protocol.oneReplaced", (Object[])new Object[]{this.file});
                break;
            }
            default: {
                message = I18n._((String)"tutti.flash.info.benthos.imported.in.protocol.severalReplaced", (Object[])new Object[]{this.file, nbSynonym});
            }
        }
        this.sendMessage(message);
    }
}

