/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import com.google.common.collect.Sets;
import fr.ifremer.shared.application.type.WeightUnit;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class BenthosFrequencyUIModel
extends AbstractTuttiTableUIModel<BenthosBatchRowModel, BenthosFrequencyRowModel, BenthosFrequencyUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";
    public static final String PROPERTY_STEP = "step";
    private static final String PROPERTY_MIN_STEP = "minStep";
    private static final String PROPERTY_MAX_STEP = "maxStep";
    public static final String PROPERTY_CAN_GENERATE = "canGenerate";
    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";
    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";
    public static final String PROPERTY_SIMPLE_COUNTING_MODE = "simpleCountingMode";
    public static final String PROPERTY_SIMPLE_COUNT = "simpleCount";
    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";
    public static final String PROPERTY_TOTAL_NUMBER = "totalNumber";
    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";
    public static final String PROPERTY_EMPTY_ROWS = "emptyRows";
    public static final String PROPERTY_NEXT_EDITABLE_ROW_INDEX = "nextEditableRowIndex";
    protected FrequencyConfigurationMode configurationMode;
    protected BenthosBatchRowModel batch;
    protected float step;
    protected Float minStep;
    protected Float maxStep;
    protected Caracteristic lengthStepCaracteristic;
    protected Integer simpleCount;
    protected Integer totalNumber;
    protected Float totalWeight;
    protected Integer nextEditableRowIndex;
    protected Set<BenthosFrequencyRowModel> emptyRows;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;
    protected Set<BenthosFrequencyRowModel> withWeightRows = Sets.newHashSet();

    public BenthosFrequencyUIModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel) {
        super(BenthosBatchRowModel.class, null, null);
        this.weightUnit = weightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.setEmptyRows(Sets.newHashSet());
    }

    @Override
    protected BenthosBatchRowModel newEntity() {
        return new BenthosBatchRowModel(this.weightUnit, this.sampleCategoryModel);
    }

    public FrequencyConfigurationMode getConfigurationMode() {
        return this.configurationMode;
    }

    public void setConfigurationMode(FrequencyConfigurationMode configurationMode) {
        FrequencyConfigurationMode oldValue = this.getConfigurationMode();
        this.configurationMode = configurationMode;
        this.firePropertyChange(PROPERTY_CONFIGURATION_MODE, (Object)oldValue, (Object)configurationMode);
        this.firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, this.isAutoGenMode());
        this.firePropertyChange(PROPERTY_RAFALE_MODE, null, this.isRafaleMode());
        this.firePropertyChange(PROPERTY_SIMPLE_COUNTING_MODE, null, this.isSimpleCountingMode());
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        Float oldValue = Float.valueOf(this.getStep());
        this.step = step;
        this.firePropertyChange(PROPERTY_STEP, oldValue, Float.valueOf(step));
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        this.firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMinStep() {
        return this.minStep;
    }

    public void setMinStep(Float minStep) {
        Float oldValue = this.getMinStep();
        this.minStep = minStep;
        this.firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Float oldValue = this.getMaxStep();
        this.maxStep = maxStep;
        this.firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Integer getSimpleCount() {
        return this.simpleCount;
    }

    public void setSimpleCount(Integer simpleCount) {
        Integer oldValue = this.getSimpleCount();
        this.simpleCount = simpleCount;
        this.firePropertyChange(PROPERTY_SIMPLE_COUNT, oldValue, simpleCount);
    }

    public Integer getNextEditableRowIndex() {
        return this.nextEditableRowIndex;
    }

    public void setNextEditableRowIndex(Integer nextEditableRowIndex) {
        Integer oldValue = this.getNextEditableRowIndex();
        this.nextEditableRowIndex = nextEditableRowIndex;
        this.firePropertyChange(PROPERTY_NEXT_EDITABLE_ROW_INDEX, oldValue, nextEditableRowIndex);
    }

    public boolean isAutoGenMode() {
        return FrequencyConfigurationMode.AUTO_GEN == this.configurationMode;
    }

    public boolean isRafaleMode() {
        return FrequencyConfigurationMode.RAFALE == this.configurationMode;
    }

    public boolean isSimpleCountingMode() {
        return FrequencyConfigurationMode.SIMPLE_COUNTING == this.configurationMode;
    }

    public boolean isCanGenerate() {
        return this.minStep != null && this.maxStep != null && this.maxStep.floatValue() > this.minStep.floatValue() && this.lengthStepCaracteristic != null;
    }

    public BenthosBatchRowModel getBatch() {
        return this.batch;
    }

    public void setBatch(BenthosBatchRowModel batch) {
        this.batch = batch;
        this.firePropertyChange(PROPERTY_BATCH, null, batch);
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int)(lengthStep * 10.0f);
        int intStep = (int)(this.step * 10.0f);
        int correctIntStep = intValue - intValue % intStep;
        float result = (float)correctIntStep / 10.0f;
        return result;
    }

    public Integer getTotalNumber() {
        return this.totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        Integer oldValue = this.getTotalNumber();
        this.totalNumber = totalNumber;
        this.firePropertyChange(PROPERTY_TOTAL_NUMBER, oldValue, totalNumber);
    }

    public Float getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(Float totalWeight) {
        Float oldValue = this.getTotalWeight();
        this.totalWeight = totalWeight;
        this.firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Set<BenthosFrequencyRowModel> getEmptyRows() {
        return this.emptyRows;
    }

    public void setEmptyRows(Set<BenthosFrequencyRowModel> emptyRows) {
        this.emptyRows = emptyRows;
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, emptyRows);
    }

    public void clearWithWeightRows() {
        this.withWeightRows.clear();
    }

    public int getNbRowsWithWeight() {
        return this.withWeightRows.size();
    }

    public boolean isAllRowsWithWeight() {
        return this.withWeightRows.size() == this.rows.size();
    }

    public boolean isSomeRowsWithWeightAndOtherWithout() {
        boolean result;
        if (CollectionUtils.isEmpty((Collection)this.rows)) {
            result = false;
        } else {
            int nbRowsWithWeight = this.getNbRowsWithWeight();
            int nbEmptyRows = this.emptyRows.size();
            result = nbRowsWithWeight != 0 && nbEmptyRows + nbRowsWithWeight != this.rows.size();
        }
        return result;
    }

    public void updateRowWithWeight(BenthosFrequencyRowModel row) {
        if (row.getWeight() == null) {
            this.withWeightRows.remove(row);
        } else {
            this.withWeightRows.add(row);
        }
    }

    public void updateEmptyRow(BenthosFrequencyRowModel row) {
        if (row.isValid() && row.getNumber() == null && row.getWeight() == null) {
            this.emptyRows.add(row);
        } else {
            this.emptyRows.remove(row);
        }
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, this.emptyRows);
    }

    public Float computeTotalWeight() {
        float result = 0.0f;
        for (BenthosFrequencyRowModel row : this.withWeightRows) {
            if (!row.isValid()) continue;
            result += row.getWeight().floatValue();
        }
        return Float.valueOf(result);
    }

    public int computeTotalNumber() {
        int result = 0;
        if (this.rows != null) {
            for (BenthosFrequencyRowModel row : this.rows) {
                if (!row.isValid() || row.getNumber() == null) continue;
                result += row.getNumber().intValue();
            }
        }
        return result;
    }

    public void recomputeTotalNumberAndWeight() {
        int totalNumber = this.computeTotalNumber();
        Float totalWeight = this.computeTotalWeight();
        this.setTotalNumber(totalNumber);
        this.setTotalWeight(totalWeight);
    }
}

