/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.EditProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DeleteProtocolAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(EditProtocolAction.class);

    public DeleteProtocolAction(SelectCruiseUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        TuttiProtocol protocol = ((SelectCruiseUIModel)((SelectCruiseUIHandler)this.getHandler()).getModel()).getProtocol();
        return result &= this.askBeforeDelete(I18n._((String)"tutti.selectCruise.action.deleteProtocol.title", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.deleteProtocol.message", (Object[])new Object[]{protocol.getName()}));
    }

    @Override
    public void doAction() {
        TuttiProtocol protocol = ((SelectCruiseUIModel)this.getModel()).getProtocol();
        Preconditions.checkNotNull((Object)protocol);
        String id = protocol.getId();
        Preconditions.checkNotNull((Object)id);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete protocol: " + id));
        }
        PersistenceService service = this.getContext().getPersistenceService();
        service.deleteProtocol(id);
        ((SelectCruiseUIModel)this.getModel()).setProtocol(null);
        List<TuttiProtocol> protocols = ((SelectCruiseUIModel)this.getModel()).getProtocols();
        protocols.remove(protocol);
        if (log.isInfoEnabled()) {
            log.info((Object)("nb protocols: " + protocols.size()));
        }
        ((SelectCruiseUIModel)this.getModel()).setProtocols(null);
        ((SelectCruiseUIModel)this.getModel()).setProtocols(protocols);
        ((SelectCruiseUIHandler)this.getHandler()).resetEditProtolAction();
    }
}

