package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.type.WeightUnit;
import fr.ifremer.shared.application.swing.table.AbstractApplicationTableModel;
import fr.ifremer.shared.application.swing.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class IndividualObservationBatchTableModel extends AbstractApplicationTableModel<IndividualObservationBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> SPECIES = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editIndividualObservationBatch.table.header.species"),
            n_("tutti.editIndividualObservationBatch.table.header.species.tip"));

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.editIndividualObservationBatch.table.header.weight"),
            n_("tutti.editIndividualObservationBatch.table.header.weight.tip"));

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> SIZE = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_SIZE,
            n_("tutti.editIndividualObservationBatch.table.header.size"),
            n_("tutti.editIndividualObservationBatch.table.header.size.tip"));

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> LENGTH_STEP_CARACTERISTIC = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_LENGTH_STEP_CARACTERISTIC,
            n_("tutti.editIndividualObservationBatch.table.header.lengthStepCaracteristic"),
            n_("tutti.editIndividualObservationBatch.table.header.lengthStepCaracteristic.tip"));

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> OTHER_CARACTERISTICS = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_CARACTERISTICS,
            n_("tutti.editIndividualObservationBatch.table.header.otherCaracteristics"),
            n_("tutti.editIndividualObservationBatch.table.header.otherCaracteristics.tip"));

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> COMMENT = ColumnIdentifier.newId(
            IndividualObservationBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editIndividualObservationBatch.table.header.comment"),
            n_("tutti.editIndividualObservationBatch.table.header.comment.tip"));

    public static final ColumnIdentifier<IndividualObservationBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId(
            IndividualObservationBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editIndividualObservationBatch.table.header.file"),
            n_("tutti.editIndividualObservationBatch.table.header.file.tip"));

    /**
     * Weight unit.
     *
     * @since 2.5
     */
    protected final WeightUnit weightUnit;

    public IndividualObservationBatchTableModel(WeightUnit weightUnit,
                                                TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.weightUnit = weightUnit;

        setNoneEditableCols();
    }

    @Override
    public IndividualObservationBatchRowModel createNewRow() {
        IndividualObservationBatchRowModel result =
                new IndividualObservationBatchRowModel(weightUnit);

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }
}
