/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.dao;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeaturesDaoImpl;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.tutti.persistence.dao.GearPhysicalFeaturesDaoTutti;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="gearPhysicalFeaturesDaoTutti")
@Lazy
public class GearPhysicalFeaturesDaoImplTutti
extends GearPhysicalFeaturesDaoImpl
implements GearPhysicalFeaturesDaoTutti {
    @Autowired
    public GearPhysicalFeaturesDaoImplTutti(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId, Short rankOrder, boolean createIfNotExists) {
        if (rankOrder == null) {
            rankOrder = 0;
        }
        if (fishingTrip.getGearPhysicalFeatures() != null && fishingTrip.getGearPhysicalFeatures().size() >= 0) {
            for (GearPhysicalFeatures guf : fishingTrip.getGearPhysicalFeatures()) {
                if (!ObjectUtils.equals((Object)rankOrder, (Object)guf.getRankOrder()) || !ObjectUtils.equals((Object)gearId, (Object)guf.getGear().getId())) continue;
                return guf;
            }
        }
        if (!createIfNotExists) {
            return null;
        }
        GearPhysicalFeatures gearPhysicalFeature = GearPhysicalFeatures.Factory.newInstance();
        gearPhysicalFeature.setFishingTrip(fishingTrip);
        gearPhysicalFeature.setRankOrder(rankOrder);
        Gear gear = (Gear)this.load(GearImpl.class, gearId);
        gearPhysicalFeature.setGear(gear);
        if (fishingTrip.getGearPhysicalFeatures() == null) {
            fishingTrip.setGearPhysicalFeatures((Collection)Lists.newArrayList((Object[])new GearPhysicalFeatures[]{gearPhysicalFeature}));
        } else {
            fishingTrip.getGearPhysicalFeatures().add(gearPhysicalFeature);
        }
        return gearPhysicalFeature;
    }
}

