/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.species.EnterMelagWeightDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class CreateSpeciesMelagAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Map<SpeciesBatchRowModel, Float> selectedRows = Maps.newHashMap();
    protected Float melagWeight = null;
    protected Float sampleMelagWeight = null;
    protected Float sortedWeight = null;
    protected final WeightUnit weightUnit = this.getConfig().getSpeciesWeightUnit();

    public CreateSpeciesMelagAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        int[] selectedRowIndexes = SwingUtil.getSelectedModelRows((JTable)((SpeciesBatchUIHandler)this.handler).getTable());
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        Float alreadyKnownWeights = Float.valueOf(0.0f);
        this.sortedWeight = Float.valueOf(0.0f);
        for (int selectedRowIndex : selectedRowIndexes) {
            SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
            Float sampleWeight = null;
            if (selectedRow.getFinestCategory().getNotNullWeight() != null) {
                alreadyKnownWeights = Float.valueOf(alreadyKnownWeights.floatValue() + selectedRow.getFinestCategory().getNotNullWeight().floatValue());
            } else if (selectedRow.getWeight() != null) {
                sampleWeight = selectedRow.getWeight();
            } else {
                sampleWeight = Float.valueOf(0.0f);
                if (selectedRow.getFrequency() != null) {
                    for (SpeciesFrequencyRowModel frequency : selectedRow.getFrequency()) {
                        if (frequency.getWeight() == null) {
                            sampleWeight = Float.valueOf(0.0f);
                            break;
                        }
                        sampleWeight = Float.valueOf(sampleWeight.floatValue() + frequency.getWeight().floatValue());
                    }
                }
            }
            if (sampleWeight != null) {
                if (sampleWeight.floatValue() == 0.0f) {
                    JOptionPane.showMessageDialog((Component)this.getUI(), I18n.t((String)"tutti.createSpeciesMelag.error.message", (Object[])new Object[]{selectedRowIndex + 1}), I18n.t((String)"tutti.createSpeciesMelag.error.title", (Object[])new Object[0]), 0);
                    SwingUtil.setSelectionInterval((JTable)((SpeciesBatchUIHandler)this.handler).getTable(), (int)selectedRowIndex);
                    result = false;
                    break;
                }
                this.sortedWeight = Float.valueOf(this.sortedWeight.floatValue() + sampleWeight.floatValue());
            }
            this.selectedRows.put(selectedRow, sampleWeight);
        }
        if (result) {
            this.melagWeight = this.openMelagWeightDialog();
            if (this.melagWeight != null) {
                this.sampleMelagWeight = Float.valueOf(this.melagWeight.floatValue() - alreadyKnownWeights.floatValue());
            }
        }
        return result && this.melagWeight != null;
    }

    protected Float openMelagWeightDialog() {
        Frame frame = (Frame)((SpeciesBatchUIHandler)this.handler).getParentContainer(Frame.class);
        EnterMelagWeightDialog dialog = new EnterMelagWeightDialog(frame, this.getConfig().getShortcutClosePopup());
        dialog.setWeightUnit(this.weightUnit);
        SwingUtil.center((Component)frame, (Component)dialog);
        dialog.pack();
        dialog.setVisible(true);
        Float result = null;
        if (dialog.getEditor().getModel() != null) {
            result = Float.valueOf(dialog.getEditor().getModel().floatValue());
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        String unitLabel = this.weightUnit.getShortLabel();
        String melagComment = I18n.t((String)"tutti.createSpeciesMelag.comment.part1", (Object[])new Object[0]) + "\n";
        for (SpeciesBatchRowModel batch : this.selectedRows.keySet()) {
            Float sampleWeight = this.selectedRows.get(batch);
            if (sampleWeight != null) {
                Float weight = Float.valueOf(this.sampleMelagWeight.floatValue() * sampleWeight.floatValue() / this.sortedWeight.floatValue());
                batch.getFinestCategory().setCategoryWeight(weight);
            }
            melagComment = melagComment + I18n.t((String)"tutti.createSpeciesMelag.comment.part2", (Object[])new Object[]{sampleWeight, unitLabel, this.decorate(batch.getSpecies())}) + "\n";
        }
        melagComment = melagComment + I18n.t((String)"tutti.createSpeciesMelag.comment.part3", (Object[])new Object[]{this.melagWeight, unitLabel});
        for (SpeciesBatchRowModel batch : this.selectedRows.keySet()) {
            String comment = batch.getComment();
            comment = StringUtils.isBlank((CharSequence)comment) ? "" : comment + "\n";
            comment = comment + melagComment;
            batch.setComment(comment);
        }
        ((SpeciesBatchUIHandler)this.getHandler()).saveRows(this.selectedRows.keySet());
    }

    public void releaseAction() {
        super.releaseAction();
        this.selectedRows.clear();
        this.melagWeight = null;
        this.sortedWeight = null;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((SpeciesBatchUIHandler)this.getHandler()).getTable().repaint();
    }
}

