/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Set<SpeciesBatchRowModel> rowToRemove;

    public RemoveSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n._((String)"tutti.editSpeciesBatch.action.removeBatch.confirm.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.action.removeBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if no batch selected");
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        SpeciesBatchRowModel selectedBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew((TuttiEntity)selectedBatch) ? 1 : 0) != 0, (Object)"Can't remove batch if batch is not persisted");
        persistenceService.deleteSpeciesBatch(selectedBatch.getId());
        if (selectedBatch.isBatchRoot()) {
            ((SpeciesBatchUIHandler)this.handler).removeFromSpeciesUsed(selectedBatch);
        } else {
            SpeciesBatchRowModel parentBatch = selectedBatch.getParentBatch();
            parentBatch.getChildBatch().remove(selectedBatch);
        }
        this.rowToRemove = Sets.newHashSet();
        this.rowToRemove.add(selectedBatch);
        ((SpeciesBatchUIHandler)this.handler).collectChildren(selectedBatch, this.rowToRemove);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        ((SpeciesBatchUIModel)this.getModel()).getRows().removeAll(this.rowToRemove);
        ((SpeciesBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing((JXTable)table);
    }
}

