/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.export.TuttiExportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProgramAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProgramAction.class);
    protected File file;

    public ExportProgramAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        Program program = ((SelectCruiseUIModel)((Object)this.getModel())).getProgram();
        if (doAction) {
            this.file = this.saveFile("exportProgram-" + program.getName(), "zip", I18n._((String)"tutti.selectCruise.title.choose.exportProgramFile", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.chooseProgramExportFile", (Object[])new Object[0]), "^.+\\.zip$", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Program program = ((SelectCruiseUIModel)((Object)this.getModel())).getProgram();
        Preconditions.checkNotNull((Object)program);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save program " + program.getId() + " to file: " + this.file));
        }
        List allCruise = this.getContext().getPersistenceService().getAllCruise(program.getId());
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(9 * allCruise.size() + 1);
        TuttiBusinessException exportError = null;
        TuttiExportService service = this.getContext().getTuttiExportService();
        try {
            service.exportProgram(program.getId(), this.file, progressionModel);
        }
        catch (TuttiBusinessException e) {
            String errorMessage = I18n._((String)"tutti.exportProgram.action.exportErrors", (Object[])new Object[]{program.getName(), e.getMessage()});
            exportError = new TuttiBusinessException(errorMessage);
        }
        ((SelectCruiseUIHandler)this.handler).resetEditProgramAction();
        this.sendMessage(I18n._((String)"tutti.exportProgram.action.success", (Object[])new Object[]{program.getName(), this.file.getName()}));
        if (exportError != null) {
            throw exportError;
        }
    }
}

