/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.cruise.VesselTypeEnum;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCruiseUIHandler
extends AbstractTuttiUIHandler<EditCruiseUIModel, EditCruiseUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditCruiseUIHandler.class);
    public static final String CRUISE_CARD = "cruise";
    public static final String GEAR_CARACTERISTICS_CARD = "gearCaracteristics";
    private final PersistenceService persistenceService;
    protected JPopupMenu gearPopupMenu;
    public static final JAXXContextEntryDef<GearWithOriginalRankOrder> GEAR_EDIT_CONTEXT = JAXXUtil.newContextEntryDef((String)"editGear", GearWithOriginalRankOrder.class);

    public static String getTitle(boolean exist) {
        String result = exist ? I18n._((String)"tutti.editCruise.title.edit.cruise", (Object[])new Object[0]) : I18n._((String)"tutti.editCruise.title.create.cruise", (Object[])new Object[0]);
        return result;
    }

    public EditCruiseUIHandler(TuttiUI parentUi, EditCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {
        this.getDataContext().resetValidationDataContext();
        EditCruiseUIModel model = new EditCruiseUIModel();
        if (this.context.isCruiseFilled()) {
            Cruise cruise = this.getDataContext().getCruise();
            model.fromBean(cruise);
            if (!model.isGearEmpty()) {
                for (GearWithOriginalRankOrder gear : model.getGear()) {
                    gear.setOriginalRankOrder(gear.getRankOrder());
                }
            }
            List attachments = this.persistenceService.getAllAttachments(model.getObjectType(), model.getObjectId());
            model.addAllAttachment(attachments);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit cruise: " + cruise.getId()));
            }
        } else {
            Program program = this.getDataContext().getProgram();
            model.setProgram(program);
            model.setMultirigNumber(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create a new cruise from program: " + program));
            }
        }
        this.listModelIsModify(model);
        ((EditCruiseUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        List users = this.persistenceService.getAllPerson();
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        List scientificVesselList = this.getDataContext().getScientificVessels();
        List fishingVesselList = this.getDataContext().getFishingVessels();
        ArrayList allVesselList = Lists.newArrayList();
        allVesselList.addAll(scientificVesselList);
        allVesselList.addAll(fishingVesselList);
        List scientificGearList = this.getDataContext().getScientificGears();
        List fishingGearList = this.getDataContext().getFishingGears();
        ArrayList allGearList = Lists.newArrayList();
        allGearList.addAll(scientificGearList);
        allGearList.addAll(fishingGearList);
        model.addPropertyChangeListener("vesselType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VesselTypeEnum vesselType = (VesselTypeEnum)((Object)evt.getNewValue());
                Predicate gearPredicate = null;
                ArrayList allVesselList = Lists.newArrayList();
                switch (vesselType) {
                    case FISHING: {
                        gearPredicate = TuttiEntities.IS_FISHING_GEAR;
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getFishingVessels());
                        break;
                    }
                    case SCIENTIFIC: {
                        gearPredicate = TuttiEntities.IS_SCIENTIFIC_GEAR;
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getScientificVessels());
                        break;
                    }
                    default: {
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getScientificVessels());
                        allVesselList.addAll(EditCruiseUIHandler.this.getDataContext().getFishingVessels());
                    }
                }
                ((EditCruiseUI)EditCruiseUIHandler.this.ui).getGearList().getHandler().clearFilters();
                ((EditCruiseUI)EditCruiseUIHandler.this.ui).getVesselComboBox().setData(null);
                ((EditCruiseUI)EditCruiseUIHandler.this.ui).getVesselComboBox().setData((List)allVesselList);
                if (gearPredicate != null) {
                    ((EditCruiseUI)EditCruiseUIHandler.this.ui).getGearList().getHandler().addFilter(gearPredicate);
                }
            }
        });
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getProgramComboBox(), Lists.newArrayList((Iterable)this.persistenceService.getAllProgram()), model.getProgram(), "onlyName");
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getDepartureLocationComboBox(), Lists.newArrayList((Iterable)this.persistenceService.getAllHarbour()), model.getDepartureLocation());
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getReturnLocationComboBox(), Lists.newArrayList((Iterable)this.persistenceService.getAllHarbour()), model.getReturnLocation());
        this.initBeanFilterableComboBox(((EditCruiseUI)this.ui).getVesselComboBox(), allVesselList, model.getVessel());
        ((EditCruiseUI)this.ui).getGearList().setModel((BeanDoubleListModel)new BeanDoubleListModel<Gear>(){
            private static final long serialVersionUID = 1L;
            private boolean valueAdjusting;

            public void moveUpSelected(Gear item) {
                super.moveUpSelected((Object)item);
                this.rebuildRankOrder();
            }

            public void moveDownSelected(Gear item) {
                super.moveDownSelected((Object)item);
                this.rebuildRankOrder();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setSelected(List<Gear> selected) {
                this.valueAdjusting = true;
                try {
                    super.setSelected(selected);
                }
                finally {
                    this.valueAdjusting = false;
                }
                this.rebuildRankOrder();
            }

            public void addToSelected(Gear item) {
                GearWithOriginalRankOrder target = GearWithOriginalRankOrders.newGearWithOriginalRankOrder((Gear)item);
                Short originalRankOrder = null;
                if (item instanceof GearWithOriginalRankOrder) {
                    originalRankOrder = ((GearWithOriginalRankOrder)item).getOriginalRankOrder();
                }
                if (originalRankOrder == null) {
                    originalRankOrder = 0;
                }
                target.setOriginalRankOrder(originalRankOrder);
                super.addToSelected((Object)target);
                this.rebuildRankOrder();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addToSelected(List<Gear> items) {
                this.valueAdjusting = true;
                try {
                    for (Gear item : items) {
                        this.addToSelected(item);
                    }
                }
                finally {
                    this.valueAdjusting = false;
                }
                this.rebuildRankOrder();
            }

            public void removeFromSelected(Gear item) {
                super.removeFromSelected((Object)item);
                this.rebuildRankOrder();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeFromSelected(List<Gear> items) {
                this.valueAdjusting = true;
                try {
                    for (Gear item : items) {
                        this.removeFromSelected(item);
                    }
                }
                finally {
                    this.valueAdjusting = false;
                }
                this.rebuildRankOrder();
            }

            protected void rebuildRankOrder() {
                if (!this.valueAdjusting) {
                    int index = 1;
                    for (Gear gear : this.getSelected()) {
                        gear.setRankOrder(Short.valueOf((short)index++));
                    }
                }
                this.selectedModel.refresh();
            }
        });
        this.initBeanList(((EditCruiseUI)this.ui).getGearList(), allGearList, model.getGear(), this.getDecorator(Gear.class, "gearWithrankOrder"));
        this.gearPopupMenu = ((EditCruiseUI)this.ui).getGearList().getSelectedList().getComponentPopupMenu();
        ((EditCruiseUI)this.ui).getGearList().getSelectedList().setComponentPopupMenu(null);
        this.gearPopupMenu.add((Component)new JSeparator(), 0);
        this.gearPopupMenu.add((Component)((EditCruiseUI)this.ui).getViewGearCaracteristicsItem(), 0);
        this.gearPopupMenu.add((Component)((EditCruiseUI)this.ui).getEditGearCaracteristicsItem(), 0);
        this.initBeanList(((EditCruiseUI)this.ui).getHeadOfMissionList(), users, model.getHeadOfMission());
        this.initBeanList(((EditCruiseUI)this.ui).getHeadOfSortRoomList(), users, model.getHeadOfSortRoom());
        ((EditCruiseUI)this.ui).getGearList().getSelectedList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point point;
                    int selectedIndex;
                    JList jList = (JList)e.getSource();
                    Rectangle rect = jList.getCellBounds(selectedIndex = jList.locationToIndex(point = e.getPoint()), selectedIndex);
                    if (rect.contains(point)) {
                        jList.setSelectedIndex(selectedIndex);
                    } else {
                        jList.clearSelection();
                    }
                    GearWithOriginalRankOrder gear = (GearWithOriginalRankOrder)jList.getSelectedValue();
                    EditCruiseUIHandler.this.updateGearActionsAndShowPoup(gear, jList, e.getX(), e.getY());
                }
            }
        });
        ((EditCruiseUI)this.ui).getGearList().getSelectedList().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 525) {
                    JList source = (JList)e.getSource();
                    int[] selectedRows = source.getSelectedIndices();
                    int lowestRow = -1;
                    for (int row : selectedRows) {
                        lowestRow = Math.max(lowestRow, row);
                    }
                    Rectangle r = source.getCellBounds(lowestRow, lowestRow);
                    Point p = new Point(r.x + r.width / 2, r.y + r.height);
                    Object[] gears = source.getSelectedValues();
                    GearWithOriginalRankOrder gear = gears != null && gears.length == 1 ? (GearWithOriginalRankOrder)gears[0] : null;
                    EditCruiseUIHandler.this.updateGearActionsAndShowPoup(gear, source, p.x, p.y);
                }
            }
        });
        SwingValidator<EditCruiseUIModel> validator = ((EditCruiseUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
        model.setModify(model.isCreate());
        this.registerValidators(validator);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((EditCruiseUI)this.getUI()).getProgramComboBox();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.add("attachment");
        result.add("vesselType");
        result.add("vesselTypeAll");
        result.add("vesselTypeScientific");
        result.add("vesselTypeFishing");
        result.add("canEditGearCatacteristic");
        result.add("canShowGearCatacteristic");
        return result;
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditCruiseUI)this.ui).getAttachmentsButton().onCloseUI();
    }

    @Override
    public boolean quitUI() {
        boolean result = this.quitScreen(((EditCruiseUIModel)this.getModel()).isValid(), ((EditCruiseUIModel)this.getModel()).isModify(), I18n._((String)"tutti.editCruise.askCancelEditBeforeLeaving.cancelSaveCruise", (Object[])new Object[0]), I18n._((String)"tutti.editCruise.askSaveBeforeLeaving.saveCruise", (Object[])new Object[0]), ((EditCruiseUI)this.ui).getSaveButton().getAction());
        return result;
    }

    @Override
    public SwingValidator<EditCruiseUIModel> getValidator() {
        return ((EditCruiseUI)this.ui).getValidator();
    }

    public void generateCampaignName() {
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        String name = model.getGeneratedCampaignName();
        model.setName(name);
    }

    protected void updateGearActionsAndShowPoup(GearWithOriginalRankOrder gear, JComponent source, int x, int y) {
        boolean editMenuEnabled = false;
        boolean viewMenuEnabled = false;
        if (gear != null) {
            editMenuEnabled = !((EditCruiseUIModel)this.getModel()).isCreate() && !((EditCruiseUIModel)this.getModel()).isModify() && (!gear.isScientificGear() || this.persistenceService.isTemporary((TuttiReferentialEntity)gear));
            viewMenuEnabled = true;
            GEAR_EDIT_CONTEXT.setContextValue((JAXXContext)this.ui, (Object)gear);
        }
        ((EditCruiseUIModel)this.getModel()).setCanEditGearCatacteristic(editMenuEnabled);
        ((EditCruiseUIModel)this.getModel()).setCanShowGearCatacteristic(viewMenuEnabled);
        this.gearPopupMenu.show(source, x, y);
    }
}

