/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.JXPathDecorator;

public class TuttiLocationTableCell {
    protected Decorator<TuttiLocation> decorator;
    protected List<TuttiLocation> entities;
    protected Map<String, TuttiLocation> entityMap;

    public TuttiLocationTableCell(TuttiUIContext context) {
        DecoratorService decoratorService = context.getDecoratorService();
        this.decorator = decoratorService.getDecoratorByType(TuttiLocation.class);
        this.entities = Lists.newArrayList((Iterable)context.getPersistenceService().getAllCountry());
        this.entityMap = TuttiEntities.splitById(this.entities);
    }

    public TableCellEditor getNewTableCellEditor() {
        return new TuttiLocationTableCellEditor();
    }

    public TableCellRenderer getNewTableCellRenderer() {
        return new TuttiLocationTableCellRenderer();
    }

    protected class TuttiLocationTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected TuttiLocationTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String entityId = String.valueOf(value);
            TuttiLocation entity = TuttiLocationTableCell.this.entityMap.get(entityId);
            return super.getTableCellRendererComponent(table, TuttiLocationTableCell.this.decorator.toString((Object)entity), isSelected, hasFocus, row, column);
        }
    }

    protected class TuttiLocationTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        protected TuttiLocationTableCellEditor() {
            super(new JComboBox());
            final BeanFilterableComboBox component = new BeanFilterableComboBox();
            component.setI18nPrefix("tutti.property.");
            component.setShowReset(Boolean.valueOf(true));
            component.setBeanType(TuttiLocation.class);
            this.setClickCountToStart(1);
            this.editorComponent = component;
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setValue(Object value) {
                    if (value != null && String.class.isInstance(value)) {
                        value = TuttiLocationTableCell.this.entityMap.get(value);
                    }
                    component.setSelectedItem(value);
                }

                @Override
                public Object getCellEditorValue() {
                    TuttiLocation entity;
                    String result = null;
                    Object selectedItem = component.getSelectedItem();
                    if (TuttiLocation.class.isInstance(selectedItem) && (entity = (TuttiLocation)component.getSelectedItem()) != null) {
                        result = entity.getId();
                    }
                    return result;
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                @Override
                public boolean stopCellEditing() {
                    if (component.isEditable().booleanValue()) {
                        component.getCombobox().actionPerformed(new ActionEvent(TuttiLocationTableCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
            component.init((JXPathDecorator)TuttiLocationTableCell.this.decorator, TuttiLocationTableCell.this.entities);
        }

        class TuttiLocationListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            TuttiLocationListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, TuttiLocationTableCell.this.decorator.toString(value), index, isSelected, cellHasFocus);
            }
        }
    }
}

