/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import liquibase.database.structure.type.BlobType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.UUIDType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;
import liquibase.util.StringUtils;

public class H2TypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof H2Database;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (StringUtils.trimToEmpty((String)defaultValue).startsWith("(NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_")) {
                return null;
            }
            if (StringUtils.trimToNull((String)defaultValue) == null) {
                return null;
            }
        }
        return super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TIMESTAMP");
    }

    public UUIDType getUUIDType() {
        return new UUIDType("UUID");
    }

    public ClobType getClobType() {
        return new ClobType("LONGVARCHAR");
    }

    public BlobType getBlobType() {
        return new BlobType("LONGVARBINARY");
    }
}

