package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProtocolSpeciesRowModel.java 1250 2013-09-30 12:34:52Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/EditProtocolSpeciesRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;

/**
 * @author kmorin
 * @since 0.3
 */
public class EditProtocolSpeciesRowModel extends AbstractTuttiBeanUIModel<SpeciesProtocol, EditProtocolSpeciesRowModel> implements SpeciesProtocol {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPECIES_SURVEY_CODE = "speciesSurveyCode";

    public static final String PROPERTY_SPECIES = "species";

    public static final String PROPERTY_LENGTH_STEP_PMFM = "lengthStepPmfm";

    public static final String PROPERTY_WEIGHT_ENABLED = "weightEnabled";

    public static final String PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED = "countIfNoFrequencyEnabled";

    public static final String PROPERTY_CALCIFY_SAMPLE_ENABLED = "calcifySampleEnabled";

    protected Species species;

    protected String speciesSurveyCode;

    protected Caracteristic lengthStepPmfm;

    protected boolean weightEnabled;

    protected boolean countIfNoFrequencyEnabled;

    protected boolean calcifySampleEnabled;

    protected List<Integer> mandatorySampleCategoryId;

    protected static final Binder<SpeciesProtocol, EditProtocolSpeciesRowModel> fromBeanBinder =
            BinderFactory.newBinder(SpeciesProtocol.class,
                                    EditProtocolSpeciesRowModel.class);

    protected static final Binder<EditProtocolSpeciesRowModel, SpeciesProtocol> toBeanBinder =
            BinderFactory.newBinder(EditProtocolSpeciesRowModel.class,
                                    SpeciesProtocol.class);

    public EditProtocolSpeciesRowModel() {
        super(SpeciesProtocol.class, fromBeanBinder, toBeanBinder);
    }

    @Override
    public Integer getSpeciesReferenceTaxonId() {
        return species.getReferenceTaxonId();
    }

    @Override
    public void setSpeciesReferenceTaxonId(Integer speciesReferenceTaxonId) {
    }

    public Species getSpecies() {
        return species;
    }

    public void setSpecies(Species species) {
        Object oldValue = getSpecies();
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    @Override
    public String getSpeciesSurveyCode() {
        return speciesSurveyCode;
    }

    @Override
    public void setSpeciesSurveyCode(String speciesSurveyCode) {
        Object oldValue = getSpeciesSurveyCode();
        this.speciesSurveyCode = speciesSurveyCode;
        firePropertyChange(PROPERTY_SPECIES_SURVEY_CODE, oldValue, speciesSurveyCode);
    }

    @Override
    public String getLengthStepPmfmId() {
        return lengthStepPmfm != null ? lengthStepPmfm.getId() : null;
    }

    @Override
    public void setLengthStepPmfmId(String lengthStepPmfmId) {
    }

    public Caracteristic getLengthStepPmfm() {
        return lengthStepPmfm;
    }

    public void setLengthStepPmfm(Caracteristic lengthStepPmfm) {
        Object oldValue = getLengthStepPmfm();
        this.lengthStepPmfm = lengthStepPmfm;
        firePropertyChange(PROPERTY_LENGTH_STEP_PMFM, oldValue, lengthStepPmfm);
    }

    @Override
    public boolean isWeightEnabled() {
        return weightEnabled;
    }

    @Override
    public void setWeightEnabled(boolean weightEnabled) {
        Object oldValue = isWeightEnabled();
        this.weightEnabled = weightEnabled;
        firePropertyChange(PROPERTY_WEIGHT_ENABLED, oldValue, weightEnabled);
    }

    @Override
    public boolean isCountIfNoFrequencyEnabled() {
        return countIfNoFrequencyEnabled;
    }

    @Override
    public void setCountIfNoFrequencyEnabled(boolean countIfNoFrequencyEnabled) {
        Object oldValue = isCountIfNoFrequencyEnabled();
        this.countIfNoFrequencyEnabled = countIfNoFrequencyEnabled;
        firePropertyChange(PROPERTY_COUNT_IF_NO_FREQUENCY_ENABLED, oldValue, countIfNoFrequencyEnabled);
    }

    @Override
    public boolean isCalcifySampleEnabled() {
        return calcifySampleEnabled;
    }

    @Override
    public void setCalcifySampleEnabled(boolean calcifySampleEnabled) {
        Object oldValue = isCalcifySampleEnabled();
        this.calcifySampleEnabled = calcifySampleEnabled;
        firePropertyChange(PROPERTY_CALCIFY_SAMPLE_ENABLED, oldValue, calcifySampleEnabled);
    }

    @Override
    public Float getLengthStep() {
        return null;
    }

    @Override
    public void setLengthStep(Float lengthStep) {
    }

    @Override
    public boolean isMadeFromAReferentTaxon() {
        return false;
    }

    @Override
    public void setMadeFromAReferentTaxon(boolean madeFromAReferentTaxon) {
    }

    @Override
    protected SpeciesProtocol newEntity() {
        return SpeciesProtocols.newSpeciesProtocol();
    }

    @Override
    public Integer getMandatorySampleCategoryId(int index) {
        Integer o = getChild(mandatorySampleCategoryId, index);
        return o;
    }

    @Override
    public boolean isMandatorySampleCategoryIdEmpty() {
        return mandatorySampleCategoryId == null || mandatorySampleCategoryId.isEmpty();
    }

    @Override
    public int sizeMandatorySampleCategoryId() {
        return mandatorySampleCategoryId == null ? 0 : mandatorySampleCategoryId.size();
    }

    @Override
    public void addMandatorySampleCategoryId(Integer mandatorySampleCategoryId) {
        getMandatorySampleCategoryId().add(mandatorySampleCategoryId);
    }

    @Override
    public void addAllMandatorySampleCategoryId(Collection<Integer> mandatorySampleCategoryId) {
        getMandatorySampleCategoryId().addAll(mandatorySampleCategoryId);
    }

    @Override
    public boolean removeMandatorySampleCategoryId(Integer mandatorySampleCategoryId) {
        boolean removed = getMandatorySampleCategoryId().remove(mandatorySampleCategoryId);
        return removed;
    }

    @Override
    public boolean removeAllMandatorySampleCategoryId(Collection<Integer> mandatorySampleCategoryId) {
        boolean removed = getMandatorySampleCategoryId().removeAll(mandatorySampleCategoryId);
        return removed;
    }

    @Override
    public boolean containsMandatorySampleCategoryId(Integer mandatorySampleCategoryId) {
        boolean contains = getMandatorySampleCategoryId().contains(mandatorySampleCategoryId);
        return contains;
    }

    @Override
    public boolean containsAllMandatorySampleCategoryId(Collection<Integer> mandatorySampleCategoryId) {
        boolean contains = getMandatorySampleCategoryId().containsAll(mandatorySampleCategoryId);
        return contains;
    }

    @Override
    public List<Integer> getMandatorySampleCategoryId() {
        return mandatorySampleCategoryId;
    }

    @Override
    public void setMandatorySampleCategoryId(List<Integer> mandatorySampleCategoryId) {
        this.mandatorySampleCategoryId = mandatorySampleCategoryId;
        firePropertyChange(PROPERTY_MANDATORY_SAMPLE_CATEGORY_ID, null, mandatorySampleCategoryId);
    }
}
