package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static org.nuiton.i18n.I18n._;

public class BenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<BenthosBatchUIModel, BenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED = "addSampleCategoryMenu.enabled";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN = "benthosTotalInertWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_MODEL = "benthosTotalInertWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "benthosTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL = "benthosTotalLivingNotItemizedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "benthosTotalSampleSortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "benthosTotalSortedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT = "benthosTotalWeightField.text";
    public static final String BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED = "changeSampleCategoryMenu.enabled";
    public static final String BINDING_CREATE_BENTHOS_MELAG_MENU_ENABLED = "createBenthosMelagMenu.enabled";
    public static final String BINDING_EDIT_FREQUENCIES_MENU_ENABLED = "editFrequenciesMenu.enabled";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED = "filterBenthosBatchAllButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED = "filterBenthosBatchLeafButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED = "filterBenthosBatchRootButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT = "filterBenthosBatchRootButton.text";
    public static final String BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED = "removeBenthosBatchMenu.enabled";
    public static final String BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED = "removeBenthosSubBatchMenu.enabled";
    public static final String BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED = "renameBenthosBatchMenu.enabled";
    public static final String BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED = "splitBenthosBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem addSampleCategoryMenu;
    protected JToolBar benthosBatchTabToolBar;
    protected TuttiComputedOrNotDataEditor benthosTotalInertWeightField;
    protected JLabel benthosTotalInertWeightLabel;
    protected TuttiComputedOrNotDataEditor benthosTotalLivingNotItemizedWeightField;
    protected JLabel benthosTotalLivingNotItemizedWeightLabel;
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JMenuItem changeSampleCategoryMenu;
    protected JButton createBenthosBatchButton;
    protected JMenuItem createBenthosMelagMenu;
    protected BenthosBatchUI editBenthosBatchTopPanel = this;
    protected JMenuItem editFrequenciesMenu;
    protected JButton exportMultiPostButton;
    protected JRadioButton filterBenthosBatchAllButton;
    protected JLabel filterBenthosBatchLabel;
    protected JRadioButton filterBenthosBatchLeafButton;
    protected JAXXButtonGroup filterBenthosBatchMode;
    protected JRadioButton filterBenthosBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected BenthosBatchUIHandler handler;
    protected JButton importMultiPostButton;
    protected BenthosBatchUIModel model;
    protected JMenuItem removeBenthosBatchMenu;
    protected JMenuItem removeBenthosSubBatchMenu;
    protected JMenuItem renameBenthosBatchMenu;
    protected JMenuItem splitBenthosBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            BenthosBatchUIHandler handler = new BenthosBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public BenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI() {
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addSampleCategoryMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addBatchCategory();
    }

    public void doActionPerformed__on__changeSampleCategoryMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeBatchCategory();
    }

    public void doActionPerformed__on__createBenthosBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doActionPerformed__on__editFrequenciesMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.editFrequencies();
    }

    public void doActionPerformed__on__filterBenthosBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterBenthosBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterBenthosBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__splitBenthosBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAddSampleCategoryMenu() {
        return addSampleCategoryMenu;
    }

    public JToolBar getBenthosBatchTabToolBar() {
        return benthosBatchTabToolBar;
    }

    public TuttiComputedOrNotDataEditor getBenthosTotalInertWeightField() {
        return benthosTotalInertWeightField;
    }

    public JLabel getBenthosTotalInertWeightLabel() {
        return benthosTotalInertWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getBenthosTotalLivingNotItemizedWeightField() {
        return benthosTotalLivingNotItemizedWeightField;
    }

    public JLabel getBenthosTotalLivingNotItemizedWeightLabel() {
        return benthosTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JMenuItem getChangeSampleCategoryMenu() {
        return changeSampleCategoryMenu;
    }

    public JButton getCreateBenthosBatchButton() {
        return createBenthosBatchButton;
    }

    public JMenuItem getCreateBenthosMelagMenu() {
        return createBenthosMelagMenu;
    }

    public JMenuItem getEditFrequenciesMenu() {
        return editFrequenciesMenu;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public JRadioButton getFilterBenthosBatchAllButton() {
        return filterBenthosBatchAllButton;
    }

    public JLabel getFilterBenthosBatchLabel() {
        return filterBenthosBatchLabel;
    }

    public JRadioButton getFilterBenthosBatchLeafButton() {
        return filterBenthosBatchLeafButton;
    }

    public JAXXButtonGroup getFilterBenthosBatchMode() {
        return filterBenthosBatchMode;
    }

    public JRadioButton getFilterBenthosBatchRootButton() {
        return filterBenthosBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public BenthosBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public BenthosBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveBenthosBatchMenu() {
        return removeBenthosBatchMenu;
    }

    public JMenuItem getRemoveBenthosSubBatchMenu() {
        return removeBenthosSubBatchMenu;
    }

    public JMenuItem getRenameBenthosBatchMenu() {
        return renameBenthosBatchMenu;
    }

    public JMenuItem getSplitBenthosBatchMenu() {
        return splitBenthosBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        benthosBatchTabToolBar.add(importMultiPostButton);
        benthosBatchTabToolBar.add(exportMultiPostButton);
    }

    protected void addChildrenToEditBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(benthosBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterBenthosBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchAllButton); }
    }

    protected void addChildrenToFilterBenthosBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchLeafButton); }
    }

    protected void addChildrenToFilterBenthosBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterBenthosBatchLabel);
        filterTablePane.add(filterBenthosBatchAllButton);
        filterTablePane.add(filterBenthosBatchLeafButton);
        filterTablePane.add(filterBenthosBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitBenthosBatchMenu);
        tablePopup.add(changeSampleCategoryMenu);
        tablePopup.add(addSampleCategoryMenu);
        tablePopup.add(removeBenthosBatchMenu);
        tablePopup.add(removeBenthosSubBatchMenu);
        tablePopup.add(renameBenthosBatchMenu);
        tablePopup.add(createBenthosMelagMenu);
        tablePopup.add(editFrequenciesMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add(filterTablePane, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSampleCategoryMenu() {
        $objectMap.put("addSampleCategoryMenu", addSampleCategoryMenu = new JMenuItem());
        
        addSampleCategoryMenu.setName("addSampleCategoryMenu");
        addSampleCategoryMenu.setText(_("tutti.editBenthosBatch.action.addSampleCategory"));
        addSampleCategoryMenu.setToolTipText(_("tutti.editBenthosBatch.action.addSampleCategory.tip"));
        addSampleCategoryMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addSampleCategoryMenu"));
        addSampleCategoryMenu.putClientProperty("help", "tutti.editBenthosBatch.action.addSampleCategory.help");
    }

    protected void createBenthosBatchTabToolBar() {
        $objectMap.put("benthosBatchTabToolBar", benthosBatchTabToolBar = new JToolBar());
        
        benthosBatchTabToolBar.setName("benthosBatchTabToolBar");
        benthosBatchTabToolBar.setFloatable(false);
        benthosBatchTabToolBar.setOpaque(false);
        benthosBatchTabToolBar.setBorderPainted(false);
    }

    protected void createBenthosTotalInertWeightField() {
        $objectMap.put("benthosTotalInertWeightField", benthosTotalInertWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalInertWeightField.setName("benthosTotalInertWeightField");
        benthosTotalInertWeightField.setUseFloat(true);
        benthosTotalInertWeightField.setShowReset(true);
        benthosTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalInertWeightLabel() {
        $objectMap.put("benthosTotalInertWeightLabel", benthosTotalInertWeightLabel = new JLabel());
        
        benthosTotalInertWeightLabel.setName("benthosTotalInertWeightLabel");
        benthosTotalInertWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalInertWeight"));
        benthosTotalInertWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalInertWeight.tip"));
        benthosTotalInertWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        benthosTotalInertWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalLivingNotItemizedWeightField() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightField", benthosTotalLivingNotItemizedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalLivingNotItemizedWeightField.setName("benthosTotalLivingNotItemizedWeightField");
        benthosTotalLivingNotItemizedWeightField.setUseFloat(true);
        benthosTotalLivingNotItemizedWeightField.setShowReset(true);
        benthosTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightLabel", benthosTotalLivingNotItemizedWeightLabel = new JLabel());
        
        benthosTotalLivingNotItemizedWeightLabel.setName("benthosTotalLivingNotItemizedWeightLabel");
        benthosTotalLivingNotItemizedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight"));
        benthosTotalLivingNotItemizedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.tip"));
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setUseFloat(true);
        benthosTotalSortedWeightField.setShowReset(true);
        benthosTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        benthosTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalWeight.tip"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        benthosTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editBenthosBatch.help"));
    }

    protected void createChangeSampleCategoryMenu() {
        $objectMap.put("changeSampleCategoryMenu", changeSampleCategoryMenu = new JMenuItem());
        
        changeSampleCategoryMenu.setName("changeSampleCategoryMenu");
        changeSampleCategoryMenu.setText(_("tutti.editBenthosBatch.action.changeSampleCategory"));
        changeSampleCategoryMenu.setToolTipText(_("tutti.editBenthosBatch.action.changeSampleCategory.tip"));
        changeSampleCategoryMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeSampleCategoryMenu"));
        changeSampleCategoryMenu.putClientProperty("help", "tutti.editBenthosBatch.action.changeSampleCategory.help");
    }

    protected void createCreateBenthosBatchButton() {
        $objectMap.put("createBenthosBatchButton", createBenthosBatchButton = new JButton());
        
        createBenthosBatchButton.setName("createBenthosBatchButton");
        createBenthosBatchButton.setText(_("tutti.editBenthosBatch.action.createBatch"));
        createBenthosBatchButton.setToolTipText(_("tutti.editBenthosBatch.action.createBatch.tip"));
        createBenthosBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createBenthosBatchButton"));
        createBenthosBatchButton.putClientProperty("help", "tutti.editBenthosBatch.action.createBatch.help");
    }

    protected void createCreateBenthosMelagMenu() {
        $objectMap.put("createBenthosMelagMenu", createBenthosMelagMenu = new JMenuItem());
        
        createBenthosMelagMenu.setName("createBenthosMelagMenu");
        createBenthosMelagMenu.setText(_("tutti.editBenthosBatch.action.createMelag"));
        createBenthosMelagMenu.setToolTipText(_("tutti.editBenthosBatch.action.createMelag.tip"));
        createBenthosMelagMenu.putClientProperty("help", "tutti.editBenthosBatch.action.createMelag.help");
        createBenthosMelagMenu.putClientProperty("tuttiAction", CreateBenthosMelagAction.class);
    }

    protected void createEditFrequenciesMenu() {
        $objectMap.put("editFrequenciesMenu", editFrequenciesMenu = new JMenuItem());
        
        editFrequenciesMenu.setName("editFrequenciesMenu");
        editFrequenciesMenu.setText(_("tutti.editBenthosBatch.action.editFrequencies"));
        editFrequenciesMenu.setToolTipText(_("tutti.editBenthosBatch.action.editFrequencies.tip"));
        editFrequenciesMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editFrequenciesMenu"));
        editFrequenciesMenu.putClientProperty("help", "tutti.editBenthosBatch.action.editFrequencies.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(_("tutti.editBenthosBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(_("tutti.editBenthosBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editBenthosBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("tuttiAction", ExportMultiPostAction.class);
    }

    protected void createFilterBenthosBatchAllButton() {
        $objectMap.put("filterBenthosBatchAllButton", filterBenthosBatchAllButton = new JRadioButton());
        
        filterBenthosBatchAllButton.setName("filterBenthosBatchAllButton");
        filterBenthosBatchAllButton.setText(_("tutti.editBenthosBatch.filterBatch.mode.all"));
        { filterBenthosBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterBenthosBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchAllButton.setToolTipText(_("tutti.editBenthosBatch.filterBatch.mode.all.tip"));
        filterBenthosBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchAllButton"));
    }

    protected void createFilterBenthosBatchLabel() {
        $objectMap.put("filterBenthosBatchLabel", filterBenthosBatchLabel = new JLabel());
        
        filterBenthosBatchLabel.setName("filterBenthosBatchLabel");
        filterBenthosBatchLabel.setText(_("tutti.editBenthosBatch.filterBatch"));
        filterBenthosBatchLabel.setToolTipText(_("tutti.editBenthosBatch.filterBatch.tip"));
        filterBenthosBatchLabel.putClientProperty("help", "tutti.editBenthosBatch.filterBatch.help");
        filterBenthosBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterBenthosBatchLeafButton() {
        $objectMap.put("filterBenthosBatchLeafButton", filterBenthosBatchLeafButton = new JRadioButton());
        
        filterBenthosBatchLeafButton.setName("filterBenthosBatchLeafButton");
        filterBenthosBatchLeafButton.setText(_("tutti.editBenthosBatch.filterBatch.mode.leaf"));
        { filterBenthosBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterBenthosBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchLeafButton.setToolTipText(_("tutti.editBenthosBatch.filterBatch.mode.leaf.tip"));
        filterBenthosBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchLeafButton"));
    }

    protected void createFilterBenthosBatchMode() {
        $objectMap.put("filterBenthosBatchMode", filterBenthosBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterBenthosBatchRootButton() {
        $objectMap.put("filterBenthosBatchRootButton", filterBenthosBatchRootButton = new JRadioButton());
        
        filterBenthosBatchRootButton.setName("filterBenthosBatchRootButton");
        { filterBenthosBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterBenthosBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchRootButton.setToolTipText(_("tutti.editBenthosBatch.filterBatch.mode.root.tip"));
        filterBenthosBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(BenthosBatchUIHandler.class));
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(_("tutti.editBenthosBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(_("tutti.editBenthosBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editBenthosBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("tuttiAction", ImportMultiPostAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosBatchUIModel.class));
    }

    protected void createRemoveBenthosBatchMenu() {
        $objectMap.put("removeBenthosBatchMenu", removeBenthosBatchMenu = new JMenuItem());
        
        removeBenthosBatchMenu.setName("removeBenthosBatchMenu");
        removeBenthosBatchMenu.setText(_("tutti.editBenthosBatch.action.removeBatch"));
        removeBenthosBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.removeBatch.tip"));
        removeBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeBatch.help");
        removeBenthosBatchMenu.putClientProperty("tuttiAction", RemoveBenthosBatchAction.class);
    }

    protected void createRemoveBenthosSubBatchMenu() {
        $objectMap.put("removeBenthosSubBatchMenu", removeBenthosSubBatchMenu = new JMenuItem());
        
        removeBenthosSubBatchMenu.setName("removeBenthosSubBatchMenu");
        removeBenthosSubBatchMenu.setText(_("tutti.editBenthosBatch.action.removeSubBatch"));
        removeBenthosSubBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.removeSubBatch.tip"));
        removeBenthosSubBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeSubBatch.help");
        removeBenthosSubBatchMenu.putClientProperty("tuttiAction", RemoveBenthosSubBatchAction.class);
    }

    protected void createRenameBenthosBatchMenu() {
        $objectMap.put("renameBenthosBatchMenu", renameBenthosBatchMenu = new JMenuItem());
        
        renameBenthosBatchMenu.setName("renameBenthosBatchMenu");
        renameBenthosBatchMenu.setText(_("tutti.editBenthosBatch.action.renameBatch"));
        renameBenthosBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.renameBatch.tip"));
        renameBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.renameBatch.help");
        renameBenthosBatchMenu.putClientProperty("tuttiAction", RenameBenthosBatchAction.class);
    }

    protected void createSplitBenthosBatchMenu() {
        $objectMap.put("splitBenthosBatchMenu", splitBenthosBatchMenu = new JMenuItem());
        
        splitBenthosBatchMenu.setName("splitBenthosBatchMenu");
        splitBenthosBatchMenu.setText(_("tutti.editBenthosBatch.action.splitBatch"));
        splitBenthosBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.splitBatch.tip"));
        splitBenthosBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitBenthosBatchMenu"));
        splitBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.splitBatch.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(true);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editBenthosBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToBenthosBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createBenthosBatchButton);
        addChildrenToFilterTablePane();
        addChildrenToFilterBenthosBatchAllButton();
        addChildrenToFilterBenthosBatchLeafButton();
        addChildrenToFilterBenthosBatchRootButton();
        addChildrenToTableScrollPane();
        
        // apply 21 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 44 property setters
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.exportMultiPost.mnemonic"),'Z'));
        splitBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        splitBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.splitBatch.mnemonic"),'Z'));
        changeSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        changeSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.changeSampleCategory.mnemonic"),'Z'));
        addSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        addSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.addSampleCategory.mnemonic"),'Z'));
        removeBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.removeBatch.mnemonic"),'Z'));
        removeBenthosSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.removeSubBatch.mnemonic"),'Z'));
        renameBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        renameBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.renameBatch.mnemonic"),'Z'));
        createBenthosMelagMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        createBenthosMelagMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.createMelag.mnemonic"),'Z'));
        editFrequenciesMenu.setIcon(SwingUtil.createActionIcon("show-frequency"));
        editFrequenciesMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.editFrequencies.mnemonic"),'Z'));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalInertWeightLabel.setLabelFor(benthosTotalInertWeightField);
        benthosTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalLivingNotItemizedWeightLabel.setLabelFor(benthosTotalLivingNotItemizedWeightField);
        benthosTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createBenthosBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createBenthosBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.createBatch.mnemonic"),'Z'));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterBenthosBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editBenthosBatchTopPanel, "tutti.editBenthosBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editBenthosBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editBenthosBatch.action.exportMultiPost.help");
        registerHelpId(_broker, splitBenthosBatchMenu, "tutti.editBenthosBatch.action.splitBatch.help");
        registerHelpId(_broker, changeSampleCategoryMenu, "tutti.editBenthosBatch.action.changeSampleCategory.help");
        registerHelpId(_broker, addSampleCategoryMenu, "tutti.editBenthosBatch.action.addSampleCategory.help");
        registerHelpId(_broker, removeBenthosBatchMenu, "tutti.editBenthosBatch.action.removeBatch.help");
        registerHelpId(_broker, removeBenthosSubBatchMenu, "tutti.editBenthosBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameBenthosBatchMenu, "tutti.editBenthosBatch.action.renameBatch.help");
        registerHelpId(_broker, createBenthosMelagMenu, "tutti.editBenthosBatch.action.createMelag.help");
        registerHelpId(_broker, editFrequenciesMenu, "tutti.editBenthosBatch.action.editFrequencies.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalInertWeightLabel, "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        registerHelpId(_broker, benthosTotalLivingNotItemizedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createBenthosBatchButton, "tutti.editBenthosBatch.action.createBatch.help");
        registerHelpId(_broker, filterBenthosBatchLabel, "tutti.editBenthosBatch.filterBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editBenthosBatchTopPanel", editBenthosBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createBenthosBatchTabToolBar();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createTablePopup();
        createSplitBenthosBatchMenu();
        createChangeSampleCategoryMenu();
        createAddSampleCategoryMenu();
        createRemoveBenthosBatchMenu();
        createRemoveBenthosSubBatchMenu();
        createRenameBenthosBatchMenu();
        createCreateBenthosMelagMenu();
        createEditFrequenciesMenu();
        createForm();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createBenthosTotalInertWeightLabel();
        createBenthosTotalInertWeightField();
        createBenthosTotalLivingNotItemizedWeightLabel();
        createBenthosTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateBenthosBatchButton();
        createFilterTablePane();
        createFilterBenthosBatchLabel();
        createFilterBenthosBatchAllButton();
        createFilterBenthosBatchLeafButton();
        createFilterBenthosBatchRootButton();
        createTableScrollPane();
        createTable();
        createFilterBenthosBatchMode();
        // inline creation of editBenthosBatchTopPanel
        setName("editBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        editBenthosBatchTopPanel.putClientProperty("help", "tutti.editBenthosBatch.help");
        
        // registers 21 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 21 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    changeSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isChangeSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isAddSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_BENTHOS_MELAG_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createBenthosMelagMenu.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_FREQUENCIES_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editFrequenciesMenu.setEnabled(model.isTableViewModeAll() && model.isEditFrequenciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalWeightField, getWeightStringValue(model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setModel(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setBean(model.getBenthosTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalSampleSortedWeightField, getWeightStringValue(model.getBenthosTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, getWeightStringValue(model.getBenthosTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setModel(model.getBenthosTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setBean(model.getBenthosTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setModel(model.getBenthosTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setBean(model.getBenthosTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setText(_(handler.getFilterBenthosBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
    }

}