package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CreateAccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateAccidentalBatchUIModel, CreateAccidentalBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_DEAD_OR_ALIVE_COMBO_BOX_SELECTED_ITEM = "accidentalDeadOrAliveComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_GENDER_COMBO_BOX_SELECTED_ITEM = "accidentalGenderComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "accidentalLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_SIZE_FIELD_MODEL = "accidentalSizeField.model";
    public static final String BINDING_ACCIDENTAL_SIZE_FIELD_NUMBER_PATTERN = "accidentalSizeField.numberPattern";
    public static final String BINDING_ACCIDENTAL_SPECIES_COMBO_BOX_SELECTED_ITEM = "accidentalSpeciesComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_WEIGHT_FIELD_MODEL = "accidentalWeightField.model";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateAccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "deadOrAlive",  editorName = "accidentalDeadOrAliveComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> accidentalDeadOrAliveComboBox;
    protected JLabel accidentalDeadOrAliveLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gender",  editorName = "accidentalGenderComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> accidentalGenderComboBox;
    protected JLabel accidentalGenderLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "accidentalLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> accidentalLengthStepCaracteristicComboBox;
    protected JLabel accidentalLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "accidentalSizeField")
    protected NumberEditor accidentalSizeField;
    protected JLabel accidentalSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "accidentalSpeciesComboBox")
    protected BeanFilterableComboBox<Species> accidentalSpeciesComboBox;
    protected JLabel accidentalSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "accidentalWeightField")
    protected NumberEditor accidentalWeightField;
    protected JLabel accidentalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateAccidentalBatchUI createAccidentalBatchTopPanel = this;
    protected CreateAccidentalBatchUIHandler handler;
    protected CreateAccidentalBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateAccidentalBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateAccidentalBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateAccidentalBatchUIHandler handler = new CreateAccidentalBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateAccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI() {
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getAccidentalDeadOrAliveComboBox() {
        return accidentalDeadOrAliveComboBox;
    }

    public JLabel getAccidentalDeadOrAliveLabel() {
        return accidentalDeadOrAliveLabel;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getAccidentalGenderComboBox() {
        return accidentalGenderComboBox;
    }

    public JLabel getAccidentalGenderLabel() {
        return accidentalGenderLabel;
    }

    public BeanFilterableComboBox<Caracteristic> getAccidentalLengthStepCaracteristicComboBox() {
        return accidentalLengthStepCaracteristicComboBox;
    }

    public JLabel getAccidentalLengthStepCaracteristicLabel() {
        return accidentalLengthStepCaracteristicLabel;
    }

    public NumberEditor getAccidentalSizeField() {
        return accidentalSizeField;
    }

    public JLabel getAccidentalSizeLabel() {
        return accidentalSizeLabel;
    }

    public BeanFilterableComboBox<Species> getAccidentalSpeciesComboBox() {
        return accidentalSpeciesComboBox;
    }

    public JLabel getAccidentalSpeciesLabel() {
        return accidentalSpeciesLabel;
    }

    public NumberEditor getAccidentalWeightField() {
        return accidentalWeightField;
    }

    public JLabel getAccidentalWeightLabel() {
        return accidentalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateAccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public CreateAccidentalBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateAccidentalBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(accidentalSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalGenderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalGenderComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalSizeField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalLengthStepCaracteristicLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalLengthStepCaracteristicComboBox), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalDeadOrAliveLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalDeadOrAliveComboBox), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalDeadOrAliveComboBox() {
        $objectMap.put("accidentalDeadOrAliveComboBox", accidentalDeadOrAliveComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        accidentalDeadOrAliveComboBox.setName("accidentalDeadOrAliveComboBox");
        accidentalDeadOrAliveComboBox.setProperty("deadOrAlive");
        accidentalDeadOrAliveComboBox.setShowReset(true);
    }

    protected void createAccidentalDeadOrAliveLabel() {
        $objectMap.put("accidentalDeadOrAliveLabel", accidentalDeadOrAliveLabel = new JLabel());
        
        accidentalDeadOrAliveLabel.setName("accidentalDeadOrAliveLabel");
        accidentalDeadOrAliveLabel.setText(_("tutti.createAccidentalBatch.field.accidentalDeadOrAlive"));
        accidentalDeadOrAliveLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalDeadOrAlive.tip"));
        accidentalDeadOrAliveLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
    }

    protected void createAccidentalGenderComboBox() {
        $objectMap.put("accidentalGenderComboBox", accidentalGenderComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        accidentalGenderComboBox.setName("accidentalGenderComboBox");
        accidentalGenderComboBox.setProperty("gender");
        accidentalGenderComboBox.setShowReset(true);
    }

    protected void createAccidentalGenderLabel() {
        $objectMap.put("accidentalGenderLabel", accidentalGenderLabel = new JLabel());
        
        accidentalGenderLabel.setName("accidentalGenderLabel");
        accidentalGenderLabel.setText(_("tutti.createAccidentalBatch.field.accidentalGender"));
        accidentalGenderLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalGender.tip"));
        accidentalGenderLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalGender.help");
    }

    protected void createAccidentalLengthStepCaracteristicComboBox() {
        $objectMap.put("accidentalLengthStepCaracteristicComboBox", accidentalLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        accidentalLengthStepCaracteristicComboBox.setName("accidentalLengthStepCaracteristicComboBox");
        accidentalLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        accidentalLengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createAccidentalLengthStepCaracteristicLabel() {
        $objectMap.put("accidentalLengthStepCaracteristicLabel", accidentalLengthStepCaracteristicLabel = new JLabel());
        
        accidentalLengthStepCaracteristicLabel.setName("accidentalLengthStepCaracteristicLabel");
        accidentalLengthStepCaracteristicLabel.setText(_("tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic"));
        accidentalLengthStepCaracteristicLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.tip"));
        accidentalLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
    }

    protected void createAccidentalSizeField() {
        $objectMap.put("accidentalSizeField", accidentalSizeField = new NumberEditor(this));
        
        accidentalSizeField.setName("accidentalSizeField");
        accidentalSizeField.setProperty("size");
        accidentalSizeField.setUseFloat(true);
        accidentalSizeField.setShowReset(true);
    }

    protected void createAccidentalSizeLabel() {
        $objectMap.put("accidentalSizeLabel", accidentalSizeLabel = new JLabel());
        
        accidentalSizeLabel.setName("accidentalSizeLabel");
        accidentalSizeLabel.setText(_("tutti.createAccidentalBatch.field.accidentalSize"));
        accidentalSizeLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalSize.tip"));
        accidentalSizeLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSize.help");
    }

    protected void createAccidentalSpeciesComboBox() {
        $objectMap.put("accidentalSpeciesComboBox", accidentalSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        accidentalSpeciesComboBox.setName("accidentalSpeciesComboBox");
        accidentalSpeciesComboBox.setProperty("species");
        accidentalSpeciesComboBox.setShowReset(true);
    }

    protected void createAccidentalSpeciesLabel() {
        $objectMap.put("accidentalSpeciesLabel", accidentalSpeciesLabel = new JLabel());
        
        accidentalSpeciesLabel.setName("accidentalSpeciesLabel");
        accidentalSpeciesLabel.setText(_("tutti.createAccidentalBatch.field.accidentalSpecies"));
        accidentalSpeciesLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalSpecies.tip"));
        accidentalSpeciesLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSpecies.help");
    }

    protected void createAccidentalWeightField() {
        $objectMap.put("accidentalWeightField", accidentalWeightField = new NumberEditor(this));
        
        accidentalWeightField.setName("accidentalWeightField");
        accidentalWeightField.setProperty("weight");
        accidentalWeightField.setUseFloat(true);
        accidentalWeightField.setShowReset(true);
    }

    protected void createAccidentalWeightLabel() {
        $objectMap.put("accidentalWeightLabel", accidentalWeightLabel = new JLabel());
        
        accidentalWeightLabel.setName("accidentalWeightLabel");
        accidentalWeightLabel.setText(_("tutti.createAccidentalBatch.field.accidentalWeight"));
        accidentalWeightLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalWeight.tip"));
        accidentalWeightLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalWeight.help");
        accidentalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getAccidentalCatchWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createAccidentalBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createAccidentalBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createAccidentalBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createAccidentalBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateAccidentalBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateAccidentalBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(_("tutti.createAccidentalBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(_("tutti.createAccidentalBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createAccidentalBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(_("tutti.createAccidentalBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(_("tutti.createAccidentalBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createAccidentalBatch.action.saveAndContinue.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateAccidentalBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateAccidentalBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 28 property setters
        accidentalSpeciesComboBox.setBeanType(Species.class);
        accidentalGenderComboBox.setBeanType(CaracteristicQualitativeValue.class);
        accidentalLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        accidentalDeadOrAliveComboBox.setBeanType(CaracteristicQualitativeValue.class);
        accidentalSpeciesLabel.setLabelFor(accidentalSpeciesComboBox);
        accidentalSpeciesComboBox.setBean(model);
        accidentalGenderLabel.setLabelFor(accidentalGenderComboBox);
        accidentalGenderComboBox.setBean(model);
        accidentalWeightLabel.setLabelFor(accidentalWeightField);
        accidentalWeightField.setBean(model);
        accidentalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        accidentalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        accidentalSizeLabel.setLabelFor(accidentalSizeField);
        accidentalSizeField.setBean(model);
        accidentalSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        accidentalSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        accidentalLengthStepCaracteristicLabel.setLabelFor(accidentalLengthStepCaracteristicComboBox);
        accidentalLengthStepCaracteristicComboBox.setBean(model);
        accidentalDeadOrAliveLabel.setLabelFor(accidentalDeadOrAliveComboBox);
        accidentalDeadOrAliveComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createAccidentalBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createAccidentalBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createAccidentalBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createAccidentalBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, accidentalSpeciesLabel, "tutti.createAccidentalBatch.field.accidentalSpecies.help");
        registerHelpId(_broker, accidentalGenderLabel, "tutti.createAccidentalBatch.field.accidentalGender.help");
        registerHelpId(_broker, accidentalWeightLabel, "tutti.createAccidentalBatch.field.accidentalWeight.help");
        registerHelpId(_broker, accidentalSizeLabel, "tutti.createAccidentalBatch.field.accidentalSize.help");
        registerHelpId(_broker, accidentalLengthStepCaracteristicLabel, "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
        registerHelpId(_broker, accidentalDeadOrAliveLabel, "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
        registerHelpId(_broker, cancelButton, "tutti.createAccidentalBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createAccidentalBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createAccidentalBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createAccidentalBatchTopPanel", createAccidentalBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createAccidentalSpeciesLabel();
        createAccidentalSpeciesComboBox();
        createAccidentalGenderLabel();
        createAccidentalGenderComboBox();
        createAccidentalWeightLabel();
        createAccidentalWeightField();
        createAccidentalSizeLabel();
        createAccidentalSizeField();
        createAccidentalLengthStepCaracteristicLabel();
        createAccidentalLengthStepCaracteristicComboBox();
        createAccidentalDeadOrAliveLabel();
        createAccidentalDeadOrAliveComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createAccidentalBatchTopPanel
        setName("createAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        createAccidentalBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_GENDER_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalGenderComboBox.setSelectedItem(model.getGender());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gender", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalWeightField.setModel(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_SIZE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("size", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalSizeField.setModel(model.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("size", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCIDENTAL_SIZE_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                accidentalSizeField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_DEAD_OR_ALIVE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("deadOrAlive", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalDeadOrAliveComboBox.setSelectedItem(model.getDeadOrAlive());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("deadOrAlive", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}