/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiDecorator;
import fr.ifremer.tutti.ui.swing.util.TuttiColorHighlighter;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import jaxx.runtime.SwingUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;

public final class TuttiUIUtil {
    public static final String SPECIES_DECORATOR = "decorator";
    public static final String SPECIES_DECORATOR_INDEX = "decoratorIndex";
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);
    public static final double EARTH_RADIUS = 6378288.0;
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    private TuttiUIUtil() {
    }

    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.property.set.error", (Object[])new Object[]{property, bean.getClass().getName()}), e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.property.get.error", (Object[])new Object[]{property, bean.getClass().getName()}), e);
        }
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, true);
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(TuttiUIUtil.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = TuttiUIUtil.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static void openLink(URL url) {
        try {
            TuttiUIUtil.openLink(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.open.link", (Object[])new Object[]{url}), e);
        }
    }

    public static Desktop getDesktopForBrowse() {
        if (!Desktop.isDesktopSupported()) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.browse.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void openLink(URI uri) {
        Desktop desktop = TuttiUIUtil.getDesktopForBrowse();
        try {
            desktop.browse(uri);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.open.link", (Object[])new Object[]{uri}), e);
        }
    }

    public static Desktop getDesktopForMail() {
        if (!Desktop.isDesktopSupported()) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.MAIL)) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.mail.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void mail(String subject, String body) {
        Desktop desktop = TuttiUIUtil.getDesktopForMail();
        try {
            URI mailtoURI = new URI("mailto", null, null, "subject=" + subject + "&body=" + body, null);
            desktop.mail(mailtoURI);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.mail", (Object[])new Object[0]), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryToConnectToUpdateUrl(String urlAsString, String badUrlFormatI18nKey, String notReachI18nKey, String notFoundI18nKey) {
        URLConnection urlConnection;
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bad url syntax at " + urlAsString), (Throwable)e);
            }
            throw new TuttiBusinessException(I18n._((String)badUrlFormatI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.connect();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not connect to " + urlAsString), (Throwable)e);
            }
            throw new TuttiBusinessException(I18n._((String)notReachI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection.setReadTimeout(1000);
            InputStream inputStream = null;
            try {
                inputStream = urlConnection.getInputStream();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not found file at to " + urlAsString), (Throwable)e);
            }
            throw new TuttiBusinessException(I18n._((String)notFoundI18nKey, (Object[])new Object[]{urlAsString}));
        }
    }

    public static float getRoundedLengthStep(float lengthStep, boolean aroundUp) {
        int intValue = (int)((lengthStep + (aroundUp ? 0.001f : 0.0f)) * 10.0f);
        float result = (float)intValue / 10.0f;
        return result;
    }

    public static <E> TuttiDecorator<E> getSpeciesColumnDecorator(TableColumnExt tableColumn) {
        TuttiDecorator decorator = (TuttiDecorator)tableColumn.getClientProperty((Object)SPECIES_DECORATOR);
        return decorator;
    }

    public static <R extends Serializable, T extends AbstractTuttiTableModel<R>> void installSpeciesColumnComparatorPopup(JXTable table, TableColumnExt speciesColumn, String ... tips) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SpeciesDecoratorListener speciesDecoratorListener = new SpeciesDecoratorListener(table, buttonGroup);
        TuttiDecorator decorator = TuttiUIUtil.getSpeciesColumnDecorator(speciesColumn);
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JLabel(I18n._((String)"tutti.ui.change.species.decorator", (Object[])new Object[0])));
        popup.add(new JSeparator());
        int nbContext = decorator.getNbContext();
        for (int i = 0; i < nbContext; ++i) {
            String property = decorator.getProperty(i);
            String i18nName = "tutti.property." + property;
            speciesColumn.putClientProperty((Object)i18nName, (Object)tips[i]);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(tips[i]);
            item.putClientProperty(SPECIES_DECORATOR_INDEX, i);
            item.addActionListener(speciesDecoratorListener);
            if (i == 0) {
                item.setSelected(true);
            }
            buttonGroup.add(item);
            popup.add(item);
        }
        speciesDecoratorListener.recomputeSpeciesColumnTip();
        table.getTableHeader().addMouseListener(new ShowSpeciesDecoratorPopupListener(popup));
    }

    public static void selectFirstCellOnFirstRowAndStopEditing(JXTable table) {
        TuttiUIUtil.doSelectCell((JTable)table, 0, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void selectFirstCellOnLastRow(JXTable table) {
        TuttiUIUtil.doSelectCell((JTable)table, table.getRowCount() - 1, 0);
    }

    public static void selectFirstCellOnRow(JXTable table, int row, boolean stopEdit) {
        TuttiUIUtil.doSelectCell((JTable)table, row, 0);
        if (stopEdit && table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void doSelectCell(JTable table, int rowIndex, int columnIndex) {
        int rowCount = table.getRowCount();
        if (rowCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No row in table, can not select any cell");
            }
            return;
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No column in table, can not select any cell");
            }
            return;
        }
        if (columnIndex > columnCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("ColumnIndex: %s is more than columnCount %s", columnIndex, columnCount));
            }
            columnIndex = columnCount - 1;
        }
        if (columnIndex < 0) {
            columnIndex = 0;
        }
        if (rowIndex >= rowCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("RowIndex: %s is more than rowCount %s", rowIndex, rowCount));
            }
            rowIndex = rowCount - 1;
        }
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        table.setColumnSelectionInterval(columnIndex, columnIndex);
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.editCellAt(rowIndex, columnIndex);
    }

    protected static class ShowSpeciesDecoratorPopupListener
    extends MouseAdapter {
        private final JPopupMenu popup;

        public ShowSpeciesDecoratorPopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader source = (JTableHeader)e.getSource();
            Point point = e.getPoint();
            int columnIndex = source.columnAtPoint(point);
            boolean rightClick = SwingUtilities.isRightMouseButton(e);
            if (columnIndex == 0 && rightClick) {
                e.consume();
                this.popup.show(source, e.getX(), e.getY());
            }
        }
    }

    protected static class SpeciesDecoratorListener<R extends Serializable, T extends AbstractTuttiTableModel<R>>
    implements ActionListener {
        protected final JXTable table;
        protected final ButtonGroup buttonGroup;
        protected final TuttiDecorator<Species> decorator;
        protected final TableColumnExt column;

        public SpeciesDecoratorListener(JXTable table, ButtonGroup buttonGroup) {
            this.table = table;
            this.buttonGroup = buttonGroup;
            this.column = (TableColumnExt)table.getColumn(0);
            this.decorator = TuttiUIUtil.getSpeciesColumnDecorator(this.column);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButtonMenuItem source = (JRadioButtonMenuItem)e.getSource();
            this.buttonGroup.setSelected(source.getModel(), true);
            Integer index = (Integer)source.getClientProperty(TuttiUIUtil.SPECIES_DECORATOR_INDEX);
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected decorator context index: " + index));
            }
            this.decorator.setContextIndex(index.intValue());
            this.column.setComparator((Comparator)this.decorator.getCurrentComparator());
            this.recomputeSpeciesColumnTip();
            AbstractTuttiTableModel tableModel = (AbstractTuttiTableModel)this.table.getModel();
            ArrayList rowsToReSelect = Lists.newArrayList();
            for (int rowIndex : SwingUtil.getSelectedModelRows((JTable)this.table)) {
                Object row = tableModel.getEntry(rowIndex);
                rowsToReSelect.add(row);
            }
            tableModel.fireTableDataChanged();
            for (Serializable row : rowsToReSelect) {
                int modelRowIndex = tableModel.getRowIndex(row);
                SwingUtil.addRowSelectionInterval((JTable)this.table, (int)modelRowIndex);
            }
        }

        public void recomputeSpeciesColumnTip() {
            ArrayList tips = Lists.newArrayList();
            int nbContext = this.decorator.getNbContext();
            for (int i = 0; i < nbContext; ++i) {
                String property = this.decorator.getProperty(i);
                String i18nName = "tutti.property." + property;
                String tip = (String)this.column.getClientProperty((Object)i18nName);
                tips.add(tip);
            }
            String tip = Joiner.on((String)" - ").join((Iterable)tips);
            this.column.setToolTipText(tip);
        }
    }
}

