package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: ReloadTuttiAction.java 1170 2013-09-13 16:21:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/ReloadTuttiAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.RunTutti;

import static org.nuiton.i18n.I18n._;

/**
 * To reload Tutti application.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public class ReloadTuttiAction extends AbstractChangeScreenAction {

    public ReloadTuttiAction(MainUIHandler handler) {
        super(handler, true, null);
        setActionDescription(_("tutti.main.action.reloadTutti"));
    }

    @Override
    public void doAction() throws Exception {

        // Close the application, will exit and restart application
        RunTutti.closeTutti(getHandler(), RunTutti.UPATE_EXIT_CODE);
    }

}