package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.UpdateDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DbManagerUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, DbManagerUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_DB_BUTTON_VISIBLE = "exportDbButton.visible";
    public static final String BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TEXT = "installOrReinstallDbButton.text";
    public static final String BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TOOL_TIP_TEXT = "installOrReinstallDbButton.toolTipText";
    public static final String BINDING_OPEN_DB_BUTTON_VISIBLE = "openDbButton.visible";
    public static final String BINDING_UPGRADE_DB_BUTTON_VISIBLE = "upgradeDbButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8bRRiemDiu49C0SRMKTVQnRZGDyLo5VEUKguZTceQ0KHGkihzKrHdsT9kvZmebDasifgI/Ae6AhMSNE+LAmQMXxF9AiAPXindm17v+2PUmNIo28cz7PPPM43mfnW//QnmHoaVn2PMU5pqcGkQ52Hzy5Eh9Rpp8hzhNRm1uMRT8jOVQ7gyVtGjc4ejeWV3AqyG8um0ZtmUSswe9UUeTDr/QidMhhHO02I9oOk71JJre8GyXdVkjUUmsX//zd+4r7ctvcgh5Nqibgq2Us1DxTsbrKEc1jmZgpee4qmOzDTIYNdug93Uxtq1jx3mMDfIZ+gIV6mjCxgzIOFq+/JYlh8R7Nkc3NfUQm7hNWMOyP8Im0Tm632IKbTFiEKZwl3OquFRxzkGH0rRMDrSKpio7XeBpzbYl4QRHhQ42NZ0wjh5elWQ/QMZcecPShJxKOlNDfDytbQtCj8fQCZVZnwoVqxnYfaLbW7I2Bhep2bJCK2aE616IOJCDoqoYFU+LYmZgTi1zkxHM0VwfpAG6BEyUz8U24aYAyI9v9BNOWTYxd9QtUAe7QrN9bMGoqLwTAd6ipsOxrh+xYxL+24WLirv91dcpnAzGR1RMu3abYY2MIiFeGglDd/oOPLSSErdSfNbHzlCeuTDM0e2z4e47hqmg724P9J0glLMv52d//+nPH/e6zVaCtecSS3uyAprAZuAw41QsPR10msupXj3E9sYZKjpEh6CRQbKQIOwknAZxsN5NAVcEXNnHTgco8oU/fv5l/pPfXkO5PTSpW1jbw6K+hoq8w8AFS9c8+8NHUtHU+TV43hDa4Lg/7cBhBDv85eCkRp2piInlFx64sZDgRiRJLf767+zJD4+6joyBwjdTy2NX8h+jCWrq1CQygMJsSQycku0QV7PiDElKFZQUK3bYYGvyuT7kQA7Oesdi9HM49Vjf1GnbNGS0TfsHdawSXdnefdzYPX7B0WTQPTWRI6jU04CeK7gfyK2L/x6Ckhs985InS8g4JEDLaroOVnU4sfkW1h34WwpTq3Fhw6eiyJtqhxu6CBuLaSJsFn2TnJd3DZtfbMmhyoN3y+HvKui+RjTKe1mT9A4GSpZcaMdxIYajdT8MX6VNeC1IgqBBRQhVZJoq1NlRdz3q8Mrq6qCVk2F8rGkq5NBTeQo35Ty8YPxaQswEs0pTfPnANkXX3zMPTWJYJm1C+A6e42AxJYIrRlRb4palN6jdkFu5n74VaifvpNs+q8PtM7Rst5+G3R8Rppf/Iu6mCQijd8D2YjCe5HrZr8k5KSdEj/a8krF2quX3soAcrhGRy5V0l7v16SYPvIOyjC1Exi6mrBm8MuG1+pw6VPbXO/7QISmvrJSX4tE6RDPRKkNNUBBkSd/FLf9ILjPa/5WRElPdXxoN6/N+JdX7sDrd+b7LxeV9L6esF90Ueq2/5WebPOPaGuZkjZEWERdYivUhv+f9U1n0f1MmEpdq+tuZyD7f05MlBqRbP3iturz7aXHSvYRd1fxiAEw64/P+rvcqKdOVdOWUiYCXTJmofkTK9F9Ss/yGG9iEji8sKEbX34eDh8sqNTW4dn8wxD4mnpOZjGL4O/H4Pplh/pUZFoDhPzjtS2YzDwAA";
    private static final Log log = LogFactory.getLog(DbManagerUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actions;
    protected TuttiHelpBroker broker;
    protected DbManagerUI dbManagerTopPanel = this;
    protected JButton exportDbButton;
    protected DbManagerUIHandler handler;
    protected JButton importDbButton;
    protected JPanel infoPanel;
    protected JTextPane informationArea;
    protected JButton installOrReinstallDbButton;
    protected TuttiUIContext model;
    protected JButton openDbButton;
    protected JButton upgradeDbButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DbManagerUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                DbManagerUIHandler handler = new DbManagerUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public DbManagerUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI() {
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DbManagerUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DbManagerUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActions() {
        return actions;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportDbButton() {
        return exportDbButton;
    }

    public DbManagerUIHandler getHandler() {
        return handler;
    }

    public JButton getImportDbButton() {
        return importDbButton;
    }

    public JPanel getInfoPanel() {
        return infoPanel;
    }

    public JTextPane getInformationArea() {
        return informationArea;
    }

    public JButton getInstallOrReinstallDbButton() {
        return installOrReinstallDbButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getOpenDbButton() {
        return openDbButton;
    }

    public JButton getUpgradeDbButton() {
        return upgradeDbButton;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(openDbButton);
        actions.add(installOrReinstallDbButton);
        actions.add(importDbButton);
        actions.add(upgradeDbButton);
        actions.add(exportDbButton);
    }

    protected void addChildrenToDbManagerTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(infoPanel, BorderLayout.CENTER);
        add(actions, BorderLayout.SOUTH);
    }

    protected void addChildrenToInfoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        infoPanel.add(informationArea, BorderLayout.CENTER);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JPanel());
        
        actions.setName("actions");
        actions.setLayout(new GridLayout(0, 1));
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.dbManager.help"));
    }

    protected void createExportDbButton() {
        $objectMap.put("exportDbButton", exportDbButton = new JButton());
        
        exportDbButton.setName("exportDbButton");
        exportDbButton.setText(_("tutti.dbManager.action.exportDb"));
        exportDbButton.setToolTipText(_("tutti.dbManager.action.exportDb.tip"));
        exportDbButton.putClientProperty("help", "tutti.dbManager.action.exportDb.help");
        exportDbButton.putClientProperty("tuttiAction", ExportDbAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DbManagerUIHandler.class));
    }

    protected void createImportDbButton() {
        $objectMap.put("importDbButton", importDbButton = new JButton());
        
        importDbButton.setName("importDbButton");
        importDbButton.setText(_("tutti.dbManager.action.importDb"));
        importDbButton.setToolTipText(_("tutti.dbManager.action.importDb.tip"));
        importDbButton.putClientProperty("help", "tutti.dbManager.action.importDb.help");
        importDbButton.putClientProperty("tuttiAction", ImportOrReimportDbAction.class);
    }

    protected void createInfoPanel() {
        $objectMap.put("infoPanel", infoPanel = new JPanel());
        
        infoPanel.setName("infoPanel");
        infoPanel.setLayout(new BorderLayout());
    }

    protected void createInformationArea() {
        $objectMap.put("informationArea", informationArea = new JTextPane());
        
        informationArea.setName("informationArea");
        informationArea.setFocusable(false);
        informationArea.setContentType("text/html");
        informationArea.setEditable(false);
    }

    protected void createInstallOrReinstallDbButton() {
        $objectMap.put("installOrReinstallDbButton", installOrReinstallDbButton = new JButton());
        
        installOrReinstallDbButton.setName("installOrReinstallDbButton");
        installOrReinstallDbButton.putClientProperty("help", "tutti.dbManager.action.installDb.help");
        installOrReinstallDbButton.putClientProperty("tuttiAction", InstallOrReinstallDbAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createOpenDbButton() {
        $objectMap.put("openDbButton", openDbButton = new JButton());
        
        openDbButton.setName("openDbButton");
        openDbButton.setText(_("tutti.dbManager.action.openDb"));
        openDbButton.setToolTipText(_("tutti.dbManager.action.openDb.tip"));
        openDbButton.putClientProperty("help", "tutti.dbManager.action.openDb.help");
        openDbButton.putClientProperty("tuttiAction", OpenDbAction.class);
    }

    protected void createUpgradeDbButton() {
        $objectMap.put("upgradeDbButton", upgradeDbButton = new JButton());
        
        upgradeDbButton.setName("upgradeDbButton");
        upgradeDbButton.setText(_("tutti.dbManager.action.upgradeDb"));
        upgradeDbButton.setToolTipText(_("tutti.dbManager.action.upgradeDb.tip"));
        upgradeDbButton.putClientProperty("help", "tutti.dbManager.action.upgradeDb.help");
        upgradeDbButton.putClientProperty("tuttiAction", UpdateDbAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDbManagerTopPanel();
        addChildrenToInfoPanel();
        addChildrenToActions();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        informationArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        openDbButton.setIcon(SwingUtil.createActionIcon("open-db"));
        openDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.openDb.mnemonic"),'Z'));
        installOrReinstallDbButton.setIcon(SwingUtil.createActionIcon("install-db"));
        installOrReinstallDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.installDb.mnemonic"),'Z'));
        importDbButton.setIcon(SwingUtil.createActionIcon("import-db"));
        importDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.importDb.mnemonic"),'Z'));
        upgradeDbButton.setIcon(SwingUtil.createActionIcon("update-referential"));
        upgradeDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.upgradeDb.mnemonic"),'Z'));
        exportDbButton.setIcon(SwingUtil.createActionIcon("export-db"));
        exportDbButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.dbManager.action.exportDb.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, dbManagerTopPanel, "tutti.dbManager.help");
        registerHelpId(_broker, openDbButton, "tutti.dbManager.action.openDb.help");
        registerHelpId(_broker, installOrReinstallDbButton, "tutti.dbManager.action.installDb.help");
        registerHelpId(_broker, importDbButton, "tutti.dbManager.action.importDb.help");
        registerHelpId(_broker, upgradeDbButton, "tutti.dbManager.action.upgradeDb.help");
        registerHelpId(_broker, exportDbButton, "tutti.dbManager.action.exportDb.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("dbManagerTopPanel", dbManagerTopPanel);
        createHandler();
        createModel();
        createBroker();
        createInfoPanel();
        createInformationArea();
        createActions();
        createOpenDbButton();
        createInstallOrReinstallDbButton();
        createImportDbButton();
        createUpgradeDbButton();
        createExportDbButton();
        // inline creation of dbManagerTopPanel
        setName("dbManagerTopPanel");
        setLayout(new BorderLayout());
        dbManagerTopPanel.putClientProperty("help", "tutti.dbManager.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OPEN_DB_BUTTON_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    openDbButton.setVisible(model.isDbExist() && !model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    installOrReinstallDbButton.setText(_(handler.getInstallButtonText(model.isDbExist())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INSTALL_OR_REINSTALL_DB_BUTTON_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbExist", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    installOrReinstallDbButton.setToolTipText(_(handler.getInstallButtonTip(model.isDbExist())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbExist", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UPGRADE_DB_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    upgradeDbButton.setVisible(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_DB_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportDbButton.setVisible(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
    }

}