/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class SpeciesBatchTableModel
extends AbstractTuttiTableModel<SpeciesBatchRowModel> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SpeciesBatchTableModel.class);
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.editSpeciesBatch.table.header.species", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.species", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId("computedOrNotWeight", I18n.n_((String)"tutti.editSpeciesBatch.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.weight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId("computedOrNotNumber", I18n.n_((String)"tutti.editSpeciesBatch.table.header.computedNumber", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.computedNumber", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId("comment", I18n.n_((String)"tutti.editSpeciesBatch.table.header.comment", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.comment", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId("attachment", I18n.n_((String)"tutti.editSpeciesBatch.table.header.file", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.file", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId("speciesToConfirm", I18n.n_((String)"tutti.editSpeciesBatch.table.header.toConfirm", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.toConfirm", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> frequencyCols;
    protected final Set<SampleCategoryColumnIdentifier<SpeciesBatchRowModel>> sampleCols;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;

    public SpeciesBatchTableModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel, TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.weightUnit = weightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.setNoneEditableCols(SPECIES);
        this.frequencyCols = Sets.newHashSet();
        this.frequencyCols.add(COMPUTED_NUMBER);
        this.frequencyCols.add(WEIGHT);
        this.sampleCols = Sets.newHashSet();
        Enumeration columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)columns.nextElement();
            Object identifier = tableColumn.getIdentifier();
            if (!(identifier instanceof SampleCategoryColumnIdentifier)) continue;
            this.sampleCols.add((SampleCategoryColumnIdentifier)identifier);
        }
    }

    @Override
    public SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel(this.weightUnit, this.sampleCategoryModel);
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName, SpeciesBatchRowModel entry) {
        if (this.sampleCols.contains(propertyName)) {
            SampleCategoryColumnIdentifier sampleCategoryColumnIdentifier = (SampleCategoryColumnIdentifier)propertyName;
            sampleCategoryColumnIdentifier.setWeightValue(entry, aValue);
            Integer sampleCategoryId = sampleCategoryColumnIdentifier.getSampleCategoryId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sample category: " + sampleCategoryId + " modified at row: " + rowIndex));
            }
            SampleCategory<?> sampleCategory = entry.getSampleCategoryById(sampleCategoryId);
            SampleCategoryAble firstAncestor = entry.getFirstAncestor((SampleCategory)sampleCategory);
            int firstRowIndex = this.getRowIndex(firstAncestor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("First ancestor row: " + firstRowIndex));
            }
            this.updateShell((SpeciesBatchRowModel)firstAncestor, columnIndex);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }
    }

    @Override
    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result) {
            if (this.frequencyCols.contains(propertyName)) {
                SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(rowIndex);
                result = entry.isBatchLeaf();
            } else if (this.sampleCols.contains(propertyName)) {
                SampleCategory value;
                SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(rowIndex);
                Species species = entry.getSpecies();
                result = species == null ? false : (value = (SampleCategory)propertyName.getValue(entry)).getCategoryValue() != null;
            }
        }
        return result;
    }

    public Integer getNextEditableFrequencyRow(Integer rowIndex) {
        Integer result = null;
        int max = this.getRowCount();
        for (int i = rowIndex.intValue(); i < max; ++i) {
            SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(i);
            if (!entry.isBatchLeaf()) continue;
            result = i;
            break;
        }
        return result;
    }

    public final int getNextChildRowIndex(SpeciesBatchRowModel row) {
        int parentRowIndex = this.getRowIndex(row);
        Preconditions.checkState((this.getRowIndex(row) != -1 ? 1 : 0) != 0);
        int result = parentRowIndex;
        if (!row.isChildBatchsEmpty()) {
            SpeciesBatchRowModel lastChild = row.getChildBatch().get(row.sizeChildBatchs() - 1);
            HashSet childs = Sets.newHashSet();
            childs.add(lastChild);
            lastChild.collectShell(childs);
            for (SpeciesBatchRowModel child : childs) {
                int childRowIndex = this.getRowIndex(child);
                result = Math.max(childRowIndex, result);
            }
        }
        return ++result;
    }

    public Integer getSampleCategoryId(int columnIndex) {
        Integer result = null;
        ColumnIdentifier identifier = this.getIdentifier(columnIndex);
        if (this.sampleCols.contains(identifier)) {
            SampleCategoryColumnIdentifier sampleId = (SampleCategoryColumnIdentifier)identifier;
            result = sampleId.getSampleCategoryId();
        }
        return result;
    }

    public void updateSampleCategorieValue(SpeciesBatchRowModel row, int columnIndex, Serializable newValue) {
        SampleCategoryColumnIdentifier identifier = (SampleCategoryColumnIdentifier)this.getIdentifier(columnIndex);
        identifier.setCategoryValue(row, newValue);
        this.updateShell(row, columnIndex);
    }

    public SpeciesBatchRowModel getPreviousSibling(SpeciesBatchRowModel row) {
        List<SpeciesBatchRowModel> childBatch;
        int i;
        SpeciesBatchRowModel result = null;
        SpeciesBatchRowModel parentBatch = row.getParentBatch();
        if (parentBatch != null && (i = (childBatch = parentBatch.getChildBatch()).indexOf(row)) > 0) {
            result = childBatch.get(i - 1);
        }
        return result;
    }

    public void updateShell(Set<SpeciesBatchRowModel> shell, int columnIndex) {
        for (SpeciesBatchRowModel batchRowModel : shell) {
            int currentRowIndex = this.getRowIndex(batchRowModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update shell row: " + currentRowIndex));
            }
            this.fireTableCellUpdated(currentRowIndex, columnIndex);
        }
    }

    protected void updateShell(SpeciesBatchRowModel entry, int columnIndex) {
        HashSet shell = Sets.newHashSet();
        entry.collectShell(shell);
        shell.add(entry);
        this.updateShell(shell, columnIndex);
    }
}

