package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class EditCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCruiseUIModel, EditCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENTS_BUTTON_ENABLED = "attachmentsButton.enabled";
    public static final String BINDING_BEGIN_DATE_FIELD_DATE = "beginDateField.date";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DEPARTURE_LOCATION_COMBO_BOX_SELECTED_ITEM = "departureLocationComboBox.selectedItem";
    public static final String BINDING_EDIT_GEAR_CARACTERISTICS_ITEM_ENABLED = "editGearCaracteristicsItem.enabled";
    public static final String BINDING_END_DATE_FIELD_DATE = "endDateField.date";
    public static final String BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED = "filterVesselAllButton.selected";
    public static final String BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED = "filterVesselFishingButton.selected";
    public static final String BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED = "filterVesselScientificButton.selected";
    public static final String BINDING_GENERATE_NAME_BUTTON_ENABLED = "generateNameButton.enabled";
    public static final String BINDING_MULTIRIG_NUMBER_FIELD_MODEL = "multirigNumberField.model";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_RETURN_LOCATION_COMBO_BOX_SELECTED_ITEM = "returnLocationComboBox.selectedItem";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";
    public static final String BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM = "vesselComboBox.selectedItem";
    public static final String BINDING_VIEW_GEAR_CARACTERISTICS_ITEM_ENABLED = "viewGearCaracteristicsItem.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment attachmentsButton;
    @ValidatorField( validatorId = "validator",  propertyName = "beginDate",  editorName = "beginDateField")
    protected JXDatePicker beginDateField;
    protected JLabel beginDateLabel;
    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JScrollPane cruiseScrollPane;
    @ValidatorField( validatorId = "validator",  propertyName = "departureLocation",  editorName = "departureLocationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> departureLocationComboBox;
    protected JLabel departureLocationLabel;
    protected EditCruiseUI editCruiseTopPanel = this;
    protected JMenuItem editGearCaracteristicsItem;
    @ValidatorField( validatorId = "validator",  propertyName = "endDate",  editorName = "endDateField")
    protected JXDatePicker endDateField;
    protected JLabel endDateLabel;
    protected JRadioButton filterVesselAllButton;
    protected JRadioButton filterVesselFishingButton;
    protected JLabel filterVesselLabel;
    protected JRadioButton filterVesselScientificButton;
    protected JAXXButtonGroup filterVesselType;
    protected GearCaracteristicsEditorUI gearCaracteristicsEditor;
    protected JXTitledPanel gearCaracteristicsEditorTitledPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearList")
    protected BeanDoubleList<Gear> gearList;
    protected JPopupMenu gearMenuPopup;
    protected JButton generateNameButton;
    protected EditCruiseUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionList")
    protected BeanDoubleList<Person> headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomList")
    protected BeanDoubleList<Person> headOfSortRoomList;
    protected CardLayout2Ext mainPanelLayout;
    protected EditCruiseUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigNumber",  editorName = "multirigNumberField")
    protected NumberEditor multirigNumberField;
    protected JLabel multirigNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "returnLocation",  editorName = "returnLocationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> returnLocationComboBox;
    protected JLabel returnLocationLabel;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    protected JToolBar topToolBar;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselComboBox")
    protected BeanFilterableComboBox<Vessel> vesselComboBox;
    protected JPanel vesselFilterPane;
    protected JLabel vesselLabel;
    protected JMenuItem viewGearCaracteristicsItem;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JSeparator $JSeparator0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditCruiseUIHandler handler = new EditCruiseUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI() {
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "beginDate");
    }

    public void doActionPerformed__on__endDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "endDate");
    }

    public void doActionPerformed__on__filterVesselAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.ALL);
    }

    public void doActionPerformed__on__filterVesselFishingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.FISHING);
    }

    public void doActionPerformed__on__filterVesselScientificButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
    }

    public void doActionPerformed__on__generateNameButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateCampaignName();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAttachmentsButton() {
        return attachmentsButton;
    }

    public JXDatePicker getBeginDateField() {
        return beginDateField;
    }

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JScrollPane getCruiseScrollPane() {
        return cruiseScrollPane;
    }

    public BeanFilterableComboBox<TuttiLocation> getDepartureLocationComboBox() {
        return departureLocationComboBox;
    }

    public JLabel getDepartureLocationLabel() {
        return departureLocationLabel;
    }

    public JMenuItem getEditGearCaracteristicsItem() {
        return editGearCaracteristicsItem;
    }

    public JXDatePicker getEndDateField() {
        return endDateField;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JRadioButton getFilterVesselAllButton() {
        return filterVesselAllButton;
    }

    public JRadioButton getFilterVesselFishingButton() {
        return filterVesselFishingButton;
    }

    public JLabel getFilterVesselLabel() {
        return filterVesselLabel;
    }

    public JRadioButton getFilterVesselScientificButton() {
        return filterVesselScientificButton;
    }

    public JAXXButtonGroup getFilterVesselType() {
        return filterVesselType;
    }

    public GearCaracteristicsEditorUI getGearCaracteristicsEditor() {
        return gearCaracteristicsEditor;
    }

    public JXTitledPanel getGearCaracteristicsEditorTitledPanel() {
        return gearCaracteristicsEditorTitledPanel;
    }

    public BeanDoubleList<Gear> getGearList() {
        return gearList;
    }

    public JPopupMenu getGearMenuPopup() {
        return gearMenuPopup;
    }

    public JButton getGenerateNameButton() {
        return generateNameButton;
    }

    public EditCruiseUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Person> getHeadOfMissionList() {
        return headOfMissionList;
    }

    public BeanDoubleList<Person> getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public CardLayout2Ext getMainPanelLayout() {
        return mainPanelLayout;
    }

    public EditCruiseUIModel getModel() {
        return model;
    }

    public NumberEditor getMultirigNumberField() {
        return multirigNumberField;
    }

    public JLabel getMultirigNumberLabel() {
        return multirigNumberLabel;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiLocation> getReturnLocationComboBox() {
        return returnLocationComboBox;
    }

    public JLabel getReturnLocationLabel() {
        return returnLocationLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public SwingValidator<EditCruiseUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<Vessel> getVesselComboBox() {
        return vesselComboBox;
    }

    public JPanel getVesselFilterPane() {
        return vesselFilterPane;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    public JMenuItem getViewGearCaracteristicsItem() {
        return viewGearCaracteristicsItem;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCruiseScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        cruiseScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToEditCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add($JPanel0, EditCruiseUIHandler.CRUISE_CARD);
        add(gearCaracteristicsEditorTitledPanel, EditCruiseUIHandler.GEAR_CARACTERISTICS_CARD);
    }

    protected void addChildrenToFilterVesselAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselAllButton); }
    }

    protected void addChildrenToFilterVesselFishingButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselFishingButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselFishingButton); }
    }

    protected void addChildrenToFilterVesselScientificButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselScientificButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselScientificButton); }
    }

    protected void addChildrenToGearCaracteristicsEditorTitledPanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsEditorTitledPanel.add(gearCaracteristicsEditor);
    }

    protected void addChildrenToGearMenuPopup() {
        if (!allComponentsCreated) {
            return;
        }
        gearMenuPopup.add(editGearCaracteristicsItem);
        gearMenuPopup.add(viewGearCaracteristicsItem);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(attachmentsButton);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselFilterPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselFilterPane.add(filterVesselLabel);
        vesselFilterPane.add(filterVesselAllButton);
        vesselFilterPane.add(filterVesselScientificButton);
        vesselFilterPane.add(filterVesselFishingButton);
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createBeginDateField() {
        $objectMap.put("beginDateField", beginDateField = new JXDatePicker());
        
        beginDateField.setName("beginDateField");
        beginDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDateField"));
        beginDateField.putClientProperty("validatorLabel", _("tutti.editCruise.field.beginDate"));
        beginDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(_("tutti.editCruise.field.beginDate"));
        beginDateLabel.setToolTipText(_("tutti.editCruise.field.beginDate.tip"));
        beginDateLabel.putClientProperty("help", "tutti.editCruise.field.beginDate.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCruise.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.editCruise.action.closeEditCruise"));
        closeButton.setToolTipText(_("tutti.editCruise.action.closeEditCruise.tip"));
        closeButton.putClientProperty("help", "tutti.editCruise.action.close.help");
        closeButton.putClientProperty("tuttiAction", fr.ifremer.tutti.ui.swing.content.SelectCruiseAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editCruise.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editCruise.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editCruise.field.comment.help");
    }

    protected void createCruiseScrollPane() {
        $objectMap.put("cruiseScrollPane", cruiseScrollPane = new JScrollPane());
        
        cruiseScrollPane.setName("cruiseScrollPane");
        cruiseScrollPane.putClientProperty("onlyVerticalScrollable", true);
    }

    protected void createDepartureLocationComboBox() {
        $objectMap.put("departureLocationComboBox", departureLocationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        departureLocationComboBox.setName("departureLocationComboBox");
        departureLocationComboBox.setProperty("departureLocation");
        departureLocationComboBox.setShowReset(true);
        departureLocationComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.departureLocation"));
    }

    protected void createDepartureLocationLabel() {
        $objectMap.put("departureLocationLabel", departureLocationLabel = new JLabel());
        
        departureLocationLabel.setName("departureLocationLabel");
        departureLocationLabel.setText(_("tutti.editCruise.field.departureLocation"));
        departureLocationLabel.setToolTipText(_("tutti.editCruise.field.departureLocation.tip"));
        departureLocationLabel.putClientProperty("help", "tutti.editCruise.field.departureLocation.help");
    }

    protected void createEditGearCaracteristicsItem() {
        $objectMap.put("editGearCaracteristicsItem", editGearCaracteristicsItem = new JMenuItem());
        
        editGearCaracteristicsItem.setName("editGearCaracteristicsItem");
        editGearCaracteristicsItem.setText(_("tutti.editCruise.action.editGearCaracteristics"));
        editGearCaracteristicsItem.setToolTipText(_("tutti.editCruise.action.editGearCaracteristics.tip"));
        editGearCaracteristicsItem.putClientProperty("help", "tutti.editCruise.action.editGearCaracteristics.help");
        editGearCaracteristicsItem.putClientProperty("tuttiAction", EditGearCaracteristicsAction.class);
    }

    protected void createEndDateField() {
        $objectMap.put("endDateField", endDateField = new JXDatePicker());
        
        endDateField.setName("endDateField");
        endDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDateField"));
        endDateField.putClientProperty("validatorLabel", _("tutti.editCruise.field.endDate"));
        endDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(_("tutti.editCruise.field.endDate"));
        endDateLabel.setToolTipText(_("tutti.editCruise.field.endDate.tip"));
        endDateLabel.putClientProperty("help", "tutti.editCruise.field.endDate.help");
    }

    protected void createFilterVesselAllButton() {
        $objectMap.put("filterVesselAllButton", filterVesselAllButton = new JRadioButton());
        
        filterVesselAllButton.setName("filterVesselAllButton");
        filterVesselAllButton.setText(_("tutti.editCruise.filterVesselType.all"));
        { filterVesselAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterVesselAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselAllButton.setToolTipText(_("tutti.editCruise.filterVesselType.all.tip"));
        filterVesselAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselAllButton"));
    }

    protected void createFilterVesselFishingButton() {
        $objectMap.put("filterVesselFishingButton", filterVesselFishingButton = new JRadioButton());
        
        filterVesselFishingButton.setName("filterVesselFishingButton");
        filterVesselFishingButton.setText(_("tutti.editCruise.filterVesselType.fishing"));
        { filterVesselFishingButton.putClientProperty("$value", "fishing");  Object $buttonGroup = filterVesselFishingButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselFishingButton.setToolTipText(_("tutti.editCruise.filterVesselType.fishing.tip"));
        filterVesselFishingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselFishingButton"));
    }

    protected void createFilterVesselLabel() {
        $objectMap.put("filterVesselLabel", filterVesselLabel = new JLabel());
        
        filterVesselLabel.setName("filterVesselLabel");
        filterVesselLabel.setText(_("tutti.editCruise.filterVesselType"));
        filterVesselLabel.setToolTipText(_("tutti.editCruise.filterVessel.tip"));
        filterVesselLabel.putClientProperty("help", "tutti.editCruise.filterVessel.help");
        filterVesselLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterVesselScientificButton() {
        $objectMap.put("filterVesselScientificButton", filterVesselScientificButton = new JRadioButton());
        
        filterVesselScientificButton.setName("filterVesselScientificButton");
        filterVesselScientificButton.setText(_("tutti.editCruise.filterVesselType.scientific"));
        { filterVesselScientificButton.putClientProperty("$value", "scientific");  Object $buttonGroup = filterVesselScientificButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselScientificButton.setToolTipText(_("tutti.editCruise.filterVesselType.scientific.tip"));
        filterVesselScientificButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselScientificButton"));
    }

    protected void createFilterVesselType() {
        $objectMap.put("filterVesselType", filterVesselType = new JAXXButtonGroup());
    }

    protected void createGearCaracteristicsEditor() {
        $objectMap.put("gearCaracteristicsEditor", gearCaracteristicsEditor = new GearCaracteristicsEditorUI(this));
        
        gearCaracteristicsEditor.setName("gearCaracteristicsEditor");
    }

    protected void createGearCaracteristicsEditorTitledPanel() {
        $objectMap.put("gearCaracteristicsEditorTitledPanel", gearCaracteristicsEditorTitledPanel = new JXTitledPanel());
        
        gearCaracteristicsEditorTitledPanel.setName("gearCaracteristicsEditorTitledPanel");
        gearCaracteristicsEditorTitledPanel.setTitle(_("tutti.editCruise.gearCaracteristics.title"));
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Gear>());
        
        gearList.setName("gearList");
        gearList.setShowSelectPopupEnabled(true);
        gearList.setUseMultiSelect(true);
        gearList.setProperty("gear");
        gearList.setShowReset(true);
        gearList.setToolTipText(_("tutti.editCruise.field.gear.tip"));
        gearList.putClientProperty("help", "tutti.editCruise.field.gear.help");
        gearList.putClientProperty("validatorLabel", _("tutti.editCruise.field.gear"));
    }

    protected void createGearMenuPopup() {
        $objectMap.put("gearMenuPopup", gearMenuPopup = new JPopupMenu());
        
        gearMenuPopup.setName("gearMenuPopup");
    }

    protected void createGenerateNameButton() {
        $objectMap.put("generateNameButton", generateNameButton = new JButton());
        
        generateNameButton.setName("generateNameButton");
        generateNameButton.setText(_("tutti.editCruise.action.generateCampaignName"));
        generateNameButton.setToolTipText(_("tutti.editCruise.action.generateName.tip"));
        generateNameButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateNameButton"));
        generateNameButton.putClientProperty("help", "tutti.editCruise.action.generateName.help");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCruiseUIHandler.class));
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new BeanDoubleList<Person>());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.setShowSelectPopupEnabled(true);
        headOfMissionList.setProperty("headOfMission");
        headOfMissionList.setShowReset(true);
        headOfMissionList.setToolTipText(_("tutti.editCruise.field.headOfMission.tip"));
        headOfMissionList.putClientProperty("help", "tutti.editCruise.field.headOfMission.help");
        headOfMissionList.putClientProperty("validatorLabel", _("tutti.editCruise.field.headOfMission"));
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new BeanDoubleList<Person>());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.setShowSelectPopupEnabled(true);
        headOfSortRoomList.setProperty("headOfSortRoom");
        headOfSortRoomList.setShowReset(true);
        headOfSortRoomList.setToolTipText(_("tutti.editCruise.field.headOfSortRoom.tip"));
        headOfSortRoomList.putClientProperty("help", "tutti.editCruise.field.headOfSortRoom.help");
        headOfSortRoomList.putClientProperty("validatorLabel", _("tutti.editCruise.field.headOfSortRoom"));
    }

    protected void createMainPanelLayout() {
        $objectMap.put("mainPanelLayout", mainPanelLayout = new CardLayout2Ext(this, "editCruiseTopPanel"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCruiseUIModel.class));
    }

    protected void createMultirigNumberField() {
        $objectMap.put("multirigNumberField", multirigNumberField = new NumberEditor(this));
        
        multirigNumberField.setName("multirigNumberField");
        multirigNumberField.setProperty("multirigNumber");
        multirigNumberField.setUseFloat(false);
        multirigNumberField.setShowReset(true);
        multirigNumberField.putClientProperty("validatorLabel", _("tutti.editCruise.field.multirigNumber"));
        multirigNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createMultirigNumberLabel() {
        $objectMap.put("multirigNumberLabel", multirigNumberLabel = new JLabel());
        
        multirigNumberLabel.setName("multirigNumberLabel");
        multirigNumberLabel.setText(_("tutti.editCruise.field.multirigNumber"));
        multirigNumberLabel.setToolTipText(_("tutti.editCruise.field.multirigNumber.tip"));
        multirigNumberLabel.putClientProperty("help", "tutti.editCruise.field.multirigNumber.help");
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("validatorLabel", _("tutti.editCruise.field.name"));
        nameField.putClientProperty("selectOnFocus", true);
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.editCruise.field.name"));
        nameLabel.setToolTipText(_("tutti.editCruise.field.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editCruise.field.name.help");
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.editCruise.field.program"));
        programLabel.setToolTipText(_("tutti.editCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.editCruise.field.program.help");
    }

    protected void createReturnLocationComboBox() {
        $objectMap.put("returnLocationComboBox", returnLocationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        returnLocationComboBox.setName("returnLocationComboBox");
        returnLocationComboBox.setProperty("returnLocation");
        returnLocationComboBox.setShowReset(true);
        returnLocationComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.returnLocation"));
    }

    protected void createReturnLocationLabel() {
        $objectMap.put("returnLocationLabel", returnLocationLabel = new JLabel());
        
        returnLocationLabel.setName("returnLocationLabel");
        returnLocationLabel.setText(_("tutti.editCruise.field.returnLocation"));
        returnLocationLabel.setToolTipText(_("tutti.editCruise.field.returnLocation.tip"));
        returnLocationLabel.putClientProperty("help", "tutti.editCruise.field.returnLocation.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editCruise.action.saveCruise"));
        saveButton.setToolTipText(_("tutti.editCruise.action.saveCruise.tip"));
        saveButton.putClientProperty("help", "tutti.editCruise.action.save.help");
        saveButton.putClientProperty("tuttiAction", SaveCruiseAction.class);
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
        surveyPartField.putClientProperty("validatorLabel", _("tutti.editCruise.field.surveyPart"));
        surveyPartField.putClientProperty("selectOnFocus", true);
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(_("tutti.editCruise.field.surveyPart"));
        surveyPartLabel.setToolTipText(_("tutti.editCruise.field.surveyPart.tip"));
        surveyPartLabel.putClientProperty("help", "tutti.editCruise.field.surveyPart.help");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCruiseUIModel.class, null));
    }

    protected void createVesselComboBox() {
        $objectMap.put("vesselComboBox", vesselComboBox = new BeanFilterableComboBox<Vessel>(this));
        
        vesselComboBox.setName("vesselComboBox");
        vesselComboBox.setProperty("vessel");
        vesselComboBox.setShowReset(true);
        vesselComboBox.setToolTipText(_("tutti.editCruise.field.vessel.tip"));
        vesselComboBox.putClientProperty("help", "tutti.editCruise.field.vessel.help");
        vesselComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.vessel"));
    }

    protected void createVesselFilterPane() {
        $objectMap.put("vesselFilterPane", vesselFilterPane = new JPanel());
        
        vesselFilterPane.setName("vesselFilterPane");
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.editCruise.field.vessel"));
        vesselLabel.setToolTipText(_("tutti.editCruise.field.vessel.tip"));
        vesselLabel.putClientProperty("help", "tutti.editCruise.field.vessel.help");
    }

    protected void createViewGearCaracteristicsItem() {
        $objectMap.put("viewGearCaracteristicsItem", viewGearCaracteristicsItem = new JMenuItem());
        
        viewGearCaracteristicsItem.setName("viewGearCaracteristicsItem");
        viewGearCaracteristicsItem.setText(_("tutti.editCruise.action.viewGearCaracteristics"));
        viewGearCaracteristicsItem.setToolTipText(_("tutti.editCruise.action.viewGearCaracteristics.tip"));
        viewGearCaracteristicsItem.putClientProperty("help", "tutti.editCruise.action.viewGearCaracteristics.help");
        viewGearCaracteristicsItem.putClientProperty("tuttiAction", ViewGearCaracteristicsAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCruiseTopPanel();
        addChildrenToValidator();
        addChildrenToTopToolBar();
        addChildrenToGearMenuPopup();
        // inline complete setup of $JPanel0
        $JPanel0.add(cruiseScrollPane, BorderLayout.CENTER);
        $JPanel0.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToCruiseScrollPane();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(departureLocationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(departureLocationComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(beginDateField), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(returnLocationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(returnLocationComboBox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(endDateField), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(generateNameButton, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multirigNumberLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(multirigNumberField), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselFilterPane, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(vesselComboBox), new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(gearList), new GridBagConstraints(0, 8, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 10, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToVesselFilterPane();
        addChildrenToFilterVesselAllButton();
        addChildrenToFilterVesselScientificButton();
        addChildrenToFilterVesselFishingButton();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfMissionList));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomList));
        addChildrenToCommentPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(closeButton);
        $JPanel2.add(saveButton);
        addChildrenToGearCaracteristicsEditorTitledPanel();
        
        // apply 18 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 44 property setters
        programComboBox.setBeanType(Program.class);
        departureLocationComboBox.setBeanType(TuttiLocation.class);
        returnLocationComboBox.setBeanType(TuttiLocation.class);
        vesselComboBox.setBeanType(Vessel.class);
        gearList.setBeanType(Gear.class);
        headOfMissionList.setBeanType(Person.class);
        headOfSortRoomList.setBeanType(Person.class);
        editGearCaracteristicsItem.setIcon(SwingUtil.createActionIcon("edit"));
        viewGearCaracteristicsItem.setIcon(SwingUtil.createActionIcon("show-frequency"));
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        surveyPartLabel.setLabelFor(surveyPartField);
        departureLocationLabel.setLabelFor(departureLocationComboBox);
        departureLocationComboBox.setBean(model);
        beginDateLabel.setLabelFor(beginDateField);
        returnLocationLabel.setLabelFor(returnLocationComboBox);
        returnLocationComboBox.setBean(model);
        endDateLabel.setLabelFor(endDateField);
        nameLabel.setLabelFor(nameField);
        generateNameButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateNameButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.generateCampaignName.mnemonic"),'Z'));
        multirigNumberLabel.setLabelFor(multirigNumberField);
        multirigNumberField.setBean(model);
        multirigNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        multirigNumberField.setNumberPattern(INT_1_DIGITS_PATTERN);
        multirigNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        filterVesselLabel.setIcon(SwingUtil.createActionIcon("filter"));
        vesselLabel.setLabelFor(vesselComboBox);
        vesselComboBox.setBean(model);
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.gear")));
        headOfMissionList.setBean(model);
        headOfMissionList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.headOfMission")));
        headOfSortRoomList.setBean(model);
        headOfSortRoomList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.headOfSortRoom")));
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.comment")));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.closeEditCruise.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.saveCruise.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCruiseTopPanel, "tutti.editCruise.help");
        registerHelpId(_broker, editGearCaracteristicsItem, "tutti.editCruise.action.editGearCaracteristics.help");
        registerHelpId(_broker, viewGearCaracteristicsItem, "tutti.editCruise.action.viewGearCaracteristics.help");
        registerHelpId(_broker, programLabel, "tutti.editCruise.field.program.help");
        registerHelpId(_broker, surveyPartLabel, "tutti.editCruise.field.surveyPart.help");
        registerHelpId(_broker, departureLocationLabel, "tutti.editCruise.field.departureLocation.help");
        registerHelpId(_broker, beginDateLabel, "tutti.editCruise.field.beginDate.help");
        registerHelpId(_broker, returnLocationLabel, "tutti.editCruise.field.returnLocation.help");
        registerHelpId(_broker, endDateLabel, "tutti.editCruise.field.endDate.help");
        registerHelpId(_broker, nameLabel, "tutti.editCruise.field.name.help");
        registerHelpId(_broker, generateNameButton, "tutti.editCruise.action.generateName.help");
        registerHelpId(_broker, multirigNumberLabel, "tutti.editCruise.field.multirigNumber.help");
        registerHelpId(_broker, filterVesselLabel, "tutti.editCruise.filterVessel.help");
        registerHelpId(_broker, vesselLabel, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, vesselComboBox, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, gearList, "tutti.editCruise.field.gear.help");
        registerHelpId(_broker, headOfMissionList, "tutti.editCruise.field.headOfMission.help");
        registerHelpId(_broker, headOfSortRoomList, "tutti.editCruise.field.headOfSortRoom.help");
        registerHelpId(_broker, commentPane, "tutti.editCruise.field.comment.help");
        registerHelpId(_broker, closeButton, "tutti.editCruise.action.close.help");
        registerHelpId(_broker, saveButton, "tutti.editCruise.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editCruiseTopPanel", editCruiseTopPanel);
        createHandler();
        createModel();
        createValidator();
        createMainPanelLayout();
        createBroker();
        createTopToolBar();
        createAttachmentsButton();
        createGearMenuPopup();
        createEditGearCaracteristicsItem();
        createViewGearCaracteristicsItem();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCruiseScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramComboBox();
        createSurveyPartLabel();
        createSurveyPartField();
        createDepartureLocationLabel();
        createDepartureLocationComboBox();
        createBeginDateLabel();
        createBeginDateField();
        createReturnLocationLabel();
        createReturnLocationComboBox();
        createEndDateLabel();
        createEndDateField();
        createNameLabel();
        createNameField();
        createGenerateNameButton();
        createMultirigNumberLabel();
        createMultirigNumberField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.HORIZONTAL));
        
        $JSeparator0.setName("$JSeparator0");
        createVesselFilterPane();
        createFilterVesselLabel();
        createFilterVesselAllButton();
        createFilterVesselScientificButton();
        createFilterVesselFishingButton();
        createVesselLabel();
        createVesselComboBox();
        createGearList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createHeadOfMissionList();
        createHeadOfSortRoomList();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        createGearCaracteristicsEditorTitledPanel();
        createGearCaracteristicsEditor();
        createFilterVesselType();
        // inline creation of editCruiseTopPanel
        setName("editCruiseTopPanel");
        setLayout(mainPanelLayout);
        editCruiseTopPanel.putClientProperty("help", "tutti.editCruise.help");
        
        // registers 18 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 18 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_GEAR_CARACTERISTICS_ITEM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canEditGearCatacteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editGearCaracteristicsItem.setEnabled(model.isCanEditGearCatacteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canEditGearCatacteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VIEW_GEAR_CARACTERISTICS_ITEM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canShowGearCatacteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    viewGearCaracteristicsItem.setEnabled(model.isCanShowGearCatacteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canShowGearCatacteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEPARTURE_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("departureLocation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    departureLocationComboBox.setSelectedItem(model.getDepartureLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("departureLocation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEGIN_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beginDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beginDateField.setDate(model.getBeginDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beginDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RETURN_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("returnLocation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    returnLocationComboBox.setSelectedItem(model.getReturnLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("returnLocation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("endDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    endDateField.setDate(model.getEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("endDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_NAME_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerateName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateNameButton.setEnabled(model.isCanGenerateName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerateName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    multirigNumberField.setModel(model.getMultirigNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselAllButton.setSelected(model.isVesselTypeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeScientific", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselScientificButton.setSelected(model.isVesselTypeScientific());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeScientific", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselFishingButton.setSelected(model.isVesselTypeFishing());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeFishing", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselComboBox.setSelectedItem(model.getVessel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}