/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.namespace.PropertyDefinition;
import org.andromda.core.repository.Repository;
import org.andromda.core.repository.RepositoryException;
import org.andromda.core.repository.RepositoryFacade;
import org.andromda.core.transformation.Transformer;
import org.apache.commons.lang.StringUtils;

public class Repositories {
    private static Repositories instance;
    private final Map repositories = new LinkedHashMap();
    static /* synthetic */ Class class$org$andromda$core$repository$Repository;
    static /* synthetic */ Class class$org$andromda$core$transformation$Transformer;

    public static Repositories instance() {
        if (instance == null) {
            instance = new Repositories();
        }
        return instance;
    }

    public void initialize() {
        if (this.repositories.isEmpty()) {
            Namespaces namespaces = Namespaces.instance();
            Collection repositories = ComponentContainer.instance().findComponentsOfType(class$org$andromda$core$repository$Repository == null ? (class$org$andromda$core$repository$Repository = Repositories.class$("org.andromda.core.repository.Repository")) : class$org$andromda$core$repository$Repository);
            Iterator iterator = repositories.iterator();
            while (iterator.hasNext()) {
                Repository repository = (Repository)iterator.next();
                RepositoryFacade repositoryImplementation = repository.getImplementation();
                String namespace = repository.getNamespace();
                PropertyDefinition[] properties = namespaces.getPropertyDefinitions(namespace);
                if (properties != null && properties.length > 0) {
                    int numberOfProperties = properties.length;
                    for (int ctr = 0; ctr < numberOfProperties; ++ctr) {
                        PropertyDefinition property = properties[ctr];
                        String propertyName = property.getName();
                        if (!Introspector.instance().isWritable(repositoryImplementation, propertyName)) continue;
                        Introspector.instance().setProperty(repositoryImplementation, property.getName(), namespaces.getPropertyValue(namespace, property.getName()));
                    }
                }
                repositoryImplementation.open();
                this.repositories.put(namespace, repositoryImplementation);
            }
        }
    }

    public RepositoryFacade getImplementation(String name) {
        RepositoryFacade implementation = (RepositoryFacade)this.repositories.get(name);
        if (implementation == null) {
            String message = this.repositories.isEmpty() ? "No repository implementations have been registered, make sure you have at least one valid repository registered under a namespace on your classpath" : "No repository implementation registered under namespace '" + name + "', you must specify one of the following as your repository name: [" + StringUtils.join(this.repositories.keySet().iterator(), (String)", ") + "]";
            throw new RepositoryException(message);
        }
        return implementation;
    }

    public boolean loadModel(Model model) {
        ExceptionUtils.checkNull("model", model);
        boolean loaded = model.isChanged();
        if (loaded) {
            int ctr;
            String repositoryName;
            org.andromda.core.configuration.Repository repository = model.getRepository();
            String string = repositoryName = repository != null ? repository.getName() : null;
            if (repositoryName == null) {
                throw new RepositoryException("Could not retrieve the repository to which the '" + model + "' belongs");
            }
            Transformer transformer = (Transformer)ComponentContainer.instance().findRequiredComponent(class$org$andromda$core$transformation$Transformer == null ? (class$org$andromda$core$transformation$Transformer = Repositories.class$("org.andromda.core.transformation.Transformer")) : class$org$andromda$core$transformation$Transformer);
            String[] uris = model.getUris();
            int uriNumber = uris.length;
            InputStream[] streams = new InputStream[uriNumber];
            for (ctr = 0; ctr < uriNumber; ++ctr) {
                streams[ctr] = transformer.transform(uris[ctr], model.getTransformations());
            }
            for (ctr = 0; ctr < uriNumber; ++ctr) {
                String uri = uris[ctr];
                AndroMDALogger.info("loading model --> '" + uri + "'");
            }
            RepositoryFacade repositoryImplementation = this.getImplementation(repositoryName);
            repositoryImplementation.readModel(streams, uris, model.getModuleSearchLocationPaths());
            repositoryImplementation.getModel().setPackageFilter(model.getPackages());
            try {
                for (int ctr2 = 0; ctr2 < uriNumber; ++ctr2) {
                    InputStream stream = streams[ctr2];
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
        return loaded;
    }

    public void clear() {
        if (!this.repositories.isEmpty()) {
            Iterator iterator = this.repositories.values().iterator();
            while (iterator.hasNext()) {
                ((RepositoryFacade)iterator.next()).clear();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

