/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Namespace;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.andromda.core.metafacade.MetafacadeMapping;
import org.andromda.core.metafacade.MetafacadeMappingsException;
import org.andromda.core.metafacade.MetafacadeUtils;
import org.andromda.core.namespace.BaseNamespaceComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetafacadeMappings
extends BaseNamespaceComponent {
    private final Collection mappings = new ArrayList();
    private final Map namespaceMetafacadeMappings = new HashMap();
    private Class defaultMetafacadeClass = null;
    private final Map mappingsByMetafacadeClass = new HashMap();
    private final Collection propertyReferences = new LinkedHashSet();
    private final Map mappingObjectHierachyCache = new HashMap();
    private static final String METAFACADE_PACKAGE_REPLACE_PATTERN = "\\{0\\}";
    private static final String METAFACADE_NAME_REPLACE_PATTERN = "\\{1\\}";
    protected final Collection inProcessMappings = new ArrayList();
    protected final Collection inProcessMetafacades = new ArrayList();
    private final Map contextHierachyCache = new HashMap();
    private final Map reversedInterfaceArrayCache = new HashMap();
    private Map parents = new HashMap();
    private String metaclassPattern;
    private static Map allMetafacadeMappingInstances = new HashMap();
    private MetafacadeImpls metafacadeClasses = MetafacadeImpls.instance();
    private Map modelMetafacadeMappings = new LinkedHashMap();
    private String parentNamespace;
    static /* synthetic */ Class class$org$andromda$core$metafacade$MetafacadeMappings;

    public static MetafacadeMappings newInstance() {
        return new MetafacadeMappings();
    }

    public void addMapping(final MetafacadeMapping mapping) {
        ExceptionUtils.checkNull("mapping", mapping);
        ExceptionUtils.checkNull("mapping.metafacadeClass", mapping.getMetafacadeClass());
        mapping.setMetafacadeMappings(this);
        MetafacadeMapping foundMapping = this.findMapping(new Condition(){

            public boolean evaluate(MetafacadeMapping object) {
                return mapping.match(object);
            }
        });
        if (foundMapping != null) {
            foundMapping.addMappingPropertyGroup(mapping.getMappingProperties());
        } else {
            this.mappings.add(mapping);
            this.mappingsByMetafacadeClass.put(this.getMetafacadeInterface(mapping.getMetafacadeClass()), mapping);
        }
    }

    public Class getMetafacadeInterface(Class metafacadeClass) {
        Class metafacadeInterface = null;
        if (metafacadeClass != null) {
            metafacadeInterface = metafacadeClass;
            List interfaces = org.apache.commons.lang.ClassUtils.getAllInterfaces((Class)metafacadeClass);
            if (interfaces != null && !interfaces.isEmpty()) {
                metafacadeInterface = (Class)interfaces.iterator().next();
            }
        }
        return metafacadeInterface;
    }

    private void copyMappings(MetafacadeMappings mappings) {
        ExceptionUtils.checkNull("mappings", mappings);
        Iterator iterator = mappings.mappings.iterator();
        while (iterator.hasNext()) {
            MetafacadeMapping mapping = (MetafacadeMapping)iterator.next();
            this.addMapping(mapping);
        }
        Collection propertyReferences = mappings.getPropertyReferences();
        if (propertyReferences != null && !propertyReferences.isEmpty()) {
            this.propertyReferences.addAll(propertyReferences);
        }
        this.defaultMetafacadeClass = mappings.defaultMetafacadeClass;
    }

    public Collection getPropertyReferences() {
        return this.propertyReferences;
    }

    protected MetafacadeMapping getMapping(Object mappingObject, String context, Collection stereotypes) {
        List hierarchy;
        MetafacadeMapping mapping = this.getMapping(null, mappingObject, context, stereotypes);
        if (mapping == null && (hierarchy = this.getMappingObjectHierarchy(mappingObject)) != null && !hierarchy.isEmpty()) {
            Iterator iterator = hierarchy.iterator();
            while (iterator.hasNext() && mapping == null) {
                mapping = this.getMapping((String)iterator.next(), mappingObject, context, stereotypes);
            }
        }
        return mapping;
    }

    protected List getMappingObjectHierarchy(Object mappingObject) {
        String pattern;
        ArrayList hierarchy = (ArrayList)this.mappingObjectHierachyCache.get(mappingObject);
        if (hierarchy == null && StringUtils.isNotBlank((String)(pattern = this.getMetaclassPattern()))) {
            hierarchy = new ArrayList(org.apache.commons.lang.ClassUtils.getAllInterfaces(mappingObject.getClass()));
            ListIterator<String> iterator = hierarchy.listIterator();
            while (iterator.hasNext()) {
                Class metafacadeInterface = (Class)iterator.next();
                String packageName = org.apache.commons.lang.ClassUtils.getPackageName((Class)metafacadeInterface);
                String name = org.apache.commons.lang.ClassUtils.getShortClassName((Class)metafacadeInterface);
                String metafacadeImplementationName = pattern != null ? pattern.replaceAll(METAFACADE_PACKAGE_REPLACE_PATTERN, packageName).replaceAll(METAFACADE_NAME_REPLACE_PATTERN, name) : metafacadeInterface.getName();
                iterator.set(metafacadeImplementationName);
            }
            this.mappingObjectHierachyCache.put(mappingObject, hierarchy);
        }
        return hierarchy;
    }

    private MetafacadeMapping getMapping(String mappingClassName, final Object mappingObject, final String context, final Collection stereotypes) {
        final String metaclassName = mappingClassName != null ? mappingClassName : mappingObject.getClass().getName();
        boolean validMetaclass = this.findMapping(new Condition(){

            public boolean evaluate(MetafacadeMapping mapping) {
                return mapping.getMappingClassName().equals(metaclassName);
            }
        }) != null;
        MetafacadeMapping mapping = null;
        if (validMetaclass) {
            boolean emptyStereotypes;
            boolean bl = emptyStereotypes = stereotypes == null || stereotypes.isEmpty();
            if (context != null && !emptyStereotypes) {
                mapping = this.findMapping(new Condition(){

                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (metaclassName.equals(mapping.getMappingClassName()) && mapping.hasContext() && mapping.hasStereotypes() && !mapping.hasMappingProperties()) {
                            valid = MetafacadeMappings.this.getContextHierarchy(context).contains(mapping.getContext()) && stereotypes.containsAll(mapping.getStereotypes());
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null && context != null) {
                mapping = this.findMapping(new Condition(){

                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (metaclassName.equals(mapping.getMappingClassName()) && !mapping.hasStereotypes() && mapping.hasContext() && mapping.hasMappingProperties() && !MetafacadeMappings.this.inProcessMappings.contains(mapping) && MetafacadeMappings.this.getContextHierarchy(context).contains(mapping.getContext())) {
                            MetafacadeMappings.this.inProcessMappings.add(mapping);
                            MetafacadeBase metafacade = MetafacadeFactory.getInstance().createMetafacade(mappingObject, mapping);
                            MetafacadeMappings.this.inProcessMetafacades.add(metafacade);
                            MetafacadeMappings.this.inProcessMappings.clear();
                            valid = MetafacadeUtils.propertiesValid(metafacade, mapping);
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null && context != null) {
                mapping = this.findMapping(new Condition(){

                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (metaclassName.equals(mapping.getMappingClassName()) && mapping.hasContext() && !mapping.hasStereotypes() && !mapping.hasMappingProperties()) {
                            valid = MetafacadeMappings.this.getContextHierarchy(context).contains(mapping.getContext());
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null && !emptyStereotypes) {
                mapping = this.findMapping(new Condition(){

                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (metaclassName.equals(mapping.getMappingClassName()) && mapping.hasStereotypes() && !mapping.hasContext() && !mapping.hasMappingProperties()) {
                            valid = stereotypes.containsAll(mapping.getStereotypes());
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null) {
                mapping = this.findMapping(new Condition(){

                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (metaclassName.equals(mapping.getMappingClassName()) && !mapping.hasStereotypes() && !mapping.hasContext() && mapping.hasMappingProperties() && !MetafacadeMappings.this.inProcessMappings.contains(mapping)) {
                            MetafacadeMappings.this.inProcessMappings.add(mapping);
                            MetafacadeBase metafacade = MetafacadeFactory.getInstance().createMetafacade(mappingObject, mapping);
                            MetafacadeMappings.this.inProcessMetafacades.add(metafacade);
                            MetafacadeMappings.this.inProcessMappings.clear();
                            valid = MetafacadeUtils.propertiesValid(metafacade, mapping);
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null) {
                mapping = this.findMapping(new Condition(){

                    public boolean evaluate(MetafacadeMapping mapping) {
                        return metaclassName.equals(mapping.getMappingClassName()) && !mapping.hasContext() && !mapping.hasStereotypes() && !mapping.hasMappingProperties();
                    }
                });
            }
        }
        if (mapping == null && this.getParent() != null) {
            mapping = this.getParent().getMapping(metaclassName, mappingObject, context, stereotypes);
        }
        this.inProcessMetafacades.clear();
        return mapping;
    }

    private MetafacadeMapping findMapping(Condition condition) {
        MetafacadeMapping found = null;
        Iterator iterator = this.mappings.iterator();
        while (iterator.hasNext()) {
            MetafacadeMapping mapping = (MetafacadeMapping)iterator.next();
            if (!condition.evaluate(mapping)) continue;
            found = mapping;
            break;
        }
        return found;
    }

    private void loadInheritedPropertyReferences(MetafacadeMapping mapping) {
        Class[] interfaces;
        if (mapping != null && (interfaces = this.getInterfacesReversed(mapping.getMetafacadeClass().getName())) != null && interfaces.length > 0) {
            for (int ctr = 0; ctr < interfaces.length; ++ctr) {
                Class metafacadeClass = interfaces[ctr];
                MetafacadeMapping contextMapping = (MetafacadeMapping)this.mappingsByMetafacadeClass.get(metafacadeClass);
                if (contextMapping == null) continue;
                mapping.addPropertyReferences(contextMapping.getPropertyReferences());
            }
        }
    }

    protected final List getContextHierarchy(String context) {
        List contexts = (List)this.contextHierachyCache.get(context);
        if (contexts == null) {
            contexts = ClassUtils.getInterfaces(context);
            if (contexts != null) {
                ListIterator<String> iterator = contexts.listIterator();
                while (iterator.hasNext()) {
                    iterator.set(((Class)iterator.next()).getName());
                }
            }
            this.contextHierachyCache.put(context, contexts);
        }
        return contexts;
    }

    private Class[] getInterfacesReversed(String className) {
        Class[] interfaces = (Class[])this.reversedInterfaceArrayCache.get(className);
        if (interfaces == null) {
            interfaces = ClassUtils.getInterfacesReversed(className);
            this.reversedInterfaceArrayCache.put(className, interfaces);
        }
        return interfaces;
    }

    public void addPropertyReference(String reference) {
        this.propertyReferences.add(reference);
    }

    public MetafacadeMapping getMetafacadeMapping(Object mappingObject, String namespace, String context, Collection stereotypes) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("performing 'MetafacadeMappings.getMetafacadeMapping' with mappingObject '" + mappingObject + "', stereotypes '" + stereotypes + "', namespace '" + namespace + "' and context '" + context + "'"));
        }
        MetafacadeMapping mapping = null;
        MetafacadeMappings mappings = this.getNamespaceMappings(namespace);
        if (mappings != null) {
            mappings.parentNamespace = this.getNamespace();
            mapping = mappings.getMapping(mappingObject, context, stereotypes);
        }
        if (mapping != null) {
            Collection propertyReferences = mapping.getPropertyReferences();
            MetafacadeMapping defaultMapping = this.getMapping(mappingObject, context, stereotypes);
            if (defaultMapping != null) {
                Collection defaultPropertyReferences = defaultMapping.getPropertyReferences();
                Class metafacadeInterface = this.metafacadeClasses.getMetafacadeClass(mapping.getMetafacadeClass().getName());
                Class defaultMetafacadeInterface = this.metafacadeClasses.getMetafacadeClass(defaultMapping.getMetafacadeClass().getName());
                if (defaultMetafacadeInterface.isAssignableFrom(metafacadeInterface)) {
                    mapping.addPropertyReferences(defaultPropertyReferences);
                    mapping.addPropertyReferences(propertyReferences);
                }
            }
        }
        if (mapping == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"namespace mapping not found --> finding default");
            }
            mapping = this.getMapping(mappingObject, context, stereotypes);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("found mapping --> '" + mapping + "'"));
        }
        return mapping;
    }

    private MetafacadeMappings getNamespaceMappings(String namespace) {
        return (MetafacadeMappings)this.namespaceMetafacadeMappings.get(namespace);
    }

    private MetafacadeMappings getParent() {
        return (MetafacadeMappings)this.parents.get(this.parentNamespace);
    }

    private void addNamespaceMappings(String namespace, MetafacadeMappings mappings) {
        if (mappings != null) {
            mappings.parents.put(this.getNamespace(), this);
            this.namespaceMetafacadeMappings.put(namespace, mappings);
        }
    }

    public void initialize() {
        ArrayList<String> modelTypeNamespaces = new ArrayList<String>();
        Collection metafacades = ComponentContainer.instance().findComponentsOfType(class$org$andromda$core$metafacade$MetafacadeMappings == null ? (class$org$andromda$core$metafacade$MetafacadeMappings = MetafacadeMappings.class$("org.andromda.core.metafacade.MetafacadeMappings")) : class$org$andromda$core$metafacade$MetafacadeMappings);
        Iterator iterator = metafacades.iterator();
        while (iterator.hasNext()) {
            MetafacadeMappings mappings = (MetafacadeMappings)iterator.next();
            String namespace = mappings.getNamespace();
            if (!MetafacadeUtils.isMetafacadeModelPresent(namespace)) continue;
            modelTypeNamespaces.add(namespace);
        }
        String[] modelNamespaces = modelTypeNamespaces.toArray(new String[0]);
        MetafacadeImpls.instance().discover(modelNamespaces);
        this.initializeMappings(modelNamespaces);
    }

    final void registerAllProperties() {
        Namespaces namespaces = Namespaces.instance();
        Iterator iterator = namespaces.getNamespaces().iterator();
        while (iterator.hasNext()) {
            String mappingsNamespace = ((Namespace)iterator.next()).getName();
            ArrayList mappings = new ArrayList(this.mappings);
            MetafacadeMappings metafacadeMappings = this.getNamespaceMappings(mappingsNamespace);
            ArrayList propertyReferences = new ArrayList(this.propertyReferences);
            if (metafacadeMappings != null) {
                mappings.addAll(metafacadeMappings.mappings);
                propertyReferences.addAll(metafacadeMappings.propertyReferences);
            }
            Iterator mappingIterator = mappings.iterator();
            while (mappingIterator.hasNext()) {
                MetafacadeMapping mapping = (MetafacadeMapping)mappingIterator.next();
                String metafacadeInterface = this.metafacadeClasses.getMetafacadeClass(mapping.getMetafacadeClass().getName()).getName();
                Class[] interfaces = this.getInterfacesReversed(metafacadeInterface);
                for (int ctr = 0; ctr < interfaces.length; ++ctr) {
                    this.registerProperties(mappingsNamespace, propertyReferences, interfaces[ctr].getName());
                }
                this.loadInheritedPropertyReferences(mapping);
                this.registerProperties(mappingsNamespace, mapping.getPropertyReferences(), metafacadeInterface);
            }
        }
    }

    private String getMetaclassPattern() {
        if (this.metaclassPattern == null && this.getParent() != null) {
            this.metaclassPattern = this.getParent().metaclassPattern;
        }
        return this.metaclassPattern;
    }

    public void setMetaclassPattern(String metaclassPattern) {
        this.metaclassPattern = metaclassPattern;
    }

    private void initializeMappings(String[] metafacadeModelNamespaces) {
        ExceptionUtils.checkNull("modelTypes", metafacadeModelNamespaces);
        Collection metafacades = ComponentContainer.instance().findComponentsOfType(class$org$andromda$core$metafacade$MetafacadeMappings == null ? (class$org$andromda$core$metafacade$MetafacadeMappings = MetafacadeMappings.class$("org.andromda.core.metafacade.MetafacadeMappings")) : class$org$andromda$core$metafacade$MetafacadeMappings);
        Iterator iterator = metafacades.iterator();
        while (iterator.hasNext()) {
            MetafacadeMappings mappings = (MetafacadeMappings)iterator.next();
            Iterator mappingIterator = mappings.mappings.iterator();
            while (mappingIterator.hasNext()) {
                MetafacadeMapping mapping = (MetafacadeMapping)mappingIterator.next();
                if (!mapping.isMappingClassNamePresent()) continue;
                allMetafacadeMappingInstances.put(mapping.getMetafacadeClass(), mapping.getMappingClassName());
            }
        }
        ArrayList<String> modelNamespaces = new ArrayList<String>(Arrays.asList(metafacadeModelNamespaces));
        try {
            Namespaces namespaces = Namespaces.instance();
            int numberOfModelTypes = metafacadeModelNamespaces.length;
            for (int ctr = 0; ctr < numberOfModelTypes; ++ctr) {
                String modelNamespace = metafacadeModelNamespaces[ctr];
                if (modelNamespace == null) continue;
                modelNamespaces.remove(modelNamespace);
                MetafacadeMappings modelMetafacadeMappings = (MetafacadeMappings)this.modelMetafacadeMappings.get(modelNamespace);
                if (modelMetafacadeMappings == null) {
                    modelMetafacadeMappings = MetafacadeMappings.newInstance();
                    modelMetafacadeMappings.setNamespace(modelNamespace);
                    this.modelMetafacadeMappings.put(modelNamespace, modelMetafacadeMappings);
                }
                Iterator iterator2 = metafacades.iterator();
                while (iterator2.hasNext()) {
                    MetafacadeMappings mappings = (MetafacadeMappings)iterator2.next();
                    String namespace = mappings.getNamespace();
                    if (modelNamespaces.contains(namespace)) continue;
                    if (namespaces.isShared(namespace) || metafacades.size() == 1) {
                        modelMetafacadeMappings.copyMappings(mappings);
                        String metaclassPattern = mappings.metaclassPattern;
                        if (metaclassPattern == null || metaclassPattern.trim().length() <= 0) continue;
                        modelMetafacadeMappings.setMetaclassPattern(mappings.metaclassPattern);
                        continue;
                    }
                    modelMetafacadeMappings.addNamespaceMappings(namespace, mappings);
                }
                modelNamespaces.add(modelNamespace);
                if (modelMetafacadeMappings.getNamespace() == null || modelMetafacadeMappings.getNamespace().trim().length() == 0) {
                    throw new MetafacadeMappingsException("No shared metafacades found, please check your classpath, at least one set of metafacades must be marked as 'shared'");
                }
                if (modelMetafacadeMappings.metaclassPattern != null && modelMetafacadeMappings.metaclassPattern.trim().length() != 0) continue;
                throw new MetafacadeMappingsException("At least one set of metafacades marked as shared must have the 'metaclassPattern' attribute defined");
            }
        }
        catch (Throwable throwable) {
            throw new MetafacadeMappingsException(throwable);
        }
    }

    static Map getAllMetafacadeMappingInstances() {
        return allMetafacadeMappingInstances;
    }

    public MetafacadeMappings getModelMetafacadeMappings(String metafacadeModelNamespace) {
        MetafacadeMappings instance = (MetafacadeMappings)this.modelMetafacadeMappings.get(metafacadeModelNamespace);
        if (instance == null) {
            throw new MetafacadeMappingsException("Namespace '" + metafacadeModelNamespace + "' is not a registered metafacade model namespace");
        }
        return instance;
    }

    final Class getDefaultMetafacadeClass(String namespace) {
        Class defaultMetafacadeClass = null;
        MetafacadeMappings mappings = this.getNamespaceMappings(namespace);
        if (mappings != null) {
            defaultMetafacadeClass = mappings.defaultMetafacadeClass;
        }
        if (defaultMetafacadeClass == null) {
            defaultMetafacadeClass = this.defaultMetafacadeClass;
        }
        return defaultMetafacadeClass;
    }

    public void setDefaultMetafacadeClass(String defaultMetafacadeClass) {
        try {
            this.defaultMetafacadeClass = ClassUtils.loadClass(StringUtils.trimToEmpty((String)defaultMetafacadeClass));
        }
        catch (Throwable throwable) {
            throw new MetafacadeMappingsException(throwable);
        }
    }

    protected Collection getMappings() {
        return this.mappings;
    }

    final void registerProperties(String namespace, Collection propertyReferences, String metafacadeName) {
        MetafacadeFactory factory = MetafacadeFactory.getInstance();
        Iterator iterator = propertyReferences.iterator();
        while (iterator.hasNext()) {
            String reference = (String)iterator.next();
            String value = Namespaces.instance().getPropertyValue(namespace, reference);
            if (value != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("setting context property '" + reference + "' with value '" + value + "' for namespace '" + namespace + "' on metafacade '" + metafacadeName + "'"));
            }
            factory.registerProperty(namespace, metafacadeName, reference, value);
        }
    }

    final void shutdown() {
        this.mappings.clear();
        this.inProcessMappings.clear();
        this.inProcessMetafacades.clear();
        this.namespaceMetafacadeMappings.clear();
        this.propertyReferences.clear();
        this.mappingObjectHierachyCache.clear();
        this.mappingsByMetafacadeClass.clear();
        this.contextHierachyCache.clear();
        this.reversedInterfaceArrayCache.clear();
        Iterator iterator = this.modelMetafacadeMappings.values().iterator();
        while (iterator.hasNext()) {
            MetafacadeMappings metafacadeMappings = (MetafacadeMappings)iterator.next();
            metafacadeMappings.shutdown();
        }
        this.modelMetafacadeMappings.clear();
    }

    private Logger getLogger() {
        return AndroMDALogger.getNamespaceLogger(this.getNamespace());
    }

    public String toString() {
        return super.toString() + "[" + this.getNamespace() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface Condition {
        public boolean evaluate(MetafacadeMapping var1);
    }
}

