package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class ValidateCruiseUI extends JSplitPane implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ValidateCruiseUIModel, ValidateCruiseUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_OPERATION_MESSAGES_ITEM_ENABLED = "exportOperationMessagesItem.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Wz28bRRSeuLGDE5cWQkJQC0pCkahUxgKJnxGtk0AURzGNiFtF+FDGuxN70vHOduZtusgK4k/gT4A7FyRunBAHzhy4IP4FhDhwRX2zu971lg1OYsmWPfPe99773nvf+rs/SdlosnLEwpDqwAMx4HRn/eDgbveIO/ARN44WPihN4tdUiZQ6ZM5Nzw2QVzu71r2euNc31cBXHvfGvNd2yayBLyQ3fc4ByMt5D8eY+n56vRb6gR6hpkkVoX7z91+lr92vvi0REvqYXQ1LWZ7klVUyvUtKwgXyPEY6ZnXJvB6moYXXw3wv27NNyYz5hA34I/IlmdklFZ9pBAOyevaSI4zIP/SBVI0vBewxjwN5/1BTcaj5gGsKAYCggaDmMcanjvIA4aijA2E4vc+kcBnwzejnvabvR4gVIDN95rmSayCNC6NtxxAZaHmgXC6B3L4wZMsCZICVrlYPbZI3T0ds25/b6LUR2WbOCx47Fj0GQnltAZK7lj3MbkXpHj3CUXwIyo9BQrpzMGZjAaopziyatZWSGwwTecG2N0xC7yTH1nAhta/x0FcaNjAvLJbM5zziU2u5lDpUB9wL9pQfYJ8Xc9bRYQtvs6quxeh3fa6j0lrcGNbjpgl8gDXn3K2nPbeur6QIVzJeEkZezHntO1pJaa/ydc1mfkCey/OgeWR8IzV+Vo0STGLcmTwTqQvdEqaPN2mR5l4z6Ykm13KLihJAMwnIdnSqQ8o6wGMgS53/qsaneBXrxdJTemEBo9t/F+d/+/GPH7ZGIlHB2AuFpmMah8vra1sHCBv6SqwQAQhZbzF/rYN7zCUKZCSA1wsS20+uMTmMF7FMrTvdZqaPEOWZ33/6efHzXy+R0haZlYq5W8zaN0kV+hpZUNIN/TuNKKPa42fw8yq+L+Fygh1wIK/F7B/nNo9mvaWJXaWrtGt3rzL0AilPsBoten2UKkfpZApqw2w3TkJk83oBm2lJ3eov/8zvf98YMTqFFb50qnnGavkzUhGeFB6PhDfR1EKhnfMND1yVaWeRmpLTtMFP1uyt6POdIharh8g5sK5lqHzIpLFMKZ89CsYOLsfU7TGBg+2OzsPAot6OCrffGiSnLZOCT6M1thozbtqFIZVYCLAJD6KOrjtxT24NP44u4sYmAjsmFLEddSwh2NQ5wPBt4bd5iFhvTxqOOAMax6ZMShwXlK3ygz7SB+SD4er5Eazr6kkRPTkpnUTQFKYhWdeKza04Ce4KWHcc4aK6MOQYnH483bRrv8dMmKLAmSRPijqDz1Lu2YHARr8xjJ6AtMchHmPuPi1lr99cXvlwOdmoaYhYf/d8nKU6ecaJqCcTkeYwcShq4s33vJbHB8oTDv5FuGB+dJBC5Mds7aKAuWFrnHfYMpzTR+7/nq9nmMA5rRTcF0aMKUTh4mdJIuoT2d+GX08LAAA=";
    private static final Log log = LogFactory.getLog(ValidateCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton exportButton;
    protected JMenuItem exportOperationMessagesItem;
    protected ValidateCruiseUIHandler handler;
    protected JPopupMenu menuPopup;
    protected ValidateCruiseUIModel model;
    protected JTree navigation;
    protected JScrollPane navigationPanel;
    protected JXTitledPanel navigationTitledPanel;
    protected FishingOperationsUI operationPanel;
    protected ValidateCruiseUI splitPane = this;
    protected JToolBar topToolBar;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidateCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  ValidateCruiseUIHandler handler = new ValidateCruiseUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public ValidateCruiseUI(int param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI() {
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0) {
        super(param0);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, boolean param1, Component param2, Component param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, boolean param2, Component param3, Component param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidateCruiseUI(int param0, Component param1, Component param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ValidateCruiseUI(JAXXContext parentContext, int param1, Component param2, Component param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__navigation(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openNodeMenu(event, menuPopup);
    }

    public void doMouseClicked__on__navigation(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectNode(event, menuPopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportButton() {
        return exportButton;
    }

    public JMenuItem getExportOperationMessagesItem() {
        return exportOperationMessagesItem;
    }

    public ValidateCruiseUIHandler getHandler() {
        return handler;
    }

    public JPopupMenu getMenuPopup() {
        return menuPopup;
    }

    public ValidateCruiseUIModel getModel() {
        return model;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPanel() {
        return navigationPanel;
    }

    public JXTitledPanel getNavigationTitledPanel() {
        return navigationTitledPanel;
    }

    public FishingOperationsUI getOperationPanel() {
        return operationPanel;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMenuPopup() {
        if (!allComponentsCreated) {
            return;
        }
        menuPopup.add(exportOperationMessagesItem);
    }

    protected void addChildrenToNavigationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPanel.getViewport().add(navigation);
    }

    protected void addChildrenToNavigationTitledPanel() {
        if (!allComponentsCreated) {
            return;
        }
        navigationTitledPanel.add(topToolBar);
        navigationTitledPanel.add(navigationPanel);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        add(navigationTitledPanel, JSplitPane.LEFT);
        add(operationPanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(exportButton);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.validateCruise.help"));
    }

    protected void createExportButton() {
        $objectMap.put("exportButton", exportButton = new JButton());
        
        exportButton.setName("exportButton");
        exportButton.setToolTipText(_("tutti.validateCruise.navigation.action.export.all.tip"));
        exportButton.putClientProperty("help", "tutti.validateCruise.navigation.action.export.all.help");
        exportButton.putClientProperty("tuttiAction", ExportCruiseValidationMessagesAction.class);
    }

    protected void createExportOperationMessagesItem() {
        $objectMap.put("exportOperationMessagesItem", exportOperationMessagesItem = new JMenuItem());
        
        exportOperationMessagesItem.setName("exportOperationMessagesItem");
        exportOperationMessagesItem.setText(_("tutti.validateCruise.navigation.action.export.operation"));
        exportOperationMessagesItem.setToolTipText(_("tutti.validateCruise.navigation.action.export.operation.tip"));
        exportOperationMessagesItem.putClientProperty("help", "tutti.validateCruise.navigation.action.export.operation.help");
        exportOperationMessagesItem.putClientProperty("tuttiAction", ExportOperationValidationMessagesAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ValidateCruiseUIHandler.class));
    }

    protected void createMenuPopup() {
        $objectMap.put("menuPopup", menuPopup = new JPopupMenu());
        
        menuPopup.setName("menuPopup");
        menuPopup.setLabel("tutti.editAccidentalBatch.title.batchActions");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ValidateCruiseUIModel.class));
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setRootVisible(false);
        navigation.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__navigation"));
        navigation.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__navigation"));
    }

    protected void createNavigationPanel() {
        $objectMap.put("navigationPanel", navigationPanel = new JScrollPane());
        
        navigationPanel.setName("navigationPanel");
    }

    protected void createNavigationTitledPanel() {
        $objectMap.put("navigationTitledPanel", navigationTitledPanel = new JXTitledPanel());
        
        navigationTitledPanel.setName("navigationTitledPanel");
        navigationTitledPanel.setTitle(_("tutti.validateCruise.navigation.title"));
    }

    protected void createOperationPanel() {
        $objectMap.put("operationPanel", operationPanel = new FishingOperationsUI(this));
        
        operationPanel.setName("operationPanel");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSplitPane();
        addChildrenToNavigationTitledPanel();
        addChildrenToTopToolBar();
        addChildrenToMenuPopup();
        addChildrenToNavigationPanel();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        navigationTitledPanel.setBorder(null);
        navigationTitledPanel.setRightDecoration(topToolBar);
        exportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportOperationMessagesItem.setIcon(SwingUtil.createActionIcon("export"));
        exportOperationMessagesItem.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.validateCruise.navigation.action.export.operation.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, exportButton, "tutti.validateCruise.navigation.action.export.all.help");
        registerHelpId(_broker, exportOperationMessagesItem, "tutti.validateCruise.navigation.action.export.operation.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("splitPane", splitPane);
        createHandler();
        createModel();
        createBroker();
        createNavigationTitledPanel();
        createTopToolBar();
        createExportButton();
        createMenuPopup();
        createExportOperationMessagesItem();
        createNavigationPanel();
        createNavigation();
        createOperationPanel();
        // inline creation of splitPane
        setName("splitPane");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_OPERATION_MESSAGES_ITEM_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportOperationMessagesItem.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
    }

}