/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ognl.PropertiesJudge;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.DefaultMemberAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityMemberAccess
extends DefaultMemberAccess {
    private final boolean allowStaticMethodAccess;
    private Set<Pattern> excludeProperties = Collections.emptySet();
    private Set<Pattern> acceptProperties = Collections.emptySet();
    private PropertiesJudge propertiesJudge;

    public SecurityMemberAccess(boolean method) {
        super(false);
        this.allowStaticMethodAccess = method;
    }

    public boolean getAllowStaticMethodAccess() {
        return this.allowStaticMethodAccess;
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        boolean allow = true;
        int modifiers = member.getModifiers();
        if (Modifier.isStatic(modifiers) && member instanceof Method && !this.getAllowStaticMethodAccess()) {
            allow = false;
            if (target instanceof Class) {
                Class clazz = (Class)target;
                Method method = (Method)member;
                if (Enum.class.isAssignableFrom(clazz) && method.getName().equals("values")) {
                    allow = true;
                }
            }
        }
        if (!allow) {
            return false;
        }
        if (!super.isAccessible(context, target, member, propertyName)) {
            return false;
        }
        return this.isAcceptableProperty(propertyName);
    }

    protected boolean isAcceptableProperty(String name) {
        if (name == null) {
            return true;
        }
        return this.isAccepted(name) && !this.isExcluded(name) || this.propertiesJudge != null && this.propertiesJudge.acceptProperty(name);
    }

    protected boolean isAccepted(String paramName) {
        if (!this.acceptProperties.isEmpty()) {
            for (Pattern pattern : this.acceptProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String paramName) {
        if (!this.excludeProperties.isEmpty()) {
            for (Pattern pattern : this.excludeProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void setExcludeProperties(Set<Pattern> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public void setAcceptProperties(Set<Pattern> acceptedProperties) {
        this.acceptProperties = acceptedProperties;
    }

    public void setPropertiesJudge(PropertiesJudge judge) {
        this.propertiesJudge = judge;
    }
}

