/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateBenthosBatchUIModel
extends AbstractTuttiBeanUIModel<CreateBenthosBatchUIModel, CreateBenthosBatchUIModel> {
    private static final Log log = LogFactory.getLog(CreateBenthosBatchUIModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";
    public static final String PROPERTY_BATCH_WEIGHT = "batchWeight";
    protected List<Species> availableSpecies;
    protected Species species;
    protected CaracteristicQualitativeValue sampleCategory;
    protected Float batchWeight;
    protected final Multimap<CaracteristicQualitativeValue, Species> speciesUsed = ArrayListMultimap.create();

    public CreateBenthosBatchUIModel() {
        super(CreateBenthosBatchUIModel.class, null, null);
    }

    public List<Species> getAvailableSpecies() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAvailableSpecies " + this.availableSpecies));
        }
        return this.availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAvailableSpecies " + availableSpecies));
        }
        List<Species> oldValue = this.getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        this.firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldSpecies = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldSpecies, this.getSpecies());
    }

    public CaracteristicQualitativeValue getSampleCategory() {
        return this.sampleCategory;
    }

    public void setSampleCategory(CaracteristicQualitativeValue sampleCategory) {
        CaracteristicQualitativeValue oldValue = this.getSampleCategory();
        this.sampleCategory = sampleCategory;
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY, oldValue, sampleCategory);
    }

    public Float getBatchWeight() {
        return this.batchWeight;
    }

    public void setBatchWeight(Float batchWeight) {
        Float oldValue = this.getBatchWeight();
        this.batchWeight = batchWeight;
        this.firePropertyChange(PROPERTY_BATCH_WEIGHT, oldValue, batchWeight);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return this.speciesUsed;
    }

    public boolean isSpeciesAndCategoryAvailable() {
        boolean result = this.species != null && this.sampleCategory != null && this.isSpeciesAndCategoryAvailable(this.species, this.sampleCategory);
        return result;
    }

    public boolean isSpeciesAndCategoryAvailable(Species species, CaracteristicQualitativeValue value) {
        boolean result = !this.speciesUsed.containsEntry((Object)value, (Object)species);
        return result;
    }

    @Override
    protected CreateBenthosBatchUIModel newEntity() {
        return new CreateBenthosBatchUIModel();
    }
}

