// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: HibernateSearch.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao;

/**
 * Implements a generic search mechanism based on the Hibernate Criteria API. The
 * <code>CriteriaSearch</code> allows adding parameters which function as where clause. The
 * parameters are analysed whether they should be considered or not. This depends both on the actual
 * value of the parameter and on the configuration.<br>
 * The <code>CriteriaSearch</code> is expected to be a general solution for a basic search with
 * parameters connected by logical <b>and</b>. This search does <b>not</b> provide grouping.
 *
 * @author Stefan Reichert
 * @author Peter Friese
 * @author Chad Brandon
 * @see org.hibernate.Criteria
 * @see org.hibernate.criterion.Expression
 */
@SuppressWarnings({"unchecked"})
public class CriteriaSearch
{
    private CriteriaSearchConfiguration configuration;
    private org.hibernate.Criteria rootCriteria;
    private java.util.Map childCriteriaMap;
    private java.util.List orderList;
    private Class resultType;

    private static final class ParameterComparator
        implements java.util.Comparator
    {
        public int compare(final Object object1, final Object object2)
        {
            final CriteriaSearchParameter parameter1 = (CriteriaSearchParameter)object1;
            final CriteriaSearchParameter parameter2 = (CriteriaSearchParameter)object2;

            final int relevance1 = parameter1.getOrderRelevance();
            final int relevance2 = parameter2.getOrderRelevance();
            int result = 0;
            if (relevance1 > relevance2)
            {
                result = 1;
            }
            else if (relevance1 < relevance2)
            {
                result = -1;
            }
            return result;

        }
    }

    /**
     * Exposes the root criteria to subclasses.
     */
    protected org.hibernate.Criteria getRootCriteria()
    {
        return this.rootCriteria;
    }

    /**
     * Constructor for CriteriaSearch. Creates a <code>CriteriaSearch</code> with a default
     * <code>CriteriaSearchConfiguration</code>.
     *
     * @param session The Hibernate session.
     * @param resultType The <code>Class</code> of the result.
     */
    public CriteriaSearch(org.hibernate.Session session, Class resultType)
    {
        this.configuration = new CriteriaSearchConfiguration();
        this.resultType = resultType;
        this.rootCriteria = session.createCriteria(this.resultType);
        this.childCriteriaMap = new java.util.HashMap();
        this.orderList = new java.util.ArrayList();
    }

    /**
     * Executes a <code>HibernateQuery</code> using the currently defined
     * <code>CriteriaSearchParameter</code>s, and returns a java.util.Set
     * containing the query results.
     *
     * @return result The result of the query.
     * @throws org.hibernate.HibernateException
     */
    public java.util.Set executeAsSet()
        throws org.hibernate.HibernateException
    {
        return new java.util.LinkedHashSet(this.executeAsList());
    }

    /**
     * Executes a <code>HibernateQuery</code> using the currently defined
     * <code>CriteriaSearchParameter</code>s, and returns a java.util.List
     * containing the query results.
     *
     * @return result The result of the query as a List
     * @throws org.hibernate.HibernateException
     */
    public java.util.List executeAsList()
        throws org.hibernate.HibernateException
    {
        // add ordering
        if (this.orderList.size() > 0)
        {
            java.util.Collections.sort(this.orderList, new ParameterComparator());
            for (java.util.Iterator orderIterator = this.orderList.iterator(); orderIterator.hasNext();)
            {
                CriteriaSearchParameter parameter = (CriteriaSearchParameter)orderIterator.next();
                int direction = parameter.getOrderDirection();
                if (direction == CriteriaSearchParameter.ORDER_ASC)
                {
                    this.getParameterCriteria(parameter).addOrder(org.hibernate.criterion.Order.asc(this.getParameterName(parameter)));
                }
                else
                {
                    this.getParameterCriteria(parameter).addOrder(org.hibernate.criterion.Order.desc(this.getParameterName(parameter)));
                }
            }
        }

        // set the first result if configured
        if (this.configuration.getFirstResult() != null)
        {
            this.rootCriteria.setFirstResult(this.configuration.getFirstResult().intValue());
        }

        // set the fetch size if configured
        if (this.configuration.getFetchSize() != null)
        {
            this.rootCriteria.setFetchSize(this.configuration.getFetchSize().intValue());
        }

        // limit the maximum result if configured
        if (this.configuration.getMaximumResultSize() != null)
        {
            this.rootCriteria.setMaxResults(this.configuration.getMaximumResultSize().intValue());
        }
        this.rootCriteria.setCacheable(true);
        return this.rootCriteria.list();
    }

    /**
     * Adds a <code>CriteriaSearchParameter</code> to this search. The parameter is connected to
     * the search by logical <b>and</b>. It is not considered if the value is <code>null</code>.
     * If the value is not <code>null</code> it is compared using the
     * <code>CriteriaSearchParameter.EQUALS_COMPARATOR</code>.
     *
     * @param parameterValue The value of the parameter.
     * @param parameterPattern The pattern of the parameter (dot-seperated path e.g. person.address.street).
     * @throws org.hibernate.HibernateException
     */
    public void addParameter(Object parameterValue, String parameterPattern)
        throws org.hibernate.HibernateException
    {
        addParameter(new CriteriaSearchParameter(parameterValue, parameterPattern));
    }

    /**
     * Adds a <code>CriteriaSearchParameter</code> to this search. The parameter is connected to
     * the search by logical <b>and</b>. It is not considered if the value is <code>null</code> or
     * if the <code>String</code> empty. If the value is not <code>null</code> it is compared
     * using the <code>CriteriaSearchParameter.LIKE_COMPARATOR</code>.
     *
     * @param parameterValue The value of the parameter.
     * @param parameterPattern The pattern of the parameter (dot-seperated path e.g. person.address.street).
     * @throws org.hibernate.HibernateException
     */
    public void addParameter(String parameterValue, String parameterPattern)
        throws org.hibernate.HibernateException
    {
        addParameter(new CriteriaSearchParameter(parameterValue, parameterPattern));
    }

    /**
     * Adds a <code>CriteriaSearchParameter</code> to this search. The parameter is connected to
     * the search by logical <b>and</b>.
     *
     * @param parameter The <code>CriteriaSearchParameter</code> to add.
     * @throws org.hibernate.HibernateException
     */
    public void addParameter(CriteriaSearchParameter parameter)
        throws org.hibernate.HibernateException
    {
        if (considerParameter(parameter))
        {
            final org.hibernate.Criteria parameterCriteria = this.getParameterCriteria(parameter);
            final java.lang.String parameterName = this.getParameterName(parameter);

            // check the type parameter value to add
            if(parameter.getParameterValue() instanceof Object[])
            {
                addExpression(
                    parameterCriteria,
                    parameterName,
                    (Object[])parameter.getParameterValue(),
                    parameter.getComparator(),
                    parameter.getMatchMode());
            }
            else
            {
                addExpression(
                    parameterCriteria,
                    parameterName,
                    parameter.getParameterValue(),
                    parameter.getComparator(),
                    parameter.getMatchMode());
            }
        }
        // if the parameter is to be ordered, add it to the order list
        if (parameter.getOrderDirection() != CriteriaSearchParameter.ORDER_UNSET)
        {
            this.orderList.add(parameter);
        }
    }

    /**
     * Retrieves the appropriate criteria object for the given <code>parameter</code>.
     *
     * @param parameter the parameter for which to retrieve the criteria.
     * @return the retrieved criteria.
     */
    private org.hibernate.Criteria getParameterCriteria(final CriteriaSearchParameter parameter)
        throws org.hibernate.HibernateException
    {
        String[] pathBeforeProcessing = CriteriaSearchParameter.PATTERN.split(parameter.getParameterPattern());
        org.hibernate.Criteria parameterCriteria = this.rootCriteria;

        org.hibernate.Criteria childEntityCriteria;
        if (pathBeforeProcessing.length > 1)
        {
         	java.util.ArrayList pathProcessing = new java.util.ArrayList();
        	// processing of the composite keys
        	for (int i = 0; i < pathBeforeProcessing.length; i++) {
				String processing = pathBeforeProcessing[i];
				if(processing.endsWith("Pk")){
					// the composite key is contained in the parameter
					StringBuffer buffer = new StringBuffer(processing);
					i++;
					if(i < pathBeforeProcessing.length){
						buffer.append(".");
						buffer.append(pathBeforeProcessing[i]);
					}
					pathProcessing.add(buffer.toString());
				}else{
					pathProcessing.add(processing);
				}
			}
        	String[] path = (String[])pathProcessing.toArray(new String[0]);

        	if (path.length > 1){
	            // We have a parameter affecting an attribute of an inner childEntity object so we need
	            // to traverse to get the right criteria object
	            childEntityCriteria = this.rootCriteria;
	            // Evaluating the proper criteria object for the defined parameter
	            Class type = this.resultType;
	            for (int index = 0; index < (path.length - 1); index++)
	            {
	                final String childEntityName = path[index];
	                final java.util.Collection embeddedValues = CriteriaSearchProperties.getEmbeddedValues(type);
	                if (embeddedValues != null && embeddedValues.contains(childEntityName))
	                {
	                    // - use the rest of the path as the parameter name
	                    final int number = path.length - index;
	                    final String[] restOfPath = new String[path.length - index];
	                    java.lang.System.arraycopy(path, index, restOfPath, 0, number);
	                    break;
	                }
	                type = CriteriaSearchProperties.getNavigableAssociationEndType(type, childEntityName);
	                childEntityCriteria = locateCriteria(childEntityName, childEntityCriteria);
	            }
	            if (childEntityCriteria != null)
	            {
	                // We now have the right criteria object
	                parameterCriteria = childEntityCriteria;
	            }
	        }
	    }
        return parameterCriteria;
    }

    /**
     * Retrieves the appropriate nested parameter name for the given <code>parameter</code>.
     *
     * @param parameter the parameter for which to retrieve the parameter name.
     * @return the parameter name.
     */
    private java.lang.String getParameterName(final CriteriaSearchParameter parameter)
    {
        // parsing the pattern of the parameter
        String[] pathBeforeProcessing = CriteriaSearchParameter.PATTERN.split(parameter.getParameterPattern());
        
    	java.util.ArrayList pathProcessing = new java.util.ArrayList();
    	// processing of the composite keys
    	for (int i = 0; i < pathBeforeProcessing.length; i++) {
			String processing = pathBeforeProcessing[i];
			if(processing.endsWith("Pk")){
				// the composite key is contained in the parameter
				StringBuffer buffer = new StringBuffer(processing);
				i++;
				if(i < pathBeforeProcessing.length){
					buffer.append(".");
					buffer.append(pathBeforeProcessing[i]);
				}
				pathProcessing.add(buffer.toString());
			}else{
				pathProcessing.add(processing);
			}
		}
    	String[] path = (String[])pathProcessing.toArray(new String[0]);
        
        String parameterName = path[path.length - 1];
        if (path.length > 1)
        {
            // We have a parameter affecting an attribute of an inner childEntity object so we need
            // to traverse to get the correct parameter name
            // Evaluating the proper criteria object for the defined parameter
            Class type = this.resultType;
            for (int index = 0; index < (path.length - 1); index++)
            {
                final String childEntityName = path[index];
                final java.util.Collection embeddedValues = CriteriaSearchProperties.getEmbeddedValues(type);
                if (embeddedValues != null && embeddedValues.contains(childEntityName))
                {
                    // - use the rest of the path as the parameter name
                    final int number = path.length - index;
                    final String[] restOfPath = new String[path.length - index];
                    java.lang.System.arraycopy(path, index, restOfPath, 0, number);
                    parameterName = org.apache.commons.lang.StringUtils.join(restOfPath, ".");
                    break;
                }
                type = CriteriaSearchProperties.getNavigableAssociationEndType(type, childEntityName);
            }
        }
        return parameterName;
    }

    /**
     * Decides whether a paramter is considered as a criteria for a search depending on the type and
     * value of the <code>parameterValue</code> and <code>searchIfIsNull</code>. A
     * <code>parameterValue</code> of the type <code>String</code> is considered
     * <code>null</code> if being a <code>NullPointer</code> or empty.
     *
     * @param parameter The parameter to check.
     */
    private boolean considerParameter(CriteriaSearchParameter parameter)
    {
        if (parameter.getParameterValue() instanceof String)
        {
            String stringParameterValue = (String) parameter.getParameterValue();
            return (parameter.isSearchIfNull()
                    || (stringParameterValue != null && stringParameterValue.length() > 0));
        }
        if (parameter.getParameterValue() instanceof Object[])
        {
            Object[] parameterValues = (Object[]) parameter.getParameterValue();
            return (parameter.isSearchIfNull()
                    || (parameterValues != null && parameterValues.length > 0));
        }
        final int comparator = parameter.getComparator();
        return (parameter.isSearchIfNull() ||
            SearchParameter.NOT_NULL_COMPARATOR == comparator ||
            SearchParameter.NULL_COMPARATOR == comparator) ||
            (parameter.getParameterValue() != null);
    }

    /**
     * Adds an <code>Expression</code> to a <code>Criteria</code>.
     *
     * @param criteria
     * @param parameterName
     * @param parameterValue
     * @param comparator
     * @param matchMode
     */
    private void addExpression(
        org.hibernate.Criteria criteria,
        String parameterName,
        Object parameterValue,
        int comparator,
        org.hibernate.criterion.MatchMode matchMode)
    {
        switch (comparator)
        {
            case CriteriaSearchParameter.NOT_NULL_COMPARATOR:
            {
                criteria.add(org.hibernate.criterion.Expression.isNotNull(parameterName));
                break;
            }
            case CriteriaSearchParameter.NULL_COMPARATOR:
            {
                criteria.add(org.hibernate.criterion.Expression.isNull(parameterName));
                break;
            }
            default:
            {
                if (parameterValue != null)
                {
                    switch (comparator)
                    {
                        case CriteriaSearchParameter.LIKE_COMPARATOR:
                        {
                            if ((matchMode != null) && (parameterValue instanceof String))
                            {
                                criteria.add(org.hibernate.criterion.Expression.like(
                                    parameterName,
                                    (String)parameterValue,
                                    matchMode));
                            }
                            else
                            {
                                criteria.add(org.hibernate.criterion.Expression.like(parameterName, parameterValue));
                            }
                            break;
                        }
                        case CriteriaSearchParameter.INSENSITIVE_LIKE_COMPARATOR:
                        {
                            if ((matchMode != null) && (parameterValue instanceof String))
                            {
                                criteria.add(org.hibernate.criterion.Expression.ilike(
                                    parameterName,
                                    (String)parameterValue,
                                    matchMode));
                            }
                            else
                            {
                                criteria.add(org.hibernate.criterion.Expression.ilike(parameterName, parameterValue));
                            }
                            break;
                        }
                        case CriteriaSearchParameter.EQUAL_COMPARATOR:
                        {
                            criteria.add(org.hibernate.criterion.Expression.eq(parameterName, parameterValue));
                            break;
                        }
                        case CriteriaSearchParameter.GREATER_THAN_OR_EQUAL_COMPARATOR:
                        {
                            criteria.add(org.hibernate.criterion.Expression.ge(parameterName, parameterValue));
                            break;
                        }
                        case CriteriaSearchParameter.GREATER_THAN_COMPARATOR:
                        {
                            criteria.add(org.hibernate.criterion.Expression.gt(parameterName, parameterValue));
                            break;
                        }
                        case CriteriaSearchParameter.LESS_THAN_OR_EQUAL_COMPARATOR:
                        {
                            criteria.add(org.hibernate.criterion.Expression.le(parameterName, parameterValue));
                            break;
                        }
                        case CriteriaSearchParameter.LESS_THAN_COMPARATOR:
                        {
                            criteria.add(org.hibernate.criterion.Expression.lt(parameterName, parameterValue));
                            break;
                        }
                        case CriteriaSearchParameter.IN_COMPARATOR:
                        {
                            if (parameterValue instanceof java.util.Collection)
                            {
                                criteria.add(org.hibernate.criterion.Expression.in(parameterName, (java.util.Collection)parameterValue));
                            }
                            break;
                        }
                        case CriteriaSearchParameter.NOT_IN_COMPARATOR:
                        {
                            if (parameterValue instanceof java.util.Collection)
                            {
                                criteria.add(org.hibernate.criterion.Expression.not(org.hibernate.criterion.Expression.in(parameterName, (java.util.Collection)parameterValue)));
                            }
                            break;
                        }
                        case CriteriaSearchParameter.NOT_EQUAL_COMPARATOR:
                        {
                            criteria.add(org.hibernate.criterion.Expression.ne(parameterName, parameterValue));
                            break;
                        }
                        case CriteriaSearchParameter.NOT_LIKE_COMPARATOR:
                        {
                            if ((matchMode != null) && (parameterValue instanceof String))
                            {
                                criteria.add(org.hibernate.criterion.Expression.not(
                                	org.hibernate.criterion.Expression.like(
                                        parameterName,
                                        (String)parameterValue,
                                        matchMode)));
                            }
                            else
                            {
                                criteria.add(org.hibernate.criterion.Expression.not(
                                	org.hibernate.criterion.Expression.like(parameterName, parameterValue)));
                            }
                            break;
                        }
                        case CriteriaSearchParameter.NOT_INSENSITIVE_LIKE_COMPARATOR:
                        {
                            if ((matchMode != null) && (parameterValue instanceof String))
                            {
                                criteria.add(org.hibernate.criterion.Expression.not(
                                	org.hibernate.criterion.Expression.ilike(
                                        parameterName,
                                        (String)parameterValue,
                                        matchMode)));
                            }
                            else
                            {
                                criteria.add(org.hibernate.criterion.Expression.not(
                                	org.hibernate.criterion.Expression.ilike(parameterName, parameterValue)));
                            }
                            break;
                        }
                    }
                }
                else
                {
                    criteria.add(org.hibernate.criterion.Expression.isNull(parameterName));
                }
            }
        }
    }

    /**
     * Adds an <code>Expression</code> to a <code>Criteria</code>. The given <code>parameterValues</code>
     * represents either an array of <code>String</code> or another object. The different values in the
     * array are added to a disjunction or conjuction which is connected with logical and to the other criteria of the
     * search.
     *
     * @param criteria
     * @param parameterName
     * @param parameterValues
     * @param searchIfNull
     * @param comparator
     * @param matchMode
     */
    private void addExpression(
        org.hibernate.Criteria criteria,
        String parameterName,
        Object[] parameterValues,
        int comparator,
        org.hibernate.criterion.MatchMode matchMode)
    {
        if (parameterValues != null)
        {
            org.hibernate.criterion.Disjunction disjunction = null;
            org.hibernate.criterion.Conjunction conjunction = null;
            switch (comparator)
            {
                case CriteriaSearchParameter.LIKE_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    if ((matchMode != null) && (parameterValues instanceof String[]))
                    {
                        String[] stringParameterValues = (String[]) parameterValues;
                        for (int index = 0; index < parameterValues.length; index++)
                        {
                            if (stringParameterValues[index] != null)
                            {
                                disjunction.add(org.hibernate.criterion.Expression.like(
                                    parameterName, stringParameterValues[index], matchMode));
                            }
                            else
                            {
                                disjunction.add(org.hibernate.criterion.Expression
                                    .isNull(parameterName));
                            }
                        }
                    }
                    else
                    {
                        for (int index = 0; index < parameterValues.length; index++)
                        {
                            if (parameterValues[index] != null)
                            {
                                disjunction.add(org.hibernate.criterion.Expression.like(
                                    parameterName, parameterValues[index]));
                            }
                            else
                            {
                                disjunction.add(org.hibernate.criterion.Expression
                                        .isNull(parameterName));
                            }
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.INSENSITIVE_LIKE_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    if ((matchMode != null) && (parameterValues instanceof String[]))
                    {
                        String[] stringParameterValues = (String[]) parameterValues;
                        for (int index = 0; index < parameterValues.length; index++)
                        {
                            if (stringParameterValues[index] != null) {
                                disjunction.add(org.hibernate.criterion.Expression.ilike(
                                    parameterName, stringParameterValues[index], matchMode));
                            }
                            else {
                                disjunction.add(org.hibernate.criterion.Expression
                                    .isNull(parameterName));
                            }
                        }
                    }
                    else
                    {
                        for (int index = 0; index < parameterValues.length; index++)
                        {
                            if (parameterValues[index] != null)
                            {
                                disjunction.add(org.hibernate.criterion.Expression.ilike(
                                    parameterName, parameterValues[index]));
                            }
                            else
                            {
                                disjunction.add(org.hibernate.criterion.Expression
                                        .isNull(parameterName));
                            }
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.EQUAL_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; index++)
                    {
                        if (parameterValues[index] != null)
                        {
                            disjunction.add(org.hibernate.criterion.Expression.eq(parameterName,
                                    parameterValues[index]));
                        }
                        else {
                            disjunction.add(org.hibernate.criterion.Expression.isNull(parameterName));
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.GREATER_THAN_OR_EQUAL_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; index++)
                    {
                        if (parameterValues[index] != null)
                        {
                            disjunction.add(org.hibernate.criterion.Expression.ge(parameterName,
                                    parameterValues[index]));
                        }
                        else
                        {
                            disjunction.add(org.hibernate.criterion.Expression.isNull(parameterName));
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.GREATER_THAN_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; index++)
                    {
                        if (parameterValues[index] != null)
                        {
                            disjunction.add(org.hibernate.criterion.Expression.gt(parameterName,
                                    parameterValues[index]));
                        }
                        else
                        {
                            disjunction.add(org.hibernate.criterion.Expression.isNull(parameterName));
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.LESS_THAN_OR_EQUAL_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; index++)
                    {
                        if (parameterValues[index] != null)
                        {
                            disjunction.add(org.hibernate.criterion.Expression.le(parameterName,
                                    parameterValues[index]));
                        }
                        else
                        {
                            disjunction.add(org.hibernate.criterion.Expression.isNull(parameterName));
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.LESS_THAN_COMPARATOR:
                {
                    disjunction = org.hibernate.criterion.Restrictions.disjunction();
                    for (int index = 0; index < parameterValues.length; index++)
                    {
                        if (parameterValues[index] != null)
                        {
                            disjunction.add(org.hibernate.criterion.Expression.lt(parameterName,
                                    parameterValues[index]));
                        }
                        else
                        {
                            disjunction.add(org.hibernate.criterion.Expression.isNull(parameterName));
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.IN_COMPARATOR:
                {
                    criteria.add(org.hibernate.criterion.Expression.in(parameterName, parameterValues));
                    break;
                }
                case CriteriaSearchParameter.NOT_IN_COMPARATOR:
                {
                    criteria.add(org.hibernate.criterion.Expression.not(org.hibernate.criterion.Expression.in(parameterName, parameterValues)));
                    break;
                }
                case CriteriaSearchParameter.NOT_EQUAL_COMPARATOR:
                {
                    conjunction = org.hibernate.criterion.Restrictions.conjunction();
                    for (int index = 0; index < parameterValues.length; index++)
                    {
                        if (parameterValues[index] != null)
                        {
                            conjunction.add(org.hibernate.criterion.Expression.ne(parameterName,
                                    parameterValues[index]));
                        }
                        else
                        {
                            conjunction.add(org.hibernate.criterion.Expression.isNotNull(parameterName));
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.NOT_LIKE_COMPARATOR:
                {
                    conjunction = org.hibernate.criterion.Restrictions.conjunction();
                    if ((matchMode != null) && (parameterValues instanceof String[]))
                    {
                        String[] stringParameterValues = (String[]) parameterValues;
                    	for (int index = 0; index < stringParameterValues.length; index++)
                    	{
                        	if (stringParameterValues[index] != null)
                        	{
                        		conjunction.add(org.hibernate.criterion.Expression.not(
                        			org.hibernate.criterion.Expression.like(parameterName,
                        			stringParameterValues[index], matchMode)));
                        	}
                        	else
                        	{
                            	conjunction.add(org.hibernate.criterion.Expression.isNotNull(parameterName));
                        	}
                        }
                    }
                    break;
                }
                case CriteriaSearchParameter.NOT_INSENSITIVE_LIKE_COMPARATOR:
                {
                    conjunction = org.hibernate.criterion.Restrictions.conjunction();
                    if ((matchMode != null) && (parameterValues instanceof String[]))
                    {
                        String[] stringParameterValues = (String[]) parameterValues;
                    	for (int index = 0; index < stringParameterValues.length; index++)
                    	{
                        	if (stringParameterValues[index] != null)
                        	{
                        		conjunction.add(org.hibernate.criterion.Expression.not(
                        			org.hibernate.criterion.Expression.ilike(parameterName,
                        			stringParameterValues[index], matchMode)));
                        	}
                        	else
                        	{
                            	conjunction.add(org.hibernate.criterion.Expression.isNotNull(parameterName));
                        	}
                        }
                    }
                    break;
                }
            }

            if (disjunction != null)
            {
                criteria.add(disjunction);
            }
            if (conjunction != null)
            {
                criteria.add(conjunction);
            }
        }
        else
        {
            criteria.add(org.hibernate.criterion.Expression.isNull(parameterName));
        }
    }

    /**
     * Locates a <code>Criteria</code> for a <code>childEntityName</code>. If a
     * <code>Criteria</code> exists for the <code>childEntityName</code>, it is returned. If
     * not, one is created and referenced in the <code>childCriteriaMap</code> under the
     * <code>childEntityName</code>.
     *
     * @param childEntityName
     * @param parentCriteria
     * @return criteria The Criteria for the childEntityName.
     * @throws org.hibernate.HibernateException
     */
    private org.hibernate.Criteria locateCriteria(String childEntityName, org.hibernate.Criteria parentCriteria) throws org.hibernate.HibernateException
    {
        if (this.childCriteriaMap.containsKey(childEntityName))
        {
            return (org.hibernate.Criteria) this.childCriteriaMap.get(childEntityName);
        }
        org.hibernate.Criteria childCriteria = parentCriteria.createCriteria(childEntityName);
        if (this.configuration.isForceEagerLoading())
        {
            parentCriteria.setFetchMode(childEntityName, org.hibernate.FetchMode.JOIN);
        }

        // Hibernate does not support a 'unique' identifier. As a search may contain outer joins,
        // duplicates in the resultList are possible. We eliminate any duplicates here, creating a
        // distinctified resultSet (Suggestion from Hibernate itself; see www.hibernate.org's FAQ's).
        parentCriteria.setResultTransformer(org.hibernate.Criteria.DISTINCT_ROOT_ENTITY);
        this.childCriteriaMap.put(childEntityName, childCriteria);
        return childCriteria;
    }

    /**
     * Returns the configuration of this search.
     *
     * @return configuration
     */
    public CriteriaSearchConfiguration getConfiguration()
    {
        return this.configuration;
    }
}