/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.namespace;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.namespace.Component;
import org.andromda.core.namespace.PropertyDefinition;

public class NamespaceRegistry {
    private String name;
    private boolean shared = false;
    private final Map components = new LinkedHashMap();
    private final Map definitions = new LinkedHashMap();
    private List resourceRoots = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void registerComponent(Component component) {
        if (component != null) {
            this.components.put(component.getName(), component.getPaths());
        }
    }

    public String[] getRegisteredComponents() {
        return this.components.keySet().toArray(new String[0]);
    }

    public String[] getPaths(String name) {
        return (String[])this.components.get(name);
    }

    public PropertyDefinition getPropertyDefinition(String name) {
        return (PropertyDefinition)this.definitions.get(name);
    }

    public void addPropertyDefinitions(PropertyDefinition[] propertyDefinitions) {
        for (int ctr = 0; ctr < propertyDefinitions.length; ++ctr) {
            this.addPropertyDefinition(propertyDefinitions[ctr]);
        }
    }

    final void copy(NamespaceRegistry registry) {
        if (registry != null) {
            this.addPropertyDefinitions(registry.getPropertyDefinitions());
            this.components.putAll(registry.components);
            if (registry.isShared()) {
                this.shared = registry.isShared();
            }
            this.resourceRoots.addAll(registry.resourceRoots);
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        return this.definitions.values().toArray(new PropertyDefinition[0]);
    }

    public void addPropertyDefinition(PropertyDefinition propertyDefinition) {
        if (propertyDefinition != null) {
            this.definitions.put(propertyDefinition.getName(), propertyDefinition);
        }
    }

    public URL[] getResourceRoots() {
        return this.resourceRoots.toArray(new URL[0]);
    }

    final void addResourceRoot(URL resourceRoot) {
        this.resourceRoots.add(resourceRoot);
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }
}

